// -------------
// fupdatenv.c
// -------------
//
// Prepared for DJGPP/GCC by KB Williams, kbwms@aol.com,
// February 2002
//
// From ISO C99:
//
// Function feupdateenv
//
// Synopsis
//
//
//	#include <fenv.h>
//	int feupdateenv(const fenv_t *envp);
//
// Description
//
// Function feupdateenv saves the currently raised exceptions
// in its automatic storage, installs the floating-point
// environment represented by the object pointed to by envp,
// and then raises the saved exceptions.  Argument envp shall
// point to an object set by a call to feholdexcept or fegetenv,
// or equal the macro FE_DFL_ENV or an implementation-defined
// environment macro.
//
// Return
//
// Function feupdateenv returns zero if and only if the floating-
// point environment represented by the object pointed to by envp
// is successfully installed.
//

#include <fenv.h>

int
feupdateenv(const fenv_t * envp);

int
feupdateenv(const fenv_t *FPU_Env)
{
    int	      Retval;
    fexcept_t Excepts;

    if (FPU_Env)
    {
	Retval = 0;			// Non-null pointer

	Excepts = fetestexcept(FE_ALL_EXCEPT);

	fesetenv(FPU_Env);

	feraiseexcept(Excepts);
    }
    else
    {
	Retval = -1;			// Null pointer
    }

    return Retval;
}
# if 0
#include <stdio.h>

int
main(void)
{
}
# endif
