// ------
// fenv.h
// ------
# if defined __FENV_H
#	// do nothing
# else
#	define	__FENV_H

#ifdef __cplusplus
extern "C" {
#endif

// Prepared for DJGPP/GCC by KB Williams, kbwms@aol.com,
// February 2002
//
// From ISO C99, Paragraph 7.6
//
// This header declares two types and several macros and
// functions to provide access to the floating-point
// environment.	 "Floating-point environment" refers
// to any floating-point status flags and control modes.
// A floating-point status flag is a system variable.  Its
// value is set (but never cleared) as a side effect of
// floating-point arithmetic to provide auxiliary information.
// A floating-point control mode is a system variable whose
// value may be set by the user to affect the subsequent
// behavior of floating-point arithmetic.
//
//
//  FPU Exceptions and other data
//
// The following macros have numerical equivalents in DJGPP <float.h>.
// Their definitions are the positions of the bits in the FPU control
// word.  Refer to the info file for _status87() for details.
//				    DJGPP
//				   <float.h>	 Description
#define FE_INVALID	0x01	// SW_INVALID	 Invalid operation
#define FE_DENORMAL	0x02	// SW_DENORMAL	 Denormalized operand
#define FE_DIVBYZERO	0x04	// SW_ZERODIVIDE Division by zero
#define FE_OVERFLOW	0x08	// SW_OVERFLOW	 Overflow
#define FE_UNDERFLOW	0x10	// SW_UNDERFLOW	 Underflow
#define FE_INEXACT	0x20	// SW_INEXACT	 Precision loss

// From ISO C99:
//
// The macro
//
//	FE_ALL_EXCEPT
//
// is simply the bitwise OR of all exception macros defined by
// the implementation except FE_DENORMAL.
//

#define FE_ALL_EXCEPT	(FE_INVALID  |	FE_DENORMAL | FE_DIVBYZERO |\
			 FE_OVERFLOW | FE_UNDERFLOW | FE_INEXACT)

// From ISO C99: FPU rounding modes.
//
// The following macros have numerical equivalents in DJGPP <float.h>.
// Their definitions are the positions of the bits in the FPU control
// word.  Refer to the info file for _control87() for details.
//				    DJGPP
				// <float.h>	Description
#define FE_DOWNWARD	0x400	//  RC_DOWN	Round towards -Inf
#define FE_TONEAREST	0x000	//  RC_NEAR	Round to nearest or even
#define FE_TOWARDZERO	0xc00	//  RC_CHOP	Truncate towards zero
#define FE_UPWARD	0x800	//  RC_UP	Round towards +Inf

#define FE_ALL_ROUND	(FE_DOWNWARD   | FE_TONEAREST |\
			 FE_TOWARDZERO | FE_UPWARD)

// Precision Control
//				    DJGPP
				// <float.h>	Precision Specified
#define FE_PC_SINGLE	0x0000	// PC_24	24-bit single
#define FE_PC_DOUBLE	0x0200	// PC_53	53-bit double
#define FE_PC_EXTENDED	0x0300	// PC_64	64-bit extended

#define FE_PC_ALL	(FE_PC_SINGLE | FE_PC_DOUBLE | FE_PC_EXTENDED)


// From ISO C99:
//
// The type
//
//	fexcept_t
//
// represents the floating-point exception flags collectively,
// including any status the implementation associates with the
// flags.

typedef unsigned short int fexcept_t;

// From ISO C99:
//
// The type
//
//	fenv_t
//
// represents the entire floating-point environment.  Its image
// is defined in the following structure.  The format is 32-bit
// Protected Mode.  Variable names were taken from the Intel
// manual for the FPU, page 7-20.  A PDF file can be downloaded
// from http://www.intel.com/design/pro/MANUALS/24269101.pdf.

typedef struct FENV_STRU
  {
    unsigned int	Control_Word;
    unsigned int	Status_Word;
    unsigned int	Tag_Word;
    unsigned int	IP_Offset;
    unsigned int	CS_Selector:16;
    unsigned int	Opcode:11;
    unsigned int	Empty:5;
    unsigned int	Data_Operand_Offset;
    unsigned int	Operand_Selector;
  }
fenv_t;

// From ISO C99:
//
//	The macro
//
//	   FE_DFL_ENV
//
//	represents the default floating-point environment -- the
//	one installed at program startup -- and has type pointer
//	to const-qualified fenv_t. It can be used as an argument to
//	<fenv.h> functions that manage the floating-point
//	environment.
//
//	Additional macro definitions, beginning with FE_ and
//	having type pointer to const-qualified fenv_t, may also be
//	specified by the implementation.
//

#define FE_DFL_ENV &DfltFPU_Env
extern	const	fenv_t DfltFPU_Env;

// -------------------
// FUNCTION PROTOTYPES
// -------------------
# if !defined __F
# if defined(__STDC__) || defined(__PROTO__)
#	define	__F( P )  P
# else
#	define	__F( P )  ()
# endif
# endif

/* *INDENT-OFF* */
extern	int	feclearexcept	__F((int));
extern	int	fegetexceptflag __F((fexcept_t *, int));
extern	int	fegetround	__F((void));
extern	int	fegetenv	__F((fenv_t *));
extern	int	feholdexcept	__F((fenv_t *));
extern	int	feraiseexcept	__F((int));
extern	int	fesetenv	__F((const fenv_t *));
extern	int	fesetexceptflag __F((const fexcept_t *, int));
extern	int	fesetround	__F((int));
extern	int	fetestexcept	__F((int));
extern	int	feupdateenv	__F((const fenv_t *));
/* *INDENT-ON* */


#ifdef __cplusplus
}
#endif

# endif // defined __FENV_H
