// ----------
// fegetenv.c
// ----------
//
// Prepared for DJGPP/GCC by KB Williams, kbwms@aol.com,
// February 2002
//
// From ISO C99:
//
// Function fegetenv
//
// Synopsis
//
//
//	   #include <fenv.h>
//	   int fegetenv(fenv_t *envp);
//
// Description
//
// The fegetenv function stores the current floating-point
// environment in the object pointed to by envp.
//
// Return
//
// Function fgetenv returns zero if and only if the current
// floating-point environment is successfully stored in the object
// pointed to by envp.
//
//

#include <fenv.h>

#define AV	__asm__ __volatile__
#define STORE_FPU_ENV(FE)\
	AV ("FSTENV  %0" : "=m" (FE));

int
fegetenv(fenv_t * FPU_Env)
{
    int	    Retval;

    if (FPU_Env)
    {
	Retval = 0;			// Non-null pointer

	// Copy Environment to User's Area
	STORE_FPU_ENV(* FPU_Env);
    }
    else
    {
	Retval = -1;			// Null pointer
    }

    return Retval;
}
# if 0
#include <stdio.h>

int
main(void)
{
    long double x, y, z;
    fenv_t  FPU_Env;

    x = 1; y = 3; z = x / y;

    // Get Environment
    AV ("FSTENV %0":"=m"(*&FPU_Env));

    printf("Initial:  FPU_Env.Control_Word	  = %.4hx\n",
       (short)FPU_Env.Control_Word);
    printf("Initial:  FPU_Env.Status_Word	  = %.4hx\n",
	(short)FPU_Env.Status_Word);
    printf("Initial:  FPU_Env.Tag_Word		  = %.4hx\n",
       (short)FPU_Env.Tag_Word);
    printf("Initial:  FPU_Env.IP_Offset		  = %.8x\n",
       FPU_Env.IP_Offset);
    printf("Initial:  FPU_Env.CS_Selector	  = %.4hx\n",
       (short)FPU_Env.CS_Selector);
    printf("Initial:  FPU_Env.Opcode		  = %.4hx\n",
       (short)FPU_Env.Opcode	 );
    printf("Initial:  FPU_Env.Data_Operand_Offset = %.8x\n",
       FPU_Env.Data_Operand_Offset);
    printf("Initial:  FPU_Env.Operand_Selector	  = %.4hx\n",
       (short)FPU_Env.Operand_Selector);

    // Set default environment in FPU
    fesetenv(FE_DFL_ENV);

    // Get it
    AV ("FSTENV %0":"=m"(*&FPU_Env));

    printf("Default:  FPU_Env.Control_Word	  = %.4hx\n",
       (short)FPU_Env.Control_Word);
    printf("Default:  FPU_Env.Status_Word	  = %.4hx\n",
	(short)FPU_Env.Status_Word);
    printf("Default:  FPU_Env.Tag_Word		  = %.4hx\n",
       (short)FPU_Env.Tag_Word);
    printf("Default:  FPU_Env.IP_Offset		  = %.8x\n",
       FPU_Env.IP_Offset);
    printf("Default:  FPU_Env.CS_Selector	  = %.4hx\n",
       (short)FPU_Env.CS_Selector);
    printf("Default:  FPU_Env.Opcode		  = %.4hx\n",
       (short)FPU_Env.Opcode	 );
    printf("Default:  FPU_Env.Data_Operand_Offset = %.8x\n",
       FPU_Env.Data_Operand_Offset);
    printf("Default:  FPU_Env.Operand_Selector	  = %.4hx\n",
       (short)FPU_Env.Operand_Selector);

    // Modify Default with Flt. Pt. Calc.
    x = 1; y = 3; z = x / y;

	AV ("FSTENV %0":"=m"(*&FPU_Env));
    fesetenv(&FPU_Env);

    printf("(After)  FPU_Env.Control_Word = %.8x\n",
	FPU_Env.Control_Word);
    printf("(After)  FPU_Env.Status_Word  = %.8x\n",
	FPU_Env.Status_Word);
}
# endif
