// Function fdim()
//
// From ISO C99:
//
// Synopsis
//
//
//	#include <math.h>
//	double fdim(double x, double y);
//
// Description
//
// The fdim function computes the floating-point positive
// difference, x - y.
//
// Returns
//
// For finite x and y, if x > y, fdim() returns the value x - y.
// A value of 0 is returned otherwise.	The inexact exception
// flag is raised when either x or y is NaN or Infinite or x < y.
//
//
// Prepared for DJGPP/GNU by KB Williams, kbwms@aol.com,
// February 2002
//
#include <errno.h>
#include <fdlibml.h>
#include <fenv.h>

double
fdim (double x, double y)
{
    double Retval;

    if (isnand(x) || isnand(y))
    {
	Retval = NAN;
	__math_set_errno(EDOM);
	__fp_raise_except(FE_INEXACT);
    }
    else if (x <= y)
    {
	Retval = 0;
    }
    else				// x > y		
    {
    	feclearexcept(FE_OVERFLOW|FE_UNDERFLOW);

	Retval = x - y;

	if (fetestexcept(FE_OVERFLOW|FE_UNDERFLOW))
	{
	    __math_set_errno(ERANGE);
	}
	if (fetestexcept(FE_OVERFLOW))
	{
	    Retval = HUGE_VAL;
	}    		    		       
    }
    				       
    return Retval;
}
