// -------------
// fclrexcpt.c
// -------------
//
// Prepared for DJGPP/GCC by KB Williams, kbwms@aol.com,
// February 2002
//
// From ISO C99:
//
// Function feclearexcept() attempts to clear supported exceptions
// represented by its argument.	 These exceptions include:
//
//	   FE_INVALID	   Invalid operation
//	   FE_DENORMAL	   Denormalized operand	 (added by KBW)
//	   FE_DIVBYZERO	   Division by zero
//	   FE_OVERFLOW	   Overflow
//	   FE_UNDERFLOW	   Underflow
//	   FE_INEXACT	   Precision loss
//
// Synopsis:
//
//   #include <fenv.h>
//   int feclearexcept(int Excepts);
//
//   where Excepts is any one or a combination (logical or) of
//   the exceptions (macros) listed above.  The numerical value
//   of each macro is given in <fenv.h>.
//
//   Return value is 0 (no errors) if argument Excepts is zero or
//   if all specified exceptions were cleared.

#include <fenv.h>

#define AV	__asm__ __volatile__

#define FEX_CLR(Xcpt)				\
    {						\
	fenv_t	FPU_Env;			\
	AV ("FSTENV %0" : "=m" (*&FPU_Env));	\
	FPU_Env.Status_Word &= Xcpt;		\
	AV ("FLDENV %0" : : "m" (*&FPU_Env));	\
	AV ("FWAIT");				\
    }

// -----------------------------------------
// Clears exceptions as indicated by Excepts
// -----------------------------------------
int
feclearexcept(int Excepts)
{
    // Clears specified and supported exceptions.
    FEX_CLR(~(FE_ALL_EXCEPT & Excepts));
          
    // Returns non-zero if any exceptions were not cleared.
    return (fetestexcept(Excepts) & (FE_ALL_EXCEPT & Excepts));
}
