// -----------
// dladdldbl.c
// -----------
//
// Function DlAddLdbl
//
// Adds two double-length long double precision arguments using
// extra-precision arithmetic.
//
// Returns a double-length long double result in space provided in
// the calling sequence.
//
// If no errors are detected, zero is returned as a function value.       .
// If one of the arguments is either a NaN or Infinity, -1 is returned.
//
// int DlAddLdbl(long double HeadA, long double TailA,
//               long double HeadB, long double TailB,
//              long double *HeadC, long double *TailC);
//
#include <fdlibml.h>
#include <fenv.h>

int
DlAddLdbl(long double HeadA, long double TailA,
    long double HeadB, long double TailB,
    long double *HeadC, long double *TailC)
{
    int     ErrFlag = 0;

    if (!isfinitel(HeadA))
    {
	ErrFlag = -1;
    }
    else if (!isfinitel(HeadB))
    {
	ErrFlag = -2;
    }
    else
    {
    	int	CrntRndMode;

	volatile long double S1, S2, T1, T2;

	CrntRndMode = fegetround();
	fesetround(FE_TOWARDZERO);

	S1 = HeadA + HeadB;

	if (fabsl(HeadA) > fabsl(HeadB))
	{
	    S2 = (HeadA - S1);
	    S2 += HeadB;
	    S2 += TailB;
	    S2 += TailA;
	}
	else
	{
	    S2 = (HeadB - S1);
	    S2 += HeadA;
	    S2 += TailA;
	    S2 += TailB;
	}

	T1 = S1 + S2;
	T2 = S1 - T1;
	T2 += S2;

	*HeadC = T1;
	*TailC = T2;

	fesetround(CrntRndMode);
    }

    return ErrFlag;
}
