// ----------
// dladdflt.c
// ----------
//
// Function DlAddFlt
//
// Adds two float-length floating point arguments using
// extra-precision arithmetic.
//
// Returns a float-length floating point result in space provided in
// the calling sequence.
//
// If no errors are detected, zero is returned as a function value.       .
// If one of the arguments is either a NaN or Infinity, -1 is returned.
//
// int DlAddFlt(float HeadA, float TailA,
//		float HeadB, float TailB,
//		float *HeadC, float *TailC);
//
#include <fdlibml.h>
#include <fenv.h>

int
DlAddFlt(float HeadA, float TailA,
	 float HeadB, float TailB,
	 float *HeadC, float *TailC)
{
    int     ErrFlag = 0;

    if (!isfinited(HeadA))
    {
	ErrFlag = -1;
    }
    else if (!isfinited(HeadB))
    {
	ErrFlag = -2;
    }
    else
    {
    	int	CrntRndMode;

	volatile
	float	S1, S2, T1, T2;

	CrntRndMode = fegetround();
	fesetround(FE_TOWARDZERO);

	S1 = HeadA + HeadB;

	if (fabsf(HeadA) > fabsf(HeadB))
	{
	    S2 = (HeadA - S1);
	    S2 += HeadB;
	    S2 += TailB;
	    S2 += TailA;
	}
	else
	{
	    S2 = (HeadB - S1);
	    S2 += HeadA;
	    S2 += TailA;
	    S2 += TailB;
	}

	T1 = S1 + S2;
	T2 = S1 - T1;
	T2 += S2;

	*HeadC = T1;
	*TailC = T2;

	fesetround(CrntRndMode);
    }

    return ErrFlag;
}
