// -----------
// dladd_dbl.c
// -----------
//
// Function DlAddDbl
//
// Adds two double-length double precision arguments using
// extra-precision arithmetic.
//
// Returns a double-length double result in space provided in
// the calling sequence.
//
// If no errors are detected, zero is returned as a function value.       .
// If one of the arguments is either a NaN or Infinity, -1 is returned.
//
// int DlAddDbl(double HeadA, double TailA,
//		double HeadB, double TailB,
//		double *HeadC, double *TailC);
//
#include <fdlibml.h>
#include <fenv.h>

int
DlAddDbl(double HeadA, double TailA,
	 double HeadB, double TailB,
	 double *HeadC, double *TailC)
{
    int     ErrFlag = 0;

    if (!isfinited(HeadA))
    {
	ErrFlag = -1;
    }
    else if (!isfinited(HeadB))
    {
	ErrFlag = -2;
    }
    else
    {
    	int	CrntRndMode;

	volatile
	double	S1, S2, T1, T2;

	CrntRndMode = fegetround();
	fesetround(FE_TOWARDZERO);

	S1 = HeadA + HeadB;

	if (fabs(HeadA) > fabs(HeadB))
	{
	    S2 = (HeadA - S1);
	    S2 += HeadB;
	    S2 += TailB;
	    S2 += TailA;
	}
	else
	{
	    S2 = (HeadB - S1);
	    S2 += HeadA;
	    S2 += TailA;
	    S2 += TailB;
	}

	T1 = S1 + S2;
	T2 = S1 - T1;
	T2 += S2;

	*HeadC = T1;
	*TailC = T2;

	fesetround(CrntRndMode);
    }

    return ErrFlag;
}
