// ----------		
// builtins.h
// ----------		
# if !defined 	_BUILTINS_H_
#	define	_BUILTINS_H_

#ifdef __cplusplus
extern "C" {
#endif

#define	isgreater(x,y)		__builtin_isgreater(x,y)
#define	isgreaterequal(x,y)	__builtin_isgreaterequal(x,y)
#define	isless(x,y)		__builtin_isless(x,y)
#define	islessequal(x,y)	__builtin_islessequal(x,y)
#define	islessgreater(x,y)	__builtin_islessgreater(x,y)
#define	isunordered(x,y)	__builtin_isunordered(x,y)
#define iscompat(v, t)		(sizeof(v) == sizeof(t))

#define isfinite(x) 		  			\
    	(iscompat(x,long double)) ? (isfinitel(x)) :	\
	(iscompat(x,double))	  ? (isfinited(x)) :    isfinitef(x)
			
#define isinf(x) 		  			\
    	(iscompat(x,long double)) ? (isinfl(x)) :	\
	(iscompat(x,double))	  ? (isinfd(x)) :	isinff(x)
#if 0			
#define isnan(x) 		  			\
    	(iscompat(x,long double)) ? (isnanl(x)) :	\
	(iscompat(x,double))	  ? (isnand(x)) :	isnanf(x)
# endif			
#define signbit(x)					\
    	(iscompat(x,long double)) ? (signbitl(x)) :	\
	(iscompat(x,double))	  ? (signbitd(x)) :	signbitf(x)

#ifdef __cplusplus
}
#endif

# endif	// End of if !defined 	_BUILTINS_H_

