/* asinhl.c -- long double version of asinh.c.
 * Modified for DJGPP/GCC by KB Williams,
 * kbwms@aol.com, December 2001 && December 2003
 */

/*
 * ====================================================
 * Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
 *
 * Developed at SunPro, a Sun Microsystems, Inc. business.
 * Permission to use, copy, modify, and distribute this
 * software is freely granted, provided that this notice
 * is preserved.
 * ====================================================
 */

/* asinhl(x)
 * Method :
 *    Based on
 *	asinhl(x) = *logl [ |x| + sqrtl(x*x+1) ]
 *    we have
 *	asinhl(x) := (sign x)(logl(x)+ln2),	if x is large; else
 *	asinhl(x) := (sign x)*logl(2|x|+1/(|x|+sqrtl(x*x+1))) if|x|>2, else
 *	asinhl(x) := signl(x)*log1pl(|x| + x^2/(1 + sqrtl(1+x^2)))
 *
 *
 * Special cases:
 *	none
 *
 */

#include <errno.h>
#include <fdlibml.h>
#include <fenv.h>


#ifdef __STDC__
long double asinhl(long double Arg)
#else
long double asinhl(Arg)
long double Arg;
#endif
{
    int		SgnBit;
    long double Retval;

    SgnBit = signbitl(Arg);
    Arg = fabsl(Arg);

    if (!isfinitel(Arg) || Arg == 0.0L)
    {
	Retval = Arg;
    }
    else if (Arg <= 1.0L/TWO_32)
    {
    	if (fpclassifyl(Arg) == FP_SUBNORMAL)
        {
    	    __math_set_errno(ERANGE);
	    __fp_raise_except(FE_UNDERFLOW);
    	}
	Retval = Arg;
    }
    else
    {
	if (Arg <= 2.0L)
	{
	    long double ArgSq = Arg*Arg;
	    Retval = log1pl(Arg + ArgSq/(1.0L + sqrtl(ArgSq + 1.0L)));
	}
	else if (Arg < TWO_32)
	{
	    Retval =
		logl(Arg+Arg + 1.0L / (Arg + sqrtl(Arg*Arg + 1.0L)));
	}
	else
	{
	    Retval = logl(Arg) + LOGE2L;
	}
    }
    return SgnBit ? -Retval : Retval;
}
