typedef void (*FUNC) (void);


#define va_arg                  __builtin_va_arg
#define va_end                  __builtin_va_end
#define va_start(ap, last_arg)  __builtin_stdarg_start((ap), (last_arg))
typedef __builtin_va_list va_list;


static void
xputc (int ch)
{
    if (ch == '\n') {
	__asm("movb $0x02, %%ah; int $0x21"::"d"('\r'):"%eax");
    }
    __asm("movb $0x02, %%ah; int $0x21"::"d"(ch):"%eax");
}


static void
xputs (const char *s)
{
    while (*s) {
        int ch = *s++;
	xputc(ch);
    }
}


static void
xputv (int x)
{
    char hexbuf[9];
    int c, i = 9;
    hexbuf[--i] = 0;
    while (i) {
        c = x & 0xf;
        if (c > 9) {
            c += 7;
        }
        c += 0x30;
        hexbuf[--i] = c;
        x >>= 4;
    }
    xputs(hexbuf);
}


void
xprintf (const char *fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    for (;;) {
        int ch = *fmt++;
        if (ch == '%') {
            ch = *fmt++;
            if (ch == 'x') {
                int v = va_arg(ap, int);
                xputv(v);
                continue;
            } else if (ch == 's') {
                char *s = va_arg(ap, char *);
                xputs(s);
                continue;
            } else if (ch != '%') {
                xputc('%');
            }
        }
        if (!ch) {
            break;
        }
        xputc(ch);
    }
    va_end(ap);
}


/****************************************************************************/


void lib1_main (void);

int exec_major = 1;
static int exec_minor = 2;
extern int lib1_major;


void
exec_something (void)
{
    xprintf("exec_something\n");
}


static void
execute_code (FUNC f)
{
    f();
}


void
__crt1_startup (void)
{
    /*__asm("int $3");*/
    /* indirect call here */
    execute_code(exec_something);
    /* call to global function here */
    /* access global variable here */
    /* access local variable here */
    /* access external variable from lib1 */
    xprintf("exec: %x.%x -> %x\n", exec_major, exec_minor, lib1_major);
    /* direct call to lib1 */
    lib1_main();
    /* call to local function here */
    /* indirect call to lib1 */
    execute_code(lib1_main);
}
