#include <crt0.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stubinfo.h>

#include <assert.h>
#include <setjmp.h>
#include <signal.h>
jmp_buf jb;
void (*old_sigill) (int);

#include <crt0/internal.h>
#include <crt0/list.h>


void __attribute__((constructor))
constructor (void)
{
    printf("%s\n", __FUNCTION__);
}


void __attribute__((destructor))
destructor (void)
{
    printf("%s\n", __FUNCTION__);
}


static void
handler (int signal)
{
    longjmp(jb, signal + 1);	/* so we can tell... also ensure we don't pass 0 */
}


extern int _stklen;
extern int __djgpp_stack_top, __djgpp_stack_limit, __djgpp_base_address;

extern stone_object objects;


int
main (int argc, char **argv)
{
    int i, j;
    stone_object *obj;
    printf("_stklen = %x / %x (%x -> %x)\n", _stklen, __djgpp_stack_top - __djgpp_stack_limit, __djgpp_stack_limit, __djgpp_stack_top);
    printf("_crt0_startup_flags = %x\n", _crt0_startup_flags);
    printf("__djgpp_base_address = %x\n", __djgpp_base_address);
    printf("__djgpp_memory_handle_list = %p\n", (void *)__djgpp_memory_handle_list);
    printf("      *\t%lx %lx\t-> %lx\n", _stubinfo->memory_handle, _stubinfo->initial_size, _stubinfo->memory_handle + _stubinfo->initial_size);
    for (i = 1; __djgpp_memory_handle_list[i].handle; i++) {
	printf("\t%x %x\t-> %x\n", __djgpp_memory_handle_list[i].address, __djgpp_memory_handle_size[i], __djgpp_memory_handle_list[i].address + __djgpp_memory_handle_size[i]);
    }
    list_foreach (obj, &objects) {
	printf("[%s] %p\n", obj->src, (void *)obj);
	printf("\tcode: %p + %x\n", obj->code, obj->len);
	printf("\tsyms: %d at %p\n", obj->nsym, (void *)obj->sym);
#if 0
	for (j = 0; j < obj->nsym; j++) {
	    printf("\t\t%s: \n", obj->sym[j].name);
	}
#else
	(void)j;
#endif
	printf("\tsyns: %d at %p\n", obj->nsyn, (void *)obj->syn);
	printf("\trels: %d at %p\n", obj->nrel, (void *)obj->rel);
	printf("\tdeps: %d at %p\n", obj->ndep, (void *)obj->dep);
    }
#if 1
    printf("argc = %d\n", argc);
    for (i = 0; i < argc; i++) {
	printf("argv[%d] = `%s'\n", i, argv[i]);
    }
#endif
#if 1
    old_sigill = signal(SIGILL, handler);
    if (setjmp(jb)) {
	printf("SIGILL\n");
    } else {
	__asm(".long -1");
    }
#endif
    return 0;
}
