/* dispatchers.c - dispatchers for the Gator watcher
*/
/*****************************************************************Includes*/
#include "gWatch.h"
#include "dispatchers.h"
#include <vpl3/gtr3FileDispatchers.h>
/*********************************************************Init dispatchers*/
bool getGatorInfo(void) {
  /* check for Gators database and open if present
  */
  bool rv = true;
  char gatorFilePath[260];

  // get filename
  strcpy(gatorFilePath, gamePath);
  strcat(gatorFilePath, "GATORS.HST");
  // check if file exists (if not, exit)
  if (!(gatorsAvailable = (access(gatorFilePath, R_OK | W_OK) == 0))) return(rv);
  // open file
  if (rv) rv = openGatorDB();
  if (!rv) errCode = EOPENGTR3GTRDB;

  return(rv);
} // getGatorInfo()
/***************************************************Functional dispatchers*/
bool makeGatorTable(void) {
  bool rv = true;
  short iGator;
  gatorType gator;

  for (iGator = 1; rv && (iGator <= maxGators); iGator++) {
    if (rv) rv = readGatorRecord(&gator, iGator);
    if (!rv || !gator.owner || gator.isMini) continue;
    duelprint("Gator #%.2d; owner %.2d; coords: (%.4d,%.4d)\n", gator.ID, gator.owner, gator.xCoord, gator.yCoord);
  } // for

  return(rv);
} // makeGatorTable()

bool makeMinigateTable(void) {
  bool rv = true;
  short iGator;
  gatorType gator;

  for (iGator = 1; rv && (iGator <= maxGators); iGator++) {
    if (rv) rv = readGatorRecord(&gator, iGator);
    if (!rv || !gator.owner || !gator.isMini) continue;
    duelprint("%s MiniGate #%.2d; owner %.2d; coords: (%.4d,%.4d)\n", ((gator.isReceiving) ? ("Receiving") : ("Sending")), gator.ID, gator.owner, gator.xCoord, gator.yCoord);
  } // for

  return(rv);
} // makeMinigateTable()

bool makeShipTable(void) {
  bool rv = true, gatorFound;
  short iShip, iGator;
  shipRecordType ship;
  gatorType gator;

  for (iShip = 1; rv && (iShip <= numberOfShips); iShip++) {
    if (rv) rv = readShip(&ship, iShip);
    if (!rv || !ship.owner || (ship.fCode[0] != 'J') || !val(ship.fCode + 1)) continue;
    gatorFound = false;
    for (iGator = 1; iGator <= maxGators; iGator++) {
      if (rv) rv = readGatorRecord(&gator, iGator);
      if (!rv || !gator.owner || (ship.xCoord != gator.xCoord) || (ship.yCoord != gator.yCoord)) continue;
      gatorFound = true;
      break;
    } // for
    if (rv && gatorFound) duelprint("Ship #%.3d; owner %.2d; at Gator #%.2d, jumping to Gator #%.2d\n", ship.ID, ship.owner, gator.ID, val(ship.fCode + 1));
  } // for

  return(rv);
} // makeShipTable()
/**************************************************************************/
