/* enhancerOptions.h - header to enhancerOptions.c
*/
#if !defined(__ENH2__) && !defined(__VPL3__) && !defined(VPL3)
#error This header was not intended for use by non-RLSystems software!
#endif
#ifndef ENH2_ENHANCEROPTIONS_H
#define ENH2_ENHANCEROPTIONS_H
/*****************************************************************Includes*/
#include <vpl3/enh2Structures.h>
/******************************************************************Defines*/
// filenames for ENH2 databases
#define componentFileName "ENH2_CMP.DAT" // towed components
#define towedBaseFileName "ENH2_TSB.DAT" // towed starbases
#define enhancedFileName  "ENH2_ENH.DAT" // database with enhanced starbases
// UFO data
#define ENH2_UFOCode      1422
#define ENH2_UFONameBase  "Starbase"
#define ENH2_UFOInfo1Base "adrift"
#define ENH2_UFOInfo2Base ""
#define ENH2_UFONameCmp   "Ship component"
#define ENH2_UFOInfo1Cmp  "adrift"
#define ENH2_UFOInfo2Cmp  ""
// fCodes
#define unloadEngines           "UE" // third indicates tech level of engines to unload
#define unloadBeamWeapons       "UB" // third indicates tech level of beam weapons to unload
#define unloadTorpedoTubes      "UT" // third indicates tech level of torpedo tubes to unload
#define unloadHulls             "UH" // third indicates type of hulls to unload
#define unloadAll               "UNA"
#define enh2_unloadEngines      "uE" // third indicates tech level of engines to unload
#define enh2_unloadBeamWeapons  "uB" // third indicates tech level of beam weapons to unload
#define enh2_unloadTorpedoTubes "uT" // third indicates tech level of torpedo tubes to unload
#define enh2_unloadHulls        "uH" // third indicates type of hulls to unload
#define enh2_unloadAll          "uNA"
#define sendEngines             "SE" // third indicates tech level of engines to load
#define sendBeamWeapons         "SB" // third indicates tech level of beam weapons to load
#define sendTorpedoTubes        "ST" // third indicates tech level of torpedo tubes to load
#define sendHulls               "SH" // third indicates type of hulls to load
#define sendAll                 "SOA"
/******************************************************************Globals*/
extern FILE *esbFile;
/*******************************************Enhanced Starbase Database I/O*/
bool openEnhancedBaseDB(void);
bool closeEnhancedBaseDB(void);
bool readEnhancedBaseRecord(enhancedBaseRecordType *ESB, short record);
bool writeEnhancedBaseRecord(enhancedBaseRecordType *ESB, short record);
/*************************************************************Data readers*/
bool getComponentTable(void);
bool getTowedBaseTable(void);
/*************************************************************Data writers*/
bool putComponentTable(void);
bool putTowedBaseTable(void);
/****************************************************************Table I/O*/
int countComponents(void);
int newComponent(void);
bool loadEngines(shipRecordType *ship, starbaseRecordType *starbase, byte techLevel);
bool loadBeamWeapons(shipRecordType *ship, starbaseRecordType *starbase, byte techLevel);
bool loadTorpedoes(shipRecordType *ship, starbaseRecordType *starbase, byte techLevel);
bool loadHulls(shipRecordType *ship, starbaseRecordType *starbase, byte techLevel);
int countTowedBases(void);
int newTowedBase(void);
bool hookStationaryStarbase(shipRecordType *ship, starbaseRecordType *starbase);
bool makeUFOTowedBase(towedBaseRecordType *T);
bool unmakeUFOTowedBase(towedBaseRecordType *T);
bool makeUFOComponent(componentRecordType *T);
bool unmakeUFOComponent(componentRecordType *T);
/**************************************************************************/
#endif // ENH2_ENHANCEROPTIONS_H
