/* Copyright (C) 1998 DJ Delorie, see COPYING.DJ for details */

typedef enum {
	CC_ALNUM, CC_ALPHA, CC_BLANK, CC_CNTRL, CC_DIGIT, CC_GRAPH, CC_LOWER,
	CC_PRINT, CC_PUNCT, CC_SPACE, CC_UPPER, CC_XDIGIT
} cclasstype;

/* character-class table */
static struct cclass {
	const char *name;
	cclasstype type;
	const char *multis;
} cclasses[] = {
	{ "alnum",	CC_ALNUM,	"" },
	{ "alpha",	CC_ALPHA,	"" },
	{ "blank",	CC_BLANK,	"" },
	{ "cntrl",	CC_CNTRL,	"" },
	{ "digit",	CC_DIGIT,	"" },
	{ "graph",	CC_GRAPH,	"" },
	{ "lower",	CC_LOWER,	"" },
	{ "print",	CC_PRINT,	"" },
	{ "punct",	CC_PUNCT,	"" },
	{ "space",	CC_SPACE,	"" },
	{ "upper",	CC_UPPER,	"" },
	{ "xdigit",	CC_XDIGIT,	"" },
	{ NULL,		0,		"" }
};
