/****************************************************************************/
/* TMENU                                                                    */
/*--------------------------------------------------------------------------*/
/* Objet TMenu (menu droulant)                                             */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 20/07/95                                                    */
/****************************************************************************/

#include <conio.h>
#include <stdlib.h>

#include "Const.h"

#include "JPAppli.h"

#include "Callback.h"
#include "Strings.h"
#include "TMenuBar.h"
#include "TWindow.h"

#include "TMenu.h"


/*ͻ*/
/*                    PROPRIETES DES ELEMENTS DES MENUS                   */
/*ͼ*/

class TMenuItemProperties:public TListItemProperties
{
  public :

    int                 f_short_cut;
    char               *f_help_message;

			TMenuItemProperties(int short_cut, const char *help_message);
    virtual            ~TMenuItemProperties();
};

typedef TMenuItemProperties *PMenuItemProperties;

TMenuItemProperties::TMenuItemProperties(int short_cut, const char *help_message)
{
  f_short_cut=short_cut;

  f_help_message=new char [strlen(help_message)+1];
  strcpy(f_help_message,help_message);
}

TMenuItemProperties::~TMenuItemProperties()
{
  delete []f_help_message;
}

/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************************************************************************/
/* Constructeur                                                             */
/*--------------------------------------------------------------------------*/
/****************************************************************************/

TMenu::TMenu(PMenuBar menu_bar,
             const char *caption,
	     const TMenuItem items[],
	     boolean enabled)
      :TList(NULL,
	     OBJ_MENU,
	     0,0,
	     0,0,
	     WHITE,
             caption,
             1,1,
	     0,0,
	     NOT_SORTED,
	     LI_DISABLED|LI_CHECKED|LI_TOGGLE,
	     FALSE,  // not always one item selected
	     TRUE,   // item hotkey enabled
	     FALSE,  // No scroll bar
             0,0,0,
	     enabled)
{
  // Couleur de la bordure de la fentre

  f_window->m_set_border_attr((WHITE<<4)+(unsigned)BLACK);

  // Barre de menus

  f_menu_bar=menu_bar;

  // Numro de menu (!= numro lment

  f_menu_nb=menu_bar->m_add_menu(this);

  // Il faut recalculer la taille du menu

  f_size_to_adjust=FALSE;

  // Largeur des shortcuts

  f_short_cut_width=0;

  // Ajout des lments

  if (items!=NULL)
    m_add_items(items);

  // Callback : Fonction appele si on clic sur un des lments
  // du menu

  InitCallback(f_item_clicked_action,f_item_clicked_argument);
}

/****************************************************************************/
/* Destructeur                                                              */
/*--------------------------------------------------------------------------*/
/****************************************************************************/

TMenu::~TMenu()
{
  // Destruction des variables dynamiques

  DestroyCallback(f_item_clicked_action,f_item_clicked_argument);
}

/****************************************************************************/
/* m_disable                                                                */
/*--------------------------------------------------------------------------*/
/* Rend l'objet inactivable                                                 */
/****************************************************************************/

void TMenu::m_disable()
{
  if (f_open)
    f_menu_bar->m_inactivate_menu_bar();

  TList::m_disable();
}

/****************************************************************************/
/* m_open                                                                   */
/*--------------------------------------------------------------------------*/
/* Opens the menu. Returns FALSE if it can't be open.		            */
/****************************************************************************/

boolean TMenu::m_open()
{
  if (f_open)
    return(TRUE);

  return(f_menu_bar->m_open_menu(f_menu_nb,TRUE));
}

/****************************************************************************/
/* m_close                                                                  */
/*--------------------------------------------------------------------------*/
/* Closes the menu. 							    */
/****************************************************************************/

void TMenu::m_close()
{
  if (f_open)
    f_menu_bar->m_close_menu();
}

/****************************************************************************/
/* m_click_item                                                             */
/*--------------------------------------------------------------------------*/
/* Clique dans un item du menu                                              */
/****************************************************************************/

void TMenu::m_click_item(int item_index)
{
  // Le menu est inactif

  if (!f_enabled)
    return;

  // L'objet de la fentre possdant le focus ne veut pas le lacher

//  if (!f_window->m_can_lose_focus())
//    return;

  m_item_clicked_callback(item_index);
}

/****************************************************************************/
/* m_set_item_clicked_callback                                              */
/*--------------------------------------------------------------------------*/
/* Dfinition du callback associ au clic d'un item du menu                 */
/****************************************************************************/

void TMenu::m_set_item_clicked_callback(void (*item_clicked_action)(PObject, int, const char *), const char *item_clicked_argument)
{
  SetCallback(f_item_clicked_action,f_item_clicked_argument,
	      item_clicked_action,item_clicked_argument);
}

/*ͻ*/
/*                          METHODES PROTEGEES                            */
/*ͼ*/

/**************************/
/* m_display : Affichage  */
/* ---------   de l'objet */
/**************************/

void TMenu::m_display()
{
  if (f_menu_bar->f_open)
    f_menu_bar->m_display_menu_caption(f_menu_nb);

  TList::m_display();
}

/****************************************************************************/
/* m_insert_item                                                            */
/*--------------------------------------------------------------------------*/
/* Ajout d'un lment au menu.                                              */
/* Retourne son index ou 0 si l'ajout est impossible.                       */
/****************************************************************************/

int TMenu::m_insert_item(int index, const char *label,
			 int attribute, int short_cut,
                         const char *help_message)
{
  int item_nb;
  TMenuItemProperties *properties;

  // Le menu doit tre ferm

  if (f_open)
    return(0);

  // Sparateur -> short_cut=SC_NONE, pas de message d'aide

  if (!strcmp(SEPARATOR,label))
    {
      short_cut=SC_NONE;
      help_message="";
    }

  // Ajout

  properties=new TMenuItemProperties(short_cut,help_message);
  item_nb=TList::m_add_item_to_list(index,label,attribute,properties);

  return(item_nb);
}

/****************************************************************************/
/* m_add_items                                                              */
/*--------------------------------------------------------------------------*/
/* Ajout d'lments au menu.                                                */
/* Chaque lment est de type TMenuItem                                     */
/* Dans le dernier lment, item[].label doit valoir NULL                   */
/* Retourne le nombre d'lments effectivement ajout                       */
/****************************************************************************/

int TMenu::m_add_items(const TMenuItem items[])
{
  register int nb_items;

  nb_items=0;
  while (items[nb_items].label!=NULL)
    {
      // Ajout d'un lment

      if ((m_add_item(items[nb_items].label,
		      items[nb_items].attribute,
		      items[nb_items].short_cut,
		      items[nb_items].help_message))==0)
	break;   // Plus de place pour ajouter

      nb_items++;
   }

  return(nb_items);
}

/****************************************************************************/
/* m_delete_item                                                            */
/*--------------------------------------------------------------------------*/
/* Suppression d'un lment de la liste.                                    */
/****************************************************************************/

void TMenu::m_delete_item(int item_index)
{
  // Le menu doit tre ouvert

  if (f_open)
    return;

  // Suppression lment

  TList::m_delete_item(item_index);

}

/****************************************************************************/
/* m_clear_list                                                             */
/*--------------------------------------------------------------------------*/
/* Efface la liste.                                                         */
/****************************************************************************/

void TMenu::m_clear_list()
{
  // Le menu doit tre ouvert

  if (f_open)
    return;

  TList::m_clear_list();

}

/****************************************************************************/
/* m_selected_item_changed_callback                                         */
/*--------------------------------------------------------------------------*/
/* Fonction appele quand l'lment slectionn du menu est modifi.        */
/****************************************************************************/

void TMenu::m_selected_item_changed_callback()
{
  PItemNode node;

  char *message="";

  if (f_selected_item_index!=0)
    {
      node=m_index_to_item(f_selected_item_index);
      if (node->properties!=NULL)
	message=PMenuItemProperties(node->properties)->f_help_message;
    }

  f_menu_bar->f_window->m_set_info_message(message);

  TList::m_selected_item_changed_callback();
}

/****************************************************************************/
/* m_nb_items_changed_callback                                              */
/*--------------------------------------------------------------------------*/
/* Fonction appele quand le nombre d'lments de la liste est modifi.     */
/****************************************************************************/

void TMenu::m_nb_items_changed_callback()
{
  f_size_to_adjust=TRUE;
  TList::m_nb_items_changed_callback();
}

/****************************************************************************/
/* m_item_clicked_callback                                                  */
/*--------------------------------------------------------------------------*/
/* Callback associ  un clic de l'un des lments du menu                  */
/****************************************************************************/

void TMenu::m_item_clicked_callback(int item_index)
{
  if (m_item_is_enabled(item_index))
    {
      // Elment de type TOGGLE ?

      if (m_item_attribute_is_set(item_index,LI_TOGGLE))
	{
	  if (!m_item_is_checked(item_index))
	    m_check_item(item_index);
	  else
	    m_uncheck_item(item_index);
	}

      // Callback utilisateur

      CallCallback(this, f_item_clicked_action, item_index,
                   f_item_clicked_argument);
    }
}

/****************************************************************************/
/* m_short_cut_pressed_event                                                */
/*--------------------------------------------------------------------------*/
/* Appele quand l'objet gre les acclrateurs de sa fentre.              */
/* Retourne TRUE si l'acclrateur intresse l'objet                        */
/****************************************************************************/

boolean TMenu::m_short_cut_pressed_event(int short_cut)
{
  register PItemNode node;
  register int       index;

  node=f_item_list;
  index=1;
  while (node!=NULL)
    {
      if ((((PMenuItemProperties)node->properties)->f_short_cut)==short_cut)
	{
	  m_click_item(index);
	  return(TRUE);
	}
      node=node->next;
      index++;
    }

  return(FALSE);
}


/*ͻ*/
/*                            METHODES PRIVEES                            */
/*ͼ*/

/****************************************************************************/
/* m_display_item_node_label                                                */
/*--------------------------------------------------------------------------*/
/* Affiche un lment de la liste d'aprs un pointeur sur cet lment       */
/* (la position d'affichage doit dj tre fixe ainsi que la couleur)      */
/* N'est pas appel pour les sparateurs                                    */
/****************************************************************************/

void TMenu::m_display_item_node_label(PItemNode node,boolean show_hot_key)
{
  f_window->m_put_caption(node->label,
			  show_hot_key,
			  f_list_width-1-f_short_cut_width,
			  JUSTIFIED_LEFT);

  if (f_short_cut_width!=0)
    {
      f_window->m_putch(' ');
      f_window->m_put_caption(GetShortCutLabel(((PMenuItemProperties)node->properties)->f_short_cut),
			      FALSE,
			      f_short_cut_width-1,
			      JUSTIFIED_LEFT);
    }
}


/****************************************************************************/
/* m_adjust_size                                                            */
/*--------------------------------------------------------------------------*/
/* Fixe la taille du menu, de la liste et de la fentre en fonction         */
/* des lments du menu                                                     */
/****************************************************************************/

void TMenu::m_adjust_size()
{
  register PItemNode node;
  int                width,
		     height;
  register int       short_cut_length;
  int                temp;

  if (!f_size_to_adjust)
    return;

  f_size_to_adjust=FALSE;

  // Taille du menu sans les short-cuts

  width=(f_nb_items==0)?0:m_get_list_needed_width();
  height=(f_nb_items==0)?0:f_nb_items;

  // Taille des short-cuts

  short_cut_length=0;
  node=f_item_list;
  while (node!=NULL)
    {
      temp=GetShortCutLabelLength(((PMenuItemProperties)node->properties)->f_short_cut);
      if (temp>=short_cut_length)
	short_cut_length=temp;
      node=node->next;
    }

  if (short_cut_length!=0)
    short_cut_length+=2;
  f_short_cut_width=short_cut_length;

  // Taille finale

  width+=short_cut_length;
  f_width=width+2;
  f_height=height+2;

  m_set_list_size(MAX(width,0),MAX(height,0));

  f_parent->m_set_size(f_width,f_height);
}

/****************************************************************************/
/* m_leave_event_if_mouse_leave_list                                        */
/*--------------------------------------------------------------------------*/
/* Appele dans l'vnement m_left_button_pressed_event lorsque la souris   */
/* quitte la zone de la liste.                                              */
/* Si TRUE est retourne, l'vnement m_left_button_pressed_event est       */
/* interrompue                                                              */
/****************************************************************************/

boolean TMenu::m_leave_event_if_mouse_leave_list(int x,int y)
{
  int x1=f_menu_bar->m_get_x();
  int x2=x1+f_menu_bar->f_width-1;
  int y1=f_menu_bar->m_get_y();

  if ((x>=x1) && (x<=x2) && (y==y1))
    return(TRUE);

  return(FALSE);
}

/****************************************************************************/
/* m_item_hot_key_pressed_event                                             */
/*--------------------------------------------------------------------------*/
/* Appele quand la hot-key d'un lment actif a t presse                */
/****************************************************************************/

void TMenu::m_item_hot_key_pressed_event(int item_index)
{
  f_menu_bar->m_inactivate_menu_bar();
  JPRefresh();

  m_item_clicked_callback(item_index);
}

