/****************************************************************************/
/* THELPWND.H                                                               */
/*--------------------------------------------------------------------------*/
/* THelpWindow class                                                        */
/****************************************************************************/

#ifndef _THELPWND_H_
#define _THELPWND_H_

#include "Types.h"

#include "TWindow.h"


/*ͻ*/
/*                             CLASS DEFINITION                           */
/*ͼ*/

class THelpWindow:public TWindow
{
  /*----------------*/
  /* Friend classes */
  /*----------------*/

  friend THelpTextZone;

  /*----------------*/
  /* Private fields */
  /*----------------*/

  private:

    // Push-Buttons

    PPushButton
	    f_contents_button,
	    f_index_button,
	    f_back_button,
	    f_previous_button,
	    f_next_button;

    // Help text

    PHelpTextZone
	    f_help_text_zone;


  /*----------------*/
  /* Public methods */
  /*----------------*/

  public:

    // Constructor / Destructor


		     THelpWindow(int x ,int y,
			     int width, int height,
			     const char *caption= "",
			     boolean modal=TRUE,
			     boolean movable=TRUE);

    virtual  	     ~THelpWindow();

    // Access methods

	    boolean m_load_help_file(const char *file_name);
	    void    m_unload_help_file();
	    boolean m_display_topic(const char *topic, boolean push_current_topic=TRUE);

	    void    m_select_contents_topic();
	    void    m_select_index_topic();
	    void    m_select_back_topic();
	    void    m_select_previous_topic();
	    void    m_select_next_topic();


  /*-------------------*/
  /* Protected methods */
  /*-------------------*/

  protected:

    static  void    m_button_pressed_call(PObject button, const char *argument);


  /*-----------------*/
  /* Private methods */
  /*-----------------*/

  private:

};

#endif