/****************************************************************************/
/* TGAUGE                                                                   */
/*--------------------------------------------------------------------------*/
/* Objet TGauge (jauge)                                                     */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 19/06/95                                                    */
/****************************************************************************/

#include <conio.h>
#include <stdio.h>

#include "Const.h"

#include "Strings.h"
#include "TWindow.h"

#include "TGauge.h"

/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************************************************************************/
/* Constructeur                                                             */
/*--------------------------------------------------------------------------*/
/* parent           : Objet auquel appartient l'objet                       */
/* rel_x,rel_y      : Coordonnes de l'objet p/r au groupe                  */
/* width            : Dimensions de l'objet                                 */
/* caption          : Lgende de l'objet (hot-key prcd de ~)             */
/* style            : Style de la jauge (cf TGAUGE.H)                       */
/* max_value        : Valeur maximum de la jauge                            */
/****************************************************************************/

TGauge::TGauge(PObject parent,
	       int rel_x,int rel_y,
               int width,
	       char *caption,
               TGaugeStyle style,
               long max_value)

       :TObject(parent,
		OBJ_GAUGE,
		rel_x,rel_y,
                width,2,
		(parent==NULL)?((unsigned)WHITE):parent->m_get_background(),
                caption,
		DISABLED,
		FALSE,  // NOT_FOCUS_DEPENDING_ASPECT
		FALSE,  // CANNOT_BE_ENABLED,
		TRUE),  // SIMPLE
	   bright_gauge_attr((WHITE<<4)+(unsigned)BLACK), 
	   normal_gauge_attr((LIGHTGRAY<<4)+(unsigned)BLACK)
{
  f_max_value=max_value;
  f_value=0;

  f_style=style;

  f_old_text_length=0;
}


/****************************************************************************/
/* Destructeur                                                              */
/*--------------------------------------------------------------------------*/
/****************************************************************************/

TGauge::~TGauge()
{
}

/****************************************************************************/
/* m_set_value                                                              */
/*--------------------------------------------------------------------------*/
/* Modifie la valeur de la jauge (la restreint si besoin aux limites)       */
/****************************************************************************/

void TGauge::m_set_value(long value)
{
  if (value<0)
    value=0;
  else
    if (value>f_max_value)
      value=f_max_value;

  if (value!=f_value)
    {
      f_value=value;
      m_display_gauge();
    }
}


/****************************************************************************/
/* m_set_max_value                                                          */
/*--------------------------------------------------------------------------*/
/* Modifie la valeur maximale de la jauge                                   */
/****************************************************************************/

void TGauge::m_set_max_value(long max_value)
{
  long old_value=f_value;

  f_max_value=max_value;

  // Pour que la jauge soit raffiche, il faut que la valeur
  // affecte soit diffrente de f_value

  f_value++;
  m_set_value(old_value);
}

/*ͻ*/
/*                           METHODES PROTEGEES                           */
/*ͼ*/

/*ͻ*/
/*                            METHODES PRIVEES                            */
/*ͼ*/

/****************************************************************************/
/* m_display                                                                */
/*--------------------------------------------------------------------------*/
/* Affichage de l'objet                                                     */
/****************************************************************************/

void TGauge::m_display()
{
  m_display_caption();
  m_display_gauge();
}

/****************************************************************************/
/* m_display_caption                                                        */
/*--------------------------------------------------------------------------*/
/* Affichage de la lgende de l'objet                                       */
/****************************************************************************/

void TGauge::m_display_caption()
{
  int x,y;

  if (!f_open)
    return;

  x=m_get_x_in_window();
  y=m_get_y_in_window();

  f_window->m_set_normal_attr(f_background);
  f_window->m_gotoxy(x,y);
  f_window->m_put_caption(f_caption,FALSE,
			  f_width,JUSTIFIED_LEFT);
}

/****************************************************************************/
/* m_display_gauge                                                          */
/*--------------------------------------------------------------------------*/
/* Affichage de la jauge (partie qui change avec la valeur)                 */
/****************************************************************************/

void TGauge::m_display_gauge()
{
  int x,y;
  int bright_width;

  char text[LONG_MAX_LENGTH+LONG_MAX_LENGTH+1];
  int  text_length;
  int  diff;


  if (!f_open)
    return;

  x=m_get_x_in_window();
  y=m_get_y_in_window();

  bright_width=(int)( (f_value*f_width ) / f_max_value);

  f_window->m_set_normal_attr(f_background);

  switch(f_style)
    {
      case GAUGE_PERCENT_STYLE : sprintf(text,"%ld%%",(100*f_value)/f_max_value);
				 break;
      case GAUGE_OUT_OF_STYLE  : sprintf(text,"%ld/%ld",f_value,f_max_value);
				 break;
    }

  text_length=strlen(text);
  if (text_length>f_width)
    {
      diff=f_width-text_length;
      text_length=f_width;
    }
  else
    diff=0;

  f_window->m_gotoxy(x+f_width-MAX(text_length,f_old_text_length),y);
  if (f_old_text_length>text_length)
    f_window->m_putnch(f_old_text_length-text_length,' ');
  f_window->m_puts(text+diff);
  f_old_text_length=text_length;


  f_window->m_textattr(bright_gauge_attr);
  f_window->m_gotoxy(x,y+1);
  f_window->m_putnch(bright_width,' ');
  f_window->m_textattr(normal_gauge_attr);
  f_window->m_putnch(f_width-bright_width,' ');

}


