#! /bin/sh
#
#  Make files.
#
#  Shell Skript zum Erzeugen aller djgpp port spezifischen Dateien.
#
#
#
#  Argumente:  keine
#              Alle Argumente muessen intern editiert werden.
#
#
#   FILE_NAME:  foobar    (Name der Bestandteil des Announcement-Dateinamens ist.  Bsp: foobar-announce.txt)
#
#


FILE_NAME="libjpeg"

cat > script.sed << EOS
/^##  START @AC_VERSION@/,/^##  END @AC_VERSION@/ {
  /^##  START @AC_VERSION@=2.68$/,/^##  END @AC_VERSION@=2.68$/!d
}
/^##  START @AC_VERSION@/d
/^##  END @AC_VERSION@/d
s/@PRODUCT_NAME@/Lib JPEG/g
s/@PRODUCT_VER@/8d/g
s/@NAME@/jpeg/g
s/@VER@/8d/g
s/@EXT@//g
s/@DIRECTORY@/8d/g
s/@FILE_NAME@/${FILE_NAME}/g
s/@TIME_STAMP@/2012-04-30/g
s/@AC_VERSION@/2.68/g
/^:<#neue option teil.*#>$/d
/^:# Beginn[ ]*Zusaetzlich zu veraendernde Dateinamen.$/,/^:# Ende[ ]*Zusaetzlich zu veraendernde Dateinamen.$/ d
/^:# Beginn[ ]*Zusaetzlich zu veraendernde Dateien.$/,/^:# Ende[ ]*Zusaetzlich zu veraendernde Dateien.$/ d
EOS

FILES="config.bat config.sed README ../${FILE_NAME}-announce.txt"
for FILE in $FILES; do
  if [ ! -f $FILE.orig ]; then
    mv -vf $FILE $FILE.orig
  fi
  sed -f script.sed $FILE.orig > $FILE
  if [ "x$FILE" != "xconfig.bat" ]; then
    dtou $FILE
  fi
done

rm -vf script.sed
