/*
 * Copyright (c) 2003, 2006 Matteo Frigo
 * Copyright (c) 2003, 2006 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Fri Jan 27 20:29:37 EST 2006 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2hc -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -twiddle-log3 -precompute-twiddles -n 16 -dit -name hf2_16 -include hf.h */

/*
 * This function contains 196 FP additions, 134 FP multiplications,
 * (or, 104 additions, 42 multiplications, 92 fused multiply/add),
 * 112 stack variables, and 64 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.8 2006-01-05 03:04:27 stevenj Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.15 2006-01-05 03:04:27 stevenj Exp $
 */

#include "hf.h"

static const R *hf2_16(R *rio, R *iio, const R *W, stride ios, INT m, INT dist)
{
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     INT i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 8, MAKE_VOLATILE_STRIDE(ios)) {
	  E T3S, T3R;
	  {
	       E T3, T6, Tf, TM, T2, Th, T4, Tp, Tt, Ta, Tz, Ti, Tm, TC, TO;
	       E T1e, T1C, T1i, TT, TP, T1y, T5;
	       {
		    E TS, TN, Tl, Tg;
		    T3 = W[0];
		    T6 = W[1];
		    Tf = W[2];
		    TM = W[6];
		    T2 = W[4];
		    Th = W[3];
		    Tl = Tf * T6;
		    Tg = Tf * T3;
		    TS = TM * T6;
		    TN = TM * T3;
		    T4 = T2 * T3;
		    Tp = T2 * Tf;
		    Tt = T2 * Th;
		    Ta = T2 * T6;
		    Tz = FMA(Th, T6, Tg);
		    Ti = FNMS(Th, T6, Tg);
		    Tm = FMA(Th, T3, Tl);
		    TC = FNMS(Th, T3, Tl);
		    TO = W[7];
		    T1e = T2 * Ti;
		    T1C = T2 * TC;
		    T1i = T2 * Tm;
		    TT = FNMS(TO, T3, TS);
		    TP = FMA(TO, T6, TN);
		    T1y = T2 * Tz;
		    T5 = W[5];
	       }
	       {
		    E T3L, T3A, T1U, Te, T2B, T3h, T1G, T2D, T3w, T1Z, Tx, T3M, T1R, T2w, T2I;
		    E T3i, T37, T25, T26, TL, T1s, T2m, T2t, T3d, T15, T1b, T2j, T38, T2d, T28;
		    E T12, T2h, T19, T18;
		    {
			 E T1m, T1f, T1p, T1j, TW, TI, TZ, TF, T1K, T2F, T1Q, T2H;
			 {
			      E Tq, Tu, T1L, T1O, T1x, T2y, T2A, T1F;
			      {
				   E T1, T3z, Tc, Tb, T7, T1z, T1D, T8;
				   T1 = rio[0];
				   T3z = iio[-WS(ios, 15)];
				   Tc = iio[-WS(ios, 7)];
				   T1m = FNMS(T5, Tm, T1e);
				   T1f = FMA(T5, Tm, T1e);
				   T1p = FMA(T5, Ti, T1i);
				   T1j = FNMS(T5, Ti, T1i);
				   TW = FMA(T5, Th, Tp);
				   Tq = FNMS(T5, Th, Tp);
				   Tb = FNMS(T5, T3, Ta);
				   TI = FMA(T5, T3, Ta);
				   TZ = FNMS(T5, Tf, Tt);
				   Tu = FMA(T5, Tf, Tt);
				   T7 = FMA(T5, T6, T4);
				   TF = FNMS(T5, T6, T4);
				   T1L = FMA(T5, TC, T1y);
				   T1z = FNMS(T5, TC, T1y);
				   T1O = FNMS(T5, Tz, T1C);
				   T1D = FMA(T5, Tz, T1C);
				   T8 = rio[WS(ios, 8)];
				   {
					E T1u, T1E, T1w, T1v, T2z, T2x, T1A, T1B;
					T1u = rio[WS(ios, 15)];
					T1E = iio[-WS(ios, 8)];
					{
					     E T3y, Td, T3x, T9;
					     T1w = iio[0];
					     T3x = Tb * T8;
					     T9 = T7 * T8;
					     T1v = TM * T1u;
					     T2z = T1z * T1E;
					     T3y = FMA(T7, Tc, T3x);
					     Td = FNMS(Tb, Tc, T9);
					     T2x = TM * T1w;
					     T1A = rio[WS(ios, 7)];
					     T3L = T3z - T3y;
					     T3A = T3y + T3z;
					     T1U = T1 - Td;
					     Te = T1 + Td;
					     T1B = T1z * T1A;
					}
					T1x = FMA(TO, T1w, T1v);
					T2y = FNMS(TO, T1u, T2x);
					T2A = FNMS(T1D, T1A, T2z);
					T1F = FMA(T1D, T1E, T1B);
				   }
			      }
			      {
				   E Tj, Tv, Tk, T1X, Tn, Tr;
				   Tj = rio[WS(ios, 4)];
				   Tv = iio[-WS(ios, 3)];
				   T2B = T2y - T2A;
				   T3h = T2y + T2A;
				   T1G = T1x + T1F;
				   T2D = T1x - T1F;
				   Tk = Ti * Tj;
				   T1X = Tq * Tv;
				   Tn = iio[-WS(ios, 11)];
				   Tr = rio[WS(ios, 12)];
				   {
					E T1P, T1J, T2E, T1H, T1I, T1N, T2G;
					{
					     E To, T1V, T1Y, Ts, T1W, Tw, T1M;
					     T1P = iio[-WS(ios, 4)];
					     T1J = iio[-WS(ios, 12)];
					     To = FMA(Tm, Tn, Tk);
					     T1V = Ti * Tn;
					     T1Y = FNMS(Tu, Tr, T1X);
					     Ts = Tq * Tr;
					     T2E = Tf * T1J;
					     T1W = FNMS(Tm, Tj, T1V);
					     T1H = rio[WS(ios, 3)];
					     Tw = FMA(Tu, Tv, Ts);
					     T1M = rio[WS(ios, 11)];
					     T3w = T1W + T1Y;
					     T1Z = T1W - T1Y;
					     T1I = Tf * T1H;
					     Tx = To + Tw;
					     T3M = To - Tw;
					     T1N = T1L * T1M;
					     T2G = T1O * T1M;
					}
					T1K = FMA(Th, T1J, T1I);
					T2F = FNMS(Th, T1H, T2E);
					T1Q = FNMS(T1O, T1P, T1N);
					T2H = FMA(T1L, T1P, T2G);
				   }
			      }
			 }
			 {
			      E T2s, T1r, T1l, T2q;
			      {
				   E TD, TJ, T23, TG, TA;
				   TD = iio[-WS(ios, 13)];
				   TJ = iio[-WS(ios, 5)];
				   T1R = T1K + T1Q;
				   T2w = T1Q - T1K;
				   T2I = T2F - T2H;
				   T3i = T2F + T2H;
				   T23 = TF * TJ;
				   TG = rio[WS(ios, 10)];
				   TA = rio[WS(ios, 2)];
				   {
					E T1k, T1q, T2r, T1n, T1o, T1h, T2p;
					{
					     E T24, TH, T21, TB;
					     T1k = iio[-WS(ios, 10)];
					     T1q = iio[-WS(ios, 2)];
					     T24 = FNMS(TI, TG, T23);
					     TH = TF * TG;
					     T21 = TC * TA;
					     TB = Tz * TA;
					     T2r = T1m * T1q;
					     {
						  E TK, T22, TE, T1g;
						  TK = FMA(TI, TJ, TH);
						  T22 = FMA(Tz, TD, T21);
						  TE = FNMS(TC, TD, TB);
						  T1n = rio[WS(ios, 13)];
						  T1g = rio[WS(ios, 5)];
						  T37 = T22 + T24;
						  T25 = T22 - T24;
						  T26 = TE - TK;
						  TL = TE + TK;
						  T1o = T1m * T1n;
						  T1h = T1f * T1g;
						  T2p = T1j * T1g;
					     }
					}
					T2s = FNMS(T1p, T1n, T2r);
					T1r = FMA(T1p, T1q, T1o);
					T1l = FNMS(T1j, T1k, T1h);
					T2q = FMA(T1f, T1k, T2p);
				   }
			      }
			      {
				   E TU, T10, TQ, TX, T16, T17;
				   TU = iio[-WS(ios, 1)];
				   T10 = iio[-WS(ios, 9)];
				   T1s = T1l + T1r;
				   T2m = T1l - T1r;
				   T2t = T2q - T2s;
				   T3d = T2q + T2s;
				   TQ = rio[WS(ios, 14)];
				   TX = rio[WS(ios, 6)];
				   {
					E T2a, TV, T2c, T11;
					T15 = rio[WS(ios, 1)];
					T1b = iio[-WS(ios, 6)];
					{
					     E T29, TR, T2b, TY;
					     T29 = TT * TQ;
					     TR = TP * TQ;
					     T2b = TZ * TX;
					     TY = TW * TX;
					     T16 = T3 * T15;
					     T2a = FMA(TP, TU, T29);
					     TV = FNMS(TT, TU, TR);
					     T2c = FMA(TW, T10, T2b);
					     T11 = FNMS(TZ, T10, TY);
					     T2j = T2 * T1b;
					}
					T17 = iio[-WS(ios, 14)];
					T38 = T2a + T2c;
					T2d = T2a - T2c;
					T28 = TV - T11;
					T12 = TV + T11;
					T2h = T3 * T17;
					T19 = rio[WS(ios, 9)];
				   }
				   T18 = FMA(T6, T17, T16);
			      }
			 }
		    }
		    {
			 E T36, T3F, T39, T2l, T3q, T14, T3G, T2o, T3g, T1S, T3E, T3C, T1t, T3b, T3e;
			 E T3r, T3s, T3j;
			 {
			      E T3v, T3c, T3B, T1d;
			      {
				   E Ty, T2i, T2k, T1a, T13, T1c;
				   T36 = Te - Tx;
				   Ty = Te + Tx;
				   T2i = FNMS(T6, T15, T2h);
				   T2k = FNMS(T5, T19, T2j);
				   T1a = T2 * T19;
				   T3F = T12 - TL;
				   T13 = TL + T12;
				   T3v = T37 + T38;
				   T39 = T37 - T38;
				   T2l = T2i - T2k;
				   T3c = T2i + T2k;
				   T1c = FMA(T5, T1b, T1a);
				   T3q = Ty - T13;
				   T14 = Ty + T13;
				   T3B = T3w + T3A;
				   T3G = T3A - T3w;
				   T1d = T18 + T1c;
				   T2o = T18 - T1c;
			      }
			      T3g = T1G - T1R;
			      T1S = T1G + T1R;
			      T3E = T3B - T3v;
			      T3C = T3v + T3B;
			      T1t = T1d + T1s;
			      T3b = T1d - T1s;
			      T3e = T3c - T3d;
			      T3r = T3c + T3d;
			      T3s = T3h + T3i;
			      T3j = T3h - T3i;
			 }
			 {
			      E T3m, T3a, T3J, T3H;
			      {
				   E T3D, T1T, T3u, T3t;
				   T3D = T1S - T1t;
				   T1T = T1t + T1S;
				   T3u = T3r + T3s;
				   T3t = T3r - T3s;
				   iio[-WS(ios, 4)] = T3D + T3E;
				   rio[WS(ios, 12)] = T3D - T3E;
				   rio[0] = T14 + T1T;
				   iio[-WS(ios, 8)] = T14 - T1T;
				   iio[0] = T3u + T3C;
				   rio[WS(ios, 8)] = T3u - T3C;
				   rio[WS(ios, 4)] = T3q + T3t;
				   iio[-WS(ios, 12)] = T3q - T3t;
			      }
			      T3m = T36 - T39;
			      T3a = T36 + T39;
			      T3J = T3G - T3F;
			      T3H = T3F + T3G;
			      {
				   E T2Q, T20, T3N, T3T, T2J, T2C, T3O, T2f, T34, T30, T2W, T2V, T3U, T2T, T2N;
				   E T2v;
				   {
					E T2R, T27, T2e, T2S;
					{
					     E T3n, T3f, T3o, T3k;
					     T2Q = T1U + T1Z;
					     T20 = T1U - T1Z;
					     T3n = T3e - T3b;
					     T3f = T3b + T3e;
					     T3o = T3g + T3j;
					     T3k = T3g - T3j;
					     T3N = T3L - T3M;
					     T3T = T3M + T3L;
					     {
						  E T3p, T3I, T3K, T3l;
						  T3p = T3n - T3o;
						  T3I = T3n + T3o;
						  T3K = T3k - T3f;
						  T3l = T3f + T3k;
						  rio[WS(ios, 6)] = FMA(KP707106781, T3p, T3m);
						  iio[-WS(ios, 14)] = FNMS(KP707106781, T3p, T3m);
						  iio[-WS(ios, 2)] = FMA(KP707106781, T3I, T3H);
						  rio[WS(ios, 10)] = FMS(KP707106781, T3I, T3H);
						  iio[-WS(ios, 6)] = FMA(KP707106781, T3K, T3J);
						  rio[WS(ios, 14)] = FMS(KP707106781, T3K, T3J);
						  rio[WS(ios, 2)] = FMA(KP707106781, T3l, T3a);
						  iio[-WS(ios, 10)] = FNMS(KP707106781, T3l, T3a);
						  T2R = T26 + T25;
						  T27 = T25 - T26;
						  T2e = T28 + T2d;
						  T2S = T28 - T2d;
					     }
					}
					{
					     E T2Y, T2Z, T2n, T2u;
					     T2J = T2D - T2I;
					     T2Y = T2D + T2I;
					     T2Z = T2B + T2w;
					     T2C = T2w - T2B;
					     T3O = T27 + T2e;
					     T2f = T27 - T2e;
					     T34 = FMA(KP414213562, T2Y, T2Z);
					     T30 = FNMS(KP414213562, T2Z, T2Y);
					     T2W = T2l - T2m;
					     T2n = T2l + T2m;
					     T2u = T2o - T2t;
					     T2V = T2o + T2t;
					     T3U = T2S - T2R;
					     T2T = T2R + T2S;
					     T2N = FNMS(KP414213562, T2n, T2u);
					     T2v = FMA(KP414213562, T2u, T2n);
					}
				   }
				   {
					E T33, T2X, T3X, T3Y;
					{
					     E T2M, T2g, T2O, T2K, T3V, T3W, T2P, T2L;
					     T2M = FNMS(KP707106781, T2f, T20);
					     T2g = FMA(KP707106781, T2f, T20);
					     T33 = FNMS(KP414213562, T2V, T2W);
					     T2X = FMA(KP414213562, T2W, T2V);
					     T2O = FNMS(KP414213562, T2C, T2J);
					     T2K = FMA(KP414213562, T2J, T2C);
					     T3V = FMA(KP707106781, T3U, T3T);
					     T3X = FNMS(KP707106781, T3U, T3T);
					     T3W = T2O - T2N;
					     T2P = T2N + T2O;
					     T3Y = T2K - T2v;
					     T2L = T2v + T2K;
					     iio[-WS(ios, 3)] = FMA(KP923879532, T3W, T3V);
					     rio[WS(ios, 11)] = FMS(KP923879532, T3W, T3V);
					     rio[WS(ios, 3)] = FMA(KP923879532, T2L, T2g);
					     iio[-WS(ios, 11)] = FNMS(KP923879532, T2L, T2g);
					     iio[-WS(ios, 15)] = FMA(KP923879532, T2P, T2M);
					     rio[WS(ios, 7)] = FNMS(KP923879532, T2P, T2M);
					}
					{
					     E T32, T3P, T3Q, T35, T2U, T31;
					     T32 = FNMS(KP707106781, T2T, T2Q);
					     T2U = FMA(KP707106781, T2T, T2Q);
					     T31 = T2X + T30;
					     T3S = T30 - T2X;
					     T3R = FNMS(KP707106781, T3O, T3N);
					     T3P = FMA(KP707106781, T3O, T3N);
					     iio[-WS(ios, 7)] = FMA(KP923879532, T3Y, T3X);
					     rio[WS(ios, 15)] = FMS(KP923879532, T3Y, T3X);
					     rio[WS(ios, 1)] = FMA(KP923879532, T31, T2U);
					     iio[-WS(ios, 9)] = FNMS(KP923879532, T31, T2U);
					     T3Q = T33 + T34;
					     T35 = T33 - T34;
					     iio[-WS(ios, 1)] = FMA(KP923879532, T3Q, T3P);
					     rio[WS(ios, 9)] = FMS(KP923879532, T3Q, T3P);
					     rio[WS(ios, 5)] = FMA(KP923879532, T35, T32);
					     iio[-WS(ios, 13)] = FNMS(KP923879532, T35, T32);
					}
				   }
			      }
			 }
		    }
	       }
	  }
	  iio[-WS(ios, 5)] = FMA(KP923879532, T3S, T3R);
	  rio[WS(ios, 13)] = FMS(KP923879532, T3S, T3R);
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 0, 1},
     {TW_CEXP, 0, 3},
     {TW_CEXP, 0, 9},
     {TW_CEXP, 0, 15},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 16, "hf2_16", twinstr, &GENUS, {104, 42, 92, 0}, 0, 0, 0 };

void X(codelet_hf2_16) (planner *p) {
     X(khc2hc_register) (p, hf2_16, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2hc -compact -variables 4 -pipeline-latency 4 -twiddle-log3 -precompute-twiddles -n 16 -dit -name hf2_16 -include hf.h */

/*
 * This function contains 196 FP additions, 108 FP multiplications,
 * (or, 156 additions, 68 multiplications, 40 fused multiply/add),
 * 82 stack variables, and 64 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.8 2006-01-05 03:04:27 stevenj Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.15 2006-01-05 03:04:27 stevenj Exp $
 */

#include "hf.h"

static const R *hf2_16(R *rio, R *iio, const R *W, stride ios, INT m, INT dist)
{
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     INT i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 8, MAKE_VOLATILE_STRIDE(ios)) {
	  E T3, T6, Tg, Ti, Tk, To, TE, TC, T5, T2, T8, TW, TJ, Tt, TU;
	  E Tc, Tx, TH, TN, TO, TP, TR, T1f, T1k, T1b, T1i, T1y, T1H, T1u, T1F;
	  {
	       E T7, Tw, Tb, Ts, T4, Tv, Ta, Tr;
	       {
		    E Th, Tn, Tj, Tm;
		    T3 = W[0];
		    T6 = W[1];
		    Tg = W[2];
		    Ti = W[3];
		    Th = Tg * T3;
		    Tn = Ti * T3;
		    Tj = Ti * T6;
		    Tm = Tg * T6;
		    Tk = Th - Tj;
		    To = Tm + Tn;
		    TE = Tm - Tn;
		    TC = Th + Tj;
		    T5 = W[5];
		    T7 = T5 * T6;
		    Tw = T5 * Tg;
		    Tb = T5 * T3;
		    Ts = T5 * Ti;
		    T2 = W[4];
		    T4 = T2 * T3;
		    Tv = T2 * Ti;
		    Ta = T2 * T6;
		    Tr = T2 * Tg;
	       }
	       T8 = T4 + T7;
	       TW = Tv - Tw;
	       TJ = Ta + Tb;
	       Tt = Tr - Ts;
	       TU = Tr + Ts;
	       Tc = Ta - Tb;
	       Tx = Tv + Tw;
	       TH = T4 - T7;
	       TN = W[6];
	       TO = W[7];
	       TP = FMA(TN, T3, TO * T6);
	       TR = FNMS(TO, T3, TN * T6);
	       {
		    E T1d, T1e, T19, T1a;
		    T1d = T2 * To;
		    T1e = T5 * Tk;
		    T1f = T1d - T1e;
		    T1k = T1d + T1e;
		    T19 = T2 * Tk;
		    T1a = T5 * To;
		    T1b = T19 + T1a;
		    T1i = T19 - T1a;
	       }
	       {
		    E T1w, T1x, T1s, T1t;
		    T1w = T2 * TE;
		    T1x = T5 * TC;
		    T1y = T1w + T1x;
		    T1H = T1w - T1x;
		    T1s = T2 * TC;
		    T1t = T5 * TE;
		    T1u = T1s - T1t;
		    T1F = T1s + T1t;
	       }
	  }
	  {
	       E Tf, T3r, T1N, T3e, TA, T3s, T1Q, T3b, TM, T2M, T1W, T2w, TZ, T2N, T21;
	       E T2x, T18, T1n, T2Q, T2R, T2S, T2T, T28, T2A, T2d, T2B, T1B, T1K, T2V, T2W;
	       E T2X, T2Y, T2j, T2D, T2o, T2E;
	       {
		    E T1, T3d, Te, T3c, T9, Td;
		    T1 = rio[0];
		    T3d = iio[-WS(ios, 15)];
		    T9 = rio[WS(ios, 8)];
		    Td = iio[-WS(ios, 7)];
		    Te = FNMS(Tc, Td, T8 * T9);
		    T3c = FMA(Tc, T9, T8 * Td);
		    Tf = T1 + Te;
		    T3r = T3d - T3c;
		    T1N = T1 - Te;
		    T3e = T3c + T3d;
	       }
	       {
		    E Tq, T1O, Tz, T1P;
		    {
			 E Tl, Tp, Tu, Ty;
			 Tl = rio[WS(ios, 4)];
			 Tp = iio[-WS(ios, 11)];
			 Tq = FMA(Tk, Tl, To * Tp);
			 T1O = FNMS(To, Tl, Tk * Tp);
			 Tu = rio[WS(ios, 12)];
			 Ty = iio[-WS(ios, 3)];
			 Tz = FMA(Tt, Tu, Tx * Ty);
			 T1P = FNMS(Tx, Tu, Tt * Ty);
		    }
		    TA = Tq + Tz;
		    T3s = Tq - Tz;
		    T1Q = T1O - T1P;
		    T3b = T1O + T1P;
	       }
	       {
		    E TG, T1S, TL, T1T, T1U, T1V;
		    {
			 E TD, TF, TI, TK;
			 TD = rio[WS(ios, 2)];
			 TF = iio[-WS(ios, 13)];
			 TG = FNMS(TE, TF, TC * TD);
			 T1S = FMA(TE, TD, TC * TF);
			 TI = rio[WS(ios, 10)];
			 TK = iio[-WS(ios, 5)];
			 TL = FMA(TH, TI, TJ * TK);
			 T1T = FNMS(TJ, TI, TH * TK);
		    }
		    TM = TG + TL;
		    T2M = T1S + T1T;
		    T1U = T1S - T1T;
		    T1V = TG - TL;
		    T1W = T1U - T1V;
		    T2w = T1V + T1U;
	       }
	       {
		    E TT, T1Y, TY, T1Z, T1X, T20;
		    {
			 E TQ, TS, TV, TX;
			 TQ = rio[WS(ios, 14)];
			 TS = iio[-WS(ios, 1)];
			 TT = FNMS(TR, TS, TP * TQ);
			 T1Y = FMA(TR, TQ, TP * TS);
			 TV = rio[WS(ios, 6)];
			 TX = iio[-WS(ios, 9)];
			 TY = FNMS(TW, TX, TU * TV);
			 T1Z = FMA(TW, TV, TU * TX);
		    }
		    TZ = TT + TY;
		    T2N = T1Y + T1Z;
		    T1X = TT - TY;
		    T20 = T1Y - T1Z;
		    T21 = T1X + T20;
		    T2x = T1X - T20;
	       }
	       {
		    E T14, T24, T1m, T2b, T17, T25, T1h, T2a;
		    {
			 E T12, T13, T1j, T1l;
			 T12 = rio[WS(ios, 1)];
			 T13 = iio[-WS(ios, 14)];
			 T14 = FMA(T3, T12, T6 * T13);
			 T24 = FNMS(T6, T12, T3 * T13);
			 T1j = rio[WS(ios, 13)];
			 T1l = iio[-WS(ios, 2)];
			 T1m = FMA(T1i, T1j, T1k * T1l);
			 T2b = FNMS(T1k, T1j, T1i * T1l);
		    }
		    {
			 E T15, T16, T1c, T1g;
			 T15 = rio[WS(ios, 9)];
			 T16 = iio[-WS(ios, 6)];
			 T17 = FMA(T2, T15, T5 * T16);
			 T25 = FNMS(T5, T15, T2 * T16);
			 T1c = rio[WS(ios, 5)];
			 T1g = iio[-WS(ios, 10)];
			 T1h = FNMS(T1f, T1g, T1b * T1c);
			 T2a = FMA(T1f, T1c, T1b * T1g);
		    }
		    T18 = T14 + T17;
		    T1n = T1h + T1m;
		    T2Q = T18 - T1n;
		    T2R = T24 + T25;
		    T2S = T2a + T2b;
		    T2T = T2R - T2S;
		    {
			 E T26, T27, T29, T2c;
			 T26 = T24 - T25;
			 T27 = T1h - T1m;
			 T28 = T26 + T27;
			 T2A = T26 - T27;
			 T29 = T14 - T17;
			 T2c = T2a - T2b;
			 T2d = T29 - T2c;
			 T2B = T29 + T2c;
		    }
	       }
	       {
		    E T1r, T2k, T1J, T2h, T1A, T2l, T1E, T2g;
		    {
			 E T1p, T1q, T1G, T1I;
			 T1p = rio[WS(ios, 15)];
			 T1q = iio[0];
			 T1r = FMA(TN, T1p, TO * T1q);
			 T2k = FNMS(TO, T1p, TN * T1q);
			 T1G = rio[WS(ios, 11)];
			 T1I = iio[-WS(ios, 4)];
			 T1J = FNMS(T1H, T1I, T1F * T1G);
			 T2h = FMA(T1H, T1G, T1F * T1I);
		    }
		    {
			 E T1v, T1z, T1C, T1D;
			 T1v = rio[WS(ios, 7)];
			 T1z = iio[-WS(ios, 8)];
			 T1A = FMA(T1u, T1v, T1y * T1z);
			 T2l = FNMS(T1y, T1v, T1u * T1z);
			 T1C = rio[WS(ios, 3)];
			 T1D = iio[-WS(ios, 12)];
			 T1E = FMA(Tg, T1C, Ti * T1D);
			 T2g = FNMS(Ti, T1C, Tg * T1D);
		    }
		    T1B = T1r + T1A;
		    T1K = T1E + T1J;
		    T2V = T1B - T1K;
		    T2W = T2k + T2l;
		    T2X = T2g + T2h;
		    T2Y = T2W - T2X;
		    {
			 E T2f, T2i, T2m, T2n;
			 T2f = T1r - T1A;
			 T2i = T2g - T2h;
			 T2j = T2f - T2i;
			 T2D = T2f + T2i;
			 T2m = T2k - T2l;
			 T2n = T1E - T1J;
			 T2o = T2m + T2n;
			 T2E = T2m - T2n;
		    }
	       }
	       {
		    E T23, T2r, T3A, T3C, T2q, T3B, T2u, T3x;
		    {
			 E T1R, T22, T3y, T3z;
			 T1R = T1N - T1Q;
			 T22 = KP707106781 * (T1W - T21);
			 T23 = T1R + T22;
			 T2r = T1R - T22;
			 T3y = KP707106781 * (T2x - T2w);
			 T3z = T3s + T3r;
			 T3A = T3y + T3z;
			 T3C = T3z - T3y;
		    }
		    {
			 E T2e, T2p, T2s, T2t;
			 T2e = FMA(KP923879532, T28, KP382683432 * T2d);
			 T2p = FNMS(KP923879532, T2o, KP382683432 * T2j);
			 T2q = T2e + T2p;
			 T3B = T2p - T2e;
			 T2s = FNMS(KP923879532, T2d, KP382683432 * T28);
			 T2t = FMA(KP382683432, T2o, KP923879532 * T2j);
			 T2u = T2s - T2t;
			 T3x = T2s + T2t;
		    }
		    iio[-WS(ios, 11)] = T23 - T2q;
		    rio[WS(ios, 11)] = T3x - T3A;
		    rio[WS(ios, 3)] = T23 + T2q;
		    iio[-WS(ios, 3)] = T3x + T3A;
		    iio[-WS(ios, 15)] = T2r - T2u;
		    rio[WS(ios, 15)] = T3B - T3C;
		    rio[WS(ios, 7)] = T2r + T2u;
		    iio[-WS(ios, 7)] = T3B + T3C;
	       }
	       {
		    E T2P, T31, T3m, T3o, T30, T3n, T34, T3j;
		    {
			 E T2L, T2O, T3k, T3l;
			 T2L = Tf - TA;
			 T2O = T2M - T2N;
			 T2P = T2L + T2O;
			 T31 = T2L - T2O;
			 T3k = TZ - TM;
			 T3l = T3e - T3b;
			 T3m = T3k + T3l;
			 T3o = T3l - T3k;
		    }
		    {
			 E T2U, T2Z, T32, T33;
			 T2U = T2Q + T2T;
			 T2Z = T2V - T2Y;
			 T30 = KP707106781 * (T2U + T2Z);
			 T3n = KP707106781 * (T2Z - T2U);
			 T32 = T2T - T2Q;
			 T33 = T2V + T2Y;
			 T34 = KP707106781 * (T32 - T33);
			 T3j = KP707106781 * (T32 + T33);
		    }
		    iio[-WS(ios, 10)] = T2P - T30;
		    rio[WS(ios, 10)] = T3j - T3m;
		    rio[WS(ios, 2)] = T2P + T30;
		    iio[-WS(ios, 2)] = T3j + T3m;
		    iio[-WS(ios, 14)] = T31 - T34;
		    rio[WS(ios, 14)] = T3n - T3o;
		    rio[WS(ios, 6)] = T31 + T34;
		    iio[-WS(ios, 6)] = T3n + T3o;
	       }
	       {
		    E T2z, T2H, T3u, T3w, T2G, T3v, T2K, T3p;
		    {
			 E T2v, T2y, T3q, T3t;
			 T2v = T1N + T1Q;
			 T2y = KP707106781 * (T2w + T2x);
			 T2z = T2v + T2y;
			 T2H = T2v - T2y;
			 T3q = KP707106781 * (T1W + T21);
			 T3t = T3r - T3s;
			 T3u = T3q + T3t;
			 T3w = T3t - T3q;
		    }
		    {
			 E T2C, T2F, T2I, T2J;
			 T2C = FMA(KP382683432, T2A, KP923879532 * T2B);
			 T2F = FNMS(KP382683432, T2E, KP923879532 * T2D);
			 T2G = T2C + T2F;
			 T3v = T2F - T2C;
			 T2I = FNMS(KP382683432, T2B, KP923879532 * T2A);
			 T2J = FMA(KP923879532, T2E, KP382683432 * T2D);
			 T2K = T2I - T2J;
			 T3p = T2I + T2J;
		    }
		    iio[-WS(ios, 9)] = T2z - T2G;
		    rio[WS(ios, 9)] = T3p - T3u;
		    rio[WS(ios, 1)] = T2z + T2G;
		    iio[-WS(ios, 1)] = T3p + T3u;
		    iio[-WS(ios, 13)] = T2H - T2K;
		    rio[WS(ios, 13)] = T3v - T3w;
		    rio[WS(ios, 5)] = T2H + T2K;
		    iio[-WS(ios, 5)] = T3v + T3w;
	       }
	       {
		    E T11, T35, T3g, T3i, T1M, T3h, T38, T39;
		    {
			 E TB, T10, T3a, T3f;
			 TB = Tf + TA;
			 T10 = TM + TZ;
			 T11 = TB + T10;
			 T35 = TB - T10;
			 T3a = T2M + T2N;
			 T3f = T3b + T3e;
			 T3g = T3a + T3f;
			 T3i = T3f - T3a;
		    }
		    {
			 E T1o, T1L, T36, T37;
			 T1o = T18 + T1n;
			 T1L = T1B + T1K;
			 T1M = T1o + T1L;
			 T3h = T1L - T1o;
			 T36 = T2R + T2S;
			 T37 = T2W + T2X;
			 T38 = T36 - T37;
			 T39 = T36 + T37;
		    }
		    iio[-WS(ios, 8)] = T11 - T1M;
		    rio[WS(ios, 8)] = T39 - T3g;
		    rio[0] = T11 + T1M;
		    iio[0] = T39 + T3g;
		    iio[-WS(ios, 12)] = T35 - T38;
		    rio[WS(ios, 12)] = T3h - T3i;
		    rio[WS(ios, 4)] = T35 + T38;
		    iio[-WS(ios, 4)] = T3h + T3i;
	       }
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 0, 1},
     {TW_CEXP, 0, 3},
     {TW_CEXP, 0, 9},
     {TW_CEXP, 0, 15},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 16, "hf2_16", twinstr, &GENUS, {156, 68, 40, 0}, 0, 0, 0 };

void X(codelet_hf2_16) (planner *p) {
     X(khc2hc_register) (p, hf2_16, &desc);
}
#endif				/* HAVE_FMA */
