/*
 * Copyright (c) 2003, 2006 Matteo Frigo
 * Copyright (c) 2003, 2006 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Fri Jan 27 19:53:31 EST 2006 */

#include "codelet-dft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_twiddle_c -fma -reorder-insns -schedule-for-pipeline -simd -compact -variables 4 -pipeline-latency 8 -n 3 -name t1fv_3 -include t1f.h */

/*
 * This function contains 8 FP additions, 8 FP multiplications,
 * (or, 5 additions, 5 multiplications, 3 fused multiply/add),
 * 12 stack variables, and 6 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.8 2006-01-05 03:04:27 stevenj Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_twiddle_c.ml,v 1.13 2006-01-05 03:04:27 stevenj Exp $
 */

#include "t1f.h"

static const R *t1fv_3(R *ri, R *ii, const R *W, stride ios, INT m, INT dist)
{
     DVK(KP500000000, +0.500000000000000000000000000000000000000000000);
     DVK(KP866025403, +0.866025403784438646763723170752936183471402627);
     INT i;
     R *x;
     x = ri;
     for (i = m; i > 0; i = i - VL, x = x + (VL * dist), W = W + (TWVL * 4), MAKE_VOLATILE_STRIDE(ios)) {
	  V T1, T2, T4;
	  T1 = LD(&(x[0]), dist, &(x[0]));
	  T2 = LD(&(x[WS(ios, 1)]), dist, &(x[WS(ios, 1)]));
	  T4 = LD(&(x[WS(ios, 2)]), dist, &(x[0]));
	  {
	       V T3, T5, T8, T6, T7;
	       T3 = BYTWJ(&(W[0]), T2);
	       T5 = BYTWJ(&(W[TWVL * 2]), T4);
	       T8 = VMUL(LDK(KP866025403), VSUB(T5, T3));
	       T6 = VADD(T3, T5);
	       T7 = VFNMS(LDK(KP500000000), T6, T1);
	       ST(&(x[0]), VADD(T1, T6), dist, &(x[0]));
	       ST(&(x[WS(ios, 1)]), VFMAI(T8, T7), dist, &(x[WS(ios, 1)]));
	       ST(&(x[WS(ios, 2)]), VFNMSI(T8, T7), dist, &(x[0]));
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     VTW(2),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 3, "t1fv_3", twinstr, &GENUS, {5, 5, 3, 0}, 0, 0, 0 };

void X(codelet_t1fv_3) (planner *p) {
     X(kdft_dit_register) (p, t1fv_3, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_twiddle_c -simd -compact -variables 4 -pipeline-latency 8 -n 3 -name t1fv_3 -include t1f.h */

/*
 * This function contains 8 FP additions, 6 FP multiplications,
 * (or, 7 additions, 5 multiplications, 1 fused multiply/add),
 * 12 stack variables, and 6 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.8 2006-01-05 03:04:27 stevenj Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_twiddle_c.ml,v 1.13 2006-01-05 03:04:27 stevenj Exp $
 */

#include "t1f.h"

static const R *t1fv_3(R *ri, R *ii, const R *W, stride ios, INT m, INT dist)
{
     DVK(KP866025403, +0.866025403784438646763723170752936183471402627);
     DVK(KP500000000, +0.500000000000000000000000000000000000000000000);
     INT i;
     R *x;
     x = ri;
     for (i = m; i > 0; i = i - VL, x = x + (VL * dist), W = W + (TWVL * 4), MAKE_VOLATILE_STRIDE(ios)) {
	  V T1, T3, T5, T6, T2, T4, T7, T8;
	  T1 = LD(&(x[0]), dist, &(x[0]));
	  T2 = LD(&(x[WS(ios, 1)]), dist, &(x[WS(ios, 1)]));
	  T3 = BYTWJ(&(W[0]), T2);
	  T4 = LD(&(x[WS(ios, 2)]), dist, &(x[0]));
	  T5 = BYTWJ(&(W[TWVL * 2]), T4);
	  T6 = VADD(T3, T5);
	  ST(&(x[0]), VADD(T1, T6), dist, &(x[0]));
	  T7 = VFNMS(LDK(KP500000000), T6, T1);
	  T8 = VBYI(VMUL(LDK(KP866025403), VSUB(T5, T3)));
	  ST(&(x[WS(ios, 2)]), VSUB(T7, T8), dist, &(x[0]));
	  ST(&(x[WS(ios, 1)]), VADD(T7, T8), dist, &(x[WS(ios, 1)]));
     }
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     VTW(2),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 3, "t1fv_3", twinstr, &GENUS, {7, 5, 1, 0}, 0, 0, 0 };

void X(codelet_t1fv_3) (planner *p) {
     X(kdft_dit_register) (p, t1fv_3, &desc);
}
#endif				/* HAVE_FMA */
