/*
 * Copyright (c) 2003, 2006 Matteo Frigo
 * Copyright (c) 2003, 2006 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Fri Jan 27 19:33:14 EST 2006 */

#include "codelet-dft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_twiddle -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -twiddle-log3 -precompute-twiddles -n 64 -name t2_64 -include t.h */

/*
 * This function contains 1154 FP additions, 840 FP multiplications,
 * (or, 520 additions, 206 multiplications, 634 fused multiply/add),
 * 371 stack variables, and 256 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.8 2006-01-05 03:04:27 stevenj Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_twiddle.ml,v 1.23 2006-01-05 03:04:27 stevenj Exp $
 */

#include "t.h"

static const R *t2_64(R *ri, R *ii, const R *W, stride ios, INT m, INT dist)
{
     DK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DK(KP820678790, +0.820678790828660330972281985331011598767386482);
     DK(KP098491403, +0.098491403357164253077197521291327432293052451);
     DK(KP534511135, +0.534511135950791641089685961295362908582039528);
     DK(KP303346683, +0.303346683607342391675883946941299872384187453);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     INT i;
     for (i = m; i > 0; i = i - 1, ri = ri + dist, ii = ii + dist, W = W + 10, MAKE_VOLATILE_STRIDE(ios)) {
	  E Tg0, TlC, TlB, Tg3;
	  {
	       E T4, T8, T5, T2, Tb, T3, T7, Td, Tt, T9, Tr, TH, T3g, T3i, TK;
	       E T10, T3a, T14, T3d, T1i, Tu, T17, Te, T1k, Tx, Ti, T19, Tg, TF, T3G;
	       E T2l, T2h, T3D, T3U, T1t, T3m, T4W, T4T, T3j, T1x, T3X, T5O, T48, TL, T79;
	       E T1I, T2U, T2X, T1M, T7c, TP, T2u, T7B, T4b, T5R, T7E, T2x, T3M, T3Q, T4w;
	       E T4A, T2c, T28, T7o, T6J, T6N, T7r, T1j, T6s, T6k, T5E, T6h, T5A, T1Y, T5v;
	       E T80, T1o, T7W, T6d, T5r, T3z, T6w, T7k, T7Q, T34, T30, T7M, T22, T7g, T3v;
	       E T69, T63, T5Z, T4H, Tn, T2N, T1R, T44, T1e, T2Q, T1V, T4E, Tj, T4f, T41;
	       E T1a, T2v, T3k, T49, TM, T4s, TC, T3q, T4p, Ty, T2B, TT, T54, T8d, T8h;
	       E T58, T5i, T6V, T6Z, T5m, TN;
	       {
		    E T1L, T1s, T1H, T1w, T2g, T2k, TI, TO, T2t, T3l, T3h, T4a, T2w, T47, Tc;
		    E T6;
		    T4 = W[2];
		    T8 = W[1];
		    T5 = W[0];
		    T2 = W[6];
		    Tb = W[5];
		    Tc = T4 * T8;
		    T6 = T4 * T5;
		    T3 = W[4];
		    T7 = W[3];
		    T1L = T2 * Tb;
		    {
			 E T13, TZ, TG, TJ;
			 T1s = T2 * T4;
			 T13 = T3 * T8;
			 T1H = T2 * T3;
			 TZ = T3 * T5;
			 TG = T3 * T4;
			 Td = FMA(T7, T5, Tc);
			 Tt = FNMS(T7, T5, Tc);
			 T9 = FNMS(T7, T8, T6);
			 Tr = FMA(T7, T8, T6);
			 TJ = T3 * T7;
			 T1w = T2 * T7;
			 T2g = T2 * T5;
			 T2k = T2 * T8;
			 TH = FNMS(Tb, T7, TG);
			 T3g = FMA(Tb, T7, TG);
			 T3i = FNMS(Tb, T4, TJ);
			 TK = FMA(Tb, T4, TJ);
			 T10 = FMA(Tb, T8, TZ);
			 T3a = FNMS(Tb, T8, TZ);
			 TI = T2 * TH;
			 TO = T2 * TK;
			 T2t = T2 * T10;
			 T3l = T2 * T3i;
			 {
			      E Ts, Ta, Tw, Th;
			      T14 = FNMS(Tb, T5, T13);
			      T3d = FMA(Tb, T5, T13);
			      T3h = T2 * T3g;
			      T4a = T2 * T3d;
			      T2w = T2 * T14;
			      T47 = T2 * T3a;
			      Ts = T3 * Tr;
			      Ta = T3 * T9;
			      Tw = T3 * Tt;
			      Th = T3 * Td;
			      T1i = FNMS(Tb, Tt, Ts);
			      Tu = FMA(Tb, Tt, Ts);
			      T17 = FNMS(Tb, Td, Ta);
			      Te = FMA(Tb, Td, Ta);
			      T1k = FMA(Tb, Tr, Tw);
			      Tx = FNMS(Tb, Tr, Tw);
			      Ti = FNMS(Tb, T9, Th);
			      T19 = FMA(Tb, T9, Th);
			      Tg = W[7];
			      TF = W[8];
			 }
		    }
		    {
			 E T6I, T6M, T5D, T5z;
			 T6I = T2 * T9;
			 T6M = T2 * Td;
			 T3G = FNMS(Tg, T5, T2k);
			 T2l = FMA(Tg, T5, T2k);
			 T2h = FNMS(Tg, T8, T2g);
			 T3D = FMA(Tg, T8, T2g);
			 T3U = FNMS(Tg, T7, T1s);
			 T1t = FMA(Tg, T7, T1s);
			 T3m = FMA(Tg, T3g, T3l);
			 T4W = FNMS(Tg, T3g, T3l);
			 T4T = FMA(Tg, T3i, T3h);
			 T3j = FNMS(Tg, T3i, T3h);
			 T1x = FNMS(Tg, T4, T1w);
			 T3X = FMA(Tg, T4, T1w);
			 T5O = FNMS(Tg, T3d, T47);
			 T48 = FMA(Tg, T3d, T47);
			 TL = FMA(Tg, TK, TI);
			 T79 = FNMS(Tg, TK, TI);
			 T1I = FNMS(Tg, Tb, T1H);
			 T2U = FMA(Tg, Tb, T1H);
			 T2X = FNMS(Tg, T3, T1L);
			 T1M = FMA(Tg, T3, T1L);
			 T7c = FMA(Tg, TH, TO);
			 TP = FNMS(Tg, TH, TO);
			 T2u = FNMS(Tg, T14, T2t);
			 T7B = FMA(Tg, T14, T2t);
			 T4b = FNMS(Tg, T3a, T4a);
			 T5R = FMA(Tg, T3a, T4a);
			 T7E = FNMS(Tg, T10, T2w);
			 T2x = FMA(Tg, T10, T2w);
			 T3M = TF * T5;
			 T3Q = TF * T8;
			 T4w = TF * T3;
			 T4A = TF * Tb;
			 T2c = TF * T7;
			 T28 = TF * T4;
			 T7o = FMA(Tg, Td, T6I);
			 T6J = FNMS(Tg, Td, T6I);
			 T6N = FMA(Tg, T9, T6M);
			 T7r = FNMS(Tg, T9, T6M);
			 T5D = T2 * Tt;
			 T5z = T2 * Tr;
			 T1j = TF * T1i;
			 T6s = TF * T2U;
			 T6k = FNMS(Tg, Tr, T5D);
			 T5E = FMA(Tg, Tr, T5D);
			 T6h = FMA(Tg, Tt, T5z);
			 T5A = FNMS(Tg, Tt, T5z);
			 T1Y = TF * Tu;
			 T5v = TF * T3i;
			 T80 = TF * Td;
			 T1o = TF * T1k;
			 T7W = TF * T9;
			 T6d = TF * Tt;
			 T5r = TF * T3g;
			 T3z = TF * Ti;
			 T6w = TF * T2X;
			 T7k = TF * T14;
			 T7Q = TF * TK;
			 T34 = TF * T19;
			 T30 = TF * T17;
			 T7M = TF * TH;
			 T22 = TF * Tx;
			 T7g = TF * T10;
			 T3v = TF * Te;
			 {
			      E Tf, T18, TB, Tv;
			      {
				   E Tm, T1Q, T1d, T1U;
				   T69 = TF * Tr;
				   T63 = TF * T3d;
				   T5Z = TF * T3a;
				   Tm = T2 * Ti;
				   T1Q = T2 * T1i;
				   T1d = T2 * T19;
				   T1U = T2 * T1k;
				   T4H = FMA(Tg, Te, Tm);
				   Tn = FNMS(Tg, Te, Tm);
				   T2N = FNMS(Tg, T1k, T1Q);
				   T1R = FMA(Tg, T1k, T1Q);
				   T44 = FNMS(Tg, T17, T1d);
				   T1e = FMA(Tg, T17, T1d);
				   T2Q = FMA(Tg, T1i, T1U);
				   T1V = FNMS(Tg, T1i, T1U);
				   Tf = T2 * Te;
			      }
			      T18 = T2 * T17;
			      T4E = FNMS(Tg, Ti, Tf);
			      Tj = FMA(Tg, Ti, Tf);
			      T4f = TF * T4b;
			      T41 = FMA(Tg, T19, T18);
			      T1a = FNMS(Tg, T19, T18);
			      T2v = TF * T2u;
			      TB = T2 * Tx;
			      T3k = TF * T3j;
			      T49 = TF * T48;
			      TM = TF * TL;
			      T4s = FNMS(Tg, Tu, TB);
			      TC = FMA(Tg, Tu, TB);
			      Tv = T2 * Tu;
			      T3q = TF * T3m;
			      T4p = FMA(Tg, Tx, Tv);
			      Ty = FNMS(Tg, Tx, Tv);
			      T2B = TF * T2x;
			      TT = TF * TP;
			 }
			 T54 = TF * T41;
			 T8d = TF * T1R;
			 T8h = TF * T1V;
			 T58 = TF * T44;
			 T5i = TF * T4E;
			 T6V = TF * Ty;
			 T6Z = TF * TC;
			 T5m = TF * T4H;
			 TN = W[9];
		    }
	       }
	       {
		    E Tl9, TlD, TY, Tg4, Tkd, TkE, T8w, TdS, T98, Te1, T2G, Tge, T9f, Te0, Tgh;
		    E TiK, Te8, T9M, TiN, Tgn, Te5, T9p, Tgq, T39, TeP, TcB, Tja, Thc, TeE, TbI;
		    E Thr, T74, TdT, T8D, Tg7, Tk7, T8K, TdU, T1B, TkD, TdX, T90, TiJ, Tgc, TdY;
		    E T8T, Tg9, T27, T9Y, Tec, T4k, TgB, Tgy, TiT, Tef, Tal, Tew, Tbs, TiZ, TgL;
		    E Tel, Taz, Th0, T5d, Tgo, T3K, TiO, Tgt, Te6, T9P, Te9, T9E, Tgz, T4L, TiU;
		    E TgE, Ted, Tao, Teg, Tad, TgM, T5I, Tj0, Th3, Tem, Tbv, Tex, TaO, Thd, T7v;
		    E Tjb, Thu, TeF, TcE, TeQ, TbX, T68, Tj5, Tez, Teq, Tbj, Tbx, TgS, Th5, T6B;
		    E Tj6, TeA, Tet, Tb4, Tby, TgX, Th6, T7V, Tjg, TeS, TeJ, Tcs, TcG, Thj, Thw;
		    E T8k, Tc3, T8b, TbZ, T88, Thl, Tca, Tc0, T8a;
		    {
			 E T60, T5s, T3A, T64, T3w, T5w, T5n, T4x, T3n, T6e, T4B, T3r, T5j, T6a, T6t;
			 E T7R, T7l, T7X, T7N, T7h, T8e, T6x, T81, T8i, T4S, Tau, T5b, Tbq, T4X, T4U;
			 E T52, T50;
			 {
			      E T4c, T3R, T3N, T4g, T59, T55, T1Z, T23, T1p, T1l, T6H, TbD, T6T, Tcz, T72;
			      E T6P, TbF, T6R;
			      {
				   E T35, T6W, T31, T70, T2p, T9d, T2E, T2o, T99, T96, Tgf, T2s, T9a;
				   {
					E T2d, T29, T2y, T2C, TU, TR, TE, T8s, Tq, T8q, Tkc, Tl7, TW, T8t;
					{
					     E T1, Tkb, TQ, Tka, Tp, TS, TV;
					     T1 = ri[0];
					     Tkb = ii[0];
					     {
						  E To, Tk, Tz, TD;
						  To = ii[WS(ios, 32)];
						  T60 = FMA(TN, T3d, T5Z);
						  T4c = FNMS(TN, T4b, T49);
						  T5s = FNMS(TN, T3i, T5r);
						  T3A = FMA(TN, Te, T3z);
						  T64 = FNMS(TN, T3a, T63);
						  T3R = FNMS(TN, T5, T3Q);
						  T3N = FMA(TN, T8, T3M);
						  T3w = FNMS(TN, Ti, T3v);
						  T5w = FMA(TN, T3g, T5v);
						  T5n = FNMS(TN, T4E, T5m);
						  T4g = FMA(TN, T48, T4f);
						  T4x = FMA(TN, Tb, T4w);
						  T3n = FMA(TN, T3m, T3k);
						  T6e = FMA(TN, Tr, T6d);
						  T59 = FMA(TN, T41, T58);
						  T4B = FNMS(TN, T3, T4A);
						  T3r = FNMS(TN, T3j, T3q);
						  T5j = FMA(TN, T4H, T5i);
						  T55 = FNMS(TN, T44, T54);
						  T6a = FNMS(TN, Tt, T69);
						  T6t = FNMS(TN, T2X, T6s);
						  T35 = FNMS(TN, T17, T34);
						  T7R = FNMS(TN, TH, T7Q);
						  T2d = FNMS(TN, T4, T2c);
						  T7l = FMA(TN, T10, T7k);
						  T1Z = FNMS(TN, Tx, T1Y);
						  T7X = FMA(TN, Td, T7W);
						  T29 = FMA(TN, T7, T28);
						  T23 = FMA(TN, Tu, T22);
						  T1p = FNMS(TN, T1i, T1o);
						  T7N = FMA(TN, TK, T7M);
						  T7h = FNMS(TN, T14, T7g);
						  T2y = FMA(TN, T2x, T2v);
						  T2C = FNMS(TN, T2u, T2B);
						  TU = FMA(TN, TL, TT);
						  T8e = FNMS(TN, T1V, T8d);
						  T6W = FMA(TN, TC, T6V);
						  T31 = FMA(TN, T19, T30);
						  T1l = FMA(TN, T1k, T1j);
						  T70 = FNMS(TN, Ty, T6Z);
						  T6x = FMA(TN, T2U, T6w);
						  T81 = FNMS(TN, T9, T80);
						  T8i = FMA(TN, T1R, T8h);
						  TQ = FNMS(TN, TP, TM);
						  Tk = ri[WS(ios, 32)];
						  Tz = ri[WS(ios, 16)];
						  TD = ii[WS(ios, 16)];
						  TR = ri[WS(ios, 48)];
						  {
						       E Tk9, Tl, TA, T8r;
						       Tk9 = Tn * Tk;
						       Tl = Tj * Tk;
						       TA = Ty * Tz;
						       T8r = Ty * TD;
						       Tka = FMA(Tj, To, Tk9);
						       Tp = FNMS(Tn, To, Tl);
						       TE = FMA(TC, TD, TA);
						       T8s = FNMS(TC, Tz, T8r);
						       TS = TQ * TR;
						  }
						  TV = ii[WS(ios, 48)];
					     }
					     Tq = T1 + Tp;
					     T8q = T1 - Tp;
					     Tkc = Tka + Tkb;
					     Tl7 = Tkb - Tka;
					     TW = FMA(TU, TV, TS);
					     T8t = TQ * TV;
					}
					{
					     E T2f, T93, T2n, T95, T2q, T2r;
					     {
						  E T2D, T2z, T2i, T2m;
						  {
						       E T2e, T8v, Tk8, T2b, T92;
						       T2e = ii[WS(ios, 60)];
						       {
							    E TX, Tl8, T8u, T2a;
							    TX = TE + TW;
							    Tl8 = TE - TW;
							    T8u = FNMS(TU, TR, T8t);
							    T2a = ri[WS(ios, 60)];
							    Tl9 = Tl7 - Tl8;
							    TlD = Tl8 + Tl7;
							    TY = Tq + TX;
							    Tg4 = Tq - TX;
							    T8v = T8s - T8u;
							    Tk8 = T8s + T8u;
							    T2b = T29 * T2a;
							    T92 = T2d * T2a;
						       }
						       Tkd = Tk8 + Tkc;
						       TkE = Tkc - Tk8;
						       T8w = T8q - T8v;
						       TdS = T8q + T8v;
						       T2f = FNMS(T2d, T2e, T2b);
						       T93 = FMA(T29, T2e, T92);
						  }
						  T2D = ii[WS(ios, 44)];
						  T2z = ri[WS(ios, 44)];
						  T2i = ri[WS(ios, 28)];
						  T2m = ii[WS(ios, 28)];
						  T2p = ri[WS(ios, 12)];
						  {
						       E T9c, T2A, T2j, T94;
						       T9c = T2C * T2z;
						       T2A = T2y * T2z;
						       T2j = T2h * T2i;
						       T94 = T2h * T2m;
						       T9d = FMA(T2y, T2D, T9c);
						       T2E = FNMS(T2C, T2D, T2A);
						       T2n = FMA(T2l, T2m, T2j);
						       T95 = FNMS(T2l, T2i, T94);
						       T2q = TH * T2p;
						  }
						  T2r = ii[WS(ios, 12)];
					     }
					     T2o = T2f + T2n;
					     T99 = T2f - T2n;
					     T96 = T93 - T95;
					     Tgf = T93 + T95;
					     T2s = FMA(TK, T2r, T2q);
					     T9a = TH * T2r;
					}
				   }
				   {
					E T2M, T9k, T2Y, T9K, T37, T2S, T9m, T2V;
					{
					     E T36, T32, T2O, T2R;
					     {
						  E T2L, Tgg, T9e, T2K, T9j;
						  T2L = ii[WS(ios, 2)];
						  {
						       E T2F, T97, T9b, T2J;
						       T2F = T2s + T2E;
						       T97 = T2s - T2E;
						       T9b = FNMS(TK, T2p, T9a);
						       T2J = ri[WS(ios, 2)];
						       T98 = T96 + T97;
						       Te1 = T96 - T97;
						       T2G = T2o + T2F;
						       Tge = T2o - T2F;
						       Tgg = T9b + T9d;
						       T9e = T9b - T9d;
						       T2K = Tr * T2J;
						       T9j = Tt * T2J;
						  }
						  T9f = T99 - T9e;
						  Te0 = T99 + T9e;
						  Tgh = Tgf - Tgg;
						  TiK = Tgf + Tgg;
						  T2M = FNMS(Tt, T2L, T2K);
						  T9k = FMA(Tr, T2L, T9j);
					     }
					     T36 = ii[WS(ios, 50)];
					     T32 = ri[WS(ios, 50)];
					     T2O = ri[WS(ios, 34)];
					     T2R = ii[WS(ios, 34)];
					     T2Y = ii[WS(ios, 18)];
					     {
						  E T9J, T33, T2P, T9l;
						  T9J = T35 * T32;
						  T33 = T31 * T32;
						  T2P = T2N * T2O;
						  T9l = T2N * T2R;
						  T9K = FMA(T31, T36, T9J);
						  T37 = FNMS(T35, T36, T33);
						  T2S = FMA(T2Q, T2R, T2P);
						  T9m = FNMS(T2Q, T2O, T9l);
						  T2V = ri[WS(ios, 18)];
					     }
					}
					{
					     E T71, T6X, T6K, T6O;
					     {
						  E T6E, T9G, T2T, T9n, Tgl, T6F, T6G, T9I, T2Z, T9H, T2W, TbC;
						  T6E = ri[WS(ios, 63)];
						  T9G = T2M - T2S;
						  T2T = T2M + T2S;
						  T9n = T9k - T9m;
						  Tgl = T9k + T9m;
						  T9H = T2X * T2V;
						  T2W = T2U * T2V;
						  T6F = TF * T6E;
						  T6G = ii[WS(ios, 63)];
						  T9I = FMA(T2U, T2Y, T9H);
						  T2Z = FNMS(T2X, T2Y, T2W);
						  T71 = ii[WS(ios, 47)];
						  T6H = FMA(TN, T6G, T6F);
						  TbC = TF * T6G;
						  {
						       E Tgm, T9L, T38, T9o;
						       Tgm = T9I + T9K;
						       T9L = T9I - T9K;
						       T38 = T2Z + T37;
						       T9o = T2Z - T37;
						       TbD = FNMS(TN, T6E, TbC);
						       Te8 = T9G + T9L;
						       T9M = T9G - T9L;
						       TiN = Tgl + Tgm;
						       Tgn = Tgl - Tgm;
						       Te5 = T9n - T9o;
						       T9p = T9n + T9o;
						       Tgq = T2T - T38;
						       T39 = T2T + T38;
						       T6X = ri[WS(ios, 47)];
						  }
					     }
					     T6K = ri[WS(ios, 31)];
					     T6O = ii[WS(ios, 31)];
					     T6T = ii[WS(ios, 15)];
					     {
						  E Tcy, T6Y, T6L, TbE;
						  Tcy = T70 * T6X;
						  T6Y = T6W * T6X;
						  T6L = T6J * T6K;
						  TbE = T6J * T6O;
						  Tcz = FMA(T6W, T71, Tcy);
						  T72 = FNMS(T70, T71, T6Y);
						  T6P = FMA(T6N, T6O, T6L);
						  TbF = FNMS(T6N, T6K, TbE);
						  T6R = ri[WS(ios, 15)];
					     }
					}
				   }
			      }
			      {
				   E T25, T8Y, T1W, T8U, T1P, Tga, T8R, T8V, T1T, T4P, T4R;
				   {
					E T8y, T16, T1q, T8I, T1z, T1g, T8A, T1m;
					{
					     E T1y, T1u, T1b, T1f;
					     {
						  E T15, Tcv, T6Q, TbG, Tha, Tcw, T6S, T11;
						  T15 = ii[WS(ios, 8)];
						  Tcv = T6H - T6P;
						  T6Q = T6H + T6P;
						  TbG = TbD - TbF;
						  Tha = TbD + TbF;
						  Tcw = TP * T6R;
						  T6S = TL * T6R;
						  T11 = ri[WS(ios, 8)];
						  T1y = ii[WS(ios, 24)];
						  {
						       E Tcx, T6U, T8x, T12;
						       Tcx = FMA(TL, T6T, Tcw);
						       T6U = FNMS(TP, T6T, T6S);
						       T8x = T14 * T11;
						       T12 = T10 * T11;
						       {
							    E TcA, Thb, TbH, T73;
							    TcA = Tcx - Tcz;
							    Thb = Tcx + Tcz;
							    TbH = T6U - T72;
							    T73 = T6U + T72;
							    T8y = FMA(T10, T15, T8x);
							    T16 = FNMS(T14, T15, T12);
							    TeP = Tcv + TcA;
							    TcB = Tcv - TcA;
							    Tja = Tha + Thb;
							    Thc = Tha - Thb;
							    TeE = TbG - TbH;
							    TbI = TbG + TbH;
							    Thr = T6Q - T73;
							    T74 = T6Q + T73;
							    T1u = ri[WS(ios, 24)];
						       }
						  }
					     }
					     T1b = ri[WS(ios, 40)];
					     T1f = ii[WS(ios, 40)];
					     T1q = ii[WS(ios, 56)];
					     {
						  E T8H, T1v, T1c, T8z;
						  T8H = T1x * T1u;
						  T1v = T1t * T1u;
						  T1c = T1a * T1b;
						  T8z = T1a * T1f;
						  T8I = FMA(T1t, T1y, T8H);
						  T1z = FNMS(T1x, T1y, T1v);
						  T1g = FMA(T1e, T1f, T1c);
						  T8A = FNMS(T1e, T1b, T8z);
						  T1m = ri[WS(ios, 56)];
					     }
					}
					{
					     E T1G, T8O, T1O, T8Q, T1S, T20, T24;
					     {
						  E T1D, T1h, Tg5, T1E, T1F, T8J, Tg6, T8E, T1A, T8N, T8G, T1r;
						  T1D = ri[WS(ios, 4)];
						  {
						       E T8C, T8B, T8F, T1n;
						       T8C = T16 - T1g;
						       T1h = T16 + T1g;
						       T8B = T8y - T8A;
						       Tg5 = T8y + T8A;
						       T8F = T1p * T1m;
						       T1n = T1l * T1m;
						       TdT = T8C + T8B;
						       T8D = T8B - T8C;
						       T8G = FMA(T1l, T1q, T8F);
						       T1r = FNMS(T1p, T1q, T1n);
						       T1E = T9 * T1D;
						  }
						  T1F = ii[WS(ios, 4)];
						  T8J = T8G - T8I;
						  Tg6 = T8G + T8I;
						  T8E = T1r - T1z;
						  T1A = T1r + T1z;
						  T8N = T9 * T1F;
						  Tg7 = Tg5 - Tg6;
						  Tk7 = Tg5 + Tg6;
						  T8K = T8E + T8J;
						  TdU = T8E - T8J;
						  T1B = T1h + T1A;
						  TkD = T1A - T1h;
						  T1G = FMA(Td, T1F, T1E);
						  T8O = FNMS(Td, T1D, T8N);
					     }
					     T20 = ri[WS(ios, 52)];
					     T24 = ii[WS(ios, 52)];
					     {
						  E T1J, T1N, T21, T8X, T1K, T8P;
						  T1J = ri[WS(ios, 36)];
						  T1N = ii[WS(ios, 36)];
						  T21 = T1Z * T20;
						  T8X = T1Z * T24;
						  T1K = T1I * T1J;
						  T8P = T1I * T1N;
						  T25 = FMA(T23, T24, T21);
						  T8Y = FNMS(T23, T20, T8X);
						  T1O = FMA(T1M, T1N, T1K);
						  T8Q = FNMS(T1M, T1J, T8P);
					     }
					     T1W = ii[WS(ios, 20)];
					     T1S = ri[WS(ios, 20)];
					     T8U = T1G - T1O;
					     T1P = T1G + T1O;
					     Tga = T8O + T8Q;
					     T8R = T8O - T8Q;
					     T8V = T1V * T1S;
					     T1T = T1R * T1S;
					}
				   }
				   {
					E T9T, T3T, T45, T4i, Taj, T3Z, T9V, T43, Tag;
					{
					     E T4d, T4e, T4h, T3V, T3Y;
					     {
						  E T3S, T8W, T1X, T3O, T8Z, Tgb;
						  T3S = ii[WS(ios, 62)];
						  T8W = FMA(T1R, T1W, T8V);
						  T1X = FNMS(T1V, T1W, T1T);
						  T3O = ri[WS(ios, 62)];
						  T4d = ri[WS(ios, 46)];
						  T8Z = T8W - T8Y;
						  Tgb = T8W + T8Y;
						  {
						       E T8S, T26, T9S, T3P;
						       T8S = T1X - T25;
						       T26 = T1X + T25;
						       T9S = T3R * T3O;
						       T3P = T3N * T3O;
						       TdX = T8U + T8Z;
						       T90 = T8U - T8Z;
						       TiJ = Tga + Tgb;
						       Tgc = Tga - Tgb;
						       TdY = T8R - T8S;
						       T8T = T8R + T8S;
						       Tg9 = T1P - T26;
						       T27 = T1P + T26;
						       T9T = FMA(T3N, T3S, T9S);
						       T3T = FNMS(T3R, T3S, T3P);
						       T4e = T4c * T4d;
						  }
						  T4h = ii[WS(ios, 46)];
					     }
					     T3V = ri[WS(ios, 30)];
					     T3Y = ii[WS(ios, 30)];
					     T45 = ii[WS(ios, 14)];
					     T4i = FMA(T4g, T4h, T4e);
					     {
						  E Tai, T3W, T9U, T42;
						  Tai = T4c * T4h;
						  T3W = T3U * T3V;
						  T9U = T3U * T3Y;
						  T42 = ri[WS(ios, 14)];
						  Taj = FNMS(T4g, T4d, Tai);
						  T3Z = FMA(T3X, T3Y, T3W);
						  T9V = FNMS(T3X, T3V, T9U);
						  T43 = T41 * T42;
						  Tag = T44 * T42;
					     }
					}
					{
					     E Taf, T40, Tgw, T9W, T46, Tah;
					     Taf = T3T - T3Z;
					     T40 = T3T + T3Z;
					     Tgw = T9T + T9V;
					     T9W = T9T - T9V;
					     T46 = FNMS(T44, T45, T43);
					     Tah = FMA(T41, T45, Tag);
					     {
						  E T4j, T9X, Tak, Tgx;
						  T4j = T46 + T4i;
						  T9X = T46 - T4i;
						  Tak = Tah - Taj;
						  Tgx = Tah + Taj;
						  T9Y = T9W + T9X;
						  Tec = T9W - T9X;
						  T4k = T40 + T4j;
						  TgB = T40 - T4j;
						  Tgy = Tgw - Tgx;
						  TiT = Tgw + Tgx;
						  Tef = Taf + Tak;
						  Tal = Taf - Tak;
					     }
					}
				   }
				   T4P = ri[WS(ios, 1)];
				   T4R = ii[WS(ios, 1)];
				   {
					E T56, T5a, T4Q, Tat, T57, Tbp;
					T56 = ri[WS(ios, 49)];
					T5a = ii[WS(ios, 49)];
					T4Q = T5 * T4P;
					Tat = T5 * T4R;
					T57 = T55 * T56;
					Tbp = T55 * T5a;
					T4S = FMA(T8, T4R, T4Q);
					Tau = FNMS(T8, T4P, Tat);
					T5b = FMA(T59, T5a, T57);
					Tbq = FNMS(T59, T56, Tbp);
				   }
				   T4X = ii[WS(ios, 33)];
				   T4U = ri[WS(ios, 33)];
				   T52 = ii[WS(ios, 17)];
				   T50 = ri[WS(ios, 17)];
			      }
			 }
			 {
			      E T7i, TbU, T7t, T7f, TbJ, TbO, Ths, T7n, TbR;
			      {
				   E Ta6, Tab, Tan, Ta5;
				   {
					E T9x, T9C, T9O, T9w;
					{
					     E T3f, T9s, T9B, T3I, T3x, T3B, T3t, T9u, T3y, T9y, T9q, T3u;
					     {
						  E T3b, T3c, T3e, T3H, T3E, T3s, T3p, T9t;
						  T3b = ri[WS(ios, 10)];
						  {
						       E Tav, T4V, Tbn, T51;
						       Tav = T4W * T4U;
						       T4V = T4T * T4U;
						       Tbn = T4b * T50;
						       T51 = T48 * T50;
						       {
							    E Taw, T4Y, Tbo, T53;
							    Taw = FMA(T4T, T4X, Tav);
							    T4Y = FNMS(T4W, T4X, T4V);
							    Tbo = FMA(T48, T52, Tbn);
							    T53 = FNMS(T4b, T52, T51);
							    {
								 E Tax, TgJ, Tbm, T4Z;
								 Tax = Tau - Taw;
								 TgJ = Tau + Taw;
								 Tbm = T4S - T4Y;
								 T4Z = T4S + T4Y;
								 {
								      E Tbr, TgK, Tay, T5c;
								      Tbr = Tbo - Tbq;
								      TgK = Tbo + Tbq;
								      Tay = T53 - T5b;
								      T5c = T53 + T5b;
								      Tew = Tbm + Tbr;
								      Tbs = Tbm - Tbr;
								      TiZ = TgJ + TgK;
								      TgL = TgJ - TgK;
								      Tel = Tax - Tay;
								      Taz = Tax + Tay;
								      Th0 = T4Z - T5c;
								      T5d = T4Z + T5c;
								      T3c = T3a * T3b;
								 }
							    }
						       }
						  }
						  T3e = ii[WS(ios, 10)];
						  T3H = ii[WS(ios, 26)];
						  T3E = ri[WS(ios, 26)];
						  T3s = ii[WS(ios, 42)];
						  T3f = FMA(T3d, T3e, T3c);
						  {
						       E T9r, T9A, T3F, T3o;
						       T9r = T3a * T3e;
						       T9A = T3G * T3E;
						       T3F = T3D * T3E;
						       T3o = ri[WS(ios, 42)];
						       T9s = FNMS(T3d, T3b, T9r);
						       T9B = FMA(T3D, T3H, T9A);
						       T3I = FNMS(T3G, T3H, T3F);
						       T3p = T3n * T3o;
						       T9t = T3r * T3o;
						  }
						  T3x = ri[WS(ios, 58)];
						  T3B = ii[WS(ios, 58)];
						  T3t = FNMS(T3r, T3s, T3p);
						  T9u = FMA(T3n, T3s, T9t);
						  T3y = T3w * T3x;
						  T9y = T3w * T3B;
					     }
					     T9q = T3f - T3t;
					     T3u = T3f + T3t;
					     {
						  E Tgr, T9v, T3C, T9z, T3J, Tgs;
						  Tgr = T9s + T9u;
						  T9v = T9s - T9u;
						  T3C = FMA(T3A, T3B, T3y);
						  T9z = FNMS(T3A, T3x, T9y);
						  T9x = T3C - T3I;
						  T3J = T3C + T3I;
						  Tgs = T9z + T9B;
						  T9C = T9z - T9B;
						  T9O = T9v - T9q;
						  T9w = T9q + T9v;
						  Tgo = T3J - T3u;
						  T3K = T3u + T3J;
						  TiO = Tgr + Tgs;
						  Tgt = Tgr - Tgs;
					     }
					}
					{
					     E Ta1, T4o, T4C, T4J, Taa, Ta3, T4u, T4z, Ta7;
					     {
						  E T4F, T4G, T4I, T4n, T4l, T4t, T4q;
						  T4n = ii[WS(ios, 6)];
						  T4l = ri[WS(ios, 6)];
						  T4F = ri[WS(ios, 22)];
						  {
						       E T9N, T9D, Ta0, T4m;
						       T9N = T9x + T9C;
						       T9D = T9x - T9C;
						       Ta0 = T3i * T4l;
						       T4m = T3g * T4l;
						       Te6 = T9O + T9N;
						       T9P = T9N - T9O;
						       Te9 = T9w + T9D;
						       T9E = T9w - T9D;
						       Ta1 = FMA(T3g, T4n, Ta0);
						       T4o = FNMS(T3i, T4n, T4m);
						       T4G = T4E * T4F;
						  }
						  T4I = ii[WS(ios, 22)];
						  T4t = ii[WS(ios, 38)];
						  T4q = ri[WS(ios, 38)];
						  T4C = ii[WS(ios, 54)];
						  T4J = FMA(T4H, T4I, T4G);
						  {
						       E Ta9, Ta2, T4r, T4y;
						       Ta9 = T4E * T4I;
						       Ta2 = T4s * T4q;
						       T4r = T4p * T4q;
						       T4y = ri[WS(ios, 54)];
						       Taa = FNMS(T4H, T4F, Ta9);
						       Ta3 = FMA(T4p, T4t, Ta2);
						       T4u = FNMS(T4s, T4t, T4r);
						       T4z = T4x * T4y;
						       Ta7 = T4B * T4y;
						  }
					     }
					     {
						  E Ta4, TgC, T4v, T9Z, T4D, Ta8, T4K, TgD;
						  Ta4 = Ta1 - Ta3;
						  TgC = Ta1 + Ta3;
						  T4v = T4o + T4u;
						  T9Z = T4o - T4u;
						  T4D = FNMS(T4B, T4C, T4z);
						  Ta8 = FMA(T4x, T4C, Ta7);
						  Ta6 = T4D - T4J;
						  T4K = T4D + T4J;
						  TgD = Ta8 + Taa;
						  Tab = Ta8 - Taa;
						  Tan = Ta4 - T9Z;
						  Ta5 = T9Z + Ta4;
						  Tgz = T4K - T4v;
						  T4L = T4v + T4K;
						  TiU = TgC + TgD;
						  TgE = TgC - TgD;
					     }
					}
				   }
				   {
					E T5h, TaC, T5t, T5G, T5u, TaL, TaE, T5p, T5x;
					{
					     E T5B, T5C, T5F, T5e, T5g;
					     T5e = ri[WS(ios, 9)];
					     T5g = ii[WS(ios, 9)];
					     T5B = ri[WS(ios, 25)];
					     {
						  E Tam, Tac, T5f, TaB;
						  Tam = Ta6 + Tab;
						  Tac = Ta6 - Tab;
						  T5f = T3 * T5e;
						  TaB = T3 * T5g;
						  Ted = Tan + Tam;
						  Tao = Tam - Tan;
						  Teg = Ta5 + Tac;
						  Tad = Ta5 - Tac;
						  T5h = FMA(Tb, T5g, T5f);
						  TaC = FNMS(Tb, T5e, TaB);
						  T5C = T5A * T5B;
					     }
					     T5F = ii[WS(ios, 25)];
					     {
						  E T5o, T5k, TaK, TaD, T5l;
						  T5o = ii[WS(ios, 41)];
						  T5k = ri[WS(ios, 41)];
						  T5t = ri[WS(ios, 57)];
						  T5G = FMA(T5E, T5F, T5C);
						  TaK = T5A * T5F;
						  TaD = T5n * T5k;
						  T5l = T5j * T5k;
						  T5u = T5s * T5t;
						  TaL = FNMS(T5E, T5B, TaK);
						  TaE = FMA(T5j, T5o, TaD);
						  T5p = FNMS(T5n, T5o, T5l);
						  T5x = ii[WS(ios, 57)];
					     }
					}
					{
					     E T78, TbL, T7e, TbN, T7j, T7m;
					     {
						  E T7s, T7p, T7a, T7d;
						  {
						       E T75, Th1, TaG, Tbu, TaH, T76, T77, TaM, Th2, TbK, T5q, T5H, TaJ, Tbt, TaN;
						       T75 = ri[WS(ios, 7)];
						       {
							    E TaF, TaA, T5y, TaI;
							    Th1 = TaC + TaE;
							    TaF = TaC - TaE;
							    T5q = T5h + T5p;
							    TaA = T5h - T5p;
							    T5y = FMA(T5w, T5x, T5u);
							    TaI = T5s * T5x;
							    TaG = TaA + TaF;
							    Tbu = TaF - TaA;
							    T5H = T5y + T5G;
							    TaH = T5y - T5G;
							    TaJ = FNMS(T5w, T5t, TaI);
							    T76 = T1i * T75;
						       }
						       T77 = ii[WS(ios, 7)];
						       TgM = T5H - T5q;
						       T5I = T5q + T5H;
						       TaM = TaJ - TaL;
						       Th2 = TaJ + TaL;
						       TbK = T1i * T77;
						       T78 = FMA(T1k, T77, T76);
						       Tbt = TaH + TaM;
						       TaN = TaH - TaM;
						       Tj0 = Th1 + Th2;
						       Th3 = Th1 - Th2;
						       Tem = Tbu + Tbt;
						       Tbv = Tbt - Tbu;
						       Tex = TaG + TaN;
						       TaO = TaG - TaN;
						       TbL = FNMS(T1k, T75, TbK);
						  }
						  T7s = ii[WS(ios, 23)];
						  T7p = ri[WS(ios, 23)];
						  T7a = ri[WS(ios, 39)];
						  T7d = ii[WS(ios, 39)];
						  T7i = ri[WS(ios, 55)];
						  {
						       E TbT, T7q, T7b, TbM;
						       TbT = T7r * T7p;
						       T7q = T7o * T7p;
						       T7b = T79 * T7a;
						       TbM = T79 * T7d;
						       TbU = FMA(T7o, T7s, TbT);
						       T7t = FNMS(T7r, T7s, T7q);
						       T7e = FMA(T7c, T7d, T7b);
						       TbN = FNMS(T7c, T7a, TbM);
						       T7j = T7h * T7i;
						  }
						  T7m = ii[WS(ios, 55)];
					     }
					     T7f = T78 + T7e;
					     TbJ = T78 - T7e;
					     TbO = TbL - TbN;
					     Ths = TbL + TbN;
					     T7n = FMA(T7l, T7m, T7j);
					     TbR = T7h * T7m;
					}
				   }
			      }
			      {
				   E T6g, TaY, T6o, T6z, T6p, TaU, Tb0, T6m, T6q;
				   {
					E T5V, Tb9, T66, T5U, Tb5, Tbg, TgO, T5Y, Tb6, T6u, T6v, T6y;
					{
					     E Tbd, T5N, T5T, Tbf, T5W, T5X;
					     {
						  E T65, T61, T5P, T5S;
						  {
						       E T5M, TbQ, TcD, TbP, TbV, Tht, T5K, T7u, TbS;
						       T5M = ii[WS(ios, 5)];
						       T7u = T7n + T7t;
						       TbQ = T7n - T7t;
						       TbS = FNMS(T7l, T7i, TbR);
						       TcD = TbO - TbJ;
						       TbP = TbJ + TbO;
						       Thd = T7u - T7f;
						       T7v = T7f + T7u;
						       TbV = TbS - TbU;
						       Tht = TbS + TbU;
						       T5K = ri[WS(ios, 5)];
						       T65 = ii[WS(ios, 53)];
						       {
							    E TcC, TbW, Tbc, T5L;
							    TcC = TbQ + TbV;
							    TbW = TbQ - TbV;
							    Tjb = Ths + Tht;
							    Thu = Ths - Tht;
							    Tbc = Ti * T5K;
							    T5L = Te * T5K;
							    TeF = TcD + TcC;
							    TcE = TcC - TcD;
							    TeQ = TbP + TbW;
							    TbX = TbP - TbW;
							    Tbd = FMA(Te, T5M, Tbc);
							    T5N = FNMS(Ti, T5M, T5L);
							    T61 = ri[WS(ios, 53)];
						       }
						  }
						  T5P = ri[WS(ios, 37)];
						  T5S = ii[WS(ios, 37)];
						  T5V = ri[WS(ios, 21)];
						  {
						       E Tb8, T62, T5Q, Tbe;
						       Tb8 = T64 * T61;
						       T62 = T60 * T61;
						       T5Q = T5O * T5P;
						       Tbe = T5O * T5S;
						       Tb9 = FMA(T60, T65, Tb8);
						       T66 = FNMS(T64, T65, T62);
						       T5T = FMA(T5R, T5S, T5Q);
						       Tbf = FNMS(T5R, T5P, Tbe);
						       T5W = T3j * T5V;
						  }
						  T5X = ii[WS(ios, 21)];
					     }
					     T5U = T5N + T5T;
					     Tb5 = T5N - T5T;
					     Tbg = Tbd - Tbf;
					     TgO = Tbd + Tbf;
					     T5Y = FMA(T3m, T5X, T5W);
					     Tb6 = T3j * T5X;
					}
					{
					     E T6b, T6c, Tbi, Teo, TgR, TgP, Tba, T6f, T67, Tbh, Tb7;
					     T6b = ri[WS(ios, 61)];
					     T67 = T5Y + T66;
					     Tbh = T5Y - T66;
					     Tb7 = FNMS(T3m, T5V, Tb6);
					     T6c = T6a * T6b;
					     Tbi = Tbg + Tbh;
					     Teo = Tbg - Tbh;
					     TgR = T5U - T67;
					     T68 = T5U + T67;
					     TgP = Tb7 + Tb9;
					     Tba = Tb7 - Tb9;
					     T6f = ii[WS(ios, 61)];
					     T6u = ri[WS(ios, 45)];
					     {
						  E Tbb, Tep, TgQ, TaX;
						  Tbb = Tb5 - Tba;
						  Tep = Tb5 + Tba;
						  TgQ = TgO - TgP;
						  Tj5 = TgO + TgP;
						  T6g = FMA(T6e, T6f, T6c);
						  TaX = T6a * T6f;
						  Tez = FMA(KP414213562, Teo, Tep);
						  Teq = FNMS(KP414213562, Tep, Teo);
						  Tbj = FNMS(KP414213562, Tbi, Tbb);
						  Tbx = FMA(KP414213562, Tbb, Tbi);
						  TgS = TgQ - TgR;
						  Th5 = TgR + TgQ;
						  TaY = FNMS(T6e, T6b, TaX);
						  T6v = T6t * T6u;
					     }
					     T6y = ii[WS(ios, 45)];
					}
					{
					     E T6l, T6i, TaT, TaZ, T6j;
					     T6l = ii[WS(ios, 29)];
					     T6i = ri[WS(ios, 29)];
					     T6o = ri[WS(ios, 13)];
					     T6z = FMA(T6x, T6y, T6v);
					     TaT = T6t * T6y;
					     TaZ = T6k * T6i;
					     T6j = T6h * T6i;
					     T6p = T17 * T6o;
					     TaU = FNMS(T6x, T6u, TaT);
					     Tb0 = FMA(T6h, T6l, TaZ);
					     T6m = FNMS(T6k, T6l, T6j);
					     T6q = ii[WS(ios, 13)];
					}
				   }
				   {
					E T7I, Tci, T7T, Thf, Tcp, Tce, T7H, T7L, Tcf;
					{
					     E T7A, Tcm, Tco, T7G, T7J, T7K;
					     {
						  E T7S, T7O, T7F, T7C;
						  {
						       E TgU, TaQ, Tb3, Ter, TgT, TgV, TaV, TaW, Tes, TgW;
						       {
							    E T7x, Tb1, T6n, T7y, T7z, T6A, Tb2, TaS, Tcl, T6r, TaR;
							    T7x = ri[WS(ios, 3)];
							    TgU = TaY + Tb0;
							    Tb1 = TaY - Tb0;
							    T6n = T6g + T6m;
							    TaQ = T6g - T6m;
							    T6r = FMA(T19, T6q, T6p);
							    TaR = T17 * T6q;
							    T7y = T4 * T7x;
							    T7z = ii[WS(ios, 3)];
							    T6A = T6r + T6z;
							    Tb2 = T6r - T6z;
							    TaS = FNMS(T19, T6o, TaR);
							    Tcl = T4 * T7z;
							    Tb3 = Tb1 + Tb2;
							    Ter = Tb1 - Tb2;
							    TgT = T6n - T6A;
							    T6B = T6n + T6A;
							    TgV = TaS + TaU;
							    TaV = TaS - TaU;
							    T7A = FMA(T7, T7z, T7y);
							    Tcm = FNMS(T7, T7x, Tcl);
						       }
						       TaW = TaQ - TaV;
						       Tes = TaQ + TaV;
						       TgW = TgU - TgV;
						       Tj6 = TgU + TgV;
						       TeA = FNMS(KP414213562, Ter, Tes);
						       Tet = FMA(KP414213562, Tes, Ter);
						       Tb4 = FMA(KP414213562, Tb3, TaW);
						       Tby = FNMS(KP414213562, TaW, Tb3);
						       TgX = TgT + TgW;
						       Th6 = TgT - TgW;
						       T7S = ii[WS(ios, 51)];
						       T7O = ri[WS(ios, 51)];
						  }
						  T7F = ii[WS(ios, 35)];
						  T7C = ri[WS(ios, 35)];
						  T7I = ri[WS(ios, 19)];
						  {
						       E Tch, T7P, Tcn, T7D;
						       Tch = T7R * T7O;
						       T7P = T7N * T7O;
						       Tcn = T7E * T7C;
						       T7D = T7B * T7C;
						       Tci = FMA(T7N, T7S, Tch);
						       T7T = FNMS(T7R, T7S, T7P);
						       Tco = FMA(T7B, T7F, Tcn);
						       T7G = FNMS(T7E, T7F, T7D);
						       T7J = T2u * T7I;
						  }
						  T7K = ii[WS(ios, 19)];
					     }
					     Thf = Tcm + Tco;
					     Tcp = Tcm - Tco;
					     Tce = T7A - T7G;
					     T7H = T7A + T7G;
					     T7L = FMA(T2x, T7K, T7J);
					     Tcf = T2u * T7K;
					}
					{
					     E T83, Tc7, T87, Tc9, T89, T8f, T8j;
					     {
						  E T82, Tcr, TeH, Thi, Thg, Tcj, T7Z, Tc6, Tck, TeI, Thh;
						  T82 = ii[WS(ios, 59)];
						  {
						       E T7U, Tcq, Tcg, T7Y;
						       T7U = T7L + T7T;
						       Tcq = T7L - T7T;
						       Tcg = FNMS(T2x, T7I, Tcf);
						       T7Y = ri[WS(ios, 59)];
						       Tcr = Tcp + Tcq;
						       TeH = Tcp - Tcq;
						       Thi = T7H - T7U;
						       T7V = T7H + T7U;
						       Thg = Tcg + Tci;
						       Tcj = Tcg - Tci;
						       T7Z = T7X * T7Y;
						       Tc6 = T81 * T7Y;
						  }
						  Tck = Tce - Tcj;
						  TeI = Tce + Tcj;
						  Thh = Thf - Thg;
						  Tjg = Thf + Thg;
						  TeS = FMA(KP414213562, TeH, TeI);
						  TeJ = FNMS(KP414213562, TeI, TeH);
						  Tcs = FNMS(KP414213562, Tcr, Tck);
						  TcG = FMA(KP414213562, Tck, Tcr);
						  Thj = Thh - Thi;
						  Thw = Thi + Thh;
						  T83 = FNMS(T81, T82, T7Z);
						  Tc7 = FMA(T7X, T82, Tc6);
					     }
					     T8f = ri[WS(ios, 43)];
					     T8j = ii[WS(ios, 43)];
					     {
						  E T84, T86, T8g, Tc2, T85, Tc8;
						  T84 = ri[WS(ios, 27)];
						  T86 = ii[WS(ios, 27)];
						  T8g = T8e * T8f;
						  Tc2 = T8e * T8j;
						  T85 = T2 * T84;
						  Tc8 = T2 * T86;
						  T8k = FMA(T8i, T8j, T8g);
						  Tc3 = FNMS(T8i, T8f, Tc2);
						  T87 = FMA(Tg, T86, T85);
						  Tc9 = FNMS(Tg, T84, Tc8);
					     }
					     T8b = ii[WS(ios, 11)];
					     T89 = ri[WS(ios, 11)];
					     TbZ = T83 - T87;
					     T88 = T83 + T87;
					     Thl = Tc7 + Tc9;
					     Tca = Tc7 - Tc9;
					     Tc0 = Tx * T89;
					     T8a = Tu * T89;
					}
				   }
			      }
			 }
		    }
		    {
			 E TeM, TeT, TcH, Tcd, Thx, Tho, Tkw, Tkv, Tl6, Tl5;
			 {
			      E TiI, Tkp, TiQ, TiS, TiL, Tkq, TiP, TiV, Tjf, Tjd, Tjc, Tji, Tj4, Tj2, Tj1;
			      E Tj7, Tkh, Tki;
			      {
				   E TjG, T2I, Tkj, T4N, Tkk, Tkf, Tk5, TjJ, T8o, Tk2, TjL, T6D, TjY, TjU, Tk1;
				   E TjO;
				   {
					E T3L, Tjh, T8m, T4M, Tk6, Tke, TjH, TjI;
					{
					     E T1C, Tc1, T8c, T2H, Tc4, Thm;
					     TiI = TY - T1B;
					     T1C = TY + T1B;
					     Tc1 = FMA(Tu, T8b, Tc0);
					     T8c = FNMS(Tx, T8b, T8a);
					     T2H = T27 + T2G;
					     Tkp = T2G - T27;
					     TiQ = T39 - T3K;
					     T3L = T39 + T3K;
					     Tc4 = Tc1 - Tc3;
					     Thm = Tc1 + Tc3;
					     {
						  E Tcb, T8l, TeL, Tc5;
						  Tcb = T8c - T8k;
						  T8l = T8c + T8k;
						  TjG = T1C - T2H;
						  T2I = T1C + T2H;
						  TeL = TbZ + Tc4;
						  Tc5 = TbZ - Tc4;
						  {
						       E Thn, TeK, Tcc, Thk;
						       Tjh = Thl + Thm;
						       Thn = Thl - Thm;
						       TeK = Tca - Tcb;
						       Tcc = Tca + Tcb;
						       T8m = T88 + T8l;
						       Thk = T88 - T8l;
						       TeM = FMA(KP414213562, TeL, TeK);
						       TeT = FNMS(KP414213562, TeK, TeL);
						       TcH = FNMS(KP414213562, Tc5, Tcc);
						       Tcd = FMA(KP414213562, Tcc, Tc5);
						       Thx = Thk - Thn;
						       Tho = Thk + Thn;
						       T4M = T4k + T4L;
						       TiS = T4k - T4L;
						  }
					     }
					     TiL = TiJ - TiK;
					     Tk6 = TiJ + TiK;
					     Tke = Tk7 + Tkd;
					     Tkq = Tkd - Tk7;
					}
					TiP = TiN - TiO;
					TjH = TiN + TiO;
					Tkj = T4M - T3L;
					T4N = T3L + T4M;
					Tkk = Tke - Tk6;
					Tkf = Tk6 + Tke;
					TjI = TiT + TiU;
					TiV = TiT - TiU;
					{
					     E TjR, TjQ, TjS, T7w, T8n;
					     Tjf = T74 - T7v;
					     T7w = T74 + T7v;
					     T8n = T7V + T8m;
					     Tjd = T8m - T7V;
					     Tjc = Tja - Tjb;
					     TjR = Tja + Tjb;
					     Tk5 = TjH + TjI;
					     TjJ = TjH - TjI;
					     TjQ = T7w - T8n;
					     T8o = T7w + T8n;
					     Tji = Tjg - Tjh;
					     TjS = Tjg + Tjh;
					     {
						  E TjM, TjN, T5J, T6C, TjT;
						  Tj4 = T5d - T5I;
						  T5J = T5d + T5I;
						  T6C = T68 + T6B;
						  Tj2 = T6B - T68;
						  TjT = TjR - TjS;
						  Tk2 = TjR + TjS;
						  Tj1 = TiZ - Tj0;
						  TjM = TiZ + Tj0;
						  TjL = T5J - T6C;
						  T6D = T5J + T6C;
						  Tj7 = Tj5 - Tj6;
						  TjN = Tj5 + Tj6;
						  TjY = TjQ + TjT;
						  TjU = TjQ - TjT;
						  Tk1 = TjM + TjN;
						  TjO = TjM - TjN;
					     }
					}
				   }
				   {
					E Tk0, Tk3, TjW, Tko, Tkn, Tkl, Tkm, TjZ;
					{
					     E TjP, TjX, Tk4, Tkg, T4O, T8p, TjK, TjV;
					     Tk0 = T2I - T4N;
					     T4O = T2I + T4N;
					     T8p = T6D + T8o;
					     Tkh = T8o - T6D;
					     TjP = TjL + TjO;
					     TjX = TjO - TjL;
					     Tk3 = Tk1 - Tk2;
					     Tk4 = Tk1 + Tk2;
					     ri[0] = T4O + T8p;
					     ri[WS(ios, 32)] = T4O - T8p;
					     Tkg = Tk5 + Tkf;
					     Tki = Tkf - Tk5;
					     TjW = TjG - TjJ;
					     TjK = TjG + TjJ;
					     TjV = TjP + TjU;
					     Tko = TjU - TjP;
					     Tkn = Tkk - Tkj;
					     Tkl = Tkj + Tkk;
					     ii[WS(ios, 32)] = Tkg - Tk4;
					     ii[0] = Tk4 + Tkg;
					     ri[WS(ios, 8)] = FMA(KP707106781, TjV, TjK);
					     ri[WS(ios, 40)] = FNMS(KP707106781, TjV, TjK);
					     Tkm = TjX + TjY;
					     TjZ = TjX - TjY;
					}
					ii[WS(ios, 40)] = FNMS(KP707106781, Tkm, Tkl);
					ii[WS(ios, 8)] = FMA(KP707106781, Tkm, Tkl);
					ri[WS(ios, 24)] = FMA(KP707106781, TjZ, TjW);
					ri[WS(ios, 56)] = FNMS(KP707106781, TjZ, TjW);
					ii[WS(ios, 56)] = FNMS(KP707106781, Tko, Tkn);
					ii[WS(ios, 24)] = FMA(KP707106781, Tko, Tkn);
					ri[WS(ios, 16)] = Tk0 + Tk3;
					ri[WS(ios, 48)] = Tk0 - Tk3;
				   }
			      }
			      {
				   E Tjq, TiM, Tkx, Tkr, Tjt, Tky, Tks, TiX, Tjz, Tje, Tjx, TjD, Tjn, Tj9, Tjr;
				   E TiR;
				   ii[WS(ios, 48)] = Tki - Tkh;
				   ii[WS(ios, 16)] = Tkh + Tki;
				   Tjq = TiI + TiL;
				   TiM = TiI - TiL;
				   Tkx = Tkq - Tkp;
				   Tkr = Tkp + Tkq;
				   Tjr = TiQ + TiP;
				   TiR = TiP - TiQ;
				   {
					E Tjw, Tj3, Tjs, TiW, Tjv, Tj8;
					Tjs = TiS - TiV;
					TiW = TiS + TiV;
					Tjw = Tj1 + Tj2;
					Tj3 = Tj1 - Tj2;
					Tjt = Tjr + Tjs;
					Tky = Tjs - Tjr;
					Tks = TiR + TiW;
					TiX = TiR - TiW;
					Tjv = Tj4 + Tj7;
					Tj8 = Tj4 - Tj7;
					Tjz = Tjc + Tjd;
					Tje = Tjc - Tjd;
					Tjx = FMA(KP414213562, Tjw, Tjv);
					TjD = FNMS(KP414213562, Tjv, Tjw);
					Tjn = FNMS(KP414213562, Tj3, Tj8);
					Tj9 = FMA(KP414213562, Tj8, Tj3);
				   }
				   {
					E Tjm, TiY, Tkz, TkB, Tjy, Tjj;
					Tjm = FNMS(KP707106781, TiX, TiM);
					TiY = FMA(KP707106781, TiX, TiM);
					Tkz = FMA(KP707106781, Tky, Tkx);
					TkB = FNMS(KP707106781, Tky, Tkx);
					Tjy = Tjf + Tji;
					Tjj = Tjf - Tji;
					{
					     E TjC, Tkt, Tku, TjF;
					     {
						  E Tju, TjE, Tjo, Tjk, TjB, TjA;
						  TjC = FNMS(KP707106781, Tjt, Tjq);
						  Tju = FMA(KP707106781, Tjt, Tjq);
						  TjA = FNMS(KP414213562, Tjz, Tjy);
						  TjE = FMA(KP414213562, Tjy, Tjz);
						  Tjo = FMA(KP414213562, Tje, Tjj);
						  Tjk = FNMS(KP414213562, Tjj, Tje);
						  TjB = Tjx + TjA;
						  Tkw = TjA - Tjx;
						  Tkv = FNMS(KP707106781, Tks, Tkr);
						  Tkt = FMA(KP707106781, Tks, Tkr);
						  {
						       E Tjp, TkA, TkC, Tjl;
						       Tjp = Tjn + Tjo;
						       TkA = Tjo - Tjn;
						       TkC = Tj9 + Tjk;
						       Tjl = Tj9 - Tjk;
						       ri[WS(ios, 4)] = FMA(KP923879532, TjB, Tju);
						       ri[WS(ios, 36)] = FNMS(KP923879532, TjB, Tju);
						       ri[WS(ios, 60)] = FMA(KP923879532, Tjp, Tjm);
						       ri[WS(ios, 28)] = FNMS(KP923879532, Tjp, Tjm);
						       ii[WS(ios, 44)] = FNMS(KP923879532, TkA, Tkz);
						       ii[WS(ios, 12)] = FMA(KP923879532, TkA, Tkz);
						       ii[WS(ios, 60)] = FMA(KP923879532, TkC, TkB);
						       ii[WS(ios, 28)] = FNMS(KP923879532, TkC, TkB);
						       ri[WS(ios, 12)] = FMA(KP923879532, Tjl, TiY);
						       ri[WS(ios, 44)] = FNMS(KP923879532, Tjl, TiY);
						       Tku = TjD + TjE;
						       TjF = TjD - TjE;
						  }
					     }
					     ii[WS(ios, 36)] = FNMS(KP923879532, Tku, Tkt);
					     ii[WS(ios, 4)] = FMA(KP923879532, Tku, Tkt);
					     ri[WS(ios, 20)] = FMA(KP923879532, TjF, TjC);
					     ri[WS(ios, 52)] = FNMS(KP923879532, TjF, TjC);
					}
				   }
			      }
			 }
			 {
			      E TkV, Tl1, ThG, Tgk, TkH, TkN, Tis, Ti0, Thv, ThJ, TkO, TkI, TgH, Thy, TiC;
			      E TiG, Tiq, Tim, ThN, ThT, ThD, Th9, TkW, Tiv, Tl2, Ti7, ThP, Thq, Tiz, TiF;
			      E Tip, Tif;
			      {
				   E Ti1, Ti2, Ti4, Ti5, Thp, The, Tij, TiB, Tii, Tik;
				   {
					E ThW, Tg8, TkT, TkF, ThX, ThY, TkU, Tgj, Tgd, Tgi;
					ThW = Tg4 - Tg7;
					Tg8 = Tg4 + Tg7;
					TkT = TkE - TkD;
					TkF = TkD + TkE;
					ThX = Tgc - Tg9;
					Tgd = Tg9 + Tgc;
					ii[WS(ios, 52)] = FNMS(KP923879532, Tkw, Tkv);
					ii[WS(ios, 20)] = FMA(KP923879532, Tkw, Tkv);
					Tgi = Tge - Tgh;
					ThY = Tge + Tgh;
					TkU = Tgi - Tgd;
					Tgj = Tgd + Tgi;
					{
					     E TgA, ThH, Tgv, TgF;
					     {
						  E Tgp, TkG, ThZ, Tgu;
						  Ti1 = Tgn - Tgo;
						  Tgp = Tgn + Tgo;
						  TkV = FMA(KP707106781, TkU, TkT);
						  Tl1 = FNMS(KP707106781, TkU, TkT);
						  ThG = FMA(KP707106781, Tgj, Tg8);
						  Tgk = FNMS(KP707106781, Tgj, Tg8);
						  TkG = ThX + ThY;
						  ThZ = ThX - ThY;
						  Tgu = Tgq + Tgt;
						  Ti2 = Tgq - Tgt;
						  Ti4 = Tgy - Tgz;
						  TgA = Tgy + Tgz;
						  TkH = FMA(KP707106781, TkG, TkF);
						  TkN = FNMS(KP707106781, TkG, TkF);
						  Tis = FNMS(KP707106781, ThZ, ThW);
						  Ti0 = FMA(KP707106781, ThZ, ThW);
						  ThH = FMA(KP414213562, Tgp, Tgu);
						  Tgv = FNMS(KP414213562, Tgu, Tgp);
						  TgF = TgB + TgE;
						  Ti5 = TgB - TgE;
					     }
					     {
						  E Tig, Tih, ThI, TgG;
						  Thv = Thr + Thu;
						  Tig = Thr - Thu;
						  Tih = Tho - Thj;
						  Thp = Thj + Tho;
						  The = Thc + Thd;
						  Tij = Thc - Thd;
						  ThI = FNMS(KP414213562, TgA, TgF);
						  TgG = FMA(KP414213562, TgF, TgA);
						  TiB = FMA(KP707106781, Tih, Tig);
						  Tii = FNMS(KP707106781, Tih, Tig);
						  ThJ = ThH + ThI;
						  TkO = ThI - ThH;
						  TkI = Tgv + TgG;
						  TgH = Tgv - TgG;
						  Tik = Thw - Thx;
						  Thy = Thw + Thx;
					     }
					}
				   }
				   {
					E Tic, Tia, Ti9, Tid, Tit, Ti3;
					{
					     E Th4, ThM, TgZ, Th7, ThL, Th8;
					     {
						  E TgN, TgY, TiA, Til;
						  Tic = TgL - TgM;
						  TgN = TgL + TgM;
						  TgY = TgS + TgX;
						  Tia = TgX - TgS;
						  Ti9 = Th0 - Th3;
						  Th4 = Th0 + Th3;
						  TiA = FMA(KP707106781, Tik, Tij);
						  Til = FNMS(KP707106781, Tik, Tij);
						  ThM = FMA(KP707106781, TgY, TgN);
						  TgZ = FNMS(KP707106781, TgY, TgN);
						  TiC = FNMS(KP198912367, TiB, TiA);
						  TiG = FMA(KP198912367, TiA, TiB);
						  Tiq = FMA(KP668178637, Tii, Til);
						  Tim = FNMS(KP668178637, Til, Tii);
						  Th7 = Th5 + Th6;
						  Tid = Th5 - Th6;
					     }
					     ThL = FMA(KP707106781, Th7, Th4);
					     Th8 = FNMS(KP707106781, Th7, Th4);
					     Tit = FNMS(KP414213562, Ti1, Ti2);
					     Ti3 = FMA(KP414213562, Ti2, Ti1);
					     ThN = FMA(KP198912367, ThM, ThL);
					     ThT = FNMS(KP198912367, ThL, ThM);
					     ThD = FNMS(KP668178637, TgZ, Th8);
					     Th9 = FMA(KP668178637, Th8, TgZ);
					}
					{
					     E Tiy, Tib, Tiu, Ti6, Tix, Tie;
					     Tiu = FMA(KP414213562, Ti4, Ti5);
					     Ti6 = FNMS(KP414213562, Ti5, Ti4);
					     Tiy = FMA(KP707106781, Tia, Ti9);
					     Tib = FNMS(KP707106781, Tia, Ti9);
					     TkW = Tiu - Tit;
					     Tiv = Tit + Tiu;
					     Tl2 = Ti3 + Ti6;
					     Ti7 = Ti3 - Ti6;
					     Tix = FMA(KP707106781, Tid, Tic);
					     Tie = FNMS(KP707106781, Tid, Tic);
					     ThP = FMA(KP707106781, Thp, The);
					     Thq = FNMS(KP707106781, Thp, The);
					     Tiz = FMA(KP198912367, Tiy, Tix);
					     TiF = FNMS(KP198912367, Tix, Tiy);
					     Tip = FNMS(KP668178637, Tib, Tie);
					     Tif = FMA(KP668178637, Tie, Tib);
					}
				   }
			      }
			      {
				   E TkM, TkL, Tl0, TkZ;
				   {
					E ThC, TgI, TkP, TkR, ThO, Thz;
					ThC = FNMS(KP923879532, TgH, Tgk);
					TgI = FMA(KP923879532, TgH, Tgk);
					TkP = FMA(KP923879532, TkO, TkN);
					TkR = FNMS(KP923879532, TkO, TkN);
					ThO = FMA(KP707106781, Thy, Thv);
					Thz = FNMS(KP707106781, Thy, Thv);
					{
					     E ThS, TkJ, TkK, ThV;
					     {
						  E ThK, ThU, ThE, ThA, ThR, ThQ;
						  ThS = FNMS(KP923879532, ThJ, ThG);
						  ThK = FMA(KP923879532, ThJ, ThG);
						  ThQ = FNMS(KP198912367, ThP, ThO);
						  ThU = FMA(KP198912367, ThO, ThP);
						  ThE = FMA(KP668178637, Thq, Thz);
						  ThA = FNMS(KP668178637, Thz, Thq);
						  ThR = ThN + ThQ;
						  TkM = ThQ - ThN;
						  TkL = FNMS(KP923879532, TkI, TkH);
						  TkJ = FMA(KP923879532, TkI, TkH);
						  {
						       E ThF, TkQ, TkS, ThB;
						       ThF = ThD + ThE;
						       TkQ = ThE - ThD;
						       TkS = Th9 + ThA;
						       ThB = Th9 - ThA;
						       ri[WS(ios, 2)] = FMA(KP980785280, ThR, ThK);
						       ri[WS(ios, 34)] = FNMS(KP980785280, ThR, ThK);
						       ri[WS(ios, 58)] = FMA(KP831469612, ThF, ThC);
						       ri[WS(ios, 26)] = FNMS(KP831469612, ThF, ThC);
						       ii[WS(ios, 42)] = FNMS(KP831469612, TkQ, TkP);
						       ii[WS(ios, 10)] = FMA(KP831469612, TkQ, TkP);
						       ii[WS(ios, 58)] = FMA(KP831469612, TkS, TkR);
						       ii[WS(ios, 26)] = FNMS(KP831469612, TkS, TkR);
						       ri[WS(ios, 10)] = FMA(KP831469612, ThB, TgI);
						       ri[WS(ios, 42)] = FNMS(KP831469612, ThB, TgI);
						       TkK = ThT + ThU;
						       ThV = ThT - ThU;
						  }
					     }
					     ii[WS(ios, 34)] = FNMS(KP980785280, TkK, TkJ);
					     ii[WS(ios, 2)] = FMA(KP980785280, TkK, TkJ);
					     ri[WS(ios, 18)] = FMA(KP980785280, ThV, ThS);
					     ri[WS(ios, 50)] = FNMS(KP980785280, ThV, ThS);
					}
				   }
				   {
					E Tio, TkX, TkY, Tir, Ti8, Tin;
					Tio = FNMS(KP923879532, Ti7, Ti0);
					Ti8 = FMA(KP923879532, Ti7, Ti0);
					Tin = Tif + Tim;
					Tl0 = Tim - Tif;
					TkZ = FNMS(KP923879532, TkW, TkV);
					TkX = FMA(KP923879532, TkW, TkV);
					ii[WS(ios, 50)] = FNMS(KP980785280, TkM, TkL);
					ii[WS(ios, 18)] = FMA(KP980785280, TkM, TkL);
					ri[WS(ios, 6)] = FMA(KP831469612, Tin, Ti8);
					ri[WS(ios, 38)] = FNMS(KP831469612, Tin, Ti8);
					TkY = Tip + Tiq;
					Tir = Tip - Tiq;
					ii[WS(ios, 38)] = FNMS(KP831469612, TkY, TkX);
					ii[WS(ios, 6)] = FMA(KP831469612, TkY, TkX);
					ri[WS(ios, 22)] = FMA(KP831469612, Tir, Tio);
					ri[WS(ios, 54)] = FNMS(KP831469612, Tir, Tio);
				   }
				   {
					E TiE, Tl3, Tl4, TiH, Tiw, TiD;
					TiE = FMA(KP923879532, Tiv, Tis);
					Tiw = FNMS(KP923879532, Tiv, Tis);
					TiD = Tiz - TiC;
					Tl6 = Tiz + TiC;
					Tl5 = FMA(KP923879532, Tl2, Tl1);
					Tl3 = FNMS(KP923879532, Tl2, Tl1);
					ii[WS(ios, 54)] = FNMS(KP831469612, Tl0, TkZ);
					ii[WS(ios, 22)] = FMA(KP831469612, Tl0, TkZ);
					ri[WS(ios, 14)] = FMA(KP980785280, TiD, Tiw);
					ri[WS(ios, 46)] = FNMS(KP980785280, TiD, Tiw);
					Tl4 = TiG - TiF;
					TiH = TiF + TiG;
					ii[WS(ios, 46)] = FNMS(KP980785280, Tl4, Tl3);
					ii[WS(ios, 14)] = FMA(KP980785280, Tl4, Tl3);
					ri[WS(ios, 62)] = FMA(KP980785280, TiH, TiE);
					ri[WS(ios, 30)] = FNMS(KP980785280, TiH, TiE);
				   }
			      }
			 }
			 {
			      E Tla, TdV, TdO, Tm6, Tm5, TdR;
			      {
				   E TcT, TlO, TlI, Tar, TcX, Td3, TcN, TbB, TdM, TdQ, TdA, Tdw, TdJ, TdP, Tdz;
				   E Tdp, TlW, TdF, Tm2, Tdh, Td7, T91, Td6, T8M, TlT, TlF, Td0, Td4, TcO, TcK;
				   E T9g, Td8;
				   {
					E Tdb, Tdc, Tde, Tdf, Tdm, Tdk, Tdj, Tdn, TcF, Tct, TbY, Tdt, TdL, Tds, Tdu;
					E TcI, TdD, Tdd;
					{
					     E Tae, TcR, T9R, Tap, T9F, T9Q;
					     Tdb = FMA(KP707106781, T9E, T9p);
					     T9F = FNMS(KP707106781, T9E, T9p);
					     T9Q = FNMS(KP707106781, T9P, T9M);
					     Tdc = FMA(KP707106781, T9P, T9M);
					     Tde = FMA(KP707106781, Tad, T9Y);
					     Tae = FNMS(KP707106781, Tad, T9Y);
					     ii[WS(ios, 62)] = FMA(KP980785280, Tl6, Tl5);
					     ii[WS(ios, 30)] = FNMS(KP980785280, Tl6, Tl5);
					     TcR = FMA(KP668178637, T9F, T9Q);
					     T9R = FNMS(KP668178637, T9Q, T9F);
					     Tap = FNMS(KP707106781, Tao, Tal);
					     Tdf = FMA(KP707106781, Tao, Tal);
					     {
						  E Tbw, TcW, Tbl, Tbz;
						  {
						       E TaP, Tbk, TcS, Taq;
						       Tdm = FMA(KP707106781, TaO, Taz);
						       TaP = FNMS(KP707106781, TaO, Taz);
						       Tbk = Tb4 - Tbj;
						       Tdk = Tbj + Tb4;
						       Tdj = FMA(KP707106781, Tbv, Tbs);
						       Tbw = FNMS(KP707106781, Tbv, Tbs);
						       TcS = FNMS(KP668178637, Tae, Tap);
						       Taq = FMA(KP668178637, Tap, Tae);
						       TcW = FMA(KP923879532, Tbk, TaP);
						       Tbl = FNMS(KP923879532, Tbk, TaP);
						       TcT = TcR + TcS;
						       TlO = TcS - TcR;
						       TlI = T9R + Taq;
						       Tar = T9R - Taq;
						       Tbz = Tbx - Tby;
						       Tdn = Tbx + Tby;
						  }
						  {
						       E Tdq, Tdr, TcV, TbA;
						       TcF = FNMS(KP707106781, TcE, TcB);
						       Tdq = FMA(KP707106781, TcE, TcB);
						       Tdr = Tcs + Tcd;
						       Tct = Tcd - Tcs;
						       TbY = FNMS(KP707106781, TbX, TbI);
						       Tdt = FMA(KP707106781, TbX, TbI);
						       TcV = FMA(KP923879532, Tbz, Tbw);
						       TbA = FNMS(KP923879532, Tbz, Tbw);
						       TdL = FMA(KP923879532, Tdr, Tdq);
						       Tds = FNMS(KP923879532, Tdr, Tdq);
						       TcX = FMA(KP303346683, TcW, TcV);
						       Td3 = FNMS(KP303346683, TcV, TcW);
						       TcN = FNMS(KP534511135, Tbl, TbA);
						       TbB = FMA(KP534511135, TbA, Tbl);
						       Tdu = TcG + TcH;
						       TcI = TcG - TcH;
						  }
					     }
					}
					{
					     E TdI, Tdl, TdK, Tdv, TdH, Tdo;
					     TdK = FMA(KP923879532, Tdu, Tdt);
					     Tdv = FNMS(KP923879532, Tdu, Tdt);
					     TdI = FMA(KP923879532, Tdk, Tdj);
					     Tdl = FNMS(KP923879532, Tdk, Tdj);
					     TdM = FNMS(KP098491403, TdL, TdK);
					     TdQ = FMA(KP098491403, TdK, TdL);
					     TdA = FMA(KP820678790, Tds, Tdv);
					     Tdw = FNMS(KP820678790, Tdv, Tds);
					     TdH = FMA(KP923879532, Tdn, Tdm);
					     Tdo = FNMS(KP923879532, Tdn, Tdm);
					     TdD = FNMS(KP198912367, Tdb, Tdc);
					     Tdd = FMA(KP198912367, Tdc, Tdb);
					     TdJ = FMA(KP098491403, TdI, TdH);
					     TdP = FNMS(KP098491403, TdH, TdI);
					     Tdz = FNMS(KP820678790, Tdl, Tdo);
					     Tdp = FMA(KP820678790, Tdo, Tdl);
					}
					{
					     E TcZ, Tcu, TdE, Tdg;
					     TdE = FMA(KP198912367, Tde, Tdf);
					     Tdg = FNMS(KP198912367, Tdf, Tde);
					     TcZ = FMA(KP923879532, Tct, TbY);
					     Tcu = FNMS(KP923879532, Tct, TbY);
					     TlW = TdE - TdD;
					     TdF = TdD + TdE;
					     Tm2 = Tdd + Tdg;
					     Tdh = Tdd - Tdg;
					     {
						  E T8L, TlE, TcY, TcJ;
						  Tla = T8D + T8K;
						  T8L = T8D - T8K;
						  TlE = TdU - TdT;
						  TdV = TdT + TdU;
						  Td7 = FNMS(KP414213562, T8T, T90);
						  T91 = FMA(KP414213562, T90, T8T);
						  TcY = FMA(KP923879532, TcI, TcF);
						  TcJ = FNMS(KP923879532, TcI, TcF);
						  Td6 = FNMS(KP707106781, T8L, T8w);
						  T8M = FMA(KP707106781, T8L, T8w);
						  TlT = FNMS(KP707106781, TlE, TlD);
						  TlF = FMA(KP707106781, TlE, TlD);
						  Td0 = FNMS(KP303346683, TcZ, TcY);
						  Td4 = FMA(KP303346683, TcY, TcZ);
						  TcO = FMA(KP534511135, Tcu, TcJ);
						  TcK = FNMS(KP534511135, TcJ, Tcu);
						  T9g = FNMS(KP414213562, T9f, T98);
						  Td8 = FMA(KP414213562, T98, T9f);
					     }
					}
				   }
				   {
					E Tm1, TlV, TdC, Tda, Td2, TlM, TlL, Td5;
					{
					     E TlS, TcQ, TlH, TcM, TlR, TcP;
					     {
						  E TcL, Tas, TlP, TlQ, TlN;
						  TlS = TbB + TcK;
						  TcL = TbB - TcK;
						  {
						       E TlU, T9h, TlG, Td9, T9i;
						       TlU = T91 + T9g;
						       T9h = T91 - T9g;
						       TlG = Td8 - Td7;
						       Td9 = Td7 + Td8;
						       Tm1 = FMA(KP923879532, TlU, TlT);
						       TlV = FNMS(KP923879532, TlU, TlT);
						       TcQ = FMA(KP923879532, T9h, T8M);
						       T9i = FNMS(KP923879532, T9h, T8M);
						       TlN = FNMS(KP923879532, TlG, TlF);
						       TlH = FMA(KP923879532, TlG, TlF);
						       TdC = FMA(KP923879532, Td9, Td6);
						       Tda = FNMS(KP923879532, Td9, Td6);
						       Tas = FMA(KP831469612, Tar, T9i);
						       TcM = FNMS(KP831469612, Tar, T9i);
						  }
						  TlR = FNMS(KP831469612, TlO, TlN);
						  TlP = FMA(KP831469612, TlO, TlN);
						  TlQ = TcO - TcN;
						  TcP = TcN + TcO;
						  ri[WS(ios, 11)] = FMA(KP881921264, TcL, Tas);
						  ri[WS(ios, 43)] = FNMS(KP881921264, TcL, Tas);
						  ii[WS(ios, 43)] = FNMS(KP881921264, TlQ, TlP);
						  ii[WS(ios, 11)] = FMA(KP881921264, TlQ, TlP);
					     }
					     {
						  E TcU, Td1, TlJ, TlK;
						  Td2 = FNMS(KP831469612, TcT, TcQ);
						  TcU = FMA(KP831469612, TcT, TcQ);
						  ri[WS(ios, 59)] = FMA(KP881921264, TcP, TcM);
						  ri[WS(ios, 27)] = FNMS(KP881921264, TcP, TcM);
						  ii[WS(ios, 59)] = FMA(KP881921264, TlS, TlR);
						  ii[WS(ios, 27)] = FNMS(KP881921264, TlS, TlR);
						  Td1 = TcX + Td0;
						  TlM = Td0 - TcX;
						  TlL = FNMS(KP831469612, TlI, TlH);
						  TlJ = FMA(KP831469612, TlI, TlH);
						  TlK = Td3 + Td4;
						  Td5 = Td3 - Td4;
						  ri[WS(ios, 3)] = FMA(KP956940335, Td1, TcU);
						  ri[WS(ios, 35)] = FNMS(KP956940335, Td1, TcU);
						  ii[WS(ios, 35)] = FNMS(KP956940335, TlK, TlJ);
						  ii[WS(ios, 3)] = FMA(KP956940335, TlK, TlJ);
					     }
					}
					{
					     E Tdy, Tm0, TlZ, TdB;
					     {
						  E Tdi, Tdx, TlX, TlY;
						  Tdy = FNMS(KP980785280, Tdh, Tda);
						  Tdi = FMA(KP980785280, Tdh, Tda);
						  ri[WS(ios, 19)] = FMA(KP956940335, Td5, Td2);
						  ri[WS(ios, 51)] = FNMS(KP956940335, Td5, Td2);
						  ii[WS(ios, 51)] = FNMS(KP956940335, TlM, TlL);
						  ii[WS(ios, 19)] = FMA(KP956940335, TlM, TlL);
						  Tdx = Tdp + Tdw;
						  Tm0 = Tdw - Tdp;
						  TlZ = FNMS(KP980785280, TlW, TlV);
						  TlX = FMA(KP980785280, TlW, TlV);
						  TlY = Tdz + TdA;
						  TdB = Tdz - TdA;
						  ri[WS(ios, 7)] = FMA(KP773010453, Tdx, Tdi);
						  ri[WS(ios, 39)] = FNMS(KP773010453, Tdx, Tdi);
						  ii[WS(ios, 39)] = FNMS(KP773010453, TlY, TlX);
						  ii[WS(ios, 7)] = FMA(KP773010453, TlY, TlX);
					     }
					     {
						  E TdG, TdN, Tm3, Tm4;
						  TdO = FMA(KP980785280, TdF, TdC);
						  TdG = FNMS(KP980785280, TdF, TdC);
						  ri[WS(ios, 23)] = FMA(KP773010453, TdB, Tdy);
						  ri[WS(ios, 55)] = FNMS(KP773010453, TdB, Tdy);
						  ii[WS(ios, 55)] = FNMS(KP773010453, Tm0, TlZ);
						  ii[WS(ios, 23)] = FMA(KP773010453, Tm0, TlZ);
						  TdN = TdJ - TdM;
						  Tm6 = TdJ + TdM;
						  Tm5 = FMA(KP980785280, Tm2, Tm1);
						  Tm3 = FNMS(KP980785280, Tm2, Tm1);
						  Tm4 = TdQ - TdP;
						  TdR = TdP + TdQ;
						  ri[WS(ios, 15)] = FMA(KP995184726, TdN, TdG);
						  ri[WS(ios, 47)] = FNMS(KP995184726, TdN, TdG);
						  ii[WS(ios, 47)] = FNMS(KP995184726, Tm4, Tm3);
						  ii[WS(ios, 15)] = FMA(KP995184726, Tm4, Tm3);
					     }
					}
				   }
			      }
			      {
				   E Tf5, Tlk, Tle, Tej, Tf9, Tff, TeZ, TeD, TfY, Tg2, TfM, TfI, TfV, Tg1, TfL;
				   E TfB, Tls, TfR, Tly, Tft, Tfj, TdZ, Tfi, TdW, Tlp, Tlb, Tfc, Tfg, Tf0, TeW;
				   E Te2, Tfk;
				   {
					E Tfn, Tfo, Tfq, Tfr, Tfy, Tfw, Tfv, Tfz, TeR, TeN, TeG, TfF, TfX, TfE, TfG;
					E TeU, TfP, Tfp;
					{
					     E Te7, Tea, Tee, Teh;
					     Tfn = FNMS(KP707106781, Te6, Te5);
					     Te7 = FMA(KP707106781, Te6, Te5);
					     ri[WS(ios, 63)] = FMA(KP995184726, TdR, TdO);
					     ri[WS(ios, 31)] = FNMS(KP995184726, TdR, TdO);
					     ii[WS(ios, 63)] = FMA(KP995184726, Tm6, Tm5);
					     ii[WS(ios, 31)] = FNMS(KP995184726, Tm6, Tm5);
					     Tea = FMA(KP707106781, Te9, Te8);
					     Tfo = FNMS(KP707106781, Te9, Te8);
					     Tfq = FNMS(KP707106781, Ted, Tec);
					     Tee = FMA(KP707106781, Ted, Tec);
					     Teh = FMA(KP707106781, Teg, Tef);
					     Tfr = FNMS(KP707106781, Teg, Tef);
					     {
						  E Tey, Tf8, Tev, TeB;
						  {
						       E Ten, Tf3, Teb, Tf4, Tei, Teu;
						       Tfy = FNMS(KP707106781, Tem, Tel);
						       Ten = FMA(KP707106781, Tem, Tel);
						       Tf3 = FMA(KP198912367, Te7, Tea);
						       Teb = FNMS(KP198912367, Tea, Te7);
						       Tf4 = FNMS(KP198912367, Tee, Teh);
						       Tei = FMA(KP198912367, Teh, Tee);
						       Teu = Teq + Tet;
						       Tfw = Tet - Teq;
						       Tfv = FNMS(KP707106781, Tex, Tew);
						       Tey = FMA(KP707106781, Tex, Tew);
						       Tf5 = Tf3 + Tf4;
						       Tlk = Tf4 - Tf3;
						       Tle = Teb + Tei;
						       Tej = Teb - Tei;
						       Tf8 = FMA(KP923879532, Teu, Ten);
						       Tev = FNMS(KP923879532, Teu, Ten);
						       TeB = Tez + TeA;
						       Tfz = Tez - TeA;
						  }
						  {
						       E TfC, TfD, Tf7, TeC;
						       TeR = FMA(KP707106781, TeQ, TeP);
						       TfC = FNMS(KP707106781, TeQ, TeP);
						       TfD = TeM - TeJ;
						       TeN = TeJ + TeM;
						       TeG = FMA(KP707106781, TeF, TeE);
						       TfF = FNMS(KP707106781, TeF, TeE);
						       Tf7 = FMA(KP923879532, TeB, Tey);
						       TeC = FNMS(KP923879532, TeB, Tey);
						       TfX = FMA(KP923879532, TfD, TfC);
						       TfE = FNMS(KP923879532, TfD, TfC);
						       Tf9 = FMA(KP098491403, Tf8, Tf7);
						       Tff = FNMS(KP098491403, Tf7, Tf8);
						       TeZ = FNMS(KP820678790, Tev, TeC);
						       TeD = FMA(KP820678790, TeC, Tev);
						       TfG = TeS - TeT;
						       TeU = TeS + TeT;
						  }
					     }
					}
					{
					     E TfU, Tfx, TfW, TfH, TfT, TfA;
					     TfW = FMA(KP923879532, TfG, TfF);
					     TfH = FNMS(KP923879532, TfG, TfF);
					     TfU = FMA(KP923879532, Tfw, Tfv);
					     Tfx = FNMS(KP923879532, Tfw, Tfv);
					     TfY = FNMS(KP303346683, TfX, TfW);
					     Tg2 = FMA(KP303346683, TfW, TfX);
					     TfM = FMA(KP534511135, TfE, TfH);
					     TfI = FNMS(KP534511135, TfH, TfE);
					     TfT = FMA(KP923879532, Tfz, Tfy);
					     TfA = FNMS(KP923879532, Tfz, Tfy);
					     TfP = FNMS(KP668178637, Tfn, Tfo);
					     Tfp = FMA(KP668178637, Tfo, Tfn);
					     TfV = FMA(KP303346683, TfU, TfT);
					     Tg1 = FNMS(KP303346683, TfT, TfU);
					     TfL = FNMS(KP534511135, Tfx, TfA);
					     TfB = FMA(KP534511135, TfA, Tfx);
					}
					{
					     E Tfb, TeO, TfQ, Tfs, Tfa, TeV;
					     TfQ = FMA(KP668178637, Tfq, Tfr);
					     Tfs = FNMS(KP668178637, Tfr, Tfq);
					     Tfb = FMA(KP923879532, TeN, TeG);
					     TeO = FNMS(KP923879532, TeN, TeG);
					     Tls = TfQ - TfP;
					     TfR = TfP + TfQ;
					     Tly = Tfp + Tfs;
					     Tft = Tfp - Tfs;
					     Tfj = FNMS(KP414213562, TdX, TdY);
					     TdZ = FMA(KP414213562, TdY, TdX);
					     Tfa = FMA(KP923879532, TeU, TeR);
					     TeV = FNMS(KP923879532, TeU, TeR);
					     Tfi = FNMS(KP707106781, TdV, TdS);
					     TdW = FMA(KP707106781, TdV, TdS);
					     Tlp = FNMS(KP707106781, Tla, Tl9);
					     Tlb = FMA(KP707106781, Tla, Tl9);
					     Tfc = FNMS(KP098491403, Tfb, Tfa);
					     Tfg = FMA(KP098491403, Tfa, Tfb);
					     Tf0 = FMA(KP820678790, TeO, TeV);
					     TeW = FNMS(KP820678790, TeV, TeO);
					     Te2 = FNMS(KP414213562, Te1, Te0);
					     Tfk = FMA(KP414213562, Te0, Te1);
					}
				   }
				   {
					E Tlx, Tlr, TfO, Tfm, Tfe, Tli, Tlh, Tfh;
					{
					     E Tlo, Tf2, Tld, TeY, Tln, Tf1;
					     {
						  E TeX, Tek, Tll, Tlm, Tlj;
						  Tlo = TeD + TeW;
						  TeX = TeD - TeW;
						  {
						       E Tlq, Te3, Tlc, Tfl, Te4;
						       Tlq = Te2 - TdZ;
						       Te3 = TdZ + Te2;
						       Tlc = Tfj + Tfk;
						       Tfl = Tfj - Tfk;
						       Tlx = FNMS(KP923879532, Tlq, Tlp);
						       Tlr = FMA(KP923879532, Tlq, Tlp);
						       Tf2 = FMA(KP923879532, Te3, TdW);
						       Te4 = FNMS(KP923879532, Te3, TdW);
						       Tlj = FNMS(KP923879532, Tlc, Tlb);
						       Tld = FMA(KP923879532, Tlc, Tlb);
						       TfO = FNMS(KP923879532, Tfl, Tfi);
						       Tfm = FMA(KP923879532, Tfl, Tfi);
						       Tek = FMA(KP980785280, Tej, Te4);
						       TeY = FNMS(KP980785280, Tej, Te4);
						  }
						  Tln = FNMS(KP980785280, Tlk, Tlj);
						  Tll = FMA(KP980785280, Tlk, Tlj);
						  Tlm = Tf0 - TeZ;
						  Tf1 = TeZ + Tf0;
						  ri[WS(ios, 9)] = FMA(KP773010453, TeX, Tek);
						  ri[WS(ios, 41)] = FNMS(KP773010453, TeX, Tek);
						  ii[WS(ios, 41)] = FNMS(KP773010453, Tlm, Tll);
						  ii[WS(ios, 9)] = FMA(KP773010453, Tlm, Tll);
					     }
					     {
						  E Tf6, Tfd, Tlf, Tlg;
						  Tfe = FNMS(KP980785280, Tf5, Tf2);
						  Tf6 = FMA(KP980785280, Tf5, Tf2);
						  ri[WS(ios, 57)] = FMA(KP773010453, Tf1, TeY);
						  ri[WS(ios, 25)] = FNMS(KP773010453, Tf1, TeY);
						  ii[WS(ios, 57)] = FMA(KP773010453, Tlo, Tln);
						  ii[WS(ios, 25)] = FNMS(KP773010453, Tlo, Tln);
						  Tfd = Tf9 + Tfc;
						  Tli = Tfc - Tf9;
						  Tlh = FNMS(KP980785280, Tle, Tld);
						  Tlf = FMA(KP980785280, Tle, Tld);
						  Tlg = Tff + Tfg;
						  Tfh = Tff - Tfg;
						  ri[WS(ios, 1)] = FMA(KP995184726, Tfd, Tf6);
						  ri[WS(ios, 33)] = FNMS(KP995184726, Tfd, Tf6);
						  ii[WS(ios, 33)] = FNMS(KP995184726, Tlg, Tlf);
						  ii[WS(ios, 1)] = FMA(KP995184726, Tlg, Tlf);
					     }
					}
					{
					     E TfK, Tlw, Tlv, TfN;
					     {
						  E Tfu, TfJ, Tlt, Tlu;
						  TfK = FNMS(KP831469612, Tft, Tfm);
						  Tfu = FMA(KP831469612, Tft, Tfm);
						  ri[WS(ios, 17)] = FMA(KP995184726, Tfh, Tfe);
						  ri[WS(ios, 49)] = FNMS(KP995184726, Tfh, Tfe);
						  ii[WS(ios, 49)] = FNMS(KP995184726, Tli, Tlh);
						  ii[WS(ios, 17)] = FMA(KP995184726, Tli, Tlh);
						  TfJ = TfB + TfI;
						  Tlw = TfI - TfB;
						  Tlv = FNMS(KP831469612, Tls, Tlr);
						  Tlt = FMA(KP831469612, Tls, Tlr);
						  Tlu = TfL + TfM;
						  TfN = TfL - TfM;
						  ri[WS(ios, 5)] = FMA(KP881921264, TfJ, Tfu);
						  ri[WS(ios, 37)] = FNMS(KP881921264, TfJ, Tfu);
						  ii[WS(ios, 37)] = FNMS(KP881921264, Tlu, Tlt);
						  ii[WS(ios, 5)] = FMA(KP881921264, Tlu, Tlt);
					     }
					     {
						  E TfS, TfZ, Tlz, TlA;
						  Tg0 = FMA(KP831469612, TfR, TfO);
						  TfS = FNMS(KP831469612, TfR, TfO);
						  ri[WS(ios, 21)] = FMA(KP881921264, TfN, TfK);
						  ri[WS(ios, 53)] = FNMS(KP881921264, TfN, TfK);
						  ii[WS(ios, 53)] = FNMS(KP881921264, Tlw, Tlv);
						  ii[WS(ios, 21)] = FMA(KP881921264, Tlw, Tlv);
						  TfZ = TfV - TfY;
						  TlC = TfV + TfY;
						  TlB = FMA(KP831469612, Tly, Tlx);
						  Tlz = FNMS(KP831469612, Tly, Tlx);
						  TlA = Tg2 - Tg1;
						  Tg3 = Tg1 + Tg2;
						  ri[WS(ios, 13)] = FMA(KP956940335, TfZ, TfS);
						  ri[WS(ios, 45)] = FNMS(KP956940335, TfZ, TfS);
						  ii[WS(ios, 45)] = FNMS(KP956940335, TlA, Tlz);
						  ii[WS(ios, 13)] = FMA(KP956940335, TlA, Tlz);
					     }
					}
				   }
			      }
			 }
		    }
	       }
	  }
	  ri[WS(ios, 61)] = FMA(KP956940335, Tg3, Tg0);
	  ri[WS(ios, 29)] = FNMS(KP956940335, Tg3, Tg0);
	  ii[WS(ios, 61)] = FMA(KP956940335, TlC, TlB);
	  ii[WS(ios, 29)] = FNMS(KP956940335, TlC, TlB);
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 0, 1},
     {TW_CEXP, 0, 3},
     {TW_CEXP, 0, 9},
     {TW_CEXP, 0, 27},
     {TW_CEXP, 0, 63},
     {TW_NEXT, 1, 0}
};

static const ct_desc desc = { 64, "t2_64", twinstr, &GENUS, {520, 206, 634, 0}, 0, 0, 0 };

void X(codelet_t2_64) (planner *p) {
     X(kdft_dit_register) (p, t2_64, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_twiddle -compact -variables 4 -pipeline-latency 4 -twiddle-log3 -precompute-twiddles -n 64 -name t2_64 -include t.h */

/*
 * This function contains 1154 FP additions, 660 FP multiplications,
 * (or, 880 additions, 386 multiplications, 274 fused multiply/add),
 * 302 stack variables, and 256 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.8 2006-01-05 03:04:27 stevenj Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_twiddle.ml,v 1.23 2006-01-05 03:04:27 stevenj Exp $
 */

#include "t.h"

static const R *t2_64(R *ri, R *ii, const R *W, stride ios, INT m, INT dist)
{
     DK(KP471396736, +0.471396736825997648556387625905254377657460319);
     DK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DK(KP290284677, +0.290284677254462367636192375817395274691476278);
     DK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DK(KP634393284, +0.634393284163645498215171613225493370675687095);
     DK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DK(KP098017140, +0.098017140329560601994195563888641845861136673);
     DK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     INT i;
     for (i = m; i > 0; i = i - 1, ri = ri + dist, ii = ii + dist, W = W + 10, MAKE_VOLATILE_STRIDE(ios)) {
	  E T3, Tc, T4, T7, T8, T5, TQ, T3e, T1e, T39, T3c, TU, T1a, T37, Ta;
	  E Tw, Tf, Ty, Tj, T2, T1C, T3K, T1V, T3x, T3I, T1G, T1R, T3v, T2m, T2q;
	  E T5Y, T6u, T53, T5B, T62, T6w, T57, T5D, T2V, T2X, Th, TE, T3Y, T3V, T3j;
	  E Tm, TA, T3g, T1j, T1t, TW, T2C, T2z, T1u, T10, T1h, To, T1p, T6j, T6H;
	  E Ts, T1l, T6l, T6F, T2P, T4b, T4x, T5i, T2R, T49, T4z, T5g, TG, T4k, T4m;
	  E TK, T21, T3O, T3Q, T25, TN, TX, T11, T79, T6X, T5M, T6b, T1v, T30, T69;
	  E T77, T13, T2F, T2D, T6p, T6O, T1x, T2a, T2f, T6V, T28, T6r, T2h, T6Q, T32;
	  E T5K, T5w, T4G, T4Q, T3m, T4h, T4I, T5y, T3k, T4f, T41, T4S, T4Y, T3q, T3D;
	  E T3F, T5r, T3s, T4W, T3Z, T5p;
	  {
	       E Tb, Tl, Tx, TD, Tg, Tk, Tz, TC, T1B, T1F, T2p, T2l, T1U, T1Q, T1A;
	       E T1E, T2o, T2k, T1T, T1P;
	       {
		    E T6, T1d, T19, Td, T1c, T9, Te, T18, TS, TP, TT, TO;
		    T3 = W[4];
		    Tc = W[5];
		    T4 = W[2];
		    T7 = W[3];
		    T8 = W[1];
		    T5 = W[0];
		    T6 = T4 * T5;
		    T1d = Tc * T5;
		    T19 = Tc * T8;
		    Td = T4 * T8;
		    T1c = T3 * T8;
		    T9 = T7 * T8;
		    Te = T7 * T5;
		    T18 = T3 * T5;
		    TS = T3 * T7;
		    TP = Tc * T7;
		    TT = Tc * T4;
		    TO = T3 * T4;
		    TQ = TO - TP;
		    T3e = TS - TT;
		    T1e = T1c - T1d;
		    T39 = T1c + T1d;
		    T3c = TO + TP;
		    TU = TS + TT;
		    T1a = T18 + T19;
		    T37 = T18 - T19;
		    Ta = T6 - T9;
		    Tb = T3 * Ta;
		    Tl = Tc * Ta;
		    Tw = T6 + T9;
		    Tx = T3 * Tw;
		    TD = Tc * Tw;
		    Tf = Td + Te;
		    Tg = Tc * Tf;
		    Tk = T3 * Tf;
		    Ty = Td - Te;
		    Tz = Tc * Ty;
		    TC = T3 * Ty;
		    Tj = W[7];
		    T1B = Tj * T7;
		    T1F = Tj * T4;
		    T2p = Tj * T5;
		    T2l = Tj * T8;
		    T1U = Tj * T3;
		    T1Q = Tj * Tc;
		    T2 = W[6];
		    T1A = T2 * T4;
		    T1E = T2 * T7;
		    T2o = T2 * T8;
		    T2k = T2 * T5;
		    T1T = T2 * Tc;
		    T1P = T2 * T3;
	       }
	       T1C = T1A + T1B;
	       T3K = T1E + T1F;
	       T1V = T1T + T1U;
	       T3x = T2o - T2p;
	       T3I = T1A - T1B;
	       T1G = T1E - T1F;
	       T1R = T1P - T1Q;
	       {
		    E T5W, T5X, T55, T56;
		    T3v = T2k + T2l;
		    T2m = T2k - T2l;
		    T2q = T2o + T2p;
		    T5W = T2 * Ta;
		    T5X = Tj * Tf;
		    T5Y = T5W - T5X;
		    T6u = T5W + T5X;
		    {
			 E T51, T52, T60, T61;
			 T51 = T2 * Tw;
			 T52 = Tj * Ty;
			 T53 = T51 - T52;
			 T5B = T51 + T52;
			 T60 = T2 * Tf;
			 T61 = Tj * Ta;
			 T62 = T60 + T61;
			 T6w = T60 - T61;
		    }
		    T55 = T2 * Ty;
		    T56 = Tj * Tw;
		    T57 = T55 + T56;
		    T5D = T55 - T56;
		    {
			 E Ti, Tr, TF, TI, T3W, T3X, T3T, T3U, T3h, T3i, Tn, Tq, TB, TJ, T3d;
			 E T3f, T1k, T1n, T1Z, T24, TR, TV, T2A, T2B, T2x, T2y, T20, T23, TY, TZ;
			 E T1i, T1o;
			 T2V = T1P + T1Q;
			 T2X = T1T - T1U;
			 Th = Tb + Tg;
			 Ti = T2 * Th;
			 Tr = Tj * Th;
			 TE = TC - TD;
			 TF = Tj * TE;
			 TI = T2 * TE;
			 T3W = T2 * T39;
			 T3X = Tj * T37;
			 T3Y = T3W - T3X;
			 T3T = T2 * T37;
			 T3U = Tj * T39;
			 T3V = T3T + T3U;
			 T3h = T2 * T3e;
			 T3i = Tj * T3c;
			 T3j = T3h + T3i;
			 Tm = Tk - Tl;
			 Tn = Tj * Tm;
			 Tq = T2 * Tm;
			 TA = Tx + Tz;
			 TB = T2 * TA;
			 TJ = Tj * TA;
			 T3d = T2 * T3c;
			 T3f = Tj * T3e;
			 T3g = T3d - T3f;
			 T1j = Tk + Tl;
			 T1k = Tj * T1j;
			 T1n = T2 * T1j;
			 T1t = Tx - Tz;
			 T1Z = T2 * T1t;
			 T24 = Tj * T1t;
			 TR = T2 * TQ;
			 TV = Tj * TU;
			 TW = TR + TV;
			 T2A = T2 * T1e;
			 T2B = Tj * T1a;
			 T2C = T2A + T2B;
			 T2x = T2 * T1a;
			 T2y = Tj * T1e;
			 T2z = T2x - T2y;
			 T1u = TC + TD;
			 T20 = Tj * T1u;
			 T23 = T2 * T1u;
			 TY = T2 * TU;
			 TZ = Tj * TQ;
			 T10 = TY - TZ;
			 T1h = Tb - Tg;
			 T1i = T2 * T1h;
			 T1o = Tj * T1h;
			 To = Ti + Tn;
			 T1p = T1n + T1o;
			 T6j = TR - TV;
			 T6H = T2A - T2B;
			 Ts = Tq - Tr;
			 T1l = T1i - T1k;
			 T6l = TY + TZ;
			 T6F = T2x + T2y;
			 T2P = T1Z - T20;
			 T4b = TI - TJ;
			 T4x = T3d + T3f;
			 T5i = T3W + T3X;
			 T2R = T23 + T24;
			 T49 = TB + TF;
			 T4z = T3h - T3i;
			 T5g = T3T - T3U;
			 TG = TB - TF;
			 T4k = Ti - Tn;
			 T4m = Tq + Tr;
			 TK = TI + TJ;
			 T21 = T1Z + T20;
			 T3O = T1i + T1k;
			 T3Q = T1n - T1o;
			 T25 = T23 - T24;
			 TN = W[8];
			 TX = W[9];
			 T11 = FNMS(TX, T10, TN * TW);
			 T79 = FMA(TN, T25, TX * T21);
			 T6X = FNMS(TX, Ta, TN * Tf);
			 T5M = FMA(TN, T2X, TX * T2V);
			 T6b = FNMS(TX, TG, TN * TK);
			 T1v = FMA(TN, T1t, TX * T1u);
			 T30 = FMA(TN, T1h, TX * T1j);
			 T69 = FMA(TN, TG, TX * TK);
			 T77 = FNMS(TX, T25, TN * T21);
			 T13 = FMA(TN, T10, TX * TW);
			 T2F = FNMS(TX, T2z, TN * T2C);
			 T2D = FMA(TN, T2z, TX * T2C);
			 T6p = FNMS(TX, T1e, TN * T1a);
			 T6O = FMA(TN, TQ, TX * TU);
			 T1x = FNMS(TX, T1t, TN * T1u);
			 T2a = FMA(TN, TE, TX * TA);
			 T2f = FMA(TN, T4, TX * T7);
			 T6V = FMA(TN, Ta, TX * Tf);
			 T28 = FNMS(TX, TE, TN * TA);
			 T6r = FMA(TN, T1e, TX * T1a);
			 T2h = FNMS(TX, T4, TN * T7);
			 T6Q = FNMS(TX, TQ, TN * TU);
			 T32 = FNMS(TX, T1h, TN * T1j);
			 T5K = FNMS(TX, T2X, TN * T2V);
			 T5w = FNMS(TX, Ty, TN * Tw);
			 T4G = FNMS(TX, T3Q, TN * T3O);
			 T4Q = FMA(TN, T4k, TX * T4m);
			 T3m = FNMS(TX, T3g, TN * T3j);
			 T4h = FNMS(TX, T3, TN * Tc);
			 T4I = FMA(TN, T3Q, TX * T3O);
			 T5y = FMA(TN, Ty, TX * Tw);
			 T3k = FMA(TN, T3g, TX * T3j);
			 T4f = FMA(TN, T3, TX * Tc);
			 T41 = FMA(TN, T3Y, TX * T3V);
			 T4S = FNMS(TX, T4k, TN * T4m);
			 T4Y = FMA(TN, T3e, TX * T3c);
			 T3q = FNMS(TX, Tm, TN * Th);
			 T3D = FMA(TN, T5, TX * T8);
			 T3F = FNMS(TX, T5, TN * T8);
			 T5r = FNMS(TX, T37, TN * T39);
			 T3s = FMA(TN, Tm, TX * Th);
			 T4W = FNMS(TX, T3e, TN * T3c);
			 T3Z = FNMS(TX, T3Y, TN * T3V);
			 T5p = FMA(TN, T37, TX * T39);
		    }
	       }
	  }
	  {
	       E T17, TdV, Tj3, Tjx, T7l, TbJ, Ti3, Tix, T1K, Tiw, TdY, ThY, T7w, Tj0, TbM;
	       E Tjw, T2e, TgA, T7I, TaY, TbQ, Tda, Te4, TfO, T2J, TgB, T7T, TaZ, TbT, Tdb;
	       E Te9, TfP, T36, T3B, TgH, TgE, TgF, TgG, T80, TbW, Tel, TfT, T8b, Tc0, T8k;
	       E TbX, Teg, TfS, T8h, TbZ, T45, T4q, TgJ, TgK, TgL, TgM, T8r, Tc6, Tew, TfW;
	       E T8C, Tc4, T8L, Tc7, Ter, TfV, T8I, Tc3, T6B, Th1, Tfm, Tga, Th8, ThI, T9N;
	       E Tcv, T9Y, TcH, Tav, Tcw, Tf5, Tg7, Tas, TcG, T5c, TgV, TeV, Tg0, TgS, ThD;
	       E T8U, Tcc, T95, Tco, T9C, Tcd, TeE, Tg3, T9z, Tcn, T5R, TgT, TeO, TeW, TgY;
	       E ThE, T9h, T9F, T9s, T9E, Tck, Tcq, TeJ, TeX, Tch, Tcr, T7e, Th9, Tff, Tfn;
	       E Th4, ThJ, Taa, Tay, Tal, Tax, TcD, TcJ, Tfa, Tfo, TcA, TcK;
	       {
		    E T1, Ti1, Tu, Ti0, TM, T7i, T15, T7j, Tp, Tt;
		    T1 = ri[0];
		    Ti1 = ii[0];
		    Tp = ri[WS(ios, 32)];
		    Tt = ii[WS(ios, 32)];
		    Tu = FNMS(Ts, Tt, To * Tp);
		    Ti0 = FMA(Ts, Tp, To * Tt);
		    {
			 E TH, TL, T12, T14;
			 TH = ri[WS(ios, 16)];
			 TL = ii[WS(ios, 16)];
			 TM = FMA(TG, TH, TK * TL);
			 T7i = FNMS(TK, TH, TG * TL);
			 T12 = ri[WS(ios, 48)];
			 T14 = ii[WS(ios, 48)];
			 T15 = FMA(T11, T12, T13 * T14);
			 T7j = FNMS(T13, T12, T11 * T14);
		    }
		    {
			 E Tv, T16, Tj1, Tj2;
			 Tv = T1 + Tu;
			 T16 = TM + T15;
			 T17 = Tv + T16;
			 TdV = Tv - T16;
			 Tj1 = Ti1 - Ti0;
			 Tj2 = TM - T15;
			 Tj3 = Tj1 - Tj2;
			 Tjx = Tj2 + Tj1;
		    }
		    {
			 E T7h, T7k, ThZ, Ti2;
			 T7h = T1 - Tu;
			 T7k = T7i - T7j;
			 T7l = T7h - T7k;
			 TbJ = T7h + T7k;
			 ThZ = T7i + T7j;
			 Ti2 = Ti0 + Ti1;
			 Ti3 = ThZ + Ti2;
			 Tix = Ti2 - ThZ;
		    }
	       }
	       {
		    E T1g, T7m, T1r, T7n, T7o, T7p, T1z, T7s, T1I, T7t, T7r, T7u;
		    {
			 E T1b, T1f, T1m, T1q;
			 T1b = ri[WS(ios, 8)];
			 T1f = ii[WS(ios, 8)];
			 T1g = FNMS(T1e, T1f, T1a * T1b);
			 T7m = FMA(T1e, T1b, T1a * T1f);
			 T1m = ri[WS(ios, 40)];
			 T1q = ii[WS(ios, 40)];
			 T1r = FMA(T1l, T1m, T1p * T1q);
			 T7n = FNMS(T1p, T1m, T1l * T1q);
		    }
		    T7o = T7m - T7n;
		    T7p = T1g - T1r;
		    {
			 E T1w, T1y, T1D, T1H;
			 T1w = ri[WS(ios, 56)];
			 T1y = ii[WS(ios, 56)];
			 T1z = FNMS(T1x, T1y, T1v * T1w);
			 T7s = FMA(T1x, T1w, T1v * T1y);
			 T1D = ri[WS(ios, 24)];
			 T1H = ii[WS(ios, 24)];
			 T1I = FNMS(T1G, T1H, T1C * T1D);
			 T7t = FMA(T1G, T1D, T1C * T1H);
		    }
		    T7r = T1z - T1I;
		    T7u = T7s - T7t;
		    {
			 E T1s, T1J, TdW, TdX;
			 T1s = T1g + T1r;
			 T1J = T1z + T1I;
			 T1K = T1s + T1J;
			 Tiw = T1J - T1s;
			 TdW = T7m + T7n;
			 TdX = T7s + T7t;
			 TdY = TdW - TdX;
			 ThY = TdW + TdX;
		    }
		    {
			 E T7q, T7v, TbK, TbL;
			 T7q = T7o - T7p;
			 T7v = T7r + T7u;
			 T7w = KP707106781 * (T7q - T7v);
			 Tj0 = KP707106781 * (T7q + T7v);
			 TbK = T7p + T7o;
			 TbL = T7r - T7u;
			 TbM = KP707106781 * (TbK + TbL);
			 Tjw = KP707106781 * (TbL - TbK);
		    }
	       }
	       {
		    E T1Y, Te0, T7A, T7D, T2d, Te1, T7B, T7G, T7C, T7H;
		    {
			 E T1O, T7y, T1X, T7z;
			 {
			      E T1M, T1N, T1S, T1W;
			      T1M = ri[WS(ios, 4)];
			      T1N = ii[WS(ios, 4)];
			      T1O = FMA(Ta, T1M, Tf * T1N);
			      T7y = FNMS(Tf, T1M, Ta * T1N);
			      T1S = ri[WS(ios, 36)];
			      T1W = ii[WS(ios, 36)];
			      T1X = FMA(T1R, T1S, T1V * T1W);
			      T7z = FNMS(T1V, T1S, T1R * T1W);
			 }
			 T1Y = T1O + T1X;
			 Te0 = T7y + T7z;
			 T7A = T7y - T7z;
			 T7D = T1O - T1X;
		    }
		    {
			 E T27, T7E, T2c, T7F;
			 {
			      E T22, T26, T29, T2b;
			      T22 = ri[WS(ios, 20)];
			      T26 = ii[WS(ios, 20)];
			      T27 = FNMS(T25, T26, T21 * T22);
			      T7E = FMA(T25, T22, T21 * T26);
			      T29 = ri[WS(ios, 52)];
			      T2b = ii[WS(ios, 52)];
			      T2c = FMA(T28, T29, T2a * T2b);
			      T7F = FNMS(T2a, T29, T28 * T2b);
			 }
			 T2d = T27 + T2c;
			 Te1 = T7E + T7F;
			 T7B = T27 - T2c;
			 T7G = T7E - T7F;
		    }
		    T2e = T1Y + T2d;
		    TgA = Te0 + Te1;
		    T7C = T7A + T7B;
		    T7H = T7D - T7G;
		    T7I = FNMS(KP923879532, T7H, KP382683432 * T7C);
		    TaY = FMA(KP923879532, T7C, KP382683432 * T7H);
		    {
			 E TbO, TbP, Te2, Te3;
			 TbO = T7A - T7B;
			 TbP = T7D + T7G;
			 TbQ = FNMS(KP382683432, TbP, KP923879532 * TbO);
			 Tda = FMA(KP382683432, TbO, KP923879532 * TbP);
			 Te2 = Te0 - Te1;
			 Te3 = T1Y - T2d;
			 Te4 = Te2 - Te3;
			 TfO = Te3 + Te2;
		    }
	       }
	       {
		    E T2t, Te6, T7L, T7O, T2I, Te7, T7M, T7R, T7N, T7S;
		    {
			 E T2j, T7J, T2s, T7K;
			 {
			      E T2g, T2i, T2n, T2r;
			      T2g = ri[WS(ios, 60)];
			      T2i = ii[WS(ios, 60)];
			      T2j = FNMS(T2h, T2i, T2f * T2g);
			      T7J = FMA(T2h, T2g, T2f * T2i);
			      T2n = ri[WS(ios, 28)];
			      T2r = ii[WS(ios, 28)];
			      T2s = FMA(T2m, T2n, T2q * T2r);
			      T7K = FNMS(T2q, T2n, T2m * T2r);
			 }
			 T2t = T2j + T2s;
			 Te6 = T7J + T7K;
			 T7L = T7J - T7K;
			 T7O = T2j - T2s;
		    }
		    {
			 E T2w, T7P, T2H, T7Q;
			 {
			      E T2u, T2v, T2E, T2G;
			      T2u = ri[WS(ios, 12)];
			      T2v = ii[WS(ios, 12)];
			      T2w = FMA(TQ, T2u, TU * T2v);
			      T7P = FNMS(TU, T2u, TQ * T2v);
			      T2E = ri[WS(ios, 44)];
			      T2G = ii[WS(ios, 44)];
			      T2H = FNMS(T2F, T2G, T2D * T2E);
			      T7Q = FMA(T2F, T2E, T2D * T2G);
			 }
			 T2I = T2w + T2H;
			 Te7 = T7P + T7Q;
			 T7M = T2w - T2H;
			 T7R = T7P - T7Q;
		    }
		    T2J = T2t + T2I;
		    TgB = Te6 + Te7;
		    T7N = T7L + T7M;
		    T7S = T7O - T7R;
		    T7T = FMA(KP382683432, T7N, KP923879532 * T7S);
		    TaZ = FNMS(KP923879532, T7N, KP382683432 * T7S);
		    {
			 E TbR, TbS, Te5, Te8;
			 TbR = T7L - T7M;
			 TbS = T7O + T7R;
			 TbT = FMA(KP923879532, TbR, KP382683432 * TbS);
			 Tdb = FNMS(KP382683432, TbR, KP923879532 * TbS);
			 Te5 = T2t - T2I;
			 Te8 = Te6 - Te7;
			 Te9 = Te5 + Te8;
			 TfP = Te5 - Te8;
		    }
	       }
	       {
		    E T2O, T7W, T2T, T7X, T2U, Tec, T2Z, T8e, T34, T8f, T35, Ted, T3p, Tei, T86;
		    E T89, T3A, Tej, T81, T84;
		    {
			 E T2M, T2N, T2Q, T2S;
			 T2M = ri[WS(ios, 2)];
			 T2N = ii[WS(ios, 2)];
			 T2O = FNMS(Ty, T2N, Tw * T2M);
			 T7W = FMA(Ty, T2M, Tw * T2N);
			 T2Q = ri[WS(ios, 34)];
			 T2S = ii[WS(ios, 34)];
			 T2T = FMA(T2P, T2Q, T2R * T2S);
			 T7X = FNMS(T2R, T2Q, T2P * T2S);
		    }
		    T2U = T2O + T2T;
		    Tec = T7W + T7X;
		    {
			 E T2W, T2Y, T31, T33;
			 T2W = ri[WS(ios, 18)];
			 T2Y = ii[WS(ios, 18)];
			 T2Z = FNMS(T2X, T2Y, T2V * T2W);
			 T8e = FMA(T2X, T2W, T2V * T2Y);
			 T31 = ri[WS(ios, 50)];
			 T33 = ii[WS(ios, 50)];
			 T34 = FNMS(T32, T33, T30 * T31);
			 T8f = FMA(T32, T31, T30 * T33);
		    }
		    T35 = T2Z + T34;
		    Ted = T8e + T8f;
		    {
			 E T3b, T87, T3o, T88;
			 {
			      E T38, T3a, T3l, T3n;
			      T38 = ri[WS(ios, 10)];
			      T3a = ii[WS(ios, 10)];
			      T3b = FMA(T37, T38, T39 * T3a);
			      T87 = FNMS(T39, T38, T37 * T3a);
			      T3l = ri[WS(ios, 42)];
			      T3n = ii[WS(ios, 42)];
			      T3o = FNMS(T3m, T3n, T3k * T3l);
			      T88 = FMA(T3m, T3l, T3k * T3n);
			 }
			 T3p = T3b + T3o;
			 Tei = T87 + T88;
			 T86 = T3b - T3o;
			 T89 = T87 - T88;
		    }
		    {
			 E T3u, T82, T3z, T83;
			 {
			      E T3r, T3t, T3w, T3y;
			      T3r = ri[WS(ios, 58)];
			      T3t = ii[WS(ios, 58)];
			      T3u = FMA(T3q, T3r, T3s * T3t);
			      T82 = FNMS(T3s, T3r, T3q * T3t);
			      T3w = ri[WS(ios, 26)];
			      T3y = ii[WS(ios, 26)];
			      T3z = FNMS(T3x, T3y, T3v * T3w);
			      T83 = FMA(T3x, T3w, T3v * T3y);
			 }
			 T3A = T3u + T3z;
			 Tej = T82 + T83;
			 T81 = T3u - T3z;
			 T84 = T82 - T83;
		    }
		    T36 = T2U + T35;
		    T3B = T3p + T3A;
		    TgH = T36 - T3B;
		    TgE = Tec + Ted;
		    TgF = Tei + Tej;
		    TgG = TgE - TgF;
		    {
			 E T7Y, T7Z, Teh, Tek;
			 T7Y = T7W - T7X;
			 T7Z = T2Z - T34;
			 T80 = T7Y + T7Z;
			 TbW = T7Y - T7Z;
			 Teh = T2U - T35;
			 Tek = Tei - Tej;
			 Tel = Teh - Tek;
			 TfT = Teh + Tek;
		    }
		    {
			 E T85, T8a, T8i, T8j;
			 T85 = T81 - T84;
			 T8a = T86 + T89;
			 T8b = KP707106781 * (T85 - T8a);
			 Tc0 = KP707106781 * (T8a + T85);
			 T8i = T89 - T86;
			 T8j = T81 + T84;
			 T8k = KP707106781 * (T8i - T8j);
			 TbX = KP707106781 * (T8i + T8j);
		    }
		    {
			 E Tee, Tef, T8d, T8g;
			 Tee = Tec - Ted;
			 Tef = T3A - T3p;
			 Teg = Tee - Tef;
			 TfS = Tee + Tef;
			 T8d = T2O - T2T;
			 T8g = T8e - T8f;
			 T8h = T8d - T8g;
			 TbZ = T8d + T8g;
		    }
	       }
	       {
		    E T3H, T8n, T3M, T8o, T3N, Ten, T3S, T8F, T43, T8G, T44, Teo, T4e, Tet, T8x;
		    E T8A, T4p, Teu, T8s, T8v;
		    {
			 E T3E, T3G, T3J, T3L;
			 T3E = ri[WS(ios, 62)];
			 T3G = ii[WS(ios, 62)];
			 T3H = FNMS(T3F, T3G, T3D * T3E);
			 T8n = FMA(T3F, T3E, T3D * T3G);
			 T3J = ri[WS(ios, 30)];
			 T3L = ii[WS(ios, 30)];
			 T3M = FMA(T3I, T3J, T3K * T3L);
			 T8o = FNMS(T3K, T3J, T3I * T3L);
		    }
		    T3N = T3H + T3M;
		    Ten = T8n + T8o;
		    {
			 E T3P, T3R, T40, T42;
			 T3P = ri[WS(ios, 14)];
			 T3R = ii[WS(ios, 14)];
			 T3S = FNMS(T3Q, T3R, T3O * T3P);
			 T8F = FMA(T3Q, T3P, T3O * T3R);
			 T40 = ri[WS(ios, 46)];
			 T42 = ii[WS(ios, 46)];
			 T43 = FMA(T3Z, T40, T41 * T42);
			 T8G = FNMS(T41, T40, T3Z * T42);
		    }
		    T44 = T3S + T43;
		    Teo = T8F + T8G;
		    {
			 E T48, T8y, T4d, T8z;
			 {
			      E T46, T47, T4a, T4c;
			      T46 = ri[WS(ios, 6)];
			      T47 = ii[WS(ios, 6)];
			      T48 = FNMS(T3e, T47, T3c * T46);
			      T8y = FMA(T3e, T46, T3c * T47);
			      T4a = ri[WS(ios, 38)];
			      T4c = ii[WS(ios, 38)];
			      T4d = FNMS(T4b, T4c, T49 * T4a);
			      T8z = FMA(T4b, T4a, T49 * T4c);
			 }
			 T4e = T48 + T4d;
			 Tet = T8y + T8z;
			 T8x = T48 - T4d;
			 T8A = T8y - T8z;
		    }
		    {
			 E T4j, T8t, T4o, T8u;
			 {
			      E T4g, T4i, T4l, T4n;
			      T4g = ri[WS(ios, 54)];
			      T4i = ii[WS(ios, 54)];
			      T4j = FNMS(T4h, T4i, T4f * T4g);
			      T8t = FMA(T4h, T4g, T4f * T4i);
			      T4l = ri[WS(ios, 22)];
			      T4n = ii[WS(ios, 22)];
			      T4o = FMA(T4k, T4l, T4m * T4n);
			      T8u = FNMS(T4m, T4l, T4k * T4n);
			 }
			 T4p = T4j + T4o;
			 Teu = T8t + T8u;
			 T8s = T4j - T4o;
			 T8v = T8t - T8u;
		    }
		    T45 = T3N + T44;
		    T4q = T4e + T4p;
		    TgJ = T45 - T4q;
		    TgK = Ten + Teo;
		    TgL = Tet + Teu;
		    TgM = TgK - TgL;
		    {
			 E T8p, T8q, Tes, Tev;
			 T8p = T8n - T8o;
			 T8q = T3S - T43;
			 T8r = T8p + T8q;
			 Tc6 = T8p - T8q;
			 Tes = T3N - T44;
			 Tev = Tet - Teu;
			 Tew = Tes - Tev;
			 TfW = Tes + Tev;
		    }
		    {
			 E T8w, T8B, T8J, T8K;
			 T8w = T8s - T8v;
			 T8B = T8x + T8A;
			 T8C = KP707106781 * (T8w - T8B);
			 Tc4 = KP707106781 * (T8B + T8w);
			 T8J = T8A - T8x;
			 T8K = T8s + T8v;
			 T8L = KP707106781 * (T8J - T8K);
			 Tc7 = KP707106781 * (T8J + T8K);
		    }
		    {
			 E Tep, Teq, T8E, T8H;
			 Tep = Ten - Teo;
			 Teq = T4p - T4e;
			 Ter = Tep - Teq;
			 TfV = Tep + Teq;
			 T8E = T3H - T3M;
			 T8H = T8F - T8G;
			 T8I = T8E - T8H;
			 Tc3 = T8E + T8H;
		    }
	       }
	       {
		    E T5V, Tao, T64, Tap, T65, Tfi, T68, T9K, T6d, T9L, T6e, Tfj, T6o, Tf2, T9Q;
		    E T9R, T6z, Tf3, T9T, T9W;
		    {
			 E T5T, T5U, T5Z, T63;
			 T5T = ri[WS(ios, 63)];
			 T5U = ii[WS(ios, 63)];
			 T5V = FMA(TN, T5T, TX * T5U);
			 Tao = FNMS(TX, T5T, TN * T5U);
			 T5Z = ri[WS(ios, 31)];
			 T63 = ii[WS(ios, 31)];
			 T64 = FMA(T5Y, T5Z, T62 * T63);
			 Tap = FNMS(T62, T5Z, T5Y * T63);
		    }
		    T65 = T5V + T64;
		    Tfi = Tao + Tap;
		    {
			 E T66, T67, T6a, T6c;
			 T66 = ri[WS(ios, 15)];
			 T67 = ii[WS(ios, 15)];
			 T68 = FNMS(T10, T67, TW * T66);
			 T9K = FMA(T10, T66, TW * T67);
			 T6a = ri[WS(ios, 47)];
			 T6c = ii[WS(ios, 47)];
			 T6d = FNMS(T6b, T6c, T69 * T6a);
			 T9L = FMA(T6b, T6a, T69 * T6c);
		    }
		    T6e = T68 + T6d;
		    Tfj = T9K + T9L;
		    {
			 E T6i, T9O, T6n, T9P;
			 {
			      E T6g, T6h, T6k, T6m;
			      T6g = ri[WS(ios, 7)];
			      T6h = ii[WS(ios, 7)];
			      T6i = FMA(T1t, T6g, T1u * T6h);
			      T9O = FNMS(T1u, T6g, T1t * T6h);
			      T6k = ri[WS(ios, 39)];
			      T6m = ii[WS(ios, 39)];
			      T6n = FMA(T6j, T6k, T6l * T6m);
			      T9P = FNMS(T6l, T6k, T6j * T6m);
			 }
			 T6o = T6i + T6n;
			 Tf2 = T9O + T9P;
			 T9Q = T9O - T9P;
			 T9R = T6i - T6n;
		    }
		    {
			 E T6t, T9U, T6y, T9V;
			 {
			      E T6q, T6s, T6v, T6x;
			      T6q = ri[WS(ios, 55)];
			      T6s = ii[WS(ios, 55)];
			      T6t = FMA(T6p, T6q, T6r * T6s);
			      T9U = FNMS(T6r, T6q, T6p * T6s);
			      T6v = ri[WS(ios, 23)];
			      T6x = ii[WS(ios, 23)];
			      T6y = FNMS(T6w, T6x, T6u * T6v);
			      T9V = FMA(T6w, T6v, T6u * T6x);
			 }
			 T6z = T6t + T6y;
			 Tf3 = T9U + T9V;
			 T9T = T6t - T6y;
			 T9W = T9U - T9V;
		    }
		    {
			 E T6f, T6A, Tfk, Tfl;
			 T6f = T65 + T6e;
			 T6A = T6o + T6z;
			 T6B = T6f + T6A;
			 Th1 = T6f - T6A;
			 Tfk = Tfi - Tfj;
			 Tfl = T6z - T6o;
			 Tfm = Tfk - Tfl;
			 Tga = Tfk + Tfl;
		    }
		    {
			 E Th6, Th7, T9J, T9M;
			 Th6 = Tfi + Tfj;
			 Th7 = Tf2 + Tf3;
			 Th8 = Th6 - Th7;
			 ThI = Th6 + Th7;
			 T9J = T5V - T64;
			 T9M = T9K - T9L;
			 T9N = T9J - T9M;
			 Tcv = T9J + T9M;
		    }
		    {
			 E T9S, T9X, Tat, Tau;
			 T9S = T9Q - T9R;
			 T9X = T9T + T9W;
			 T9Y = KP707106781 * (T9S - T9X);
			 TcH = KP707106781 * (T9S + T9X);
			 Tat = T9T - T9W;
			 Tau = T9R + T9Q;
			 Tav = KP707106781 * (Tat - Tau);
			 Tcw = KP707106781 * (Tau + Tat);
		    }
		    {
			 E Tf1, Tf4, Taq, Tar;
			 Tf1 = T65 - T6e;
			 Tf4 = Tf2 - Tf3;
			 Tf5 = Tf1 - Tf4;
			 Tg7 = Tf1 + Tf4;
			 Taq = Tao - Tap;
			 Tar = T68 - T6d;
			 Tas = Taq + Tar;
			 TcG = Taq - Tar;
		    }
	       }
	       {
		    E T4w, T8Q, T4B, T8R, T4C, TeA, T4F, T9w, T4K, T9x, T4L, TeB, T4V, TeS, T90;
		    E T93, T5a, TeT, T8V, T8Y;
		    {
			 E T4u, T4v, T4y, T4A;
			 T4u = ri[WS(ios, 1)];
			 T4v = ii[WS(ios, 1)];
			 T4w = FMA(T5, T4u, T8 * T4v);
			 T8Q = FNMS(T8, T4u, T5 * T4v);
			 T4y = ri[WS(ios, 33)];
			 T4A = ii[WS(ios, 33)];
			 T4B = FNMS(T4z, T4A, T4x * T4y);
			 T8R = FMA(T4z, T4y, T4x * T4A);
		    }
		    T4C = T4w + T4B;
		    TeA = T8Q + T8R;
		    {
			 E T4D, T4E, T4H, T4J;
			 T4D = ri[WS(ios, 17)];
			 T4E = ii[WS(ios, 17)];
			 T4F = FNMS(T3Y, T4E, T3V * T4D);
			 T9w = FMA(T3Y, T4D, T3V * T4E);
			 T4H = ri[WS(ios, 49)];
			 T4J = ii[WS(ios, 49)];
			 T4K = FMA(T4G, T4H, T4I * T4J);
			 T9x = FNMS(T4I, T4H, T4G * T4J);
		    }
		    T4L = T4F + T4K;
		    TeB = T9w + T9x;
		    {
			 E T4P, T91, T4U, T92;
			 {
			      E T4N, T4O, T4R, T4T;
			      T4N = ri[WS(ios, 9)];
			      T4O = ii[WS(ios, 9)];
			      T4P = FMA(T3, T4N, Tc * T4O);
			      T91 = FNMS(Tc, T4N, T3 * T4O);
			      T4R = ri[WS(ios, 41)];
			      T4T = ii[WS(ios, 41)];
			      T4U = FNMS(T4S, T4T, T4Q * T4R);
			      T92 = FMA(T4S, T4R, T4Q * T4T);
			 }
			 T4V = T4P + T4U;
			 TeS = T91 + T92;
			 T90 = T4P - T4U;
			 T93 = T91 - T92;
		    }
		    {
			 E T50, T8W, T59, T8X;
			 {
			      E T4X, T4Z, T54, T58;
			      T4X = ri[WS(ios, 57)];
			      T4Z = ii[WS(ios, 57)];
			      T50 = FMA(T4W, T4X, T4Y * T4Z);
			      T8W = FNMS(T4Y, T4X, T4W * T4Z);
			      T54 = ri[WS(ios, 25)];
			      T58 = ii[WS(ios, 25)];
			      T59 = FMA(T53, T54, T57 * T58);
			      T8X = FNMS(T57, T54, T53 * T58);
			 }
			 T5a = T50 + T59;
			 TeT = T8W + T8X;
			 T8V = T50 - T59;
			 T8Y = T8W - T8X;
		    }
		    {
			 E T4M, T5b, TeR, TeU;
			 T4M = T4C + T4L;
			 T5b = T4V + T5a;
			 T5c = T4M + T5b;
			 TgV = T4M - T5b;
			 TeR = T4C - T4L;
			 TeU = TeS - TeT;
			 TeV = TeR - TeU;
			 Tg0 = TeR + TeU;
		    }
		    {
			 E TgQ, TgR, T8S, T8T;
			 TgQ = TeA + TeB;
			 TgR = TeS + TeT;
			 TgS = TgQ - TgR;
			 ThD = TgQ + TgR;
			 T8S = T8Q - T8R;
			 T8T = T4F - T4K;
			 T8U = T8S + T8T;
			 Tcc = T8S - T8T;
		    }
		    {
			 E T8Z, T94, T9A, T9B;
			 T8Z = T8V - T8Y;
			 T94 = T90 + T93;
			 T95 = KP707106781 * (T8Z - T94);
			 Tco = KP707106781 * (T94 + T8Z);
			 T9A = T93 - T90;
			 T9B = T8V + T8Y;
			 T9C = KP707106781 * (T9A - T9B);
			 Tcd = KP707106781 * (T9A + T9B);
		    }
		    {
			 E TeC, TeD, T9v, T9y;
			 TeC = TeA - TeB;
			 TeD = T5a - T4V;
			 TeE = TeC - TeD;
			 Tg3 = TeC + TeD;
			 T9v = T4w - T4B;
			 T9y = T9w - T9x;
			 T9z = T9v - T9y;
			 Tcn = T9v + T9y;
		    }
	       }
	       {
		    E T5l, TeL, T9k, T9n, T5P, TeH, T9a, T9f, T5u, TeM, T9l, T9q, T5G, TeG, T97;
		    E T9e;
		    {
			 E T5f, T9i, T5k, T9j;
			 {
			      E T5d, T5e, T5h, T5j;
			      T5d = ri[WS(ios, 5)];
			      T5e = ii[WS(ios, 5)];
			      T5f = FNMS(Tm, T5e, Th * T5d);
			      T9i = FMA(Tm, T5d, Th * T5e);
			      T5h = ri[WS(ios, 37)];
			      T5j = ii[WS(ios, 37)];
			      T5k = FMA(T5g, T5h, T5i * T5j);
			      T9j = FNMS(T5i, T5h, T5g * T5j);
			 }
			 T5l = T5f + T5k;
			 TeL = T9i + T9j;
			 T9k = T9i - T9j;
			 T9n = T5f - T5k;
		    }
		    {
			 E T5J, T98, T5O, T99;
			 {
			      E T5H, T5I, T5L, T5N;
			      T5H = ri[WS(ios, 13)];
			      T5I = ii[WS(ios, 13)];
			      T5J = FMA(T1h, T5H, T1j * T5I);
			      T98 = FNMS(T1j, T5H, T1h * T5I);
			      T5L = ri[WS(ios, 45)];
			      T5N = ii[WS(ios, 45)];
			      T5O = FMA(T5K, T5L, T5M * T5N);
			      T99 = FNMS(T5M, T5L, T5K * T5N);
			 }
			 T5P = T5J + T5O;
			 TeH = T98 + T99;
			 T9a = T98 - T99;
			 T9f = T5J - T5O;
		    }
		    {
			 E T5o, T9o, T5t, T9p;
			 {
			      E T5m, T5n, T5q, T5s;
			      T5m = ri[WS(ios, 21)];
			      T5n = ii[WS(ios, 21)];
			      T5o = FMA(T3g, T5m, T3j * T5n);
			      T9o = FNMS(T3j, T5m, T3g * T5n);
			      T5q = ri[WS(ios, 53)];
			      T5s = ii[WS(ios, 53)];
			      T5t = FNMS(T5r, T5s, T5p * T5q);
			      T9p = FMA(T5r, T5q, T5p * T5s);
			 }
			 T5u = T5o + T5t;
			 TeM = T9o + T9p;
			 T9l = T5o - T5t;
			 T9q = T9o - T9p;
		    }
		    {
			 E T5A, T9c, T5F, T9d;
			 {
			      E T5x, T5z, T5C, T5E;
			      T5x = ri[WS(ios, 61)];
			      T5z = ii[WS(ios, 61)];
			      T5A = FMA(T5w, T5x, T5y * T5z);
			      T9c = FNMS(T5y, T5x, T5w * T5z);
			      T5C = ri[WS(ios, 29)];
			      T5E = ii[WS(ios, 29)];
			      T5F = FNMS(T5D, T5E, T5B * T5C);
			      T9d = FMA(T5D, T5C, T5B * T5E);
			 }
			 T5G = T5A + T5F;
			 TeG = T9c + T9d;
			 T97 = T5A - T5F;
			 T9e = T9c - T9d;
		    }
		    {
			 E T5v, T5Q, TeK, TeN;
			 T5v = T5l + T5u;
			 T5Q = T5G + T5P;
			 T5R = T5v + T5Q;
			 TgT = T5Q - T5v;
			 TeK = T5l - T5u;
			 TeN = TeL - TeM;
			 TeO = TeK + TeN;
			 TeW = TeN - TeK;
		    }
		    {
			 E TgW, TgX, T9b, T9g;
			 TgW = TeL + TeM;
			 TgX = TeG + TeH;
			 TgY = TgW - TgX;
			 ThE = TgW + TgX;
			 T9b = T97 - T9a;
			 T9g = T9e + T9f;
			 T9h = FNMS(KP923879532, T9g, KP382683432 * T9b);
			 T9F = FMA(KP382683432, T9g, KP923879532 * T9b);
		    }
		    {
			 E T9m, T9r, Tci, Tcj;
			 T9m = T9k + T9l;
			 T9r = T9n - T9q;
			 T9s = FMA(KP923879532, T9m, KP382683432 * T9r);
			 T9E = FNMS(KP923879532, T9r, KP382683432 * T9m);
			 Tci = T9k - T9l;
			 Tcj = T9n + T9q;
			 Tck = FMA(KP382683432, Tci, KP923879532 * Tcj);
			 Tcq = FNMS(KP382683432, Tcj, KP923879532 * Tci);
		    }
		    {
			 E TeF, TeI, Tcf, Tcg;
			 TeF = T5G - T5P;
			 TeI = TeG - TeH;
			 TeJ = TeF - TeI;
			 TeX = TeF + TeI;
			 Tcf = T97 + T9a;
			 Tcg = T9e - T9f;
			 Tch = FNMS(KP382683432, Tcg, KP923879532 * Tcf);
			 Tcr = FMA(KP923879532, Tcg, KP382683432 * Tcf);
		    }
	       }
	       {
		    E T6K, Tf6, Ta2, Ta5, T7c, Tfd, Tae, Taj, T6T, Tf7, Ta3, Ta8, T73, Tfc, Tad;
		    E Tag;
		    {
			 E T6E, Ta0, T6J, Ta1;
			 {
			      E T6C, T6D, T6G, T6I;
			      T6C = ri[WS(ios, 3)];
			      T6D = ii[WS(ios, 3)];
			      T6E = FMA(T4, T6C, T7 * T6D);
			      Ta0 = FNMS(T7, T6C, T4 * T6D);
			      T6G = ri[WS(ios, 35)];
			      T6I = ii[WS(ios, 35)];
			      T6J = FNMS(T6H, T6I, T6F * T6G);
			      Ta1 = FMA(T6H, T6G, T6F * T6I);
			 }
			 T6K = T6E + T6J;
			 Tf6 = Ta0 + Ta1;
			 Ta2 = Ta0 - Ta1;
			 Ta5 = T6E - T6J;
		    }
		    {
			 E T76, Tah, T7b, Tai;
			 {
			      E T74, T75, T78, T7a;
			      T74 = ri[WS(ios, 11)];
			      T75 = ii[WS(ios, 11)];
			      T76 = FNMS(TE, T75, TA * T74);
			      Tah = FMA(TE, T74, TA * T75);
			      T78 = ri[WS(ios, 43)];
			      T7a = ii[WS(ios, 43)];
			      T7b = FMA(T77, T78, T79 * T7a);
			      Tai = FNMS(T79, T78, T77 * T7a);
			 }
			 T7c = T76 + T7b;
			 Tfd = Tah + Tai;
			 Tae = T76 - T7b;
			 Taj = Tah - Tai;
		    }
		    {
			 E T6N, Ta6, T6S, Ta7;
			 {
			      E T6L, T6M, T6P, T6R;
			      T6L = ri[WS(ios, 19)];
			      T6M = ii[WS(ios, 19)];
			      T6N = FMA(T2z, T6L, T2C * T6M);
			      Ta6 = FNMS(T2C, T6L, T2z * T6M);
			      T6P = ri[WS(ios, 51)];
			      T6R = ii[WS(ios, 51)];
			      T6S = FNMS(T6Q, T6R, T6O * T6P);
			      Ta7 = FMA(T6Q, T6P, T6O * T6R);
			 }
			 T6T = T6N + T6S;
			 Tf7 = Ta6 + Ta7;
			 Ta3 = T6N - T6S;
			 Ta8 = Ta6 - Ta7;
		    }
		    {
			 E T6Z, Tab, T72, Tac;
			 {
			      E T6W, T6Y, T70, T71;
			      T6W = ri[WS(ios, 59)];
			      T6Y = ii[WS(ios, 59)];
			      T6Z = FNMS(T6X, T6Y, T6V * T6W);
			      Tab = FMA(T6X, T6W, T6V * T6Y);
			      T70 = ri[WS(ios, 27)];
			      T71 = ii[WS(ios, 27)];
			      T72 = FMA(T2, T70, Tj * T71);
			      Tac = FNMS(Tj, T70, T2 * T71);
			 }
			 T73 = T6Z + T72;
			 Tfc = Tab + Tac;
			 Tad = Tab - Tac;
			 Tag = T6Z - T72;
		    }
		    {
			 E T6U, T7d, Tfb, Tfe;
			 T6U = T6K + T6T;
			 T7d = T73 + T7c;
			 T7e = T6U + T7d;
			 Th9 = T7d - T6U;
			 Tfb = T73 - T7c;
			 Tfe = Tfc - Tfd;
			 Tff = Tfb + Tfe;
			 Tfn = Tfb - Tfe;
		    }
		    {
			 E Th2, Th3, Ta4, Ta9;
			 Th2 = Tf6 + Tf7;
			 Th3 = Tfc + Tfd;
			 Th4 = Th2 - Th3;
			 ThJ = Th2 + Th3;
			 Ta4 = Ta2 + Ta3;
			 Ta9 = Ta5 - Ta8;
			 Taa = FNMS(KP923879532, Ta9, KP382683432 * Ta4);
			 Tay = FMA(KP923879532, Ta4, KP382683432 * Ta9);
		    }
		    {
			 E Taf, Tak, TcB, TcC;
			 Taf = Tad + Tae;
			 Tak = Tag - Taj;
			 Tal = FMA(KP382683432, Taf, KP923879532 * Tak);
			 Tax = FNMS(KP923879532, Taf, KP382683432 * Tak);
			 TcB = Tad - Tae;
			 TcC = Tag + Taj;
			 TcD = FMA(KP923879532, TcB, KP382683432 * TcC);
			 TcJ = FNMS(KP382683432, TcB, KP923879532 * TcC);
		    }
		    {
			 E Tf8, Tf9, Tcy, Tcz;
			 Tf8 = Tf6 - Tf7;
			 Tf9 = T6K - T6T;
			 Tfa = Tf8 - Tf9;
			 Tfo = Tf9 + Tf8;
			 Tcy = Ta2 - Ta3;
			 Tcz = Ta5 + Ta8;
			 TcA = FNMS(KP382683432, Tcz, KP923879532 * Tcy);
			 TcK = FMA(KP382683432, Tcy, KP923879532 * Tcz);
		    }
	       }
	       {
		    E T2L, Thx, ThU, ThV, Ti5, Tib, T4s, Tia, T7g, Ti7, ThG, ThO, ThL, ThP, ThA;
		    E ThW;
		    {
			 E T1L, T2K, ThS, ThT;
			 T1L = T17 + T1K;
			 T2K = T2e + T2J;
			 T2L = T1L + T2K;
			 Thx = T1L - T2K;
			 ThS = ThD + ThE;
			 ThT = ThI + ThJ;
			 ThU = ThS - ThT;
			 ThV = ThS + ThT;
		    }
		    {
			 E ThX, Ti4, T3C, T4r;
			 ThX = TgA + TgB;
			 Ti4 = ThY + Ti3;
			 Ti5 = ThX + Ti4;
			 Tib = Ti4 - ThX;
			 T3C = T36 + T3B;
			 T4r = T45 + T4q;
			 T4s = T3C + T4r;
			 Tia = T4r - T3C;
		    }
		    {
			 E T5S, T7f, ThC, ThF;
			 T5S = T5c + T5R;
			 T7f = T6B + T7e;
			 T7g = T5S + T7f;
			 Ti7 = T7f - T5S;
			 ThC = T5c - T5R;
			 ThF = ThD - ThE;
			 ThG = ThC + ThF;
			 ThO = ThF - ThC;
		    }
		    {
			 E ThH, ThK, Thy, Thz;
			 ThH = T6B - T7e;
			 ThK = ThI - ThJ;
			 ThL = ThH - ThK;
			 ThP = ThH + ThK;
			 Thy = TgE + TgF;
			 Thz = TgK + TgL;
			 ThA = Thy - Thz;
			 ThW = Thy + Thz;
		    }
		    {
			 E T4t, Ti6, ThR, Ti8;
			 T4t = T2L + T4s;
			 ri[WS(ios, 32)] = T4t - T7g;
			 ri[0] = T4t + T7g;
			 Ti6 = ThW + Ti5;
			 ii[0] = ThV + Ti6;
			 ii[WS(ios, 32)] = Ti6 - ThV;
			 ThR = T2L - T4s;
			 ri[WS(ios, 48)] = ThR - ThU;
			 ri[WS(ios, 16)] = ThR + ThU;
			 Ti8 = Ti5 - ThW;
			 ii[WS(ios, 16)] = Ti7 + Ti8;
			 ii[WS(ios, 48)] = Ti8 - Ti7;
		    }
		    {
			 E ThB, ThM, Ti9, Tic;
			 ThB = Thx + ThA;
			 ThM = KP707106781 * (ThG + ThL);
			 ri[WS(ios, 40)] = ThB - ThM;
			 ri[WS(ios, 8)] = ThB + ThM;
			 Ti9 = KP707106781 * (ThO + ThP);
			 Tic = Tia + Tib;
			 ii[WS(ios, 8)] = Ti9 + Tic;
			 ii[WS(ios, 40)] = Tic - Ti9;
		    }
		    {
			 E ThN, ThQ, Tid, Tie;
			 ThN = Thx - ThA;
			 ThQ = KP707106781 * (ThO - ThP);
			 ri[WS(ios, 56)] = ThN - ThQ;
			 ri[WS(ios, 24)] = ThN + ThQ;
			 Tid = KP707106781 * (ThL - ThG);
			 Tie = Tib - Tia;
			 ii[WS(ios, 24)] = Tid + Tie;
			 ii[WS(ios, 56)] = Tie - Tid;
		    }
	       }
	       {
		    E TgD, Thh, Thr, Thv, Tij, Tip, TgO, Tig, Th0, The, Thk, Tio, Tho, Thu, Thb;
		    E Thf;
		    {
			 E Tgz, TgC, Thp, Thq;
			 Tgz = T17 - T1K;
			 TgC = TgA - TgB;
			 TgD = Tgz - TgC;
			 Thh = Tgz + TgC;
			 Thp = Th1 + Th4;
			 Thq = Th8 + Th9;
			 Thr = FNMS(KP382683432, Thq, KP923879532 * Thp);
			 Thv = FMA(KP923879532, Thq, KP382683432 * Thp);
		    }
		    {
			 E Tih, Tii, TgI, TgN;
			 Tih = T2J - T2e;
			 Tii = Ti3 - ThY;
			 Tij = Tih + Tii;
			 Tip = Tii - Tih;
			 TgI = TgG - TgH;
			 TgN = TgJ + TgM;
			 TgO = KP707106781 * (TgI - TgN);
			 Tig = KP707106781 * (TgI + TgN);
		    }
		    {
			 E TgU, TgZ, Thi, Thj;
			 TgU = TgS - TgT;
			 TgZ = TgV - TgY;
			 Th0 = FMA(KP923879532, TgU, KP382683432 * TgZ);
			 The = FNMS(KP923879532, TgZ, KP382683432 * TgU);
			 Thi = TgH + TgG;
			 Thj = TgJ - TgM;
			 Thk = KP707106781 * (Thi + Thj);
			 Tio = KP707106781 * (Thj - Thi);
		    }
		    {
			 E Thm, Thn, Th5, Tha;
			 Thm = TgS + TgT;
			 Thn = TgV + TgY;
			 Tho = FMA(KP382683432, Thm, KP923879532 * Thn);
			 Thu = FNMS(KP382683432, Thn, KP923879532 * Thm);
			 Th5 = Th1 - Th4;
			 Tha = Th8 - Th9;
			 Thb = FNMS(KP923879532, Tha, KP382683432 * Th5);
			 Thf = FMA(KP382683432, Tha, KP923879532 * Th5);
		    }
		    {
			 E TgP, Thc, Tin, Tiq;
			 TgP = TgD + TgO;
			 Thc = Th0 + Thb;
			 ri[WS(ios, 44)] = TgP - Thc;
			 ri[WS(ios, 12)] = TgP + Thc;
			 Tin = The + Thf;
			 Tiq = Tio + Tip;
			 ii[WS(ios, 12)] = Tin + Tiq;
			 ii[WS(ios, 44)] = Tiq - Tin;
		    }
		    {
			 E Thd, Thg, Tir, Tis;
			 Thd = TgD - TgO;
			 Thg = The - Thf;
			 ri[WS(ios, 60)] = Thd - Thg;
			 ri[WS(ios, 28)] = Thd + Thg;
			 Tir = Thb - Th0;
			 Tis = Tip - Tio;
			 ii[WS(ios, 28)] = Tir + Tis;
			 ii[WS(ios, 60)] = Tis - Tir;
		    }
		    {
			 E Thl, Ths, Tif, Tik;
			 Thl = Thh + Thk;
			 Ths = Tho + Thr;
			 ri[WS(ios, 36)] = Thl - Ths;
			 ri[WS(ios, 4)] = Thl + Ths;
			 Tif = Thu + Thv;
			 Tik = Tig + Tij;
			 ii[WS(ios, 4)] = Tif + Tik;
			 ii[WS(ios, 36)] = Tik - Tif;
		    }
		    {
			 E Tht, Thw, Til, Tim;
			 Tht = Thh - Thk;
			 Thw = Thu - Thv;
			 ri[WS(ios, 52)] = Tht - Thw;
			 ri[WS(ios, 20)] = Tht + Thw;
			 Til = Thr - Tho;
			 Tim = Tij - Tig;
			 ii[WS(ios, 20)] = Til + Tim;
			 ii[WS(ios, 52)] = Tim - Til;
		    }
	       }
	       {
		    E Teb, Tfx, Tey, TiK, TiN, TiT, TfA, TiS, Tfr, TfL, Tfv, TfH, Tf0, TfK, Tfu;
		    E TfE;
		    {
			 E TdZ, Tea, Tfy, Tfz;
			 TdZ = TdV - TdY;
			 Tea = KP707106781 * (Te4 - Te9);
			 Teb = TdZ - Tea;
			 Tfx = TdZ + Tea;
			 {
			      E Tem, Tex, TiL, TiM;
			      Tem = FNMS(KP923879532, Tel, KP382683432 * Teg);
			      Tex = FMA(KP382683432, Ter, KP923879532 * Tew);
			      Tey = Tem - Tex;
			      TiK = Tem + Tex;
			      TiL = KP707106781 * (TfP - TfO);
			      TiM = Tix - Tiw;
			      TiN = TiL + TiM;
			      TiT = TiM - TiL;
			 }
			 Tfy = FMA(KP923879532, Teg, KP382683432 * Tel);
			 Tfz = FNMS(KP923879532, Ter, KP382683432 * Tew);
			 TfA = Tfy + Tfz;
			 TiS = Tfz - Tfy;
			 {
			      E Tfh, TfF, Tfq, TfG, Tfg, Tfp;
			      Tfg = KP707106781 * (Tfa - Tff);
			      Tfh = Tf5 - Tfg;
			      TfF = Tf5 + Tfg;
			      Tfp = KP707106781 * (Tfn - Tfo);
			      Tfq = Tfm - Tfp;
			      TfG = Tfm + Tfp;
			      Tfr = FNMS(KP980785280, Tfq, KP195090322 * Tfh);
			      TfL = FMA(KP831469612, TfG, KP555570233 * TfF);
			      Tfv = FMA(KP195090322, Tfq, KP980785280 * Tfh);
			      TfH = FNMS(KP555570233, TfG, KP831469612 * TfF);
			 }
			 {
			      E TeQ, TfC, TeZ, TfD, TeP, TeY;
			      TeP = KP707106781 * (TeJ - TeO);
			      TeQ = TeE - TeP;
			      TfC = TeE + TeP;
			      TeY = KP707106781 * (TeW - TeX);
			      TeZ = TeV - TeY;
			      TfD = TeV + TeY;
			      Tf0 = FMA(KP980785280, TeQ, KP195090322 * TeZ);
			      TfK = FNMS(KP555570233, TfD, KP831469612 * TfC);
			      Tfu = FNMS(KP980785280, TeZ, KP195090322 * TeQ);
			      TfE = FMA(KP555570233, TfC, KP831469612 * TfD);
			 }
		    }
		    {
			 E Tez, Tfs, TiR, TiU;
			 Tez = Teb + Tey;
			 Tfs = Tf0 + Tfr;
			 ri[WS(ios, 46)] = Tez - Tfs;
			 ri[WS(ios, 14)] = Tez + Tfs;
			 TiR = Tfu + Tfv;
			 TiU = TiS + TiT;
			 ii[WS(ios, 14)] = TiR + TiU;
			 ii[WS(ios, 46)] = TiU - TiR;
		    }
		    {
			 E Tft, Tfw, TiV, TiW;
			 Tft = Teb - Tey;
			 Tfw = Tfu - Tfv;
			 ri[WS(ios, 62)] = Tft - Tfw;
			 ri[WS(ios, 30)] = Tft + Tfw;
			 TiV = Tfr - Tf0;
			 TiW = TiT - TiS;
			 ii[WS(ios, 30)] = TiV + TiW;
			 ii[WS(ios, 62)] = TiW - TiV;
		    }
		    {
			 E TfB, TfI, TiJ, TiO;
			 TfB = Tfx + TfA;
			 TfI = TfE + TfH;
			 ri[WS(ios, 38)] = TfB - TfI;
			 ri[WS(ios, 6)] = TfB + TfI;
			 TiJ = TfK + TfL;
			 TiO = TiK + TiN;
			 ii[WS(ios, 6)] = TiJ + TiO;
			 ii[WS(ios, 38)] = TiO - TiJ;
		    }
		    {
			 E TfJ, TfM, TiP, TiQ;
			 TfJ = Tfx - TfA;
			 TfM = TfK - TfL;
			 ri[WS(ios, 54)] = TfJ - TfM;
			 ri[WS(ios, 22)] = TfJ + TfM;
			 TiP = TfH - TfE;
			 TiQ = TiN - TiK;
			 ii[WS(ios, 22)] = TiP + TiQ;
			 ii[WS(ios, 54)] = TiQ - TiP;
		    }
	       }
	       {
		    E TfR, Tgj, TfY, Tiu, Tiz, TiF, Tgm, TiE, Tgd, Tgx, Tgh, Tgt, Tg6, Tgw, Tgg;
		    E Tgq;
		    {
			 E TfN, TfQ, Tgk, Tgl;
			 TfN = TdV + TdY;
			 TfQ = KP707106781 * (TfO + TfP);
			 TfR = TfN - TfQ;
			 Tgj = TfN + TfQ;
			 {
			      E TfU, TfX, Tiv, Tiy;
			      TfU = FNMS(KP382683432, TfT, KP923879532 * TfS);
			      TfX = FMA(KP923879532, TfV, KP382683432 * TfW);
			      TfY = TfU - TfX;
			      Tiu = TfU + TfX;
			      Tiv = KP707106781 * (Te4 + Te9);
			      Tiy = Tiw + Tix;
			      Tiz = Tiv + Tiy;
			      TiF = Tiy - Tiv;
			 }
			 Tgk = FMA(KP382683432, TfS, KP923879532 * TfT);
			 Tgl = FNMS(KP382683432, TfV, KP923879532 * TfW);
			 Tgm = Tgk + Tgl;
			 TiE = Tgl - Tgk;
			 {
			      E Tg9, Tgr, Tgc, Tgs, Tg8, Tgb;
			      Tg8 = KP707106781 * (Tfo + Tfn);
			      Tg9 = Tg7 - Tg8;
			      Tgr = Tg7 + Tg8;
			      Tgb = KP707106781 * (Tfa + Tff);
			      Tgc = Tga - Tgb;
			      Tgs = Tga + Tgb;
			      Tgd = FNMS(KP831469612, Tgc, KP555570233 * Tg9);
			      Tgx = FMA(KP195090322, Tgr, KP980785280 * Tgs);
			      Tgh = FMA(KP831469612, Tg9, KP555570233 * Tgc);
			      Tgt = FNMS(KP195090322, Tgs, KP980785280 * Tgr);
			 }
			 {
			      E Tg2, Tgo, Tg5, Tgp, Tg1, Tg4;
			      Tg1 = KP707106781 * (TeO + TeJ);
			      Tg2 = Tg0 - Tg1;
			      Tgo = Tg0 + Tg1;
			      Tg4 = KP707106781 * (TeW + TeX);
			      Tg5 = Tg3 - Tg4;
			      Tgp = Tg3 + Tg4;
			      Tg6 = FMA(KP555570233, Tg2, KP831469612 * Tg5);
			      Tgw = FNMS(KP195090322, Tgo, KP980785280 * Tgp);
			      Tgg = FNMS(KP831469612, Tg2, KP555570233 * Tg5);
			      Tgq = FMA(KP980785280, Tgo, KP195090322 * Tgp);
			 }
		    }
		    {
			 E TfZ, Tge, TiD, TiG;
			 TfZ = TfR + TfY;
			 Tge = Tg6 + Tgd;
			 ri[WS(ios, 42)] = TfZ - Tge;
			 ri[WS(ios, 10)] = TfZ + Tge;
			 TiD = Tgg + Tgh;
			 TiG = TiE + TiF;
			 ii[WS(ios, 10)] = TiD + TiG;
			 ii[WS(ios, 42)] = TiG - TiD;
		    }
		    {
			 E Tgf, Tgi, TiH, TiI;
			 Tgf = TfR - TfY;
			 Tgi = Tgg - Tgh;
			 ri[WS(ios, 58)] = Tgf - Tgi;
			 ri[WS(ios, 26)] = Tgf + Tgi;
			 TiH = Tgd - Tg6;
			 TiI = TiF - TiE;
			 ii[WS(ios, 26)] = TiH + TiI;
			 ii[WS(ios, 58)] = TiI - TiH;
		    }
		    {
			 E Tgn, Tgu, Tit, TiA;
			 Tgn = Tgj + Tgm;
			 Tgu = Tgq + Tgt;
			 ri[WS(ios, 34)] = Tgn - Tgu;
			 ri[WS(ios, 2)] = Tgn + Tgu;
			 Tit = Tgw + Tgx;
			 TiA = Tiu + Tiz;
			 ii[WS(ios, 2)] = Tit + TiA;
			 ii[WS(ios, 34)] = TiA - Tit;
		    }
		    {
			 E Tgv, Tgy, TiB, TiC;
			 Tgv = Tgj - Tgm;
			 Tgy = Tgw - Tgx;
			 ri[WS(ios, 50)] = Tgv - Tgy;
			 ri[WS(ios, 18)] = Tgv + Tgy;
			 TiB = Tgt - Tgq;
			 TiC = Tiz - Tiu;
			 ii[WS(ios, 18)] = TiB + TiC;
			 ii[WS(ios, 50)] = TiC - TiB;
		    }
	       }
	       {
		    E T7V, TaH, TjN, TjT, T8O, TjS, TaK, TjK, T9I, TaU, TaE, TaO, TaB, TaV, TaF;
		    E TaR;
		    {
			 E T7x, T7U, TjL, TjM;
			 T7x = T7l - T7w;
			 T7U = T7I - T7T;
			 T7V = T7x - T7U;
			 TaH = T7x + T7U;
			 TjL = TaZ - TaY;
			 TjM = Tjx - Tjw;
			 TjN = TjL + TjM;
			 TjT = TjM - TjL;
		    }
		    {
			 E T8m, TaI, T8N, TaJ;
			 {
			      E T8c, T8l, T8D, T8M;
			      T8c = T80 - T8b;
			      T8l = T8h - T8k;
			      T8m = FNMS(KP980785280, T8l, KP195090322 * T8c);
			      TaI = FMA(KP980785280, T8c, KP195090322 * T8l);
			      T8D = T8r - T8C;
			      T8M = T8I - T8L;
			      T8N = FMA(KP195090322, T8D, KP980785280 * T8M);
			      TaJ = FNMS(KP980785280, T8D, KP195090322 * T8M);
			 }
			 T8O = T8m - T8N;
			 TjS = TaJ - TaI;
			 TaK = TaI + TaJ;
			 TjK = T8m + T8N;
		    }
		    {
			 E T9u, TaM, T9H, TaN;
			 {
			      E T96, T9t, T9D, T9G;
			      T96 = T8U - T95;
			      T9t = T9h - T9s;
			      T9u = T96 - T9t;
			      TaM = T96 + T9t;
			      T9D = T9z - T9C;
			      T9G = T9E - T9F;
			      T9H = T9D - T9G;
			      TaN = T9D + T9G;
			 }
			 T9I = FMA(KP995184726, T9u, KP098017140 * T9H);
			 TaU = FNMS(KP634393284, TaN, KP773010453 * TaM);
			 TaE = FNMS(KP995184726, T9H, KP098017140 * T9u);
			 TaO = FMA(KP634393284, TaM, KP773010453 * TaN);
		    }
		    {
			 E Tan, TaP, TaA, TaQ;
			 {
			      E T9Z, Tam, Taw, Taz;
			      T9Z = T9N - T9Y;
			      Tam = Taa - Tal;
			      Tan = T9Z - Tam;
			      TaP = T9Z + Tam;
			      Taw = Tas - Tav;
			      Taz = Tax - Tay;
			      TaA = Taw - Taz;
			      TaQ = Taw + Taz;
			 }
			 TaB = FNMS(KP995184726, TaA, KP098017140 * Tan);
			 TaV = FMA(KP773010453, TaQ, KP634393284 * TaP);
			 TaF = FMA(KP098017140, TaA, KP995184726 * Tan);
			 TaR = FNMS(KP634393284, TaQ, KP773010453 * TaP);
		    }
		    {
			 E T8P, TaC, TjR, TjU;
			 T8P = T7V + T8O;
			 TaC = T9I + TaB;
			 ri[WS(ios, 47)] = T8P - TaC;
			 ri[WS(ios, 15)] = T8P + TaC;
			 TjR = TaE + TaF;
			 TjU = TjS + TjT;
			 ii[WS(ios, 15)] = TjR + TjU;
			 ii[WS(ios, 47)] = TjU - TjR;
		    }
		    {
			 E TaD, TaG, TjV, TjW;
			 TaD = T7V - T8O;
			 TaG = TaE - TaF;
			 ri[WS(ios, 63)] = TaD - TaG;
			 ri[WS(ios, 31)] = TaD + TaG;
			 TjV = TaB - T9I;
			 TjW = TjT - TjS;
			 ii[WS(ios, 31)] = TjV + TjW;
			 ii[WS(ios, 63)] = TjW - TjV;
		    }
		    {
			 E TaL, TaS, TjJ, TjO;
			 TaL = TaH + TaK;
			 TaS = TaO + TaR;
			 ri[WS(ios, 39)] = TaL - TaS;
			 ri[WS(ios, 7)] = TaL + TaS;
			 TjJ = TaU + TaV;
			 TjO = TjK + TjN;
			 ii[WS(ios, 7)] = TjJ + TjO;
			 ii[WS(ios, 39)] = TjO - TjJ;
		    }
		    {
			 E TaT, TaW, TjP, TjQ;
			 TaT = TaH - TaK;
			 TaW = TaU - TaV;
			 ri[WS(ios, 55)] = TaT - TaW;
			 ri[WS(ios, 23)] = TaT + TaW;
			 TjP = TaR - TaO;
			 TjQ = TjN - TjK;
			 ii[WS(ios, 23)] = TjP + TjQ;
			 ii[WS(ios, 55)] = TjQ - TjP;
		    }
	       }
	       {
		    E TbV, TcT, Tjj, Tjp, Tca, Tjo, TcW, Tjg, Tcu, Td6, TcQ, Td0, TcN, Td7, TcR;
		    E Td3;
		    {
			 E TbN, TbU, Tjh, Tji;
			 TbN = TbJ - TbM;
			 TbU = TbQ - TbT;
			 TbV = TbN - TbU;
			 TcT = TbN + TbU;
			 Tjh = Tdb - Tda;
			 Tji = Tj3 - Tj0;
			 Tjj = Tjh + Tji;
			 Tjp = Tji - Tjh;
		    }
		    {
			 E Tc2, TcU, Tc9, TcV;
			 {
			      E TbY, Tc1, Tc5, Tc8;
			      TbY = TbW - TbX;
			      Tc1 = TbZ - Tc0;
			      Tc2 = FNMS(KP831469612, Tc1, KP555570233 * TbY);
			      TcU = FMA(KP555570233, Tc1, KP831469612 * TbY);
			      Tc5 = Tc3 - Tc4;
			      Tc8 = Tc6 - Tc7;
			      Tc9 = FMA(KP831469612, Tc5, KP555570233 * Tc8);
			      TcV = FNMS(KP831469612, Tc8, KP555570233 * Tc5);
			 }
			 Tca = Tc2 - Tc9;
			 Tjo = TcV - TcU;
			 TcW = TcU + TcV;
			 Tjg = Tc2 + Tc9;
		    }
		    {
			 E Tcm, TcY, Tct, TcZ;
			 {
			      E Tce, Tcl, Tcp, Tcs;
			      Tce = Tcc - Tcd;
			      Tcl = Tch - Tck;
			      Tcm = Tce - Tcl;
			      TcY = Tce + Tcl;
			      Tcp = Tcn - Tco;
			      Tcs = Tcq - Tcr;
			      Tct = Tcp - Tcs;
			      TcZ = Tcp + Tcs;
			 }
			 Tcu = FMA(KP956940335, Tcm, KP290284677 * Tct);
			 Td6 = FNMS(KP471396736, TcZ, KP881921264 * TcY);
			 TcQ = FNMS(KP956940335, Tct, KP290284677 * Tcm);
			 Td0 = FMA(KP471396736, TcY, KP881921264 * TcZ);
		    }
		    {
			 E TcF, Td1, TcM, Td2;
			 {
			      E Tcx, TcE, TcI, TcL;
			      Tcx = Tcv - Tcw;
			      TcE = TcA - TcD;
			      TcF = Tcx - TcE;
			      Td1 = Tcx + TcE;
			      TcI = TcG - TcH;
			      TcL = TcJ - TcK;
			      TcM = TcI - TcL;
			      Td2 = TcI + TcL;
			 }
			 TcN = FNMS(KP956940335, TcM, KP290284677 * TcF);
			 Td7 = FMA(KP881921264, Td2, KP471396736 * Td1);
			 TcR = FMA(KP290284677, TcM, KP956940335 * TcF);
			 Td3 = FNMS(KP471396736, Td2, KP881921264 * Td1);
		    }
		    {
			 E Tcb, TcO, Tjn, Tjq;
			 Tcb = TbV + Tca;
			 TcO = Tcu + TcN;
			 ri[WS(ios, 45)] = Tcb - TcO;
			 ri[WS(ios, 13)] = Tcb + TcO;
			 Tjn = TcQ + TcR;
			 Tjq = Tjo + Tjp;
			 ii[WS(ios, 13)] = Tjn + Tjq;
			 ii[WS(ios, 45)] = Tjq - Tjn;
		    }
		    {
			 E TcP, TcS, Tjr, Tjs;
			 TcP = TbV - Tca;
			 TcS = TcQ - TcR;
			 ri[WS(ios, 61)] = TcP - TcS;
			 ri[WS(ios, 29)] = TcP + TcS;
			 Tjr = TcN - Tcu;
			 Tjs = Tjp - Tjo;
			 ii[WS(ios, 29)] = Tjr + Tjs;
			 ii[WS(ios, 61)] = Tjs - Tjr;
		    }
		    {
			 E TcX, Td4, Tjf, Tjk;
			 TcX = TcT + TcW;
			 Td4 = Td0 + Td3;
			 ri[WS(ios, 37)] = TcX - Td4;
			 ri[WS(ios, 5)] = TcX + Td4;
			 Tjf = Td6 + Td7;
			 Tjk = Tjg + Tjj;
			 ii[WS(ios, 5)] = Tjf + Tjk;
			 ii[WS(ios, 37)] = Tjk - Tjf;
		    }
		    {
			 E Td5, Td8, Tjl, Tjm;
			 Td5 = TcT - TcW;
			 Td8 = Td6 - Td7;
			 ri[WS(ios, 53)] = Td5 - Td8;
			 ri[WS(ios, 21)] = Td5 + Td8;
			 Tjl = Td3 - Td0;
			 Tjm = Tjj - Tjg;
			 ii[WS(ios, 21)] = Tjl + Tjm;
			 ii[WS(ios, 53)] = Tjm - Tjl;
		    }
	       }
	       {
		    E Tdd, TdF, Tj5, Tjb, Tdk, Tja, TdI, TiY, Tds, TdS, TdC, TdM, Tdz, TdT, TdD;
		    E TdP;
		    {
			 E Td9, Tdc, TiZ, Tj4;
			 Td9 = TbJ + TbM;
			 Tdc = Tda + Tdb;
			 Tdd = Td9 - Tdc;
			 TdF = Td9 + Tdc;
			 TiZ = TbQ + TbT;
			 Tj4 = Tj0 + Tj3;
			 Tj5 = TiZ + Tj4;
			 Tjb = Tj4 - TiZ;
		    }
		    {
			 E Tdg, TdG, Tdj, TdH;
			 {
			      E Tde, Tdf, Tdh, Tdi;
			      Tde = TbW + TbX;
			      Tdf = TbZ + Tc0;
			      Tdg = FNMS(KP195090322, Tdf, KP980785280 * Tde);
			      TdG = FMA(KP980785280, Tdf, KP195090322 * Tde);
			      Tdh = Tc3 + Tc4;
			      Tdi = Tc6 + Tc7;
			      Tdj = FMA(KP195090322, Tdh, KP980785280 * Tdi);
			      TdH = FNMS(KP195090322, Tdi, KP980785280 * Tdh);
			 }
			 Tdk = Tdg - Tdj;
			 Tja = TdH - TdG;
			 TdI = TdG + TdH;
			 TiY = Tdg + Tdj;
		    }
		    {
			 E Tdo, TdK, Tdr, TdL;
			 {
			      E Tdm, Tdn, Tdp, Tdq;
			      Tdm = Tcn + Tco;
			      Tdn = Tck + Tch;
			      Tdo = Tdm - Tdn;
			      TdK = Tdm + Tdn;
			      Tdp = Tcc + Tcd;
			      Tdq = Tcq + Tcr;
			      Tdr = Tdp - Tdq;
			      TdL = Tdp + Tdq;
			 }
			 Tds = FMA(KP634393284, Tdo, KP773010453 * Tdr);
			 TdS = FNMS(KP098017140, TdK, KP995184726 * TdL);
			 TdC = FNMS(KP773010453, Tdo, KP634393284 * Tdr);
			 TdM = FMA(KP995184726, TdK, KP098017140 * TdL);
		    }
		    {
			 E Tdv, TdN, Tdy, TdO;
			 {
			      E Tdt, Tdu, Tdw, Tdx;
			      Tdt = Tcv + Tcw;
			      Tdu = TcK + TcJ;
			      Tdv = Tdt - Tdu;
			      TdN = Tdt + Tdu;
			      Tdw = TcG + TcH;
			      Tdx = TcA + TcD;
			      Tdy = Tdw - Tdx;
			      TdO = Tdw + Tdx;
			 }
			 Tdz = FNMS(KP773010453, Tdy, KP634393284 * Tdv);
			 TdT = FMA(KP098017140, TdN, KP995184726 * TdO);
			 TdD = FMA(KP773010453, Tdv, KP634393284 * Tdy);
			 TdP = FNMS(KP098017140, TdO, KP995184726 * TdN);
		    }
		    {
			 E Tdl, TdA, Tj9, Tjc;
			 Tdl = Tdd + Tdk;
			 TdA = Tds + Tdz;
			 ri[WS(ios, 41)] = Tdl - TdA;
			 ri[WS(ios, 9)] = Tdl + TdA;
			 Tj9 = TdC + TdD;
			 Tjc = Tja + Tjb;
			 ii[WS(ios, 9)] = Tj9 + Tjc;
			 ii[WS(ios, 41)] = Tjc - Tj9;
		    }
		    {
			 E TdB, TdE, Tjd, Tje;
			 TdB = Tdd - Tdk;
			 TdE = TdC - TdD;
			 ri[WS(ios, 57)] = TdB - TdE;
			 ri[WS(ios, 25)] = TdB + TdE;
			 Tjd = Tdz - Tds;
			 Tje = Tjb - Tja;
			 ii[WS(ios, 25)] = Tjd + Tje;
			 ii[WS(ios, 57)] = Tje - Tjd;
		    }
		    {
			 E TdJ, TdQ, TiX, Tj6;
			 TdJ = TdF + TdI;
			 TdQ = TdM + TdP;
			 ri[WS(ios, 33)] = TdJ - TdQ;
			 ri[WS(ios, 1)] = TdJ + TdQ;
			 TiX = TdS + TdT;
			 Tj6 = TiY + Tj5;
			 ii[WS(ios, 1)] = TiX + Tj6;
			 ii[WS(ios, 33)] = Tj6 - TiX;
		    }
		    {
			 E TdR, TdU, Tj7, Tj8;
			 TdR = TdF - TdI;
			 TdU = TdS - TdT;
			 ri[WS(ios, 49)] = TdR - TdU;
			 ri[WS(ios, 17)] = TdR + TdU;
			 Tj7 = TdP - TdM;
			 Tj8 = Tj5 - TiY;
			 ii[WS(ios, 17)] = Tj7 + Tj8;
			 ii[WS(ios, 49)] = Tj8 - Tj7;
		    }
	       }
	       {
		    E Tb1, Tbt, Tjz, TjF, Tb8, TjE, Tbw, Tju, Tbg, TbG, Tbq, TbA, Tbn, TbH, Tbr;
		    E TbD;
		    {
			 E TaX, Tb0, Tjv, Tjy;
			 TaX = T7l + T7w;
			 Tb0 = TaY + TaZ;
			 Tb1 = TaX - Tb0;
			 Tbt = TaX + Tb0;
			 Tjv = T7I + T7T;
			 Tjy = Tjw + Tjx;
			 Tjz = Tjv + Tjy;
			 TjF = Tjy - Tjv;
		    }
		    {
			 E Tb4, Tbu, Tb7, Tbv;
			 {
			      E Tb2, Tb3, Tb5, Tb6;
			      Tb2 = T80 + T8b;
			      Tb3 = T8h + T8k;
			      Tb4 = FNMS(KP555570233, Tb3, KP831469612 * Tb2);
			      Tbu = FMA(KP555570233, Tb2, KP831469612 * Tb3);
			      Tb5 = T8r + T8C;
			      Tb6 = T8I + T8L;
			      Tb7 = FMA(KP831469612, Tb5, KP555570233 * Tb6);
			      Tbv = FNMS(KP555570233, Tb5, KP831469612 * Tb6);
			 }
			 Tb8 = Tb4 - Tb7;
			 TjE = Tbv - Tbu;
			 Tbw = Tbu + Tbv;
			 Tju = Tb4 + Tb7;
		    }
		    {
			 E Tbc, Tby, Tbf, Tbz;
			 {
			      E Tba, Tbb, Tbd, Tbe;
			      Tba = T9z + T9C;
			      Tbb = T9s + T9h;
			      Tbc = Tba - Tbb;
			      Tby = Tba + Tbb;
			      Tbd = T8U + T95;
			      Tbe = T9E + T9F;
			      Tbf = Tbd - Tbe;
			      Tbz = Tbd + Tbe;
			 }
			 Tbg = FMA(KP471396736, Tbc, KP881921264 * Tbf);
			 TbG = FNMS(KP290284677, Tby, KP956940335 * Tbz);
			 Tbq = FNMS(KP881921264, Tbc, KP471396736 * Tbf);
			 TbA = FMA(KP956940335, Tby, KP290284677 * Tbz);
		    }
		    {
			 E Tbj, TbB, Tbm, TbC;
			 {
			      E Tbh, Tbi, Tbk, Tbl;
			      Tbh = T9N + T9Y;
			      Tbi = Tay + Tax;
			      Tbj = Tbh - Tbi;
			      TbB = Tbh + Tbi;
			      Tbk = Tas + Tav;
			      Tbl = Taa + Tal;
			      Tbm = Tbk - Tbl;
			      TbC = Tbk + Tbl;
			 }
			 Tbn = FNMS(KP881921264, Tbm, KP471396736 * Tbj);
			 TbH = FMA(KP290284677, TbB, KP956940335 * TbC);
			 Tbr = FMA(KP881921264, Tbj, KP471396736 * Tbm);
			 TbD = FNMS(KP290284677, TbC, KP956940335 * TbB);
		    }
		    {
			 E Tb9, Tbo, TjD, TjG;
			 Tb9 = Tb1 + Tb8;
			 Tbo = Tbg + Tbn;
			 ri[WS(ios, 43)] = Tb9 - Tbo;
			 ri[WS(ios, 11)] = Tb9 + Tbo;
			 TjD = Tbq + Tbr;
			 TjG = TjE + TjF;
			 ii[WS(ios, 11)] = TjD + TjG;
			 ii[WS(ios, 43)] = TjG - TjD;
		    }
		    {
			 E Tbp, Tbs, TjH, TjI;
			 Tbp = Tb1 - Tb8;
			 Tbs = Tbq - Tbr;
			 ri[WS(ios, 59)] = Tbp - Tbs;
			 ri[WS(ios, 27)] = Tbp + Tbs;
			 TjH = Tbn - Tbg;
			 TjI = TjF - TjE;
			 ii[WS(ios, 27)] = TjH + TjI;
			 ii[WS(ios, 59)] = TjI - TjH;
		    }
		    {
			 E Tbx, TbE, Tjt, TjA;
			 Tbx = Tbt + Tbw;
			 TbE = TbA + TbD;
			 ri[WS(ios, 35)] = Tbx - TbE;
			 ri[WS(ios, 3)] = Tbx + TbE;
			 Tjt = TbG + TbH;
			 TjA = Tju + Tjz;
			 ii[WS(ios, 3)] = Tjt + TjA;
			 ii[WS(ios, 35)] = TjA - Tjt;
		    }
		    {
			 E TbF, TbI, TjB, TjC;
			 TbF = Tbt - Tbw;
			 TbI = TbG - TbH;
			 ri[WS(ios, 51)] = TbF - TbI;
			 ri[WS(ios, 19)] = TbF + TbI;
			 TjB = TbD - TbA;
			 TjC = Tjz - Tju;
			 ii[WS(ios, 19)] = TjB + TjC;
			 ii[WS(ios, 51)] = TjC - TjB;
		    }
	       }
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 0, 1},
     {TW_CEXP, 0, 3},
     {TW_CEXP, 0, 9},
     {TW_CEXP, 0, 27},
     {TW_CEXP, 0, 63},
     {TW_NEXT, 1, 0}
};

static const ct_desc desc = { 64, "t2_64", twinstr, &GENUS, {880, 386, 274, 0}, 0, 0, 0 };

void X(codelet_t2_64) (planner *p) {
     X(kdft_dit_register) (p, t2_64, &desc);
}
#endif				/* HAVE_FMA */
