/*
 * BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 * Copyright (C) 1993-96 by Hartmut Schirmer
 *
 * This library is copyrighted (see above). It might be used and
 * distributed freely as long as all copyright notices are left
 * intact.
 *
 * You may not distribute any changed versions of BCC2GRX without
 * written permission by Hartmut Schirmer.
 *
 * You are permitted to distribute an application linked with BCC2GRX
 * in binary only, provided that the documentation of the program:
 *
 *    a)   informs the user that BCC2GRX is used in the program, AND
 *
 *    b)   provides the user with the necessary information about
 *         how to obtain BCC2GRX. (i.e. ftp site, etc..)
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Contact :                Hartmut Schirmer
 *                          Feldstrasse 118
 *                  D-24105 Kiel
 *                          Germany
 *
 * e-mail : hsc@techfak.uni-kiel.d400.de
 */

#include "bccgrx00.h"
#include <stdio.h>

char *getmodename(int mode_number)
{
  static char result[50];
  char cols[20];
  int xw, yw;
  long nc;

/*  _DO_INIT_CHECK_RV(NULL); */
  __gr_set_up_modes();
  if (mode_number < 0 || mode_number > MM) {
    ERR = grInvalidMode;
    return NULL;
  }
  switch (mode_number) {
    case GRX_DEFAULT_GRAPHICS               : return "default graphics mode";
    case GRX_BIGGEST_NONINTERLACED_GRAPHICS : return "biggest non interlaced graphics mode";
    case GRX_BIGGEST_GRAPHICS               : return "biggest graphics mode";
    case GRX_BGI_EMULATION                  : return "BGI emulation mode";
  }
  if (!__gr_getmode_whc(mode_number, &xw, &yw, &nc))
    return NULL;
  switch (nc) {
    case 1<<15 : strcpy(cols,"32K"); break;
    case 1<<16 : strcpy(cols,"64K"); break;
    case 1<<24 : strcpy(cols,"16M"); break;
    default    : sprintf(cols, "%ld", nc);
		 break;
  }
  sprintf(result, "%d x %d x %s", xw, yw, cols);
  return result;
}

