/* 8bpp palette code */
#include "m3d.h"

/* texture cache */
static BITMAP *txt_cache[TOTAL_TEXTURES], *ntxt_cache[TOTAL_TEXTURES];
static int txt_cache_i;
static RGB_MAP rgbmap;
PALETTE m3dpal;
static unsigned long *ColCnt;

void m3d_MakePal(void)
{
    unsigned long i, best, besti, x, y, r, g, b;

    /* find 256 highest used colors */
    for (x = 0; x < 256; x++) {
        for (best = besti = y = 0; y < (1<<18); y++)
            if (ColCnt[y] > best) {
                best = ColCnt[y];
                besti = y; }
        m3dpal[x].r = (besti>>12);
        m3dpal[x].g = (besti>>6) & 63;
        m3dpal[x].b = (besti&63);
        ColCnt[besti] = 0; }

    /* make rgbmap */
    create_rgb_table(&rgbmap, m3dpal, NULL);
    rgb_map = &rgbmap;

    /* set palette */
    set_palette(m3dpal);

    /* remap textures */
    for (i = 0; i < txt_cache_i; i++) {
        besti = bitmap_color_depth(txt_cache[i]);
        for (x = 0; x < txt_cache[i]->w; x++)
        for (y = 0; y < txt_cache[i]->h; y++) {
            best = getpixel(txt_cache[i], x, y);
            r = getr_depth(besti, best);
            g = getg_depth(besti, best);
            b = getb_depth(besti, best);
            putpixel(ntxt_cache[i], x, y, rgbmap.data[r>>2][g>>2][b>>2]);
        }
        destroy_bitmap(txt_cache[i]);
    }

    /* free mem */
    free(ColCnt);
}   

void m3d_MakePalInit(void) {
    txt_cache_i = 0;
    ColCnt = calloc(1<<18, sizeof(long));
}

void m3d_MakePalAddColor(unsigned long color, unsigned long shades)
{
    unsigned long i, r, g, b, rr, gg, bb, best, besti;

    /* check for bad parameters */
    if (shades > 32)
        shades = 32;
    else if (shades < 1)
        shades = 1;

    /* get rgb values */
    r = (color >> 16);
    g = (color >> 8) & 255;
    b = (color) & 255;

    for (i = 1; i <= shades; i++) {
        rr = ((r * i) / shades) >> 2;
        gg = ((g * i) / shades) >> 2;
        bb = ((b * i) / shades) >> 2;
        ++ColCnt[(rr<<12)|(gg<<6)|bb];
    }
}

void m3d_MakePalObj(obj *o, unsigned long shades)
{
    int x, i, xx, yy, r, g, b, t;

    for (x = 0; x < o->nfaces; x++) {
        switch (o->faces[x].shadetype & (~POLYTYPE_ZBUF)) {
            case POLYTYPE_GRGB:
            case POLYTYPE_FLAT:
            case POLYTYPE_GCOL:
                for (i = 0; i < 3; i++)
                    m3d_MakePalAddColor(o->faces[x].v[i].c, shades);
                break;
            case POLYTYPE_ATEX:
            case POLYTYPE_PTEX:
            case POLYTYPE_ATEX_LIT:
            case POLYTYPE_PTEX_LIT:
                /* is it in the cache? */
                for (xx = 0; xx < txt_cache_i; xx++)
                    if (txt_cache[xx] == o->faces[x].texture) {
                        o->faces[x].texture = ntxt_cache[xx];
                        xx = 1234567; break; }

                if ((xx != 1234567) && (txt_cache_i < TOTAL_TEXTURES)) {
                    txt_cache[txt_cache_i] = o->faces[x].texture;
                    ntxt_cache[txt_cache_i] = create_bitmap_ex(8, o->faces[x].texture->w, o->faces[x].texture->h);
                    o->faces[x].texture = ntxt_cache[txt_cache_i];
                    i = bitmap_color_depth(txt_cache[txt_cache_i]);
                    for (xx = 0; xx < txt_cache[txt_cache_i]->w; xx++)
                    for (yy = 0; yy < txt_cache[txt_cache_i]->h; yy++) {
                        t = getpixel(txt_cache[txt_cache_i], xx, yy);
                        r = getr_depth(i, t);
                        g = getg_depth(i, t);
                        b = getb_depth(i, t);
                        m3d_MakePalAddColor((r<<16)|(g<<8)|b, shades);
                    }
                    ++txt_cache_i;
               }
                break;
        }
    }
    for (x = 0; x < o->nchild; x++)
        m3d_MakePalObj(&o->child[x], shades);
}
