This is gettext.info, produced by makeinfo version 4.0 from
gettext.texi.

INFO-DIR-SECTION GNU Gettext Utilities
START-INFO-DIR-ENTRY
* Gettext: (gettext).                           GNU gettext utilities.
* gettextize: (gettext)gettextize Invocation.   Prepare a package for gettext.
* msgfmt: (gettext)msgfmt Invocation.           Make MO files out of PO files.
* msgmerge: (gettext)msgmerge Invocation.       Update two PO files into one.
* xgettext: (gettext)xgettext Invocation.       Extract strings into a PO file.
END-INFO-DIR-ENTRY

   This file provides documentation for GNU `gettext' utilities.  It
also serves as a reference for the free Translation Project.

   Copyright (C) 1995, 1996, 1997, 1998, 2001 Free Software Foundation,
Inc.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, provided that
the entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be stated in a
translation approved by the Foundation.


File: gettext.info,  Node: Obsolete Entries,  Next: Modifying Translations,  Prev: Untranslated Entries,  Up: Updating

Obsolete Entries
================

   By "obsolete" PO file entries, we mean those entries which are
commented out, usually by `msgmerge' when it found that the translation
is not needed anymore by the package being localized.

   The usual commands moving from entry to entry consider obsolete
entries on the same level as active entries.  Obsolete entries are
easily recognizable by the fact that all their lines start with `#',
even those lines containing `msgid' or `msgstr'.

   Commands exist for emptying the translation or reinitializing it to
the original untranslated string.  Commands interfacing with the kill
ring may force some previously saved text into the translation.  The
user may interactively edit the translation.  All these commands may
apply to obsolete entries, carefully leaving the entry obsolete after
the fact.

   Moreover, some commands are more specifically related to obsolete
entry processing.

`o'
     Find the next obsolete entry.

`M-o'
     Find the previous obsolete entry.

`<DEL>'
     Make an active entry obsolete, or zap out an obsolete entry.

   The commands `o' (`po-next-obsolete-entry') and `M-o'
(`po-previous-obsolete-entry') move forwards or backwards, chasing for
an obsolete entry.  If none is found, the search is extended and wraps
around in the PO file buffer.

   PO mode does not provide ways for un-commenting an obsolete entry
and making it active, because this would reintroduce an original
untranslated string which does not correspond to any marked string in
the program sources.  This goes with the philosophy of never
introducing useless `msgid' values.

   However, it is possible to comment out an active entry, so making it
obsolete.  GNU `gettext' utilities will later react to the
disappearance of a translation by using the untranslated string.  The
command `<DEL>' (`po-fade-out-entry') pushes the current entry a little
further towards annihilation.  If the entry is active (it is a
translated entry), then it is first made fuzzy.  If it is already fuzzy,
then the entry is merely commented out, with confirmation.  If the entry
is already obsolete, then it is completely deleted from the PO file.
It is easy to recycle the translation so deleted into some other PO file
entry, usually one which is untranslated.  *Note Modifying
Translations::.

   Here is a quite interesting problem to solve for later development of
PO mode, for those nights you are not sleepy.  The idea would be that
PO mode might become bright enough, one of these days, to make good
guesses at retrieving the most probable candidate, among all obsolete
entries, for initializing the translation of a newly appeared string.
I think it might be a quite hard problem to do this algorithmically, as
we have to develop good and efficient measures of string similarity.
Right now, PO mode completely lets the decision to the translator, when
the time comes to find the adequate obsolete translation, it merely
tries to provide handy tools for helping her to do so.


File: gettext.info,  Node: Modifying Translations,  Next: Modifying Comments,  Prev: Obsolete Entries,  Up: Updating

Modifying Translations
======================

   PO mode prevents direct edition of the PO file, by the usual means
Emacs give for altering a buffer's contents.  By doing so, it pretends
helping the translator to avoid little clerical errors about the
overall file format, or the proper quoting of strings, as those errors
would be easily made.  Other kinds of errors are still possible, but
some may be caught and diagnosed by the batch validation process, which
the translator may always trigger by the `V' command.  For all other
errors, the translator has to rely on her own judgment, and also on the
linguistic reports submitted to her by the users of the translated
package, having the same mother tongue.

   When the time comes to create a translation, correct an error
diagnosed mechanically or reported by a user, the translators have to
resort to using the following commands for modifying the translations.

`<RET>'
     Interactively edit the translation.

`<LFD>'
     Reinitialize the translation with the original, untranslated
     string.

`k'
     Save the translation on the kill ring, and delete it.

`w'
     Save the translation on the kill ring, without deleting it.

`y'
     Replace the translation, taking the new from the kill ring.

   The command `<RET>' (`po-edit-msgstr') opens a new Emacs window
meant to edit in a new translation, or to modify an already existing
translation.  The new window contains a copy of the translation taken
from the current PO file entry, all ready for edition, expunged of all
quoting marks, fully modifiable and with the complete extent of Emacs
modifying commands.  When the translator is done with her
modifications, she may use `C-c C-c' to close the subedit window with
the automatically requoted results, or `C-c C-k' to abort her
modifications.  *Note Subedit::, for more information.

   The command `<LFD>' (`po-msgid-to-msgstr') initializes, or
reinitializes the translation with the original string.  This command is
normally used when the translator wants to redo a fresh translation of
the original string, disregarding any previous work.

   It is possible to arrange so, whenever editing an untranslated
entry, the `<LFD>' command be automatically executed.  If you set
`po-auto-edit-with-msgid' to `t', the translation gets initialised with
the original string, in case none exists already.  The default value
for `po-auto-edit-with-msgid' is `nil'.

   In fact, whether it is best to start a translation with an empty
string, or rather with a copy of the original string, is a matter of
taste or habit.  Sometimes, the source language and the target language
are so different that is simply best to start writing on an empty page.
At other times, the source and target languages are so close that it
would be a waste to retype a number of words already being written in
the original string.  A translator may also like having the original
string right under her eyes, as she will progressively overwrite the
original text with the translation, even if this requires some extra
editing work to get rid of the original.

   The command `k' (`po-kill-msgstr') merely empties the translation
string, so turning the entry into an untranslated one.  But while doing
so, its previous contents is put apart in a special place, known as the
kill ring.  The command `w' (`po-kill-ring-save-msgstr') has also the
effect of taking a copy of the translation onto the kill ring, but it
otherwise leaves the entry alone, and does _not_ remove the translation
from the entry.  Both commands use exactly the Emacs kill ring, which
is shared between buffers, and which is well known already to Emacs
lovers.

   The translator may use `k' or `w' many times in the course of her
work, as the kill ring may hold several saved translations.  From the
kill ring, strings may later be reinserted in various Emacs buffers.
In particular, the kill ring may be used for moving translation strings
between different entries of a single PO file buffer, or if the
translator is handling many such buffers at once, even between PO files.

   To facilitate exchanges with buffers which are not in PO mode, the
translation string put on the kill ring by the `k' command is fully
unquoted before being saved: external quotes are removed, multi-line
strings are concatenated, and backslash escaped sequences are turned
into their corresponding characters.  In the special case of obsolete
entries, the translation is also uncommented prior to saving.

   The command `y' (`po-yank-msgstr') completely replaces the
translation of the current entry by a string taken from the kill ring.
Following Emacs terminology, we then say that the replacement string is
"yanked" into the PO file buffer.  *Note Yanking: (emacs)Yanking.  The
first time `y' is used, the translation receives the value of the most
recent addition to the kill ring.  If `y' is typed once again,
immediately, without intervening keystrokes, the translation just
inserted is taken away and replaced by the second most recent addition
to the kill ring.  By repeating `y' many times in a row, the translator
may travel along the kill ring for saved strings, until she finds the
string she really wanted.

   When a string is yanked into a PO file entry, it is fully and
automatically requoted for complying with the format PO files should
have.  Further, if the entry is obsolete, PO mode then appropriately
push the inserted string inside comments.  Once again, translators
should not burden themselves with quoting considerations besides, of
course, the necessity of the translated string itself respective to the
program using it.

   Note that `k' or `w' are not the only commands pushing strings on
the kill ring, as almost any PO mode command replacing translation
strings (or the translator comments) automatically saves the old string
on the kill ring.  The main exceptions to this general rule are the
yanking commands themselves.

   To better illustrate the operation of killing and yanking, let's use
an actual example, taken from a common situation.  When the programmer
slightly modifies some string right in the program, his change is later
reflected in the PO file by the appearance of a new untranslated entry
for the modified string, and the fact that the entry translating the
original or unmodified string becomes obsolete.  In many cases, the
translator might spare herself some work by retrieving the unmodified
translation from the obsolete entry, then initializing the untranslated
entry `msgstr' field with this retrieved translation.  Once this done,
the obsolete entry is not wanted anymore, and may be safely deleted.

   When the translator finds an untranslated entry and suspects that a
slight variant of the translation exists, she immediately uses `m' to
mark the current entry location, then starts chasing obsolete entries
with `o', hoping to find some translation corresponding to the
unmodified string.  Once found, she uses the `<DEL>' command for
deleting the obsolete entry, knowing that `<DEL>' also _kills_ the
translation, that is, pushes the translation on the kill ring.  Then,
`r' returns to the initial untranslated entry, and `y' then _yanks_ the
saved translation right into the `msgstr' field.  The translator is
then free to use `<RET>' for fine tuning the translation contents, and
maybe to later use `u', then `m' again, for going on with the next
untranslated string.

   When some sequence of keys has to be typed over and over again, the
translator may find it useful to become better acquainted with the Emacs
capability of learning these sequences and playing them back under
request.  *Note Keyboard Macros: (emacs)Keyboard Macros.


File: gettext.info,  Node: Modifying Comments,  Next: Subedit,  Prev: Modifying Translations,  Up: Updating

Modifying Comments
==================

   Any translation work done seriously will raise many linguistic
difficulties, for which decisions have to be made, and the choices
further documented.  These documents may be saved within the PO file in
form of translator comments, which the translator is free to create,
delete, or modify at will.  These comments may be useful to herself
when she returns to this PO file after a while.

   Comments not having whitespace after the initial `#', for example,
those beginning with `#.' or `#:', are _not_ translator comments, they
are exclusively created by other `gettext' tools.  So, the commands
below will never alter such system added comments, they are not meant
for the translator to modify.  *Note PO Files::.

   The following commands are somewhat similar to those modifying
translations, so the general indications given for those apply here.
*Note Modifying Translations::.

`#'
     Interactively edit the translator comments.

`K'
     Save the translator comments on the kill ring, and delete it.

`W'
     Save the translator comments on the kill ring, without deleting it.

`Y'
     Replace the translator comments, taking the new from the kill ring.

   These commands parallel PO mode commands for modifying the
translation strings, and behave much the same way as they do, except
that they handle this part of PO file comments meant for translator
usage, rather than the translation strings.  So, if the descriptions
given below are slightly succinct, it is because the full details have
already been given.  *Note Modifying Translations::.

   The command `#' (`po-edit-comment') opens a new Emacs window
containing a copy of the translator comments on the current PO file
entry.  If there are no such comments, PO mode understands that the
translator wants to add a comment to the entry, and she is presented
with an empty screen.  Comment marks (`#') and the space following them
are automatically removed before edition, and reinstated after.  For
translator comments pertaining to obsolete entries, the uncommenting
and recommenting operations are done twice.  Once in the editing
window, the keys `C-c C-c' allow the translator to tell she is finished
with editing the comment.  *Note Subedit::, for further details.

   Functions found on `po-subedit-mode-hook', if any, are executed after
the string has been inserted in the edit buffer.

   The command `K' (`po-kill-comment') gets rid of all translator
comments, while saving those comments on the kill ring.  The command
`W' (`po-kill-ring-save-comment') takes a copy of the translator
comments on the kill ring, but leaves them undisturbed in the current
entry.  The command `Y' (`po-yank-comment') completely replaces the
translator comments by a string taken at the front of the kill ring.
When this command is immediately repeated, the comments just inserted
are withdrawn, and replaced by other strings taken along the kill ring.

   On the kill ring, all strings have the same nature.  There is no
distinction between _translation_ strings and _translator comments_
strings.  So, for example, let's presume the translator has just
finished editing a translation, and wants to create a new translator
comment to document why the previous translation was not good, just to
remember what was the problem.  Foreseeing that she will do that in her
documentation, the translator may want to quote the previous
translation in her translator comments.  To do so, she may initialize
the translator comments with the previous translation, still at the
head of the kill ring.  Because editing already pushed the previous
translation on the kill ring, she merely has to type `M-w' prior to
`#', and the previous translation will be right there, all ready for
being introduced by some explanatory text.

   On the other hand, presume there are some translator comments already
and that the translator wants to add to those comments, instead of
wholly replacing them.  Then, she should edit the comment right away
with `#'.  Once inside the editing window, she can use the regular
Emacs commands `C-y' (`yank') and `M-y' (`yank-pop') to get the
previous translation where she likes.


File: gettext.info,  Node: Subedit,  Next: C Sources Context,  Prev: Modifying Comments,  Up: Updating

Details of Sub Edition
======================

   The PO subedit minor mode has a few peculiarities worth being
described in fuller detail.  It installs a few commands over the usual
editing set of Emacs, which are described below.

`C-c C-c'
     Complete edition.

`C-c C-k'
     Abort edition.

`C-c C-a'
     Consult auxiliary PO files.

   The window's contents represents a translation for a given message,
or a translator comment.  The translator may modify this window to her
heart's content.  Once this done, the command `C-c C-c'
(`po-subedit-exit') may be used to return the edited translation into
the PO file, replacing the original translation, even if it moved out of
sight or if buffers were switched.

   If the translator becomes unsatisfied with her translation or
comment, to the extent she prefers keeping what was existent prior to
the `<RET>' or `#' command, she may use the command `C-c C-k'
(`po-subedit-abort') to merely get rid of edition, while preserving the
original translation or comment.  Another way would be for her to exit
normally with `C-c C-c', then type `U' once for undoing the whole
effect of last edition.

   The command `C-c C-a' allows for glancing through translations
already achieved in other languages, directly while editing the current
translation.  This may be quite convenient when the translator is fluent
at many languages, but of course, only makes sense when such completed
auxiliary PO files are already available to her (*note Auxiliary::).

   Functions found on `po-subedit-mode-hook', if any, are executed after
the string has been inserted in the edit buffer.

   While editing her translation, the translator should pay attention
to not inserting unwanted `<RET>' (newline) characters at the end of
the translated string if those are not meant to be there, or to removing
such characters when they are required.  Since these characters are not
visible in the editing buffer, they are easily introduced by mistake.
To help her, `<RET>' automatically puts the character `<' at the end of
the string being edited, but this `<' is not really part of the string.
On exiting the editing window with `C-c C-c', PO mode automatically
removes such `<' and all whitespace added after it.  If the translator
adds characters after the terminating `<', it looses its delimiting
property and integrally becomes part of the string.  If she removes the
delimiting `<', then the edited string is taken _as is_, with all
trailing newlines, even if invisible.  Also, if the translated string
ought to end itself with a genuine `<', then the delimiting `<' may not
be removed; so the string should appear, in the editing window, as
ending with two `<' in a row.

   When a translation (or a comment) is being edited, the translator
may move the cursor back into the PO file buffer and freely move to
other entries, browsing at will.  If, with an edition pending, the
translator wanders in the PO file buffer, she may decide to start
modifying another entry.  Each entry being edited has its own subedit
buffer.  It is possible to simultaneously edit the translation _and_
the comment of a single entry, or to edit entries in different PO
files, all at once.  Typing `<RET>' on a field already being edited
merely resumes that particular edit.  Yet, the translator should better
be comfortable at handling many Emacs windows!

   Pending subedits may be completed or aborted in any order, regardless
of how or when they were started.  When many subedits are pending and
the translator asks for quitting the PO file (with the `q' command),
subedits are automatically resumed one at a time, so she may decide for
each of them.


File: gettext.info,  Node: C Sources Context,  Next: Auxiliary,  Prev: Subedit,  Up: Updating

C Sources Context
=================

   PO mode is particularily powerful when used with PO files created
through GNU `gettext' utilities, as those utilities insert special
comments in the PO files they generate.  Some of these special comments
relate the PO file entry to exactly where the untranslated string
appears in the program sources.

   When the translator gets to an untranslated entry, she is fairly
often faced with an original string which is not as informative as it
normally should be, being succinct, cryptic, or otherwise ambiguous.
Before chosing how to translate the string, she needs to understand
better what the string really means and how tight the translation has
to be.  Most of times, when problems arise, the only way left to make
her judgment is looking at the true program sources from where this
string originated, searching for surrounding comments the programmer
might have put in there, and looking around for helping clues of _any_
kind.

   Surely, when looking at program sources, the translator will receive
more help if she is a fluent programmer.  However, even if she is not
versed in programming and feels a little lost in C code, the translator
should not be shy at taking a look, once in a while.  It is most
probable that she will still be able to find some of the hints she
needs.  She will learn quickly to not feel uncomfortable in program
code, paying more attention to programmer's comments, variable and
function names (if he dared chosing them well), and overall
organization, than to programmation itself.

   The following commands are meant to help the translator at getting
program source context for a PO file entry.

`s'
     Resume the display of a program source context, or cycle through
     them.

`M-s'
     Display of a program source context selected by menu.

`S'
     Add a directory to the search path for source files.

`M-S'
     Delete a directory from the search path for source files.

   The commands `s' (`po-cycle-reference') and `M-s'
(`po-select-source-reference') both open another window displaying some
source program file, and already positioned in such a way that it shows
an actual use of the string to be translated.  By doing so, the command
gives source program context for the string.  But if the entry has no
source context references, or if all references are unresolved along
the search path for program sources, then the command diagnoses this as
an error.

   Even if `s' (or `M-s') opens a new window, the cursor stays in the
PO file window.  If the translator really wants to get into the program
source window, she ought to do it explicitly, maybe by using command
`O'.

   When `s' is typed for the first time, or for a PO file entry which
is different of the last one used for getting source context, then the
command reacts by giving the first context available for this entry, if
any.  If some context has already been recently displayed for the
current PO file entry, and the translator wandered off to do other
things, typing `s' again will merely resume, in another window, the
context last displayed.  In particular, if the translator moved the
cursor away from the context in the source file, the command will bring
the cursor back to the context.  By using `s' many times in a row, with
no other commands intervening, PO mode will cycle to the next available
contexts for this particular entry, getting back to the first context
once the last has been shown.

   The command `M-s' behaves differently.  Instead of cycling through
references, it lets the translator choose a particular reference among
many, and displays that reference.  It is best used with completion, if
the translator types `<TAB>' immediately after `M-s', in response to
the question, she will be offered a menu of all possible references, as
a reminder of which are the acceptable answers.  This command is useful
only where there are really many contexts available for a single string
to translate.

   Program source files are usually found relative to where the PO file
stands.  As a special provision, when this fails, the file is also
looked for, but relative to the directory immediately above it.  Those
two cases take proper care of most PO files.  However, it might happen
that a PO file has been moved, or is edited in a different place than
its normal location.  When this happens, the translator should tell PO
mode in which directory normally sits the genuine PO file.  Many such
directories may be specified, and all together, they constitute what is
called the "search path" for program sources.  The command `S'
(`po-consider-source-path') is used to interactively enter a new
directory at the front of the search path, and the command `M-S'
(`po-ignore-source-path') is used to select, with completion, one of
the directories she does not want anymore on the search path.


File: gettext.info,  Node: Auxiliary,  Next: Compendium,  Prev: C Sources Context,  Up: Updating

Consulting Auxiliary PO Files
=============================

   PO mode is able to help the knowledgeable translator, being fluent in
many languages, at taking advantage of translations already achieved in
other languages she just happens to know.  It provides these other
language translations as additional context for her own work.  Moreover,
it has features to ease the production of translations for many
languages at once, for translators preferring to work in this way.

   An "auxiliary" PO file is an existing PO file meant for the same
package the translator is working on, but targeted to a different mother
tongue language.  Commands exist for declaring and handling auxiliary
PO files, and also for showing contexts for the entry under work.

   Here are the auxiliary file commands available in PO mode.

`a'
     Seek auxiliary files for another translation for the same entry.

`M-a'
     Switch to a particular auxiliary file.

`A'
     Declare this PO file as an auxiliary file.

`M-A'
     Remove this PO file from the list of auxiliary files.

   Command `A' (`po-consider-as-auxiliary') adds the current PO file to
the list of auxiliary files, while command `M-A'
(`po-ignore-as-auxiliary' just removes it.

   The command `a' (`po-cycle-auxiliary') seeks all auxiliary PO files,
round-robin, searching for a translated entry in some other language
having an `msgid' field identical as the one for the current entry.
The found PO file, if any, takes the place of the current PO file in
the display (its window gets on top).  Before doing so, the current PO
file is also made into an auxiliary file, if not already.  So, `a' in
this newly displayed PO file will seek another PO file, and so on, so
repeating `a' will eventually yield back the original PO file.

   The command `M-a' (`po-select-auxiliary') asks the translator for
her choice of a particular auxiliary file, with completion, and then
switches to that selected PO file.  The command also checks if the
selected file has an `msgid' field identical as the one for the current
entry, and if yes, this entry becomes current.  Otherwise, the cursor
of the selected file is left undisturbed.

   For all this to work fully, auxiliary PO files will have to be
normalized, in that way that `msgid' fields should be written _exactly_
the same way.  It is possible to write `msgid' fields in various ways
for representing the same string, different writing would break the
proper behaviour of the auxiliary file commands of PO mode.  This is not
expected to be much a problem in practice, as most existing PO files
have their `msgid' entries written by the same GNU `gettext' tools.

   However, PO files initially created by PO mode itself, while marking
strings in source files, are normalised differently.  So are PO files
resulting of the the `M-x normalize' command.  Until these
discrepancies between PO mode and other GNU `gettext' tools get fully
resolved, the translator should stay aware of normalisation issues.


File: gettext.info,  Node: Compendium,  Prev: Auxiliary,  Up: Updating

Using Translation Compendiums
=============================

   Compendiums are yet to be implemented.

   An incoming PO mode feature will let the translator maintain a
compendium of already achieved translations.  A "compendium" is a
special PO file containing a set of translations recurring in many
different packages.  The translator will be given commands for adding
entries to her compendium, and later initializing untranslated entries,
or updating already translated entries, from translations kept in the
compendium.  For this to work, however, the compendium would have to be
normalized.  *Note Normalizing::.


File: gettext.info,  Node: Binaries,  Next: Users,  Prev: Updating,  Up: Top

Producing Binary MO Files
*************************

* Menu:

* msgfmt Invocation::           Invoking the `msgfmt' Program
* MO Files::                    The Format of GNU MO Files


File: gettext.info,  Node: msgfmt Invocation,  Next: MO Files,  Prev: Binaries,  Up: Binaries

Invoking the `msgfmt' Program
=============================

     Usage: msgfmt [OPTION] FILENAME.po ...

`-a NUMBER'
`--alignment=NUMBER'
     Align strings to NUMBER bytes (default: 1).

`-h'
`--help'
     Display this help and exit.

`--no-hash'
     Binary file will not include the hash table.

`-o FILE'
`--output-file=FILE'
     Specify output file name as FILE.

`--strict'
     Direct the program to work strictly following the Uniforum/Sun
     implementation.  Currently this only affects the naming of the
     output file.  If this option is not given the name of the output
     file is the same as the domain name.  If the strict Uniforum mode
     is enabled the suffix `.mo' is added to the file name if it is not
     already present.

     We find this behaviour of Sun's implementation rather silly and so
     by default this mode is _not_ selected.

`-v'
`--verbose'
     Detect and diagnose input file anomalies which might represent
     translation errors.  The `msgid' and `msgstr' strings are studied
     and compared.  It is considered abnormal that one string starts or
     ends with a newline while the other does not.

     Also, if the string represents a format string used in a
     `printf'-like function both strings should have the same number of
     `%' format specifiers, with matching types.  If the flag
     `c-format' or `possible-c-format' appears in the special comment
     <#,> for this entry a check is performed.  For example, the check
     will diagnose using `%.*s' against `%s', or `%d' against `%s', or
     `%d' against `%x'.  It can even handle positional parameters.

     Normally the `xgettext' program automatically decides whether a
     string is a format string or not.  This algorithm is not perfect,
     though.  It might regard a string as a format string though it is
     not used in a `printf'-like function and so `msgfmt' might report
     errors where there are none.  Or the other way round: a string is
     not regarded as a format string but it is used in a `printf'-like
     function.

     So solve this problem the programmer can dictate the decision to
     the `xgettext' program (*note c-format::).  The translator should
     not consider removing the flag from the <#,> line.  This "fix"
     would be reversed again as soon as `msgmerge' is called the next
     time.

`-V'
`--version'
     Output version information and exit.

   If input file is `-', standard input is read.  If output file is
`-', output is written to standard output.


File: gettext.info,  Node: MO Files,  Prev: msgfmt Invocation,  Up: Binaries

The Format of GNU MO Files
==========================

   The format of the generated MO files is best described by a picture,
which appears below.

   The first two words serve the identification of the file.  The magic
number will always signal GNU MO files.  The number is stored in the
byte order of the generating machine, so the magic number really is two
numbers: `0x950412de' and `0xde120495'.  The second word describes the
current revision of the file format.  For now the revision is 0.  This
might change in future versions, and ensures that the readers of MO
files can distinguish new formats from old ones, so that both can be
handled correctly.  The version is kept separate from the magic number,
instead of using different magic numbers for different formats, mainly
because `/etc/magic' is not updated often.  It might be better to have
magic separated from internal format version identification.

   Follow a number of pointers to later tables in the file, allowing
for the extension of the prefix part of MO files without having to
recompile programs reading them.  This might become useful for later
inserting a few flag bits, indication about the charset used, new
tables, or other things.

   Then, at offset O and offset T in the picture, two tables of string
descriptors can be found.  In both tables, each string descriptor uses
two 32 bits integers, one for the string length, another for the offset
of the string in the MO file, counting in bytes from the start of the
file.  The first table contains descriptors for the original strings,
and is sorted so the original strings are in increasing lexicographical
order.  The second table contains descriptors for the translated
strings, and is parallel to the first table: to find the corresponding
translation one has to access the array slot in the second array with
the same index.

   Having the original strings sorted enables the use of simple binary
search, for when the MO file does not contain an hashing table, or for
when it is not practical to use the hashing table provided in the MO
file.  This also has another advantage, as the empty string in a PO
file GNU `gettext' is usually _translated_ into some system information
attached to that particular MO file, and the empty string necessarily
becomes the first in both the original and translated tables, making
the system information very easy to find.

   The size S of the hash table can be zero.  In this case, the hash
table itself is not contained in the MO file.  Some people might prefer
this because a precomputed hashing table takes disk space, and does not
win _that_ much speed.  The hash table contains indices to the sorted
array of strings in the MO file.  Conflict resolution is done by double
hashing.  The precise hashing algorithm used is fairly dependent of GNU
`gettext' code, and is not documented here.

   As for the strings themselves, they follow the hash file, and each
is terminated with a <NUL>, and this <NUL> is not counted in the length
which appears in the string descriptor.  The `msgfmt' program has an
option selecting the alignment for MO file strings.  With this option,
each string is separately aligned so it starts at an offset which is a
multiple of the alignment value.  On some RISC machines, a correct
alignment will speed things up.

   Plural forms are stored by letting the plural of the original string
follow the singular of the original string, separated through a <NUL>
byte.  The length which appears in the string descriptor includes both.
However, only the singular of the original string takes part in the
hash table lookup.  The plural variants of the translation are all
stored consecutively, separated through a <NUL> byte.  Here also, the
length in the string descriptor includes all of them.

   Nothing prevents a MO file from having embedded <NUL>s in strings.
However, the program interface currently used already presumes that
strings are <NUL> terminated, so embedded <NUL>s are somewhat useless.
But the MO file format is general enough so other interfaces would be
later possible, if for example, we ever want to implement wide
characters right in MO files, where <NUL> bytes may accidently appear.
(No, we don't want to have wide characters in MO files.  They would
make the file unnecessarily large, and the `wchar_t' type being
platform dependent, MO files would be platform dependent as well.)

   This particular issue has been strongly debated in the GNU `gettext'
development forum, and it is expectable that MO file format will evolve
or change over time.  It is even possible that many formats may later
be supported concurrently.  But surely, we have to start somewhere, and
the MO file format described here is a good start.  Nothing is cast in
concrete, and the format may later evolve fairly easily, so we should
feel comfortable with the current approach.

             byte
                  +------------------------------------------+
               0  | magic number = 0x950412de                |
                  |                                          |
               4  | file format revision = 0                 |
                  |                                          |
               8  | number of strings                        |  == N
                  |                                          |
              12  | offset of table with original strings    |  == O
                  |                                          |
              16  | offset of table with translation strings |  == T
                  |                                          |
              20  | size of hashing table                    |  == S
                  |                                          |
              24  | offset of hashing table                  |  == H
                  |                                          |
                  .                                          .
                  .    (possibly more entries later)         .
                  .                                          .
                  |                                          |
               O  | length & offset 0th string  ----------------.
           O + 8  | length & offset 1st string  ------------------.
                   ...                                    ...   | |
     O + ((N-1)*8)| length & offset (N-1)th string           |  | |
                  |                                          |  | |
               T  | length & offset 0th translation  ---------------.
           T + 8  | length & offset 1st translation  -----------------.
                   ...                                    ...   | | | |
     T + ((N-1)*8)| length & offset (N-1)th translation      |  | | | |
                  |                                          |  | | | |
               H  | start hash table                         |  | | | |
                   ...                                    ...   | | | |
       H + S * 4  | end hash table                           |  | | | |
                  |                                          |  | | | |
                  | NUL terminated 0th string  <----------------' | | |
                  |                                          |    | | |
                  | NUL terminated 1st string  <------------------' | |
                  |                                          |      | |
                   ...                                    ...       | |
                  |                                          |      | |
                  | NUL terminated 0th translation  <---------------' |
                  |                                          |        |
                  | NUL terminated 1st translation  <-----------------'
                  |                                          |
                   ...                                    ...
                  |                                          |
                  +------------------------------------------+


File: gettext.info,  Node: Users,  Next: Programmers,  Prev: Binaries,  Up: Top

The User's View
***************

   When GNU `gettext' will truly have reached its goal, average users
should feel some kind of astonished pleasure, seeing the effect of that
strange kind of magic that just makes their own native language appear
everywhere on their screens.  As for naive users, they would ideally
have no special pleasure about it, merely taking their own language for
_granted_, and becoming rather unhappy otherwise.

   So, let's try to describe here how we would like the magic to
operate, as we want the users' view to be the simplest, among all ways
one could look at GNU `gettext'.  All other software engineers:
programmers, translators, maintainers, should work together in such a
way that the magic becomes possible.  This is a long and progressive
undertaking, and information is available about the progress of the
Translation Project.

   When a package is distributed, there are two kinds of users:
"installers" who fetch the distribution, unpack it, configure it,
compile it and install it for themselves or others to use; and "end
users" that call programs of the package, once these have been
installed at their site.  GNU `gettext' is offering magic for both
installers and end users.

* Menu:

* Matrix::                      The Current `ABOUT-NLS' Matrix
* Installers::                  Magic for Installers
* End Users::                   Magic for End Users


File: gettext.info,  Node: Matrix,  Next: Installers,  Prev: Users,  Up: Users

The Current `ABOUT-NLS' Matrix
==============================

   Languages are not equally supported in all packages using GNU
`gettext'.  To know if some package uses GNU `gettext', one may check
the distribution for the `ABOUT-NLS' information file, for some `LL.po'
files, often kept together into some `po/' directory, or for an `intl/'
directory.  Internationalized packages have usually many `LL.po' files,
where LL represents the language.  *Note End Users:: for a complete
description of the format for LL.

   More generally, a matrix is available for showing the current state
of the Translation Project, listing which packages are prepared for
multi-lingual messages, and which languages are supported by each.
Because this information changes often, this matrix is not kept within
this GNU `gettext' manual.  This information is often found in file
`ABOUT-NLS' from various distributions, but is also as old as the
distribution itself.  A recent copy of this `ABOUT-NLS' file,
containing up-to-date information, should generally be found on the
Translation Project sites, and also on most GNU archive sites.


File: gettext.info,  Node: Installers,  Next: End Users,  Prev: Matrix,  Up: Users

Magic for Installers
====================

   By default, packages fully using GNU `gettext', internally, are
installed in such a way that they to allow translation of messages.  At
_configuration_ time, those packages should automatically detect
whether the underlying host system already provides the GNU `gettext'
functions.  If not, the GNU `gettext' library should be automatically
prepared and used.  Installers may use special options at configuration
time for changing this behavior.  The command `./configure
--with-included-gettext' bypasses system `gettext' to use the included
GNU `gettext' instead, while `./configure --disable-nls' produces
programs totally unable to translate messages.

   Internationalized packages have usually many `LL.po' files.  Unless
translations are disabled, all those available are installed together
with the package.  However, the environment variable `LINGUAS' may be
set, prior to configuration, to limit the installed set.  `LINGUAS'
should then contain a space separated list of two-letter codes, stating
which languages are allowed.


File: gettext.info,  Node: End Users,  Prev: Installers,  Up: Users

Magic for End Users
===================

   We consider here those packages using GNU `gettext' internally, and
for which the installers did not disable translation at _configure_
time.  Then, users only have to set the `LANG' environment variable to
the appropriate `LL_CC' combination prior to using the programs in the
package.  *Note Matrix::.  For example, let's presume a German site.
At the shell prompt, users merely have to execute `setenv LANG de_DE'
(in `csh') or `export LANG; LANG=de_DE' (in `sh').  They could even do
this from their `.login' or `.profile' file.


File: gettext.info,  Node: Programmers,  Next: Translators,  Prev: Users,  Up: Top

The Programmer's View
*********************

   One aim of the current message catalog implementation provided by
GNU `gettext' was to use the systems message catalog handling, if the
installer wishes to do so.  So we perhaps should first take a look at
the solutions we know about.  The people in the POSIX committee did not
manage to agree on one of the semi-official standards which we'll
describe below.  In fact they couldn't agree on anything, so they
decided only to include an example of an interface.  The major Unix
vendors are split in the usage of the two most important
specifications: X/Open's catgets vs. Uniforum's gettext interface.
We'll describe them both and later explain our solution of this dilemma.

* Menu:

* catgets::                     About `catgets'
* gettext::                     About `gettext'
* Comparison::                  Comparing the two interfaces
* Using libintl.a::             Using libintl.a in own programs
* gettext grok::                Being a `gettext' grok
* Temp Programmers::            Temporary Notes for the Programmers Chapter


File: gettext.info,  Node: catgets,  Next: gettext,  Prev: Programmers,  Up: Programmers

About `catgets'
===============

   The `catgets' implementation is defined in the X/Open Portability
Guide, Volume 3, XSI Supplementary Definitions, Chapter 5.  But the
process of creating this standard seemed to be too slow for some of the
Unix vendors so they created their implementations on preliminary
versions of the standard.  Of course this leads again to problems while
writing platform independent programs: even the usage of `catgets' does
not guarantee a unique interface.

   Another, personal comment on this that only a bunch of committee
members could have made this interface.  They never really tried to
program using this interface.  It is a fast, memory-saving
implementation, an user can happily live with it.  But programmers hate
it (at least me and some others do...)

   But we must not forget one point: after all the trouble with
transfering the rights on Unix(tm) they at last came to X/Open, the
very same who published this specification.  This leads me to making
the prediction that this interface will be in future Unix standards
(e.g. Spec1170) and therefore part of all Unix implementation
(implementations, which are _allowed_ to wear this name).

* Menu:

* Interface to catgets::        The interface
* Problems with catgets::       Problems with the `catgets' interface?!


File: gettext.info,  Node: Interface to catgets,  Next: Problems with catgets,  Prev: catgets,  Up: catgets

The Interface
-------------

   The interface to the `catgets' implementation consists of three
functions which correspond to those used in file access: `catopen' to
open the catalog for using, `catgets' for accessing the message tables,
and `catclose' for closing after work is done.  Prototypes for the
functions and the needed definitions are in the `<nl_types.h>' header
file.

   `catopen' is used like in this:

     nl_catd catd = catopen ("catalog_name", 0);

   The function takes as the argument the name of the catalog.  This
usual refers to the name of the program or the package.  The second
parameter is not further specified in the standard.  I don't even know
whether it is implemented consistently among various systems.  So the
common advice is to use `0' as the value.  The return value is a handle
to the message catalog, equivalent to handles to file returned by
`open'.

   This handle is of course used in the `catgets' function which can be
used like this:

     char *translation = catgets (catd, set_no, msg_id, "original string");

   The first parameter is this catalog descriptor.  The second parameter
specifies the set of messages in this catalog, in which the message
described by `msg_id' is obtained.  `catgets' therefore uses a
three-stage addressing:

     catalog name => set number => message ID => translation

   The fourth argument is not used to address the translation.  It is
given as a default value in case when one of the addressing stages
fail.  One important thing to remember is that although the return type
of catgets is `char *' the resulting string _must not_ be changed.  It
should better be `const char *', but the standard is published in 1988,
one year before ANSI C.

The last of these function functions is used and behaves as expected:

     catclose (catd);

   After this no `catgets' call using the descriptor is legal anymore.


File: gettext.info,  Node: Problems with catgets,  Prev: Interface to catgets,  Up: catgets

Problems with the `catgets' Interface?!
---------------------------------------

   Now that this description seemed to be really easy -- where are the
problem we speak of?  In fact the interface could be used in a
reasonable way, but constructing the message catalogs is a pain.  The
reason for this lies in the third argument of `catgets': the unique
message ID.  This has to be a numeric value for all messages in a single
set.  Perhaps you could imagine the problems keeping such a list while
changing the source code.  Add a new message here, remove one there.  Of
course there have been developed a lot of tools helping to organize this
chaos but one as the other fails in one aspect or the other.  We don't
want to say that the other approach has no problems but they are far
more easy to manage.

