# Used to modify the perl and test scripts
# so that "make check" works.

#Perl script specific changes.
# Change !/bin/sh to !/dev/env/DJDIR/bin/sh
# s/! *\/bin\/sh/\!\/dev\/env\/DJDIR\/bin\/sh/g

# We require the perl script to change the backward slashes to forward in $PWD.
s/\(my $prog =.*\)/\1 \
my $cwd = $ENV{PWD}; \
$cwd =\~ s\/\\\\\/\\\/\/g;/g

# Change the $prog: and $prog --help so that they show their full paths.
s/\$prog:/$cwd\/..\/..\/src\/$prog.exe:\1/g
s/\$prog --help/$cwd\/..\/..\/src\/$prog.exe --help/g

# Test script specific changes.
# Change to valid 8.3 filenames.
s/NN-strne-\([12]\)/NN\1-strne/g
s/N-strne-\([12]\)/N\1-strne/g
s/NN-streq-\([12]\)/NN\1q-stre/g
s/N-streq-\([12]\)/N\1q-stre/g
s/date2sec-/d2sec-/g
s/relative-\([12]\).X/relat-\1.X/g
s/\.saved-s/_saved-s/g

# We still have no perl programm that understands the "/dev/x" syntax
# so we must translate "/dev/x/" into "x:/"
# This is needed for the following files:
#   tests/basename/basic
#   tests/factor/basic
#   tests/seq/basic
/^d=\$srcdir\/\.\.$/ i\
srcdir=`echo "$srcdir" | sed "s,^/dev/\\([A-Za-z]\\)/,\\1:/,"`

# The raw-col-1 test does not work.
/^# .*`stty size'$/ i\
if test -n "$DJDIR"; then\
  echo "$0: cannot test \\`stty size' on DJGPP" >&2\
  exit 77\
fi
