@echo off
echo Configuring GNU gdbm for DJGPP v2.x...

Rem The SmallEnv tests protect against fixed and too small size
Rem of the environment in stock DOS shell.

Rem Find out if NLS is wanted or not
Rem and where the sources are.
Rem We always default to NLS support,
Rem and to in place configuration.
set ARGS=
set NLS=enabled
if not "%NLS%" == "enabled" goto SmallEnv
set XSRC=.
if not "%XSRC%" == "." goto SmallEnv

Rem Loop over all arguments.
Rem Special arguments are: NLS and XSRC.
Rem All other arguments are stored into ARGS.
:ArgLoop
set SPECIAL_ARG_SEEN=0
if not "%SPECIAL_ARG_SEEN%" == "0" goto SmallEnv
if not "%1" == "NLS" if not "%1" == "nls" if not "%1" == "NO-NLS" if not "%1" == "no-NLS" if not "%1" == "no-nls" goto SrcDirOpt
if "%1" == "no-nls" set NLS=disabled
if "%1" == "no-NLS" set NLS=disabled
if "%1" == "NO-NLS" set NLS=disabled
if not "%NLS%" == "disabled" goto SmallEnv
set SPECIAL_ARG_SEEN=1
if not "%SPECIAL_ARG_SEEN%" == "1" goto SmallEnv
shift
:SrcDirOpt
set SPECIAL_ARG_SEEN=0
if not "%SPECIAL_ARG_SEEN%" == "0" goto SmallEnv
echo %1 | grep -q "/"
if errorlevel 1 goto NextArg
set XSRC=%1
if not "%XSRC%" == "%1" goto SmallEnv
set SPECIAL_ARG_SEEN=1
if not "%SPECIAL_ARG_SEEN%" == "1" goto SmallEnv
:NextArg
if "%SPECIAL_ARG_SEEN%" == "0" set _ARGS=%ARGS% %1
if "%SPECIAL_ARG_SEEN%" == "0" if not "%_ARGS%" == "%ARGS% %1" goto SmallEnv
set ARGS=%_ARGS%
set _ARGS=
shift
if not "%1" == "" goto ArgLoop
set SPECIAL_ARG_SEEN=

if "%XSRC%" == "." goto InPlace

:NotInPlace
redir -e /dev/null update %XSRC%/configure.orig ./configure
test -f ./configure
if errorlevel 1 update %XSRC%/configure ./configure

:InPlace
Rem Update configuration files
echo Updating configuration scripts...
test -f ./configure.orig
if errorlevel 1 update configure configure.orig
sed -f %XSRC%/djgpp/config.sed configure.orig > configure
if errorlevel 1 goto SedError

Rem Make sure they have a config.site file
set CONFIG_SITE=%XSRC%/djgpp/config.site
if not "%CONFIG_SITE%" == "%XSRC%/djgpp/config.site" goto SmallEnv

Rem Make sure crucial file names are not munged by unpacking
test -f %XSRC%/autoconf.h.in
if not errorlevel 1 mv -f %XSRC%/autoconf.h.in %XSRC%/autoconf.h-in
test -f %XSRC%/po/Makefile.in.in
if not errorlevel 1 mv -f %XSRC%/po/Makefile.in.in %XSRC%/po/Makefile.in-in
test -f %XSRC%/po/Makefile.am.in
if not errorlevel 1 mv -f %XSRC%/po/Makefile.am.in %XSRC%/po/Makefile.am-in
test -f %XSRC%/gdbm.pr2
if not errorlevel 1 goto NoRen0
test -f %XSRC%/gdbm.proto2
if not errorlevel 1 mv -f %XSRC%/gdbm.proto2 %XSRC%/gdbm.pr2
:NoRen0

Rem This is required because DOS/Windows are case-insensitive
Rem to file names, and "make install" will do nothing if Make
Rem finds a file called `install'.
if exist INSTALL ren INSTALL INSTALL.txt

Rem Set HOSTNAME so it shows in config.status
if not "%HOSTNAME%" == "" goto hostdone
if "%windir%" == "" goto msdos
set OS=MS-Windows
if not "%OS%" == "MS-Windows" goto SmallEnv
goto haveos
:msdos
set OS=MS-DOS
if not "%OS%" == "MS-DOS" goto SmallEnv
:haveos
if not "%USERNAME%" == "" goto haveuname
if not "%USER%" == "" goto haveuser
echo No USERNAME and no USER found in the environment, using default values
set HOSTNAME=Unknown PC
if not "%HOSTNAME%" == "Unknown PC" goto SmallEnv
goto userdone
:haveuser
set HOSTNAME=%USER%'s PC
if not "%HOSTNAME%" == "%USER%'s PC" goto SmallEnv
goto userdone
:haveuname
set HOSTNAME=%USERNAME%'s PC
if not "%HOSTNAME%" == "%USERNAME%'s PC" goto SmallEnv
:userdone
set _HOSTNAME=%HOSTNAME%, %OS%
if not "%_HOSTNAME%" == "%HOSTNAME%, %OS%" goto SmallEnv
set HOSTNAME=%_HOSTNAME%
:hostdone
set _HOSTNAME=
set OS=

Rem install-sh is required by the configure script but clashes with the
Rem various Makefile install-foo targets, so we MUST have it before the
Rem script runs and rename it afterwards
test -f %XSRC%/install-sh
if not errorlevel 1 goto NoRen1
test -f %XSRC%/install-sh.sh
if not errorlevel 1 mv -f %XSRC%/install-sh.sh %XSRC%/install-sh
:NoRen1

if "%NLS%" == "disabled" goto WithoutNLS

:WithNLS
Rem Check for the needed libraries and binaries.
test -x /dev/env/DJDIR/bin/msgfmt.exe
if not errorlevel 0 goto MissingNLSTools
test -x /dev/env/DJDIR/bin/xgettext.exe
if not errorlevel 0 goto MissingNLSTools
test -f /dev/env/DJDIR/include/libcharset.h
if not errorlevel 0 goto MissingNLSTools
test -f /dev/env/DJDIR/lib/libcharset.a
if not errorlevel 0 goto MissingNLSTools
test -f /dev/env/DJDIR/include/iconv.h
if not errorlevel 0 goto MissingNLSTools
test -f /dev/env/DJDIR/lib/libiconv.a
if not errorlevel 0 goto MissingNLSTools
test -f /dev/env/DJDIR/include/libintl.h
if not errorlevel 0 goto MissingNLSTools
test -f /dev/env/DJDIR/lib/libintl.a
if not errorlevel 0 goto MissingNLSTools

Rem Recreate the files in the %XSRC%/po subdir with our ported tools.
redir -e /dev/null rm %XSRC%/po/*.gmo
redir -e /dev/null rm %XSRC%/po/gdbm.pot
redir -e /dev/null rm %XSRC%/po/cat-id-tbl.c
redir -e /dev/null rm %XSRC%/po/stamp-cat-id

Rem We prefer without-included-gettext because libintl.a from gettext package
Rem is the only one that is garanteed to have been ported to DJGPP.
echo Running the ./configure script...
sh ./configure --src=%XSRC% --enable-nls --without-included-gettext %ARGS%
if errorlevel 1 goto CfgError
goto MoveLibtool

:MissingNLSTools
echo Needed libs/tools for NLS not found. Configuring without NLS.
:WithoutNLS
echo Running the ./configure script...
sh ./configure --src=%XSRC% --disable-nls %ARGS%
if errorlevel 1 goto CfgError

:MoveLibtool
Rem The configure script generates the libtool script in the configure
Rem directory but the makefile expects it in the top srcdir.
if not "%XSRC%" =="." mv -f ./libtool "%XSRC%"/libtool
echo Done.
goto End

:SedError
echo ./configure script editing failed!
goto End

:CfgError
echo ./configure script exited abnormally!
goto End

:SmallEnv
echo Your environment size is too small.  Enlarge it and run me again.
echo Configuration NOT done!

:End
test -f %XSRC%/install-sh.sh
if not errorlevel 1 goto NoRen2
test -f %XSRC%/install-sh
if not errorlevel 1 mv -f %XSRC%/install-sh %XSRC%/install-sh.sh
:NoRen2
set ARGS=
set CONFIG_SITE=
set HOSTNAME=
set NLS=
set XSRC=
