#  This script only works in the ./djgpp directory.

export HOME=.
export PATH_SEPARATOR=:
export PATH_EXPAND=y
export TEST_FINDS_EXE=y
export LD=ld
export NM=nm
export LN_S="cp -p"
export GMSGFMT=${GMSGFMT='/dev/env/DJDIR/bin/msgfmt'}
export MSGFMT=${MSGFMT='/dev/env/DJDIR/bin/msgfmt'}
export MSGMERGE=${MSGMERGE='/dev/env/DJDIR/bin/msgmerge'}
export XGETTEXT=${XGETTEXT='/dev/env/DJDIR/bin/xgettext'}
export ac_cv_path_EMACS=${EMACS='/dev/env/DJDIR/gnu/emacs/bin/emacs'}
export ac_cv_path_M4=${M4='/dev/env/DJDIR/bin/m4'}
export ac_cv_path_GREP=${GREP='/dev/env/DJDIR/bin/grep'}
export ac_cv_path_EGREP=${EGREP='/dev/env/DJDIR/bin/egrep'}
export ac_cv_path_FGREP=${FGREP='/dev/env/DJDIR/bin/fgrep'}
export ac_cv_path_SED=${SED='/dev/env/DJDIR/bin/sed'}
export ac_cv_path_MAKEINFO=${MAKEINFO='/dev/env/DJDIR/bin/makeinfo'}
export ac_cv_path_INSTALL_INFO=${INSTALL_INFO='/dev/env/DJDIR/bin/install-info'}
export ac_cv_path_ROFF=${ROFF='/dev/env/DJDIR/bin/groff'}
export ac_cv_path_GROFF=${GROFF='/dev/env/DJDIR/bin/groff'}
export ac_cv_path_NROFF=${NROFF='/dev/env/DJDIR/bin/nroff'}
export ac_cv_path_PERL=${PERL='/dev/env/DJDIR/bin/perl'}
export ac_cv_path_mkdir=${MKDIR_P='/dev/env/DJDIR/bin/mkdir -p'}
export ac_cv_path_RM=${RM='/dev/env/DJDIR/bin/rm'}
export ac_cv_path_MV=${MV='/dev/env/DJDIR/bin/mv'}
export ac_cv_path_TAR=${TAR='/dev/env/DJDIR/bin/tar'}
export ac_cv_path_PR_PROGRAM=${PR='/dev/env/DJDIR/bin/pr'}
export ac_cv_path_ed_PROGRAM=${ED='/dev/env/DJDIR/bin/ed'}
export ac_cv_path_TEXI2DVI=${TEXI2DVI='texi2dvi'}
export ac_cv_path_TEXI2PDF=${TEXI2PDF='texi2pdf'}
export ac_cv_path_DVIPS=${DVIPS='dvips'}
export ac_cv_path_PS2PDF=${PS2PDF='ps2pdf'}
export ac_cv_path_TEST_SHELL=${TEST_SHELL='/dev/env/DJDIR/bin/bash'}
export ac_cv_path_MKTEMP=${MKTEMP='/dev/env/DJDIR/bin/mktemp'}
export ac_cv_prog_LN_S="cp -p"
export ac_cv_func_fork=no
export ac_cv_func_mkfifo=no
export ac_cv_func_mknod=no
export ac_cv_func_mmap=no
export ac_cv_func_pipe=no
export ac_cv_func_vfork=no

# Do not allow that the BFD's configure script determine the
# host dependant file_ptr a.k.a. off_t type as BFD_HOST_64_BIT.
# This is the case if ftello64 and fseeko64 are found.  But DJGPP
# does not provide the full set of 64 bit file functions required
# for a working 64 bit BFD.
export ac_cv_func_fseeko64=${ac_cv_func_fseeko64=no}
export ac_cv_func_ftello64=${ac_cv_func_ftello64=no}
export ac_cv_have_decl_fseeko64=${ac_cv_have_decl_fseeko64=no}
export ac_cv_have_decl_ftello64=${ac_cv_have_decl_ftello64=no}

# Ensure that always old GNU extern inline semantics is used
# (aka -fgnu89-inline) even if ISO C99 semantics has been specified.
export CFLAGS=${CFLAGS='-g -O2 -fgnu89-inline -march=i386 -mtune=i586'}

# DJGPP's implementation of printf survives out-of-memory conditions.
export gl_cv_func_printf_enomem='yes'

# Enable libiberty installation.
# Passing --enable-install-libiberty to the toplovel configure seems not to be enough.
export enable_install_libiberty=yes

# Select NLS support.
# NLS_SUPPORT='--enable-nls'
 NLS_SUPPORT='--disable-nls'

if [ "x${NLS_SUPPORT}" = "x--enable-nls" ]; then
  rm -vf ../bfd/po/*gmo
  rm -vf ../bfd/po/*pot
  rm -vf ../gdb/po/*gmo
  rm -vf ../gdb/po/*pot
  rm -vf ../opcodes/po/*gmo
  rm -vf ../opcodes/po/*pot
fi


#
#  1: Adjust the configure scripts.
#

cat > script.sed << EOF
# For some reason the function does not work with bash 2.05b.
/^func_lalib_p/,/^}$/ {
  /test/ i\\
    case \$1 in\\
    *.la | *.lo)
  /GREP/ {
    s/$/;;/
    a\\
    *) false;;\\
    esac
  }
}

# Use func_lalib_p instead of func_lalib_unsafe_p.
/func_lalib_unsafe_p[ 	][^(]/ s/_unsafe//

# Adjust temp directory.
/{TMPDIR-\/tmp}/ s|{TMPDIR-/tmp}|{TMPDIR-\${TMP-\${TEMP-.}}}|

# Remove -lc reference from the dependency_libs= line in .la files.
# This is unnecessary when linking with static  labraries and causes
# multiple symbol definitions that cannot be resolved when using DXE3 modules.
/^# Libraries that this one depends upon.$/,/^# Directory that this library needs to be installed in:$/ {
  /^# Directory that this library needs to be installed in:$/ {
    n
    a\\
	  sed "/^dependency_libs=/ s|[ 	]\\\\{1,\\\\}-lc| |"  \$output > fixed.sed && cp -vf fixed.sed \$output
  }
}

# The CR test for awk does not work for DJGPP.
/^ac_cs_awk_cr=/,/^$/ {
  /^fi$/ a\\
ac_cs_awk_cr=\$ac_cr
}

# AWK program above erroneously prepends '/' to C:/dos/paths
/# AWK program above erroneously prepends/,/esac/ {
  s/mingw/*djgpp* | mingw/
}

# Force the test for 'ln -s' to report 'cp -pf'.
/as_ln_s='ln -s'/ s/ln -s/cp -pf/

# Set the right shell for libtool
/^LIBTOOL=.*libtool'$/ s/".*"/'\$(SHELL) '/

# Adjust the config.site path for the case
# of recursive called configure scripts
/^if test "\$no_recursion" != yes; then/ a\\
  djgpp_config_site=\$CONFIG_SITE
/case \$srcdir in/,/esac/ {
  / # Relative name.$/ a\\
export CONFIG_SITE=\$ac_top_build_prefix\$djgpp_config_site
}

# DJGPP specific adjustments of the compile-time system search path for libraries.
/^[ 	]*lt_search_path_spec=.*-print-search-dirs/ s,\`\$, -e \\"s%[A-z]:[\\\\\\\\/]djgpp-[0-9].[0-9][0-9][\\\\\\\\/]%/dev/env/DJDIR/%g\\"&,

# Fix realpath check.  DJGPP always prepends a drive letter.
/checking whether realpath works/,/^_ACEOF$/ {
  /name && \*name == '\/'/ s/\*name/name[2]/
}

# We have an emulation of nl_langinfo in go32-nat.c that supports CODESET.
/^for ac_var in \\\$ac_precious_vars; do/i\\
am_cv_langinfo_codeset=yes\\
bash_cv_langinfo_codeset=yes\\
ac_cv_header_nl_types_h=yes

# Add pdcurses to the search list.
/for ac_lib in.*ncurses cursesX curses/ s/ncurses/pdcurses &/
EOF


for file in ../ltmain.sh ../configure ../bfd/configure ../etc/configure ../gdb/configure ../opcodes/configure ../readline/configure; do
  if test ! -f ${file}.orig; then
    cp -vf ${file} ${file}.orig
    touch ${file}.orig -r ${file}
  fi
  sed -f ./script.sed ${file}.orig > ./file.out
  update ./file.out ${file}
  touch ${file} -r ${file}.orig
done
rm -vf ./file.out ./script.sed



#
#  2: Adjust the Makefile.ins and other files.
#

cat > script.sed << EOF
# Fix for ./gdb/data-directory/Makefile.in
/^stamp-syscalls:/ s/\\\$(SYSCALLS_FILES)/#&/
/^stamp-python:/ s/\\\$(PYTHON_FILES)/#&/
/^stamp-system-gdbinit:/ s/\\\$(SYSTEM_GDBINIT_FILES)/#&/

# Fix for ./bfd/Makefile.in
# Force the regenaration of libcoff.h
# to define obj_go32
/^\\\$(BFD_H):/ s/:/: stmp-lcoff-h/

# Fix for ./readline/Makefile.in
# Force the compilation of readline/tminit.c
/^CSOURCES = \\\$(srcdir)\\/readline.c/ s|=|= \\\$(srcdir)/tminit.c|
/^OBJECTS = readline.o/ s/=/= tminit.o/
/^readline.o: \\\$(srcdir)\\/readline.c/ {
i\\
tminit.o: \\\$(srcdir)/tminit.c
s|$| \\\$(srcdir)/tminit.c|
}

# For html docs.
/^MAKEINFOHTML[ 	]*=/ s/$/ --no-split/
s/--split-size=5000000/--no-split/g

# Fixes for ./libiberty/Makefile.in
# ps support for libiberty docs.
/dvi-subdir[ 	]\\{1,\\}pdf-subdir/ s/dvi-subdir[ 	]\\{1,\\}pdf-subdir/& ps-subdir/

/^LIBIBERTY_PDFFILES[ 	]*=/ i\\
LIBIBERTY_PSFILES = libiberty.ps\\
\\
ps: \\\$(LIBIBERTY_PSFILES) ps-subdir\\


/^libiberty.pdf[ 	]*:/ i\\
libiberty.ps : ./libiberty.dvi \\\$(srcdir)/libiberty.texi \\\$(TEXISRC)\\
	dvips -o ./libiberty.ps ./libiberty.dvi\\

# Enable libiberty installation.
# Passing --enable-install-libiberty to the toplovel configure seems not to be enough.
s/@target_header_dir@/libiberty/

# Fixes for ./etc/Makefile.in.
/^HTMLFILES =.*configure.html$/ i\\
PSFILES = standards.ps configure.ps
/epstopdf/ s/[ 	]\\{1,\\}-outfile/ --outfile/

# Fixes for ./gdb/Makefile
/^COMMON_OBS[ 	]*=.*(YYOBJ).*$/,/^$/ {
  /version.o/ i\\
	vsnprntf.o \\\\
}
/^# gdb\\/cli\\/ dependencies/ i\\
# gdb/djgpp/ dependencies\\
#\\
\\
vsnprntf.o: \\\$(srcdir)/djgpp/vsnprntf.c\\
	\\\$(COMPILE) \\\$(srcdir)/djgpp/vsnprntf.c\\
	\\\$(POSTCOMPILE)\\
\\
#

# Fixes for ./gdb/doc/Makefile
# For html docs.
/^MAKEHTML[ 	]*=/ s/$/ --no-split/
EOF


for file in ./../gdb/Makefile.in ./../gdb/data-directory/Makefile.in ./../bfd/Makefile.in ./../bfd/doc/Makefile.in ./../gdb/doc/Makefile.in ./../libiberty/Makefile.in ./../etc/Makefile.in ./../readline/Makefile.in; do
  if test ! -f ${file}.orig; then
    cp -vf ${file} ${file}.orig
    touch ${file}.orig -r ${file}
  fi
  sed -f ./script.sed ${file}.orig > ./file.out
  update ./file.out ${file}
  touch ${file} -r ${file}.orig
done

rm -vf ./file.out ./script.sed



#
#  3: Adjust the config.in headers.
#

cat > script.sed << EOF
# DJGPP 2.03 needs the snprintf prototype.
/^#undef HAVE_DECL_SNPRINTF$/ c\\
#include <sys/version.h>\\
#if __DJGPP__ == 2 && __DJGPP_MINOR__ < 4\\
# define HAVE_DECL_SNPRINTF 0\\
#else\\
#undef HAVE_DECL_SNPRINTF\\
#endif

$ a\\
#ifdef __DJGPP__\\
# if defined (__GNUC__) && (__GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 8))\\
#  define __gnuc_extension__  __extension__\\
# else\\
#  define __gnuc_extension__\\
# endif\\
\\
# undef  IS_SLASH\\
# define IS_SLASH(c)                ((c) == '/' || (c) == '\\\\\\\\')\\
# undef  IS_DIRECTORY_SEPARATOR\\
# define IS_DIRECTORY_SEPARATOR(c)  (IS_SLASH(c) || (c) == ':')\\
\\
# include <libc/unconst.h>\\
# define STRIP_FULL_PATH_AND_EXTENSION(file_name)   \\\\\\
  (__gnuc_extension__                               \\\\\\
    ({                                              \\\\\\
       char *_dst, *_src;                           \\\\\\
       _dst = _src = unconst((file_name), char *);  \\\\\\
       while (*_src++)                              \\\\\\
         ;                                          \\\\\\
       while ((_src - _dst) && (*--_src != '.'))    \\\\\\
         ;                                          \\\\\\
       for (*_src = '\\\\0'; (_src - _dst); _src--)    \\\\\\
         if (IS_DIRECTORY_SEPARATOR(*_src))         \\\\\\
           break;                                   \\\\\\
       if (_src - _dst)                             \\\\\\
         while ((*_dst++ = *++_src))                \\\\\\
           ;                                        \\\\\\
       (file_name);                                 \\\\\\
    })                                              \\\\\\
  )\\
#else\\
# define STRIP_FULL_PATH_AND_EXTENSION(file_name)  (file_name)\\
#endif
EOF


for file in ../bfd/config.in ../gdb/config.in ../libiberty/config.in; do
  if test ! -f ${file}.orig; then
    cp -vf ${file} ${file}.orig
    touch ${file}.orig -r ${file}
  fi
  sed -f ./script.sed ${file}.orig > ./file.out
  update ./file.out ${file}
  touch ${file} -r ${file}.orig
done
rm -vf ./file.out ./script.sed


cat > script.sed << EOF
# DJGPP 2.03 needs the snprintf prototype.
$ a\\
\\
#ifdef __DJGPP__\\
# include <sys/version.h>\\
# if __DJGPP__ == 2 && __DJGPP_MINOR__ < 4\\
/* Define to 1 if you have the declaration of snprintf, and to 0 if you\\
   do not. */\\
#  define HAVE_DECL_SNPRINTF 0\\
# endif\\
\\
# if defined (__GNUC__) && (__GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 8))\\
#  define __gnuc_extension__  __extension__\\
# else\\
#  define __gnuc_extension__\\
# endif\\
\\
# undef  IS_SLASH\\
# define IS_SLASH(c)                ((c) == '/' || (c) == '\\\\\\\\')\\
# undef  IS_DIRECTORY_SEPARATOR\\
# define IS_DIRECTORY_SEPARATOR(c)  (IS_SLASH(c) || (c) == ':')\\
\\
# include <libc/unconst.h>\\
# define STRIP_FULL_PATH_AND_EXTENSION(file_name)   \\\\\\
  (__gnuc_extension__                               \\\\\\
    ({                                              \\\\\\
       char *_dst, *_src;                           \\\\\\
       _dst = _src = unconst((file_name), char *);  \\\\\\
       while (*_src++)                              \\\\\\
         ;                                          \\\\\\
       while ((_src - _dst) && (*--_src != '.'))    \\\\\\
         ;                                          \\\\\\
       for (*_src = '\\\\0'; (_src - _dst); _src--)    \\\\\\
         if (IS_DIRECTORY_SEPARATOR(*_src))         \\\\\\
           break;                                   \\\\\\
       if (_src - _dst)                             \\\\\\
         while ((*_dst++ = *++_src))                \\\\\\
           ;                                        \\\\\\
       (file_name);                                 \\\\\\
    })                                              \\\\\\
  )\\
#else\\
# define STRIP_FULL_PATH_AND_EXTENSION(file_name)  (file_name)\\
#endif
EOF


for file in ../libdecnumber/config.in ../opcodes/config.in; do
  if test ! -f ${file}.orig; then
    cp -vf ${file} ${file}.orig
    touch ${file}.orig -r ${file}
  fi
  sed -f ./script.sed ${file}.orig > ./file.out
  update ./file.out ${file}
  touch ${file} -r ${file}.orig
done
rm -vf ./file.out ./script.sed



#
#  4: Configure and build the libs and programs.
#

touch start_build.txt

echo
echo Configuring the progs and libs.
echo See build_log.txt file for output.


echo Using: > build_log.txt
gcc --version >> build_log.txt
as --version >> build_log.txt
echo >> build_log.txt
ld --version >> build_log.txt
echo >> build_log.txt
echo >> build_log.txt
echo >> build_log.txt

echo Configuring the progs and libs for DJGPP. >> build_log.txt
echo >> build_log.txt

# Set to yes if you want TUI support.
# BUILD_WITH_TUI_SUPPORT=yes
BUILD_WITH_TUI_SUPPORT=no
if [ "x${BUILD_WITH_TUI_SUPPORT}" = "xyes" ]; then
# configuring the TUI support version.
../configure  --disable-dependency-tracking ${NLS_SUPPORT} \
              --with-mpc --with-mpfr --with-gmp --with-curses --enable-tui \
              --enable-install-bfd --enable-install-libiberty \
              --enable-build-warnings=-Wimplicit,-Wcomment,-Wformat,-Wparentheses,-Wpointer-arith >> build_log.txt  2>&1
else
# configuring without TUI support.
../configure  --disable-dependency-tracking ${NLS_SUPPORT} \
              --with-mpc --with-mpfr --with-gmp --without-curses --disable-tui \
              --enable-install-bfd --enable-install-libiberty \
              --enable-build-warnings=-Wimplicit,-Wcomment,-Wformat,-Wparentheses,-Wpointer-arith >> build_log.txt  2>&1
fi
echo >> build_log.txt
echo ################################################################################ >> build_log.txt
echo >> build_log.txt


echo
echo Building the progs and libs.
echo See build_log.txt file for output.
echo Building the progs and libs for DJGPP. >> build_log.txt
echo >> build_log.txt
make >> build_log.txt  2>&1

touch stop_build.txt
