#  This script only works in the ./djgpp directory.

export HOME=.
export PATH_SEPARATOR=:
export PATH_EXPAND=y
export TEST_FINDS_EXE=y
export LD=ld
export NM=nm
export LN_S="cp -p"
export ac_cv_prog_LN_S="cp -p"
export ac_cv_func_fork=no
export ac_cv_func_mkfifo=no
export ac_cv_func_mknod=no
export ac_cv_func_mmap=no
export ac_cv_func_pipe=no
export ac_cv_func_vfork=no

# Do not allow that the BFD's configure script determine the
# host dependant file_ptr a.k.a. off_t type as BFD_HOST_64_BIT.
# This is the case if ftello64 and fseeko64 are found.  But DJGPP
# does not provide the full set of 64 bit file functions required
# for a working 64 bit BFD.
export ac_cv_func_fseeko64=${ac_cv_func_fseeko64=no}
export ac_cv_func_ftello64=${ac_cv_func_ftello64=no}
export ac_cv_have_decl_fseeko64=${ac_cv_have_decl_fseeko64=no}
export ac_cv_have_decl_ftello64=${ac_cv_have_decl_ftello64=no}



#
#  1: Adjust the configure scripts.
#

cat > script.sed << EOF
# For some reason the function does not work with bash 2.05b.
/^func_lalib_p/,/^}$/ {
  /test/ i\\
    case \$1 in\\
    *.la | *.lo)
  /GREP/ {
    s/$/;;/
    a\\
    *) false;;\\
    esac
  }
}

# The CR test for awk does not work for DJGPP.
/^ac_cs_awk_cr=/,/^$/ {
  /^fi$/ a\\
ac_cs_awk_cr=\$ac_cr
}

# AWK program above erroneously prepends '/' to C:/dos/paths
/# AWK program above erroneously prepends/,/esac/ {
  s/mingw/*djgpp* | mingw/
}

# Force the test for 'ln -s' to report 'cp -pf'.
/as_ln_s='ln -s'/ s/ln -s/cp -pf/

# We have an emulation of nl_langinfo in go32-nat.c that supports CODESET.
/^for ac_var in \\\$ac_precious_vars; do/i\\
am_cv_langinfo_codeset=yes\\
bash_cv_langinfo_codeset=yes\\
ac_cv_header_nl_types_h=yes

# Add pdcurses to the search list.
/for ac_lib in.*ncurses cursesX curses/ s/ncurses/pdcurses &/
EOF


for file in ../ltmain.sh ../configure ../bfd/configure ../etc/configure ../gdb/configure ../opcodes/configure ../readline/configure; do
  if test ! -f ${file}.orig; then
    cp -vf ${file} ${file}.orig
    touch ${file}.orig -r ${file}
  fi
  sed -f ./script.sed ${file}.orig > ./file.out
  update ./file.out ${file}
  touch ${file} -r ${file}.orig
done
rm -vf ./file.out ./script.sed



#
#  2: Adjust the Makefile.ins and other files.
#

cat > script.sed << EOF
# Fix for ./gdb/data-directory/Makefile.in
/^stamp-syscalls:/ s/\\\$(SYSCALLS_FILES)/#&/

# Fix for ./bfd/Makefile.in
# Force the regenaration of libcoff.h
# to define obj_go32
/^\\\$(BFD_H):/ s/:/: stmp-lcoff-h/

# Fix for ./readline/Makefile.in
# Force the compilation of readline/tminit.c
/^CSOURCES = \\\$(srcdir)\\/readline.c/ s|=|= \\\$(srcdir)/tminit.c|
/^OBJECTS = readline.o/ s/=/= tminit.o/
/^readline.o: \\\$(srcdir)\\/readline.c/ {
i\\
tminit.o: \\\$(srcdir)/tminit.c
s|$| \\\$(srcdir)/tminit.c|
}

# For html docs.
/^MAKEINFOHTML[ 	]*=/ s/=/& --no-split/

# ps support for libiberty docs.
/dvi-subdir[ 	]\\{1,\\}pdf-subdir/ s/dvi-subdir[ 	]\\{1,\\}pdf-subdir/& ps-subdir/

/^LIBIBERTY_PDFFILES[ 	]*=/ i\\
LIBIBERTY_PSFILES = libiberty.ps\\
\\
ps: \\\$(LIBIBERTY_PSFILES) ps-subdir\\


/^libiberty.pdf[ 	]*:/ i\\
libiberty.ps : ./libiberty.dvi \\\$(srcdir)/libiberty.texi \\\$(TEXISRC)\\
	dvips -o ./libiberty.ps ./libiberty.dvi\\


# Fix ./etc Makefile.in.
/epstopdf/ s/[ 	]\\{1,\\}-outfile/ --outfile/
EOF


for file in ./../gdb/data-directory/Makefile.in ./../bfd/Makefile.in ./../bfd/doc/Makefile.in ./../gdb/doc/Makefile.in ./../libiberty/Makefile.in ./../etc/Makefile.in ./../readline/Makefile.in; do
  if test ! -f ${file}.orig; then
    cp -vf ${file} ${file}.orig
    touch ${file}.orig -r ${file}
  fi
  sed -f ./script.sed ${file}.orig > ./file.out
  update ./file.out ${file}
  touch ${file} -r ${file}.orig
done
rm -vf ./file.out ./script.sed



#
#  3: Adjust the config.in headers.
#

cat > script.sed << EOF
# DJGPP 2.03 needs the snprintf prototype.
/^#undef HAVE_DECL_SNPRINTF$/ c\\
#include <sys/version.h>\\
#if __DJGPP__ == 2 && __DJGPP_MINOR__ < 4\\
# define HAVE_DECL_SNPRINTF 0\\
#else\\
#undef HAVE_DECL_SNPRINTF\\
#endif
EOF


for file in ../bfd/config.in ../gdb/config.in ../libiberty/config.in; do
  if test ! -f ${file}.orig; then
    cp -vf ${file} ${file}.orig
    touch ${file}.orig -r ${file}
  fi
  sed -f ./script.sed ${file}.orig > ./file.out
  update ./file.out ${file}
  touch ${file} -r ${file}.orig
done
rm -vf ./file.out ./script.sed


cat > script.sed << EOF
# DJGPP 2.03 needs the snprintf prototype.
$ a\\
\\
#include <sys/version.h>\\
#if __DJGPP__ == 2 && __DJGPP_MINOR__ < 4\\
/* Define to 1 if you have the declaration of snprintf, and to 0 if you\\
   do not. */\\
# define HAVE_DECL_SNPRINTF 0\\
#endif
EOF


for file in ../libdecnumber/config.in ../opcodes/config.in; do
  if test ! -f ${file}.orig; then
    cp -vf ${file} ${file}.orig
    touch ${file}.orig -r ${file}
  fi
  sed -f ./script.sed ${file}.orig > ./file.out
  update ./file.out ${file}
  touch ${file} -r ${file}.orig
done
rm -vf ./file.out ./script.sed



#
#  4: Configure and build the libs and programs.
#

touch start_build.txt

echo
echo Configuring the progs and libs.
echo See build_log.txt file for output.


echo Using: > build_log.txt
gcc --version >> build_log.txt
as --version >> build_log.txt
echo >> build_log.txt
ld --version >> build_log.txt
echo >> build_log.txt
echo >> build_log.txt
echo >> build_log.txt

echo Configuring the progs and libs for DJGPP. >> build_log.txt
echo >>build_log.txt

# configuring the TUI support version.
../configure  --disable-dependency-tracking --disable-nls \
              --with-mpc --with-mpfr --with-gmp --with-curses --enable-tui \
              --enable-install-bfd --enable-install-libiberty \
              --enable-build-warnings=-Wimplicit,-Wcomment,-Wformat,-Wparentheses,-Wpointer-arith >> build_log.txt  2>&1

# configuring without TUI support.
# ../configure  --disable-dependency-tracking --disable-nls \
#               --with-mpc --with-mpfr --with-gmp --without-curses --disable-tui \
#               --enable-install-bfd --enable-install-libiberty \
#               --enable-build-warnings=-Wimplicit,-Wcomment,-Wformat,-Wparentheses,-Wpointer-arith >> build_log.txt  2>&1

echo >> build_log.txt
echo ####################################################### >> build_log.txt
echo >> build_log.txt


echo
echo Building the progs and libs.
echo See build_log.txt file for output.
echo Building the progs and libs for DJGPP. >> build_log.txt
echo >> build_log.txt
make >> build_log.txt  2>&1

touch stop_build.txt
