#  This script only works in the ./djgpp directory.

export HOME=.
export PATH_SEPARATOR=:
export PATH_EXPAND=y
export TEST_FINDS_EXE=y
export LD=ld
export NM=nm
export LN_S="cp -p"
export ac_cv_prog_LN_S="cp -p"
export ac_cv_func_fork=no
export ac_cv_func_mkfifo=no
export ac_cv_func_mknod=no
export ac_cv_func_mmap=no
export ac_cv_func_pipe=no
export ac_cv_func_vfork=no



#
#  1: Adjust the configure scripts.
#

cat > script.sed << EOF
# For some reason the function does not work with bash 2.05b.
/^func_lalib_p/,/^}$/ {
  /test/ i\\
    case \$1 in\\
    *.la | *.lo)
  /GREP/ {
    s/$/;;/
    a\\
    *) false;;\\
    esac
  }
}

# The CR test for awk does not work for DJGPP.
/^ac_cs_awk_cr=/,/^$/ {
  /^fi$/ a\\
ac_cs_awk_cr=\$ac_cr
}

# AWK program above erroneously prepends '/' to C:/dos/paths
/# AWK program above erroneously prepends/,/esac/ {
  s/mingw/*djgpp* | mingw/
}

# Force the test for 'ln -s' to report 'cp -pf'.
/as_ln_s='ln -s'/ s/ln -s/cp -pf/

# We have an emulation of nl_langinfo in go32-nat.c that supports CODESET.
/^for ac_var in \\\$ac_precious_vars; do/i\\
am_cv_langinfo_codeset=yes\\
bash_cv_langinfo_codeset=yes\\
ac_cv_header_nl_types_h=yes

# Add pdcurses to the search list.
/for ac_lib in.*ncurses cursesX curses/ s/ncurses/pdcurses &/
EOF


for file in ../ltmain.sh ../configure ../bfd/configure ../etc/configure ../gdb/configure ../opcodes/configure ../readline/configure; do
  if test ! -f ${file}.orig; then
    cp -vf ${file} ${file}.orig
    touch ${file}.orig -r ${file}
  fi
  sed -f ./script.sed ${file}.orig > ./file.out
  update ./file.out ${file}
  touch ${file} -r ${file}.orig
done
rm -vf ./file.out ./script.sed



#
#  3: Adjust the Makefile.in and other files.
#

cat > script.sed << EOF
# Fix for ./gdb/data-directory/Makefile.in
/^stamp-syscalls:/ s/\\\$(SYSCALLS_FILES)/#&/

# Force the regenaration of libcoff.h
# to define obj_go32
/^\\\$(BFD_H):/ s/:/: stmp-lcoff-h/
EOF


for file in ./../gdb/data-directory/Makefile.in ./../bfd/Makefile.in; do
  if test ! -f ${file}.orig; then
    cp -vf ${file} ${file}.orig
    touch ${file}.orig -r ${file}
  fi
  sed -f ./script.sed ${file}.orig > ./file.out
  update ./file.out ${file}
  touch ${file} -r ${file}.orig
done
rm -vf ./file.out ./script.sed


#
#  4: Configure and build the libs and programs.
#

echo
echo Configuring the progs and libs.
echo See log.txt file for output.
echo Configuring the progs and libs for DJGPP. > log.txt
echo >>log.txt

# configuring the TUI support version.
redir -eo  ../configure  --disable-dependency-tracking --disable-nls --with-mpc --with-mpfr --with-gmp --with-curses --enable-tui \
                         --enable-build-warnings=-Wimplicit,-Wcomment,-Wformat,-Wparentheses,-Wpointer-arith >> log.txt

# configuring without TUI support.
# redir -eo  ../configure  --disable-dependency-tracking --disable-nls --with-mpc --with-mpfr --with-gmp --without-curses --disable-tui \
#                          --enable-build-warnings=-Wimplicit,-Wcomment,-Wformat,-Wparentheses,-Wpointer-arith >> log.txt

echo >>log.txt
echo #######################################################>>log.txt
echo >>log.txt


echo
echo Building the progs and libs.
echo See log.txt file for output.
echo Building the progs and libs for DJGPP. >> log.txt
echo >>log.txt
redir -eo  make >> log.txt
