This is ./gdb.info, produced by makeinfo version 4.0b from gdb.texinfo.

INFO-DIR-SECTION Programming & development tools.
START-INFO-DIR-ENTRY
* Gdb: (gdb).                     The GNU debugger.
END-INFO-DIR-ENTRY

   This file documents the GNU debugger GDB.

   This is the Ninth Edition, January 2002, of `Debugging with GDB: the
GNU Source-Level Debugger' for GDB Version 5.1.1.

   Copyright (C) 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996,
1998,
1999, 2000, 2001, 2002 Free Software Foundation, Inc.

   Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.1 or
any later version published by the Free Software Foundation; with the
Invariant Sections being "Free Software" and "Free Software Needs Free
Documentation", with the Front-Cover Texts being "A GNU Manual," and
with the Back-Cover Texts as in (a) below.

   (a) The Free Software Foundation's Back-Cover Text is: "You have
freedom to copy and modify this GNU Manual, like GNU software.  Copies
published by the Free Software Foundation raise funds for GNU
development."


File: gdb.info,  Node: Disabling,  Next: Conditions,  Prev: Delete Breaks,  Up: Breakpoints

Disabling breakpoints
---------------------

   Rather than deleting a breakpoint, watchpoint, or catchpoint, you
might prefer to "disable" it.  This makes the breakpoint inoperative as
if it had been deleted, but remembers the information on the breakpoint
so that you can "enable" it again later.

   You disable and enable breakpoints, watchpoints, and catchpoints with
the `enable' and `disable' commands, optionally specifying one or more
breakpoint numbers as arguments.  Use `info break' or `info watch' to
print a list of breakpoints, watchpoints, and catchpoints if you do not
know which numbers to use.

   A breakpoint, watchpoint, or catchpoint can have any of four
different states of enablement:

   * Enabled.  The breakpoint stops your program.  A breakpoint set
     with the `break' command starts out in this state.

   * Disabled.  The breakpoint has no effect on your program.

   * Enabled once.  The breakpoint stops your program, but then becomes
     disabled.

   * Enabled for deletion.  The breakpoint stops your program, but
     immediately after it does so it is deleted permanently.  A
     breakpoint set with the `tbreak' command starts out in this state.

   You can use the following commands to enable or disable breakpoints,
watchpoints, and catchpoints:

`disable [breakpoints] [RANGE...]'
     Disable the specified breakpoints--or all breakpoints, if none are
     listed.  A disabled breakpoint has no effect but is not forgotten.
     All options such as ignore-counts, conditions and commands are
     remembered in case the breakpoint is enabled again later.  You may
     abbreviate `disable' as `dis'.

`enable [breakpoints] [RANGE...]'
     Enable the specified breakpoints (or all defined breakpoints).
     They become effective once again in stopping your program.

`enable [breakpoints] once RANGE...'
     Enable the specified breakpoints temporarily.  GDB disables any of
     these breakpoints immediately after stopping your program.

`enable [breakpoints] delete RANGE...'
     Enable the specified breakpoints to work once, then die.  GDB
     deletes any of these breakpoints as soon as your program stops
     there.

   Except for a breakpoint set with `tbreak' (*note Setting
breakpoints: Set Breaks.), breakpoints that you set are initially
enabled; subsequently, they become disabled or enabled only when you
use one of the commands above.  (The command `until' can set and delete
a breakpoint of its own, but it does not change the state of your other
breakpoints; see *Note Continuing and stepping: Continuing and
Stepping.)


File: gdb.info,  Node: Conditions,  Next: Break Commands,  Prev: Disabling,  Up: Breakpoints

Break conditions
----------------

   The simplest sort of breakpoint breaks every time your program
reaches a specified place.  You can also specify a "condition" for a
breakpoint.  A condition is just a Boolean expression in your
programming language (*note Expressions: Expressions.).  A breakpoint
with a condition evaluates the expression each time your program
reaches it, and your program stops only if the condition is _true_.

   This is the converse of using assertions for program validation; in
that situation, you want to stop when the assertion is violated--that
is, when the condition is false.  In C, if you want to test an
assertion expressed by the condition ASSERT, you should set the
condition `! ASSERT' on the appropriate breakpoint.

   Conditions are also accepted for watchpoints; you may not need them,
since a watchpoint is inspecting the value of an expression anyhow--but
it might be simpler, say, to just set a watchpoint on a variable name,
and specify a condition that tests whether the new value is an
interesting one.

   Break conditions can have side effects, and may even call functions
in your program.  This can be useful, for example, to activate functions
that log program progress, or to use your own print functions to format
special data structures. The effects are completely predictable unless
there is another enabled breakpoint at the same address.  (In that
case, GDB might see the other breakpoint first and stop your program
without checking the condition of this one.)  Note that breakpoint
commands are usually more convenient and flexible than break conditions
for the purpose of performing side effects when a breakpoint is reached
(*note Breakpoint command lists: Break Commands.).

   Break conditions can be specified when a breakpoint is set, by using
`if' in the arguments to the `break' command.  *Note Setting
breakpoints: Set Breaks.  They can also be changed at any time with the
`condition' command.

   You can also use the `if' keyword with the `watch' command.  The
`catch' command does not recognize the `if' keyword; `condition' is the
only way to impose a further condition on a catchpoint.

`condition BNUM EXPRESSION'
     Specify EXPRESSION as the break condition for breakpoint,
     watchpoint, or catchpoint number BNUM.  After you set a condition,
     breakpoint BNUM stops your program only if the value of EXPRESSION
     is true (nonzero, in C).  When you use `condition', GDB checks
     EXPRESSION immediately for syntactic correctness, and to determine
     whether symbols in it have referents in the context of your
     breakpoint.  If EXPRESSION uses symbols not referenced in the
     context of the breakpoint, GDB prints an error message:

          No symbol "foo" in current context.

     GDB does not actually evaluate EXPRESSION at the time the
     `condition' command (or a command that sets a breakpoint with a
     condition, like `break if ...') is given, however.  *Note
     Expressions: Expressions.

`condition BNUM'
     Remove the condition from breakpoint number BNUM.  It becomes an
     ordinary unconditional breakpoint.

   A special case of a breakpoint condition is to stop only when the
breakpoint has been reached a certain number of times.  This is so
useful that there is a special way to do it, using the "ignore count"
of the breakpoint.  Every breakpoint has an ignore count, which is an
integer.  Most of the time, the ignore count is zero, and therefore has
no effect.  But if your program reaches a breakpoint whose ignore count
is positive, then instead of stopping, it just decrements the ignore
count by one and continues.  As a result, if the ignore count value is
N, the breakpoint does not stop the next N times your program reaches
it.

`ignore BNUM COUNT'
     Set the ignore count of breakpoint number BNUM to COUNT.  The next
     COUNT times the breakpoint is reached, your program's execution
     does not stop; other than to decrement the ignore count, GDB takes
     no action.

     To make the breakpoint stop the next time it is reached, specify a
     count of zero.

     When you use `continue' to resume execution of your program from a
     breakpoint, you can specify an ignore count directly as an
     argument to `continue', rather than using `ignore'.  *Note
     Continuing and stepping: Continuing and Stepping.

     If a breakpoint has a positive ignore count and a condition, the
     condition is not checked.  Once the ignore count reaches zero, GDB
     resumes checking the condition.

     You could achieve the effect of the ignore count with a condition
     such as `$foo-- <= 0' using a debugger convenience variable that
     is decremented each time.  *Note Convenience variables:
     Convenience Vars.

   Ignore counts apply to breakpoints, watchpoints, and catchpoints.


File: gdb.info,  Node: Break Commands,  Next: Breakpoint Menus,  Prev: Conditions,  Up: Breakpoints

Breakpoint command lists
------------------------

   You can give any breakpoint (or watchpoint or catchpoint) a series of
commands to execute when your program stops due to that breakpoint.  For
example, you might want to print the values of certain expressions, or
enable other breakpoints.

`commands [BNUM]'
`... COMMAND-LIST ...'
`end'
     Specify a list of commands for breakpoint number BNUM.  The
     commands themselves appear on the following lines.  Type a line
     containing just `end' to terminate the commands.

     To remove all commands from a breakpoint, type `commands' and
     follow it immediately with `end'; that is, give no commands.

     With no BNUM argument, `commands' refers to the last breakpoint,
     watchpoint, or catchpoint set (not to the breakpoint most recently
     encountered).

   Pressing <RET> as a means of repeating the last GDB command is
disabled within a COMMAND-LIST.

   You can use breakpoint commands to start your program up again.
Simply use the `continue' command, or `step', or any other command that
resumes execution.

   Any other commands in the command list, after a command that resumes
execution, are ignored.  This is because any time you resume execution
(even with a simple `next' or `step'), you may encounter another
breakpoint--which could have its own command list, leading to
ambiguities about which list to execute.

   If the first command you specify in a command list is `silent', the
usual message about stopping at a breakpoint is not printed.  This may
be desirable for breakpoints that are to print a specific message and
then continue.  If none of the remaining commands print anything, you
see no sign that the breakpoint was reached.  `silent' is meaningful
only at the beginning of a breakpoint command list.

   The commands `echo', `output', and `printf' allow you to print
precisely controlled output, and are often useful in silent
breakpoints.  *Note Commands for controlled output: Output.

   For example, here is how you could use breakpoint commands to print
the value of `x' at entry to `foo' whenever `x' is positive.

     break foo if x>0
     commands
     silent
     printf "x is %d\n",x
     cont
     end

   One application for breakpoint commands is to compensate for one bug
so you can test for another.  Put a breakpoint just after the erroneous
line of code, give it a condition to detect the case in which something
erroneous has been done, and give it commands to assign correct values
to any variables that need them.  End with the `continue' command so
that your program does not stop, and start with the `silent' command so
that no output is produced.  Here is an example:

     break 403
     commands
     silent
     set x = y + 4
     cont
     end


File: gdb.info,  Node: Breakpoint Menus,  Next: Error in Breakpoints,  Prev: Break Commands,  Up: Breakpoints

Breakpoint menus
----------------

   Some programming languages (notably C++) permit a single function
name to be defined several times, for application in different contexts.
This is called "overloading".  When a function name is overloaded,
`break FUNCTION' is not enough to tell GDB where you want a breakpoint.
If you realize this is a problem, you can use something like `break
FUNCTION(TYPES)' to specify which particular version of the function
you want.  Otherwise, GDB offers you a menu of numbered choices for
different possible breakpoints, and waits for your selection with the
prompt `>'.  The first two options are always `[0] cancel' and `[1]
all'.  Typing `1' sets a breakpoint at each definition of FUNCTION, and
typing `0' aborts the `break' command without setting any new
breakpoints.

   For example, the following session excerpt shows an attempt to set a
breakpoint at the overloaded symbol `String::after'.  We choose three
particular definitions of that function name:

     (gdb) b String::after
     [0] cancel
     [1] all
     [2] file:String.cc; line number:867
     [3] file:String.cc; line number:860
     [4] file:String.cc; line number:875
     [5] file:String.cc; line number:853
     [6] file:String.cc; line number:846
     [7] file:String.cc; line number:735
     > 2 4 6
     Breakpoint 1 at 0xb26c: file String.cc, line 867.
     Breakpoint 2 at 0xb344: file String.cc, line 875.
     Breakpoint 3 at 0xafcc: file String.cc, line 846.
     Multiple breakpoints were set.
     Use the "delete" command to delete unwanted
      breakpoints.
     (gdb)


File: gdb.info,  Node: Error in Breakpoints,  Prev: Breakpoint Menus,  Up: Breakpoints

"Cannot insert breakpoints"
---------------------------

   Under some operating systems, breakpoints cannot be used in a
program if any other process is running that program.  In this
situation, attempting to run or continue a program with a breakpoint
causes GDB to print an error message:

     Cannot insert breakpoints.
     The same program may be running in another process.

   When this happens, you have three ways to proceed:

  1. Remove or disable the breakpoints, then continue.

  2. Suspend GDB, and copy the file containing your program to a new
     name.  Resume GDB and use the `exec-file' command to specify that
     GDB should run your program under that name.  Then start your
     program again.

  3. Relink your program so that the text segment is nonsharable, using
     the linker option `-N'.  The operating system limitation may not
     apply to nonsharable executables.

   A similar message can be printed if you request too many active
hardware-assisted breakpoints and watchpoints:

     Stopped; cannot insert breakpoints.
     You may have requested too many hardware breakpoints and watchpoints.

This message is printed when you attempt to resume the program, since
only then GDB knows exactly how many hardware breakpoints and
watchpoints it needs to insert.

   When this message is printed, you need to disable or remove some of
the hardware-assisted breakpoints and watchpoints, and then continue.


File: gdb.info,  Node: Continuing and Stepping,  Next: Signals,  Prev: Breakpoints,  Up: Stopping

Continuing and stepping
=======================

   "Continuing" means resuming program execution until your program
completes normally.  In contrast, "stepping" means executing just one
more "step" of your program, where "step" may mean either one line of
source code, or one machine instruction (depending on what particular
command you use).  Either when continuing or when stepping, your
program may stop even sooner, due to a breakpoint or a signal.  (If it
stops due to a signal, you may want to use `handle', or use `signal 0'
to resume execution.  *Note Signals: Signals.)

`continue [IGNORE-COUNT]'
`c [IGNORE-COUNT]'
`fg [IGNORE-COUNT]'
     Resume program execution, at the address where your program last
     stopped; any breakpoints set at that address are bypassed.  The
     optional argument IGNORE-COUNT allows you to specify a further
     number of times to ignore a breakpoint at this location; its
     effect is like that of `ignore' (*note Break conditions:
     Conditions.).

     The argument IGNORE-COUNT is meaningful only when your program
     stopped due to a breakpoint.  At other times, the argument to
     `continue' is ignored.

     The synonyms `c' and `fg' (for "foreground", as the debugged
     program is deemed to be the foreground program) are provided
     purely for convenience, and have exactly the same behavior as
     `continue'.

   To resume execution at a different place, you can use `return'
(*note Returning from a function: Returning.) to go back to the calling
function; or `jump' (*note Continuing at a different address: Jumping.)
to go to an arbitrary location in your program.

   A typical technique for using stepping is to set a breakpoint (*note
Breakpoints; watchpoints; and catchpoints: Breakpoints.) at the
beginning of the function or the section of your program where a problem
is believed to lie, run your program until it stops at that breakpoint,
and then step through the suspect area, examining the variables that are
interesting, until you see the problem happen.

`step'
     Continue running your program until control reaches a different
     source line, then stop it and return control to GDB.  This command
     is abbreviated `s'.

          _Warning:_ If you use the `step' command while control is
          within a function that was compiled without debugging
          information, execution proceeds until control reaches a
          function that does have debugging information.  Likewise, it
          will not step into a function which is compiled without
          debugging information.  To step through functions without
          debugging information, use the `stepi' command, described
          below.

     The `step' command only stops at the first instruction of a source
     line.  This prevents the multiple stops that could otherwise occur
     in `switch' statements, `for' loops, etc.  `step' continues to
     stop if a function that has debugging information is called within
     the line.  In other words, `step' _steps inside_ any functions
     called within the line.

     Also, the `step' command only enters a function if there is line
     number information for the function.  Otherwise it acts like the
     `next' command.  This avoids problems when using `cc -gl' on MIPS
     machines.  Previously, `step' entered subroutines if there was any
     debugging information about the routine.

`step COUNT'
     Continue running as in `step', but do so COUNT times.  If a
     breakpoint is reached, or a signal not related to stepping occurs
     before COUNT steps, stepping stops right away.

`next [COUNT]'
     Continue to the next source line in the current (innermost) stack
     frame.  This is similar to `step', but function calls that appear
     within the line of code are executed without stopping.  Execution
     stops when control reaches a different line of code at the
     original stack level that was executing when you gave the `next'
     command.  This command is abbreviated `n'.

     An argument COUNT is a repeat count, as for `step'.

     The `next' command only stops at the first instruction of a source
     line.  This prevents multiple stops that could otherwise occur in
     `switch' statements, `for' loops, etc.

`set step-mode'
`set step-mode on'
     The `set step-mode on' command causes the `step' command to stop
     at the first instruction of a function which contains no debug line
     information rather than stepping over it.

     This is useful in cases where you may be interested in inspecting
     the machine instructions of a function which has no symbolic info
     and do not want GDB to automatically skip over this function.

`set step-mode off'
     Causes the `step' command to step over any functions which
     contains no debug information.  This is the default.

`finish'
     Continue running until just after function in the selected stack
     frame returns.  Print the returned value (if any).

     Contrast this with the `return' command (*note Returning from a
     function: Returning.).

`until'
`u'
     Continue running until a source line past the current line, in the
     current stack frame, is reached.  This command is used to avoid
     single stepping through a loop more than once.  It is like the
     `next' command, except that when `until' encounters a jump, it
     automatically continues execution until the program counter is
     greater than the address of the jump.

     This means that when you reach the end of a loop after single
     stepping though it, `until' makes your program continue execution
     until it exits the loop.  In contrast, a `next' command at the end
     of a loop simply steps back to the beginning of the loop, which
     forces you to step through the next iteration.

     `until' always stops your program if it attempts to exit the
     current stack frame.

     `until' may produce somewhat counterintuitive results if the order
     of machine code does not match the order of the source lines.  For
     example, in the following excerpt from a debugging session, the `f'
     (`frame') command shows that execution is stopped at line `206';
     yet when we use `until', we get to line `195':

          (gdb) f
          #0  main (argc=4, argv=0xf7fffae8) at m4.c:206
          206                 expand_input();
          (gdb) until
          195             for ( ; argc > 0; NEXTARG) {

     This happened because, for execution efficiency, the compiler had
     generated code for the loop closure test at the end, rather than
     the start, of the loop--even though the test in a C `for'-loop is
     written before the body of the loop.  The `until' command appeared
     to step back to the beginning of the loop when it advanced to this
     expression; however, it has not really gone to an earlier
     statement--not in terms of the actual machine code.

     `until' with no argument works by means of single instruction
     stepping, and hence is slower than `until' with an argument.

`until LOCATION'
`u LOCATION'
     Continue running your program until either the specified location
     is reached, or the current stack frame returns.  LOCATION is any of
     the forms of argument acceptable to `break' (*note Setting
     breakpoints: Set Breaks.).  This form of the command uses
     breakpoints, and hence is quicker than `until' without an argument.

`stepi'
`stepi ARG'
`si'
     Execute one machine instruction, then stop and return to the
     debugger.

     It is often useful to do `display/i $pc' when stepping by machine
     instructions.  This makes GDB automatically display the next
     instruction to be executed, each time your program stops.  *Note
     Automatic display: Auto Display.

     An argument is a repeat count, as in `step'.

`nexti'
`nexti ARG'
`ni'
     Execute one machine instruction, but if it is a function call,
     proceed until the function returns.

     An argument is a repeat count, as in `next'.


File: gdb.info,  Node: Signals,  Next: Thread Stops,  Prev: Continuing and Stepping,  Up: Stopping

Signals
=======

   A signal is an asynchronous event that can happen in a program.  The
operating system defines the possible kinds of signals, and gives each
kind a name and a number.  For example, in Unix `SIGINT' is the signal
a program gets when you type an interrupt character (often `C-c');
`SIGSEGV' is the signal a program gets from referencing a place in
memory far away from all the areas in use; `SIGALRM' occurs when the
alarm clock timer goes off (which happens only if your program has
requested an alarm).

   Some signals, including `SIGALRM', are a normal part of the
functioning of your program.  Others, such as `SIGSEGV', indicate
errors; these signals are "fatal" (they kill your program immediately)
if the program has not specified in advance some other way to handle
the signal.  `SIGINT' does not indicate an error in your program, but
it is normally fatal so it can carry out the purpose of the interrupt:
to kill the program.

   GDB has the ability to detect any occurrence of a signal in your
program.  You can tell GDB in advance what to do for each kind of
signal.

   Normally, GDB is set up to let the non-erroneous signals like
`SIGALRM' be silently passed to your program (so as not to interfere
with their role in the program's functioning) but to stop your program
immediately whenever an error signal happens.  You can change these
settings with the `handle' command.

`info signals'
`info handle'
     Print a table of all the kinds of signals and how GDB has been
     told to handle each one.  You can use this to see the signal
     numbers of all the defined types of signals.

     `info handle' is an alias for `info signals'.

`handle SIGNAL KEYWORDS...'
     Change the way GDB handles signal SIGNAL.  SIGNAL can be the
     number of a signal or its name (with or without the `SIG' at the
     beginning); a list of signal numbers of the form `LOW-HIGH'; or
     the word `all', meaning all the known signals.  The KEYWORDS say
     what change to make.

   The keywords allowed by the `handle' command can be abbreviated.
Their full names are:

`nostop'
     GDB should not stop your program when this signal happens.  It may
     still print a message telling you that the signal has come in.

`stop'
     GDB should stop your program when this signal happens.  This
     implies the `print' keyword as well.

`print'
     GDB should print a message when this signal happens.

`noprint'
     GDB should not mention the occurrence of the signal at all.  This
     implies the `nostop' keyword as well.

`pass'
`noignore'
     GDB should allow your program to see this signal; your program can
     handle the signal, or else it may terminate if the signal is fatal
     and not handled.  `pass' and `noignore' are synonyms.

`nopass'
`ignore'
     GDB should not allow your program to see this signal.  `nopass'
     and `ignore' are synonyms.

   When a signal stops your program, the signal is not visible to the
program until you continue.  Your program sees the signal then, if
`pass' is in effect for the signal in question _at that time_.  In
other words, after GDB reports a signal, you can use the `handle'
command with `pass' or `nopass' to control whether your program sees
that signal when you continue.

   The default is set to `nostop', `noprint', `pass' for non-erroneous
signals such as `SIGALRM', `SIGWINCH' and `SIGCHLD', and to `stop',
`print', `pass' for the erroneous signals.

   You can also use the `signal' command to prevent your program from
seeing a signal, or cause it to see a signal it normally would not see,
or to give it any signal at any time.  For example, if your program
stopped due to some sort of memory reference error, you might store
correct values into the erroneous variables and continue, hoping to see
more execution; but your program would probably terminate immediately as
a result of the fatal signal once it saw the signal.  To prevent this,
you can continue with `signal 0'.  *Note Giving your program a signal:
Signaling.


File: gdb.info,  Node: Thread Stops,  Prev: Signals,  Up: Stopping

Stopping and starting multi-thread programs
===========================================

   When your program has multiple threads (*note Debugging programs
with multiple threads: Threads.), you can choose whether to set
breakpoints on all threads, or on a particular thread.

`break LINESPEC thread THREADNO'
`break LINESPEC thread THREADNO if ...'
     LINESPEC specifies source lines; there are several ways of writing
     them, but the effect is always to specify some source line.

     Use the qualifier `thread THREADNO' with a breakpoint command to
     specify that you only want GDB to stop the program when a
     particular thread reaches this breakpoint.  THREADNO is one of the
     numeric thread identifiers assigned by GDB, shown in the first
     column of the `info threads' display.

     If you do not specify `thread THREADNO' when you set a breakpoint,
     the breakpoint applies to _all_ threads of your program.

     You can use the `thread' qualifier on conditional breakpoints as
     well; in this case, place `thread THREADNO' before the breakpoint
     condition, like this:

          (gdb) break frik.c:13 thread 28 if bartab > lim

   Whenever your program stops under GDB for any reason, _all_ threads
of execution stop, not just the current thread.  This allows you to
examine the overall state of the program, including switching between
threads, without worrying that things may change underfoot.

   Conversely, whenever you restart the program, _all_ threads start
executing.  _This is true even when single-stepping_ with commands like
`step' or `next'.

   In particular, GDB cannot single-step all threads in lockstep.
Since thread scheduling is up to your debugging target's operating
system (not controlled by GDB), other threads may execute more than one
statement while the current thread completes a single step.  Moreover,
in general other threads stop in the middle of a statement, rather than
at a clean statement boundary, when the program stops.

   You might even find your program stopped in another thread after
continuing or even single-stepping.  This happens whenever some other
thread runs into a breakpoint, a signal, or an exception before the
first thread completes whatever you requested.

   On some OSes, you can lock the OS scheduler and thus allow only a
single thread to run.

`set scheduler-locking MODE'
     Set the scheduler locking mode.  If it is `off', then there is no
     locking and any thread may run at any time.  If `on', then only the
     current thread may run when the inferior is resumed.  The `step'
     mode optimizes for single-stepping.  It stops other threads from
     "seizing the prompt" by preempting the current thread while you are
     stepping.  Other threads will only rarely (or never) get a chance
     to run when you step.  They are more likely to run when you `next'
     over a function call, and they are completely free to run when you
     use commands like `continue', `until', or `finish'.  However,
     unless another thread hits a breakpoint during its timeslice, they
     will never steal the GDB prompt away from the thread that you are
     debugging.

`show scheduler-locking'
     Display the current scheduler locking mode.


File: gdb.info,  Node: Stack,  Next: Source,  Prev: Stopping,  Up: Top

Examining the Stack
*******************

   When your program has stopped, the first thing you need to know is
where it stopped and how it got there.

   Each time your program performs a function call, information about
the call is generated.  That information includes the location of the
call in your program, the arguments of the call, and the local
variables of the function being called.  The information is saved in a
block of data called a "stack frame".  The stack frames are allocated
in a region of memory called the "call stack".

   When your program stops, the GDB commands for examining the stack
allow you to see all of this information.

   One of the stack frames is "selected" by GDB and many GDB commands
refer implicitly to the selected frame.  In particular, whenever you
ask GDB for the value of a variable in your program, the value is found
in the selected frame.  There are special GDB commands to select
whichever frame you are interested in. *Note Selecting a frame:
Selection.

   When your program stops, GDB automatically selects the currently
executing frame and describes it briefly, similar to the `frame'
command (*note Information about a frame: Frame Info.).

* Menu:

* Frames::                      Stack frames
* Backtrace::                   Backtraces
* Selection::                   Selecting a frame
* Frame Info::                  Information on a frame


File: gdb.info,  Node: Frames,  Next: Backtrace,  Up: Stack

Stack frames
============

   The call stack is divided up into contiguous pieces called "stack
frames", or "frames" for short; each frame is the data associated with
one call to one function.  The frame contains the arguments given to
the function, the function's local variables, and the address at which
the function is executing.

   When your program is started, the stack has only one frame, that of
the function `main'.  This is called the "initial" frame or the
"outermost" frame.  Each time a function is called, a new frame is
made.  Each time a function returns, the frame for that function
invocation is eliminated.  If a function is recursive, there can be
many frames for the same function.  The frame for the function in which
execution is actually occurring is called the "innermost" frame.  This
is the most recently created of all the stack frames that still exist.

   Inside your program, stack frames are identified by their addresses.
A stack frame consists of many bytes, each of which has its own
address; each kind of computer has a convention for choosing one byte
whose address serves as the address of the frame.  Usually this address
is kept in a register called the "frame pointer register" while
execution is going on in that frame.

   GDB assigns numbers to all existing stack frames, starting with zero
for the innermost frame, one for the frame that called it, and so on
upward.  These numbers do not really exist in your program; they are
assigned by GDB to give you a way of designating stack frames in GDB
commands.

   Some compilers provide a way to compile functions so that they
operate without stack frames.  (For example, the gcc option
     `-fomit-frame-pointer'
   generates functions without a frame.)  This is occasionally done
with heavily used library functions to save the frame setup time.  GDB
has limited facilities for dealing with these function invocations.  If
the innermost function invocation has no stack frame, GDB nevertheless
regards it as though it had a separate frame, which is numbered zero as
usual, allowing correct tracing of the function call chain.  However,
GDB has no provision for frameless functions elsewhere in the stack.

`frame ARGS'
     The `frame' command allows you to move from one stack frame to
     another, and to print the stack frame you select.  ARGS may be
     either the address of the frame or the stack frame number.
     Without an argument, `frame' prints the current stack frame.

`select-frame'
     The `select-frame' command allows you to move from one stack frame
     to another without printing the frame.  This is the silent version
     of `frame'.


File: gdb.info,  Node: Backtrace,  Next: Selection,  Prev: Frames,  Up: Stack

Backtraces
==========

   A backtrace is a summary of how your program got where it is.  It
shows one line per frame, for many frames, starting with the currently
executing frame (frame zero), followed by its caller (frame one), and
on up the stack.

`backtrace'
`bt'
     Print a backtrace of the entire stack: one line per frame for all
     frames in the stack.

     You can stop the backtrace at any time by typing the system
     interrupt character, normally `C-c'.

`backtrace N'
`bt N'
     Similar, but print only the innermost N frames.

`backtrace -N'
`bt -N'
     Similar, but print only the outermost N frames.

   The names `where' and `info stack' (abbreviated `info s') are
additional aliases for `backtrace'.

   Each line in the backtrace shows the frame number and the function
name.  The program counter value is also shown--unless you use `set
print address off'.  The backtrace also shows the source file name and
line number, as well as the arguments to the function.  The program
counter value is omitted if it is at the beginning of the code for that
line number.

   Here is an example of a backtrace.  It was made with the command `bt
3', so it shows the innermost three frames.

     #0  m4_traceon (obs=0x24eb0, argc=1, argv=0x2b8c8)
         at builtin.c:993
     #1  0x6e38 in expand_macro (sym=0x2b600) at macro.c:242
     #2  0x6840 in expand_token (obs=0x0, t=177664, td=0xf7fffb08)
         at macro.c:71
     (More stack frames follow...)

The display for frame zero does not begin with a program counter value,
indicating that your program has stopped at the beginning of the code
for line `993' of `builtin.c'.


File: gdb.info,  Node: Selection,  Next: Frame Info,  Prev: Backtrace,  Up: Stack

Selecting a frame
=================

   Most commands for examining the stack and other data in your program
work on whichever stack frame is selected at the moment.  Here are the
commands for selecting a stack frame; all of them finish by printing a
brief description of the stack frame just selected.

`frame N'
`f N'
     Select frame number N.  Recall that frame zero is the innermost
     (currently executing) frame, frame one is the frame that called the
     innermost one, and so on.  The highest-numbered frame is the one
     for `main'.

`frame ADDR'
`f ADDR'
     Select the frame at address ADDR.  This is useful mainly if the
     chaining of stack frames has been damaged by a bug, making it
     impossible for GDB to assign numbers properly to all frames.  In
     addition, this can be useful when your program has multiple stacks
     and switches between them.

     On the SPARC architecture, `frame' needs two addresses to select
     an arbitrary frame: a frame pointer and a stack pointer.

     On the MIPS and Alpha architecture, it needs two addresses: a stack
     pointer and a program counter.

     On the 29k architecture, it needs three addresses: a register stack
     pointer, a program counter, and a memory stack pointer.

`up N'
     Move N frames up the stack.  For positive numbers N, this advances
     toward the outermost frame, to higher frame numbers, to frames
     that have existed longer.  N defaults to one.

`down N'
     Move N frames down the stack.  For positive numbers N, this
     advances toward the innermost frame, to lower frame numbers, to
     frames that were created more recently.  N defaults to one.  You
     may abbreviate `down' as `do'.

   All of these commands end by printing two lines of output describing
the frame.  The first line shows the frame number, the function name,
the arguments, and the source file and line number of execution in that
frame.  The second line shows the text of that source line.

   For example:

     (gdb) up
     #1  0x22f0 in main (argc=1, argv=0xf7fffbf4, env=0xf7fffbfc)
         at env.c:10
     10              read_input_file (argv[i]);

   After such a printout, the `list' command with no arguments prints
ten lines centered on the point of execution in the frame.  *Note
Printing source lines: List.

`up-silently N'
`down-silently N'
     These two commands are variants of `up' and `down', respectively;
     they differ in that they do their work silently, without causing
     display of the new frame.  They are intended primarily for use in
     GDB command scripts, where the output might be unnecessary and
     distracting.


File: gdb.info,  Node: Frame Info,  Prev: Selection,  Up: Stack

Information about a frame
=========================

   There are several other commands to print information about the
selected stack frame.

`frame'
`f'
     When used without any argument, this command does not change which
     frame is selected, but prints a brief description of the currently
     selected stack frame.  It can be abbreviated `f'.  With an
     argument, this command is used to select a stack frame.  *Note
     Selecting a frame: Selection.

`info frame'
`info f'
     This command prints a verbose description of the selected stack
     frame, including:

        * the address of the frame

        * the address of the next frame down (called by this frame)

        * the address of the next frame up (caller of this frame)

        * the language in which the source code corresponding to this
          frame is written

        * the address of the frame's arguments

        * the address of the frame's local variables

        * the program counter saved in it (the address of execution in
          the caller frame)

        * which registers were saved in the frame

     The verbose description is useful when something has gone wrong
     that has made the stack format fail to fit the usual conventions.

`info frame ADDR'
`info f ADDR'
     Print a verbose description of the frame at address ADDR, without
     selecting that frame.  The selected frame remains unchanged by this
     command.  This requires the same kind of address (more than one
     for some architectures) that you specify in the `frame' command.
     *Note Selecting a frame: Selection.

`info args'
     Print the arguments of the selected frame, each on a separate line.

`info locals'
     Print the local variables of the selected frame, each on a separate
     line.  These are all variables (declared either static or
     automatic) accessible at the point of execution of the selected
     frame.

`info catch'
     Print a list of all the exception handlers that are active in the
     current stack frame at the current point of execution.  To see
     other exception handlers, visit the associated frame (using the
     `up', `down', or `frame' commands); then type `info catch'.  *Note
     Setting catchpoints: Set Catchpoints.


File: gdb.info,  Node: Source,  Next: Data,  Prev: Stack,  Up: Top

Examining Source Files
**********************

   GDB can print parts of your program's source, since the debugging
information recorded in the program tells GDB what source files were
used to build it.  When your program stops, GDB spontaneously prints
the line where it stopped.  Likewise, when you select a stack frame
(*note Selecting a frame: Selection.), GDB prints the line where
execution in that frame has stopped.  You can print other portions of
source files by explicit command.

   If you use GDB through its GNU Emacs interface, you may prefer to
use Emacs facilities to view source; see *Note Using GDB under GNU
Emacs: Emacs.

* Menu:

* List::                        Printing source lines
* Search::                      Searching source files
* Source Path::                 Specifying source directories
* Machine Code::                Source and machine code


File: gdb.info,  Node: List,  Next: Search,  Up: Source

Printing source lines
=====================

   To print lines from a source file, use the `list' command
(abbreviated `l').  By default, ten lines are printed.  There are
several ways to specify what part of the file you want to print.

   Here are the forms of the `list' command most commonly used:

`list LINENUM'
     Print lines centered around line number LINENUM in the current
     source file.

`list FUNCTION'
     Print lines centered around the beginning of function FUNCTION.

`list'
     Print more lines.  If the last lines printed were printed with a
     `list' command, this prints lines following the last lines
     printed; however, if the last line printed was a solitary line
     printed as part of displaying a stack frame (*note Examining the
     Stack: Stack.), this prints lines centered around that line.

`list -'
     Print lines just before the lines last printed.

   By default, GDB prints ten source lines with any of these forms of
the `list' command.  You can change this using `set listsize':

`set listsize COUNT'
     Make the `list' command display COUNT source lines (unless the
     `list' argument explicitly specifies some other number).

`show listsize'
     Display the number of lines that `list' prints.

   Repeating a `list' command with <RET> discards the argument, so it
is equivalent to typing just `list'.  This is more useful than listing
the same lines again.  An exception is made for an argument of `-';
that argument is preserved in repetition so that each repetition moves
up in the source file.

   In general, the `list' command expects you to supply zero, one or two
"linespecs".  Linespecs specify source lines; there are several ways of
writing them, but the effect is always to specify some source line.
Here is a complete description of the possible arguments for `list':

`list LINESPEC'
     Print lines centered around the line specified by LINESPEC.

`list FIRST,LAST'
     Print lines from FIRST to LAST.  Both arguments are linespecs.

`list ,LAST'
     Print lines ending with LAST.

`list FIRST,'
     Print lines starting with FIRST.

`list +'
     Print lines just after the lines last printed.

`list -'
     Print lines just before the lines last printed.

`list'
     As described in the preceding table.

   Here are the ways of specifying a single source line--all the kinds
of linespec.

`NUMBER'
     Specifies line NUMBER of the current source file.  When a `list'
     command has two linespecs, this refers to the same source file as
     the first linespec.

`+OFFSET'
     Specifies the line OFFSET lines after the last line printed.  When
     used as the second linespec in a `list' command that has two, this
     specifies the line OFFSET lines down from the first linespec.

`-OFFSET'
     Specifies the line OFFSET lines before the last line printed.

`FILENAME:NUMBER'
     Specifies line NUMBER in the source file FILENAME.

`FUNCTION'
     Specifies the line that begins the body of the function FUNCTION.
     For example: in C, this is the line with the open brace.

`FILENAME:FUNCTION'
     Specifies the line of the open-brace that begins the body of the
     function FUNCTION in the file FILENAME.  You only need the file
     name with a function name to avoid ambiguity when there are
     identically named functions in different source files.

`*ADDRESS'
     Specifies the line containing the program address ADDRESS.
     ADDRESS may be any expression.


File: gdb.info,  Node: Search,  Next: Source Path,  Prev: List,  Up: Source

Searching source files
======================

   There are two commands for searching through the current source file
for a regular expression.

`forward-search REGEXP'
`search REGEXP'
     The command `forward-search REGEXP' checks each line, starting
     with the one following the last line listed, for a match for
     REGEXP.  It lists the line that is found.  You can use the synonym
     `search REGEXP' or abbreviate the command name as `fo'.

`reverse-search REGEXP'
     The command `reverse-search REGEXP' checks each line, starting
     with the one before the last line listed and going backward, for a
     match for REGEXP.  It lists the line that is found.  You can
     abbreviate this command as `rev'.


File: gdb.info,  Node: Source Path,  Next: Machine Code,  Prev: Search,  Up: Source

Specifying source directories
=============================

   Executable programs sometimes do not record the directories of the
source files from which they were compiled, just the names.  Even when
they do, the directories could be moved between the compilation and
your debugging session.  GDB has a list of directories to search for
source files; this is called the "source path".  Each time GDB wants a
source file, it tries all the directories in the list, in the order
they are present in the list, until it finds a file with the desired
name.  Note that the executable search path is _not_ used for this
purpose.  Neither is the current working directory, unless it happens
to be in the source path.

   If GDB cannot find a source file in the source path, and the object
program records a directory, GDB tries that directory too.  If the
source path is empty, and there is no record of the compilation
directory, GDB looks in the current directory as a last resort.

   Whenever you reset or rearrange the source path, GDB clears out any
information it has cached about where source files are found and where
each line is in the file.

   When you start GDB, its source path includes only `cdir' and `cwd',
in that order.  To add other directories, use the `directory' command.

`directory DIRNAME ...'

`dir DIRNAME ...'
     Add directory DIRNAME to the front of the source path.  Several
     directory names may be given to this command, separated by `:'
     (`;' on MS-DOS and MS-Windows, where `:' usually appears as part
     of absolute file names) or whitespace.  You may specify a
     directory that is already in the source path; this moves it
     forward, so GDB searches it sooner.

     You can use the string `$cdir' to refer to the compilation
     directory (if one is recorded), and `$cwd' to refer to the current
     working directory.  `$cwd' is not the same as `.'--the former
     tracks the current working directory as it changes during your GDB
     session, while the latter is immediately expanded to the current
     directory at the time you add an entry to the source path.

`directory'
     Reset the source path to empty again.  This requires confirmation.

`show directories'
     Print the source path: show which directories it contains.

   If your source path is cluttered with directories that are no longer
of interest, GDB may sometimes cause confusion by finding the wrong
versions of source.  You can correct the situation as follows:

  1. Use `directory' with no argument to reset the source path to empty.

  2. Use `directory' with suitable arguments to reinstall the
     directories you want in the source path.  You can add all the
     directories in one command.

