# Specs file to building RPM of Linux to DJGPP cross-compiler
# Tested on Fedora Core 4. One may need to modify this file
# for other RPM based Linux distribution

%define gcc_version 4.3.2
%define gmp_version 4.2.3
#%define mpfr_version 2.3.1

Name: djcross-gcc
Summary:  GCC cross-compiler for target i586-pc-msdosdjgpp
Version: %{gcc_version}
Release: 8ap

License: GPL
Group: Development/Tools
URL: http://www.iki.fi/andris.pavenis/djgpp/gcc/
Source0: gcc-%{gcc_version}.tar.bz2
Source1: gcc432s2.zip
Source2: gmp-%{gmp_version}.tar.bz2
Source3: mpfr-%{mpfr_version}.tar.bz2

Buildroot: %{_tmppath}/%{name}-%{version}-root
BuildArch: i686 x86_64
Requires: djcrx djcross-binutils
BuildPrereq: gcc gcc-gnat gmp gmp-devel djcrx djcross-binutils autoconf >= 2.59 autoconf213 automake >= 1.9.5 automake14

%define shortver %(echo %{gcc_version} | sed -e 's:\\.::2g')
%define shortver2 %(echo %{gcc_version} | sed -e 's:\\.::g')

%description 
Support of the following programing languages is included:
    C
    C++
    Fortran
    Objective C
    Objective C++
    Ada

%prep 

rm -rf $RPM_BUILD_DIR/%{name}-%{version} || exit 1
mkdir $RPM_BUILD_DIR/%{name}-%{version} || exit 1
ln -s $RPM_SOURCE_DIR/gcc-%{gcc_version}.tar.bz2 $RPM_BUILD_DIR/%{name}-%{version}/ || exit 1
cd $RPM_BUILD_DIR/%{name}-%{version} || exit 1
unzip -aq $RPM_SOURCE_DIR/gcc%{shortver2}s2.zip || exit 1
sed -e 's:^\(AUTOCONF_OLD=\).*$:\1/usr/bin/autoconf-2.13:' \
    -e 's:^\(AUTOHEADER_OLD=\).*$:\1/usr/bin/autoheader-2.13:' \
    -e 's:^\(exec .*\)$:#\1:' unpack-gcc.sh >unpack-gcc.sh.new
mv -f unpack-gcc.sh.new unpack-gcc.sh
sh unpack-gcc.sh gcc-%{gcc_version}.tar.bz2 || exit 1

tar xjf $RPM_SOURCE_DIR/gmp-%{gmp_version}.tar.bz2 || exit 1

tar xjf $RPM_SOURCE_DIR/mpfr-%{mpfr_version}.tar.bz2 || exit 1

%build 
# Build requires this directory to be present or to be creatable to work
#mkdir -p /usr/lib/gcc/i586-pc-msdosdjgpp/%{version} || exit 1
#

cd $RPM_BUILD_DIR/%{name}-%{version}/gmp-%{gmp_version}
./configure --build=${RPM_ARCH}-${RPM_OS} \
            --prefix=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst \
            --enable-static --disable-shared || exit 1
make all check || exit 1
make install || exit 1

cd $RPM_BUILD_DIR/%{name}-%{version}/mpfr-%{mpfr_version}
./configure --build=${RPM_ARCH}-${RPM_OS} \
            --prefix=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst \
            --with-gmp-build=$RPM_BUILD_DIR/%{name}-%{version}/gmp-%{gmp_version} \
            --enable-static --disable-shared || exit 1
make all check || exit 1
make install || exit 1

cd $RPM_BUILD_DIR/%{name}-%{version}

mkdir tmpbuild || exit 1
cd tmpbuild || exit 1

../gnu/gcc-%{shortver}/configure --prefix=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst \
                                 --with-gmp=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst \
                                 --with-mpfr=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst \
                                 --enable-languages=c,ada \
                                 --enable-__cxa_atexit || exit 1
make bootstrap -j 2 || exit 1
make install || exit 1

cd ..
#

mkdir djcross
cd djcross
$RPM_BUILD_DIR/%{name}-%{version}/tmpinst/bin/gcc -v >$RPM_BUILD_DIR/%{name}-%{version}/gccver.stmp 2>&1

CC=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst/bin/gcc \
CXX=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst/bin/g++ \
PATH=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst/bin:$PATH \
../gnu/gcc-%{shortver}/configure --build=%{_build} \
                                 --host=%{_host} \
			         --target=i586-pc-msdosdjgpp \
			         --program-prefix=i586-pc-msdosdjgpp- \
			         --prefix=%{_prefix} \
			         --exec-prefix=%{_exec_prefix} \
			         --bindir=%{_bindir} \
			         --sbindir=%{_sbindir} \
			         --sysconfdir=%{_sysconfdir} \
			         --datadir=%{_datadir} \
			         --includedir=%{_includedir} \
			         --libdir=%{_libdir} \
			         --libexecdir=%{_libexecdir} \
			         --localstatedir=%{_localstatedir} \
			         --sharedstatedir=%{_sharedstatedir} \
			         --mandir=%{_mandir} \
			         --infodir=%{_infodir} \
			         --disable-nls \
			         --disable-libssp \
                                 --with-gmp=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst \
                                 --with-mpfr=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst \
			         --enable-version-specific-runtime-libs \
			         --enable-languages=c,c++,f95,objc,obj-c++,ada || exit 1 

make -j 2 PATH=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst/bin:$PATH || exit 1

%install 
rm -fr %{buildroot}

export STRIP=/bin/true
cd $RPM_BUILD_DIR/%{name}-%{version}/djcross
#%makeinstall
PATH=$RPM_BUILD_DIR/%{name}-%{version}/tmpinst/bin:$PATH make install DESTDIR=%{buildroot}
( cd %{buildroot}%{_bindir} && strip -v * )
( cd %{buildroot}%{_bindir} && mv -fv gprmake i586-pc-msdosdjgpp-gprmake )
( cd %{buildroot}%{_bindir} && mv -fv vxaddr2line i586-pc-msdosdjgpp-vxaddr2line )
rm -f %{buildroot}%{_libdir}/libiberty.a
rm -fr %{buildroot}%{_mandir}/man7/*
rm -fr %{buildroot}%{_infodir}/*

( cd %{buildroot}%{_libexecdir}/gcc/i586-pc-msdosdjgpp/%{version} &&\
    strip -v cc1* collect2 f951 gnat1 install-tools/fixincl )

%clean 
rm -fr %{buildroot}

%files 
%defattr(-,root,root) 
%{_bindir}/*
%{_libdir}/gcc/*
%{_libexecdir}/gcc/*
%{_prefix}/i586-pc-msdosdjgpp/*
%{_mandir}/man1/*

%changelog

* Sat Aug 30 2008 Andris Pavenis <andris.pavenis@iki.fi>
- Use gcc-4.3.2 (RPM version 4.3.2-7ap)

- I wanted to include also sources of GMP and MPFR to avoid dependency
  on their shared libraries. Unfortunatelly it did not work. So I left
  related stuff commented out from spec file.

* Sat Jun  7 2008 Andris Pavenis <andris.pavenis@iki.fi>
- Use gcc-4.3.1 (RPM version 4.3.1-6ap)

* Wed Apr 30 2008 Andris Pavenis <andris.pavenis@iki.fi>
- Some small additional patches (does not affect functionality)

* Sat Apr  5 2008 Andris Pavenis <andris.pavenis@iki.fi>
- Some small additional patches

* Sat Mar 15 2008 Andris Pavenis <andris.pavenis@iki.fi>
- Use gcc-4.3.0 (RPM version 4.3.0-3ap)

* Sun Feb 24 2008 Andris Pavenis <andris.pavenis@iki.fi>
- Use gcc-4.3-20080221
- use 'make install DESTDIR=...' instead of '%makeinstall'.

* Sat Feb  4 2008 Andris Pavenis <andris.pavenis@iki.fi>
- Use gcc-4.3-20080201
- Disable building libssp
- Fix libstdc++-v3 configuration for DJGPP (add os/djgpp/error_constants.h)

* Sat Nov 24 2007 Andris Pavenis <andris.pavenis@iki.fi>
- Updates for using gcc-4.3.0 development snapshots

* Mon Oct 15 2007 Andris Pavenis <andris.pavenis@iki.fi>
- Small updates (4.2.2-12ap) to scripts and readme.DJGPP
  in gcc422s2.zip

* Tue Oct  9 2007 Andris Pavenis <andris.pavenis@iki.fi>
- Update to GCC-4.2.2 (4.2.2-11ap)

* Tue Sep  5 2007 Andris Pavenis <andris.pavenis@iki.fi>
- Add BuildArch for x86_64.

* Fri Jul 25 2007 Andris Pavenis <andris.pavenis@iki.fi>
- Update to GCC-4.2.1 (4.2.1-9).

* Fri Jul 23 2007 Andris Pavenis <andris.pavenis@iki.fi>
- Small updates not really influencing functionality
  (4.2.0-8).

* Fri Jun 07 2007 Andris Pavenis <andris.pavenis@iki.fi>
- Small updates not really influencing functionality
  (4.2.0-7).

* Mon May 28 2007 Andris Pavenis <andris.pavenis@iki.fi>
- Include patch for fixing warnings about requested
  alignemnt exceeding one supported in object file
  from DJ Delorie <dj@delorie.com> 

* Wed May 23 2007 Andris Pavenis <andris.pavenis@iki.fi>
- Update to GCC-4.2.0 (4.2.0-5)

* Sun Mar 25 2007 Andris Pavenis <andris.pavenis@iki.fi>
- Test for cross-compiler installation directory at very
  begin, as it is nuisance to see build failing after an
  hour for this reason
- Merge changes from Gordon Schumacher with my updates to
  later GCC versions.

* Tue Mar 13 2007 Gordon Schumacher <whiplash@pobox.com>
- Updated to use RPM's prefix macros

* Thu Mar  8 2007 Andris Pavenis <andris.pavenis@iki.fi>
- Update to GCC-4.1.2 (4.1.2-1)
 
* Tue May 30 2006 Andris Pavenis <andris.pavenis@iki.fi>
- Fixed libstdc++ name for cross-compiler (4.1.1-2)

* Sun May 28 2006 Andris Pavenis <andris.pavenis@iki.fi>
- Updated to GCC-4.1.1 (4.1.1-1)

* Fri Apr  7 2006 Andris Pavenis <andris.pavenis@iki.fi>
- Patched libssp directory to fix problem with generated
  gcc410s.zip. Cross-compiler itself does not change.

* Sat Mar  5 2006 Andris Pavenis <andris.pavenis@iki.fi>
- Bootstrap at first native compiler to be used for building 
  cross-compiler as one need to build cross-compiler with the
  same version of GCC (use of GCC-4.0.2 causes failure in 
  building Ada tools). Updates to DJGPP related patchset.

* Wed Mar  1 2006 Andris Pavenis <andris.pavenis@iki.fi>
- Updated for GCC-4.1.0

* Sun Feb 19 2006 Andris Pavenis <andris.pavenis@iki.fi>
- Added modification of readme.DJGPP according the version of GCC and DJGPP, as
  otherwise it is rather easy to forget to edit it manually when needed

* Mon Nov 15 2005 Andris Pavenis <pavenis@latnet.lv>
- Initial version of rpm spec file for DJGPP cross-compiler
