#! /bin/sh
#
# Building DJGPP targetted cross-compiler. Tested under Linux only
#
# It may be necessary to edit this script before use
#
version=3.3.5
prefix=/usr
target=i586-pc-msdosdjgpp

DVER=`echo $version | sed -e 's#\.##2g'`
DVER0=`echo $version | sed -e 's#\.##g'`
TOP=`pwd`
SRC=$TOP/gnu/gcc-$DVER

export AUTOCONF_OLD=autoconf-2.13
export AUTOHEADER_OLD=autoheader-2.13
export AUTOMAKE_OLD=automake-1.5
export ACLOCAL_OLD=aclocal-1.5

if ! [ -f gcc${DVER0}s.zip ] ; then 
    sh ./unpack-gcc.sh || exit 1
    test -f gcc${DVER0}s.zip || exit 1
fi    

if ! [ -d $prefix/lib/gcc-lib/$target/$version ] ; then
    if ! mkdir $prefix/lib/gcc-lib/$target/$version ; then
	echo "Failed to create directory $prefix/lib/gcc-lib/$target/$version"
	exit 1
    fi
fi    	

if ! [ -d $PREFIX/$TARGET/sys-include ] ; then
    if [ -d $PREFIX/$TARGET/include ] ; then
	if ! ln -s $PREFIX/$TARGET/include $PREFIX/$TARGET/sys-include ; then
	    echo "Failed to symlink $PREFIX/$TARGET/include to $PREFIX/$TARGET/sys-include"
	    exit 1
	else
	    echo "Created symlink $PREFIX/$TARGET/sys-include to $PREFIX/$TARGET/include"
	    sleep 1s
	fi
    else
	echo "Directory $PREFIX/$TARGET/include is not found"
	exit 1
    fi
fi

test -d djcross || mkdir djcross || exit 1
cd djcross || exit 1

$SRC/configure	--prefix=$prefix \
		--host=`sh $SRC/config.guess` \
		--target=$target \
		--disable-nls \
		--enable-version-specific-runtime-libs \
		--enable-languages=c,c++,f77,objc || exit 1
		
make

