/* Configuration for an i386 running MS-DOS with DJGPP.
   Copyright (C) 1997, 1998, 1999, 2000, 2001 Free Software Foundation, Inc.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include "dbxcoff.h"

/* Support generation of DWARF2 debugging info.  */
#define DWARF2_DEBUGGING_INFO

/* Don't assume anything about the header files. */
#define NO_IMPLICIT_EXTERN_C

#define HANDLE_SYSV_PRAGMA

/* Enable parsing of #pragma pack(push,<n>) and #pragma pack(pop).  */
#define HANDLE_PRAGMA_PACK_PUSH_POP 1

#define YES_UNDERSCORES

#include "i386/gas.h"

/* If defined, a C expression whose value is a string containing the
   assembler operation to identify the following data as
   uninitialized global data.  If not defined, and neither
   `ASM_OUTPUT_BSS' nor `ASM_OUTPUT_ALIGNED_BSS' are defined,
   uninitialized global data will be output in the data section if
   `-fno-common' is passed, otherwise `ASM_OUTPUT_COMMON' will be
   used.  */
#undef BSS_SECTION_ASM_OP
#define BSS_SECTION_ASM_OP "\t.section\t.bss"

/* Define the name of the .ctor section.  */
#undef CTORS_SECTION_ASM_OP
#define CTORS_SECTION_ASM_OP "\t.section .ctor"

/* Define the name of the .data section.  */
#undef DATA_SECTION_ASM_OP
#define DATA_SECTION_ASM_OP "\t.section .data"

/* Define the name of the .dtor section.  */
#undef DTORS_SECTION_ASM_OP
#define DTORS_SECTION_ASM_OP "\t.section .dtor"

/* Define the name of the .eh_frame section.  */
#undef EH_FRAME_SECTION_ASM_OP
#define EH_FRAME_SECTION_ASM_OP "\t.section .eh_frame"

/* Define the name of the .ident op.  */
#undef IDENT_ASM_OP
#define IDENT_ASM_OP "\t.ident\t"

/* Define the name of the .int op.  */
#undef INT_ASM_OP
#define INT_ASM_OP "\t.long\t"

/* Enable alias attribute support.  */
#ifndef SET_ASM_OP
#define SET_ASM_OP "\t.set\t"
#endif

/* Define the name of the .text section.  */
#undef TEXT_SECTION_ASM_OP
#define TEXT_SECTION_ASM_OP "\t.section .text"

/* How to output an unaligned integer.  */
#undef UNALIGNED_INT_ASM_OP
#define UNALIGNED_INT_ASM_OP "\t.long\t"

/* How to output an unaligned double length integer.  */
#undef UNALIGNED_DOUBLE_INT_ASM_OP
#define UNALIGNED_DOUBLE_INT_ASM_OP "\t.quad\t"

/* How to output an unaligned half length intenger.  */
#undef UNALIGNED_SHORT_ASM_OP
#define UNALIGNED_SHORT_ASM_OP "\t.short\t"

/* Define standard DJGPP installation paths.                             */
/* We override default /usr or /usr/local part with /dev/env/DJDIR which */
/* points to actual DJGPP instalation directory.                         */

/* Standard include directory */
#undef STANDARD_INCLUDE_DIR
#define STANDARD_INCLUDE_DIR "/dev/env/DJDIR/include/"

/* Undef PREFIX_INCLUDE_DIR as we already have STANDARD_INCLUDE_DIR   
   and we don't want $DJDIR/include to be scanned before compiler
   private headers  */
#undef PREFIX_INCLUDE_DIR

/* Search for as.exe and ld.exe in DJGPP's binary directory. */ 
#undef MD_EXEC_PREFIX
#define MD_EXEC_PREFIX "/dev/env/DJDIR/bin/"

/* Standard DJGPP library and startup files */
#undef MD_STARTFILE_PREFIX
#define MD_STARTFILE_PREFIX "/dev/env/DJDIR/lib/"

/* Correctly handle absolute filename detection in cp/xref.c */
#define FILE_NAME_ABSOLUTE_P(NAME) \
        (((NAME)[0] == '/') || ((NAME)[0] == '\\') || \
        (((NAME)[0] >= 'A') && ((NAME)[0] <= 'z') && ((NAME)[1] == ':')))

#undef CPP_PREDEFINES
#define CPP_PREDEFINES "-D__MSDOS__ -D__GO32__ -D__DJGPP__=2 -D__unix__ -Asystem=msdos -Asystem=unix"

/* Include <sys/version.h> so __DJGPP__ and __DJGPP_MINOR__ are defined.  */
#undef CPP_SPEC
#define CPP_SPEC "%(cpp_cpu) %{posix:-D_POSIX_SOURCE} %{!ansi:%{!std=c*:%{!std=i*:-DMSDOS -DGO32 -DDJGPP=2 -Dunix}}}"

/* Options to be used with cpp0 only (not with tradcpp0) */
#define CPP0_ONLY_OPTIONS "-remap -imacros %sdjgpp.ver"

/* We need to override link_command_spec in gcc.c so support -Tdjgpp.djl.
   This cannot be done in LINK_SPECS as that LINK_SPECS is processed
   before library search directories are known by the linker.
   This avoids problems when specs file is not available. An alternate way,
   suggested by Robert Hoehne, is to use SUBTARGET_EXTRA_SPECS instead.
*/ 

#undef LINK_COMMAND_SPEC
#define LINK_COMMAND_SPEC \
"%{!fsyntax-only: \
%{!c:%{!M:%{!MM:%{!E:%{!S:%(linker) %l %X %{o*} %{A} %{d} %{e*} %{m} %{N} %{n} \
\t%{r} %{s} %{t} %{u*} %{x} %{z} %{Z}\
\t%{!A:%{!nostdlib:%{!nostartfiles:%S}}}\
\t%{static:} %{L*} %D %o\
\t%{!nostdlib:%{!nodefaultlibs:%G %L %G}}\
\t%{!A:%{!nostdlib:%{!nostartfiles:%E}}}\
\t%{!T*:-Tdjgpp-x.djl} %{T*}}}}}}}\n\
%{!c:%{!M:%{!MM:%{!E:%{!S:stubify %{v} %{o*:%*} %{!o*:a.out} }}}}}"

/* Always just link in 'libc.a'.  */
#undef LIB_SPEC
#define LIB_SPEC "-lc"

/* Pick the right startup code depending on the -pg flag.  */
#undef STARTFILE_SPEC
#define STARTFILE_SPEC "%{pg:gcrt0.o%s}%{!pg:crt0.o%s}"

/* Make sure that gcc will not look for .h files in /usr/local/include 
   unless user explicitly requests it.  */
#undef LOCAL_INCLUDE_DIR

/* Do not make only .exe if no executable file suffix was specified.  */
/* Let the linker handle that.  */
#undef NO_AUTO_EXE_SUFFIX
#define NO_AUTO_EXE_SUFFIX

#undef EXTRA_SECTIONS
#define EXTRA_SECTIONS in_ctor, in_dtor

#undef EXTRA_SECTION_FUNCTIONS
#define EXTRA_SECTION_FUNCTIONS					\
  CTOR_SECTION_FUNCTION						\
  DTOR_SECTION_FUNCTION

#define CTOR_SECTION_FUNCTION					\
void								\
ctor_section ()							\
{								\
  if (in_section != in_ctor)					\
    {								\
      fprintf (asm_out_file, "%s\n", CTORS_SECTION_ASM_OP);	\
      in_section = in_ctor;					\
    }								\
}

#define DTOR_SECTION_FUNCTION					\
void								\
dtor_section ()							\
{								\
  if (in_section != in_dtor)					\
    {								\
      fprintf (asm_out_file, "%s\n", DTORS_SECTION_ASM_OP);	\
      in_section = in_dtor;					\
    }								\
}

#define ASM_OUTPUT_CONSTRUCTOR(FILE,NAME)	\
  do {						\
    ctor_section ();				\
    fputs (ASM_LONG, FILE);			\
    assemble_name (FILE, NAME);			\
    fprintf (FILE, "\n");			\
  } while (0)

/* Tell GCC how to output a section name. Add "x" for code sections.  */
#define ASM_OUTPUT_SECTION_NAME(FILE, DECL, NAME, RELOC)\
  do {									\
    if ((DECL) && TREE_CODE (DECL) == FUNCTION_DECL)			\
      fprintf ((FILE), "\t.section %s,\"x\"\n", (NAME));		\
    else								\
      fprintf ((FILE), "\t.section %s\n", (NAME));			\
  } while (0)

#define ASM_OUTPUT_DESTRUCTOR(FILE,NAME)	\
  do {						\
    dtor_section ();                   		\
    fputs (ASM_LONG, FILE);			\
    assemble_name (FILE, NAME);              	\
    fprintf (FILE, "\n");			\
  } while (0)

/* Output at beginning of assembler file.  */
/* The .file command should always begin the output.  */

#undef ASM_FILE_START
#define ASM_FILE_START(FILE)						\
  do {									\
	output_file_directive (FILE, main_input_filename);		\
  } while (0)

/* This is how to output an assembler line
   that says to advance the location counter
   to a multiple of 2**LOG bytes.  */

#undef ASM_OUTPUT_ALIGN
#define ASM_OUTPUT_ALIGN(FILE,LOG) \
  if ((LOG) != 0) fprintf ((FILE), "\t.p2align %d\n", LOG)

/* This is how to output a global symbol in the BSS section.  */
#undef ASM_OUTPUT_ALIGNED_BSS
#define ASM_OUTPUT_ALIGNED_BSS(FILE, DECL, NAME, SIZE, ALIGN) \
  asm_output_aligned_bss ((FILE), (DECL), (NAME), (SIZE), (ALIGN))

/* This is how to tell assembler that a symbol is weak  */ 
#undef ASM_WEAKEN_LABEL
#define ASM_WEAKEN_LABEL(FILE,NAME) \
  do { fputs ("\t.weak\t", FILE); assemble_name (FILE, NAME); \
       fputc ('\n', FILE); } while (0)

/* djgpp automatically calls its own version of __main, so don't define one
   in libgcc, nor call one in main().  */
#define HAS_INIT_SECTION

/* Definitions for types and sizes. Wide characters are 16-bits long so
   Win32 compiler add-ons will be wide character compatible.  */
#undef WCHAR_UNSIGNED
#define WCHAR_UNSIGNED 1

#undef WCHAR_TYPE_SIZE
#define WCHAR_TYPE_SIZE 16

#undef WCHAR_TYPE
#define WCHAR_TYPE "short unsigned int"

#undef WINT_TYPE
#define WINT_TYPE "int"

#undef SIZE_TYPE
#define SIZE_TYPE "long unsigned int"

#undef PTRDIFF_TYPE
#define PTRDIFF_TYPE "int"

/* Used to be defined in xm-djgpp.h, but moved here for cross-compilers.  */
#define LIBSTDCXX "-lstdcxx"

/* -mbnu210 is now ignored and obsolete. It was used to enable support for
   weak symbols, and .gnu.linkonce support.  */
#undef MASK_BNU210
#define MASK_BNU210 (0x40000000)

#undef SUBTARGET_SWITCHES
#define SUBTARGET_SWITCHES \
  { "no-bnu210", MASK_BNU210, "Ignored (obsolete)." }, \
  { "bnu210", MASK_BNU210, "Ignored (obsolete)." },

/* Warn that -mbnu210 is now obsolete.  */
#undef  SUBTARGET_OVERRIDE_OPTIONS
#define SUBTARGET_OVERRIDE_OPTIONS \
do \
  { \
    if (target_flags & MASK_BNU210) \
      {	\
        warning ("-mbnu210 or -mno-bnu210 is ignored (option is obsolete)."); \
      }	\
  } \
while (0)

/* Support for C++ templates.  */
#undef MAKE_DECL_ONE_ONLY
#define MAKE_DECL_ONE_ONLY(DECL) (DECL_WEAK (DECL) = 1)

/* Additional support for C++ templates and support for
   garbage collection.  */
#undef UNIQUE_SECTION_P
#define UNIQUE_SECTION_P(DECL) (DECL_ONE_ONLY (DECL))

#undef UNIQUE_SECTION
#define UNIQUE_SECTION(DECL,RELOC)				\
do {								\
  int len;							\
  const char *name, *prefix;					\
  char *string;							\
								\
  name = IDENTIFIER_POINTER (DECL_ASSEMBLER_NAME (DECL));	\
								\
  if (! DECL_ONE_ONLY (DECL))					\
    {								\
      if (TREE_CODE (DECL) == FUNCTION_DECL)			\
	prefix = ".text.";					\
      else if (DECL_READONLY_SECTION (DECL, RELOC))		\
	prefix = ".rodata.";					\
      else							\
	prefix = ".data.";					\
    }								\
  else if (TREE_CODE (DECL) == FUNCTION_DECL)			\
    prefix = ".gnu.linkonce.t.";				\
  else if (DECL_READONLY_SECTION (DECL, RELOC))			\
    prefix = ".gnu.linkonce.r.";				\
  else								\
    prefix = ".gnu.linkonce.d.";				\
								\
  len = strlen (name) + strlen (prefix);			\
  string = alloca (len + 1);					\
  sprintf (string, "%s%s", prefix, name);			\
								\
  DECL_SECTION_NAME (DECL) = build_string (len, string);	\
} while (0)


#undef DBX_REGISTER_NUMBER
#define DBX_REGISTER_NUMBER(n) \
  ((write_symbols == DWARF2_DEBUG) ? svr4_dbx_register_map[n] : dbx_register_map[n])
