#include <ceditint.h>
class TRect;
class TSOSListBox;
#define Uses_TDialog
#define Uses_TPoint
#define Uses_TProgram
#define Uses_TDeskTop
#include <ceditor.h>
#include <edmsg.h>
#include <dskwin.h>
#include <dskmessa.h>
#include <stdio.h>

extern TView *setFocusTo;
extern Boolean focusChanged;

TStreamable *TDskWinMessage::build()
{
 return new TDskWinMessage( streamableInit );
}

void TDskWinMessage::write( opstream& os )
{
 TEdMsgDialog *edw=(TEdMsgDialog *)view;
 os << edw->origin << edw->size << (int)(edw->state & sfVisible)
    << edw->zoomRect
    << (int)(TProgram::deskTop->indexOf(edw));
}

void *TDskWinMessage::read( ipstream& is )
{
 TPoint aux;

 TEdMsgDialog *edw=EdMessageWindowInit(0);

 // Now restore the last settings
 is >> aux;
 edw->moveTo(aux.x,aux.y);
 is >> aux;
 edw->growTo(aux.x,aux.y);
 int vis;
 is >> vis;
 if (vis)
    edw->show();
 else
    edw->hide();
 is >> edw->zoomRect >> ZOrder;
 view=edw;

 return this;
}

char *TDskWinMessage::GetText(char *dest, short )
{
 sprintf(dest,_("   Message Box (%d lines)"),EdMessageCantMessages());
 return dest;
}

TDskWinMessage::TDskWinMessage(TEdMsgDialog *w)
{
 view=w;
 type=dktMessage;
 CanBeSaved=1;
}

int TDskWinMessage::GoAction(ccIndex )
{
 TProgram::deskTop->lock();
 setFocusTo=view;
 focusChanged=True;

 return 0;
}

int TDskWinMessage::DeleteAction(ccIndex )
{
 view->hide();

 return 0;
}

TDskWinMessage::~TDskWinMessage()
{
}

