#if defined( Uses_TCEditor_Class )

#if defined( Uses_TFindCDialogRec ) && !defined( __TFindCDialogRec__ )
#define __TFindCDialogRec__

struct TFindCDialogRec
{
 TFindCDialogRec( const char *str, unsigned flgs, unsigned insel,
                  unsigned from_where )
   {
    strcpy( find, str );
    options = flgs;
    in_sel = insel;
    from = from_where;
   }
 char find[maxFindStrLen];
 unsigned short options;
 unsigned short in_sel;
 unsigned short from;
};

#endif  // Uses_TFindCDialogRec


#if defined( Uses_TReplaceCDialogRec ) && !defined( __TReplaceCDialogRec__ )
#define __TReplaceCDialogRec__

struct TReplaceCDialogRec
{
 TReplaceCDialogRec( const char *str, const char *rep, unsigned flgs,
                     unsigned insel, unsigned from_where )
    {
     strcpy( find, str );
     strcpy( replace, rep );
     options = flgs;
     in_sel = insel;
     from = from_where;
    }
 char find[maxFindStrLen];
 char replace[maxReplaceStrLen];
 unsigned short options;
 unsigned short in_sel;
 unsigned short from;
};

#endif  // Uses_TReplaceCDialogRec



#if defined( Uses_LineLengthArray ) && !defined( __LineLengthArray__ )
#define __LineLengthArray__

class LineLengthArray
{
public:
 LineLengthArray();
 ~LineLengthArray();
 operator [](unsigned pos) { return elArray[pos]; };
 void set(unsigned pos, uint16 val);
 void insert(unsigned pos, uint16 val);
 void del(unsigned pos);
 void deleteRange(unsigned from,unsigned to);
 uint16 getAttr(unsigned line) { return elArrayAttr[line]; };
 void setAttr(unsigned line, uint16 val);
 void setAll(unsigned line, uint16 length, uint16 attr);
 unsigned Length;
 uint16 *elArray;
 uint16 *elArrayAttr;

private:
 unsigned MaxPos;
};

#endif // Uses_LineLengthArray


#if defined( Uses_TCEditor ) && !defined( __TCEditor__ )
#define __TCEditor__

class TRect;
class TScrollBar;
class TIndicator;
class TEvent;

class TCEditor : public TViewPlus
{

public:

    TCEditor( const TRect&, TScrollBar *, TScrollBar *, TIndicator *, const char * );

    virtual ~TCEditor();
    virtual void shutDown();
    char bufChar( unsigned Pos )    { return buffer[Pos]; };
    unsigned bufPtr( unsigned Pos ) { return Pos; };
    virtual void changeBounds( const TRect& );
    virtual void convertEvent( TEvent& );
    Boolean cursorVisible();
    void deleteSelect();
    virtual void doneBuffer();
    virtual void draw();
    virtual TPalette& getPalette() const;
    virtual void handleEvent( TEvent& );
    virtual void initBuffer();
    Boolean insertBuffer( char *, unsigned, unsigned, Boolean, Boolean, Boolean moveToEnd=True );
    virtual Boolean insertFrom( TCEditor * );
    Boolean insertText( const void *, unsigned, Boolean );
    unsigned CopySelToBuffer(char *b, unsigned l);
    void scrollTo( int, int );
    Boolean search( const char *, unsigned );
    virtual Boolean setBufSize( unsigned );
    void setCmdState( uint16 command, Boolean enable );
    void setSelect( unsigned, unsigned, Boolean);
    virtual void setState( uint16 aState, Boolean enable );
    void trackCursor( Boolean );
    void undo();
    virtual void updateCommands();

    Boolean clipCopy();
    Boolean clipWinCopy();
    void clipCut();
    void clipPaste();
    void clipWinPaste();
    void deleteRange( unsigned , unsigned, Boolean );
    void doUpdate();
    void doSearchReplace();
    void drawLines( int, int, unsigned );
    void find();
    Boolean hasSelection() { return Boolean(selStart<selEnd); };
    Boolean hasVisibleSelection() { return Boolean(!selHided && selStart<selEnd); };
//{ return Boolean(IslineInEdition ? selLineStart<selLineEnd : selStart<selEnd); };
    void hideSelect();
    Boolean isClipboard() { return Boolean(clipboard == this); };
    void lock() { lockCount++; };
    void newLine();
    unsigned nextWordC( unsigned );
    char *WordUnderCursor(unsigned maxLength=256);
    Boolean StringUnderCursor(uint32 &word_start, uint32 &word_end);
    void replace();
    void setBufLen( unsigned );
    void startSelect();
    void toggleInsMode( Boolean allowUndo );
    void unlock();
    void update( uchar );
    void checkScrollBar( const TEvent&, TScrollBar *, int& );
    unsigned LenWithoutCRLF(unsigned yInFile,char *lineStart);
    void ExpandAllTabs(void);
    void CompactBuffer();
    uint16 CompactFlags(void);
    void ExpandFlags(uint16 t,Boolean allowUndo=True);
    Boolean selRectCopy(Boolean allowUndo=True);
    Boolean selRectPaste(struct selRecSt *st, int X, int Y, Boolean allowUndo=True);
    Boolean selRectDelete(int X1, int Y1, int X2, int Y2, Boolean allowUndo=True);
    void UndoRectangularPasteClear(UndoCell &un);
    Boolean FillUndoForRectangularPasteClear(int Height,struct UndoCell &un,UndoState st);
    Boolean FillUndoForRectangularStartEnd(UndoState st);
    void undoOneAction();
    //   Global options managment, global to allow setting while there isn't any editor
    // opened.
    static void SetGlobalOptions(void);
    static void ExpandGlobalOptions(GlobalOptionsRect *temp);
    static void CompactGlobalOptions(GlobalOptionsRect *temp);
    void ExpandGlobalOptionsLocally(GlobalOptionsRect *temp);

    TScrollBar *hScrollBar;
    TScrollBar *vScrollBar;
    TIndicator *indicator;
    char *buffer;
    unsigned bufSize;
    unsigned bufLen;
    unsigned gapLen;
    unsigned selStart;
    unsigned selEnd;
    unsigned curPtr;
    TPoint delta;
    TPoint limit;
    unsigned drawPtr;
    unsigned delCount;
    unsigned insCount;
    Boolean isValid;
    Boolean canUndo;
    Boolean modified;
    Boolean selecting;
    Boolean overwrite;

    Boolean autoIndent;               // Indent when ENTER is pressed
    static Boolean staticAutoIndent;  // the static version
    Boolean intelIndent;              // try to be smart in the autoindent
    static Boolean staticIntelIndent; // the static version
    unsigned tabSize;                 // The size of the tabulator
    static unsigned staticTabSize;    // the static version
    Boolean UseTabs;                  // True if when we press Tab an ascii 9 is inserted
    static Boolean staticUseTabs;     // the static version
    Boolean PersistentBlocks;         // True if the blocks isn't deleted after a move
    static Boolean staticPersistentBlocks;  // the static version
    Boolean ShowMatchPair;            // True if the editor highlights the match pair
    static Boolean staticShowMatchPair;     // the static version
    static Boolean staticNoMoveToEndPaste;  //  True if the cursor is moved to the end of
                                            // the pasted area.
    Boolean TransparentSel;           // True if you can see through the slelection
    static Boolean staticTransparentSel; // the static version
    Boolean OptimalFill;             // When True the editor tries to fill all the gaps
                                     // with tabs instead of spaces
    static Boolean staticOptimalFill;// the static version

    static TEditorDialog editorDialog;
    static unsigned editorFlags;
    static unsigned fromFlags;
    static unsigned whereFlags;
    static char near findStr[maxFindStrLen];
    static char near replaceStr[maxReplaceStrLen];
    static TCEditor * near clipboard;
    uchar lockCount;
    uchar updateFlags;
    int keyState;
    unsigned WantedCol;
    void formatLine(void *, unsigned, int, unsigned short, unsigned, unsigned short, unsigned );
    void formatLineHighLight(void *, unsigned, int, unsigned short, unsigned, unsigned short, unsigned );
    void formatLineHighLightPascal(void *,unsigned,int,unsigned short,unsigned,unsigned short, unsigned );
    void formatLineHighLightClipper(void *,unsigned,int,unsigned short,unsigned,unsigned short, unsigned );
    void formatLineHighLightGeneric( void *,unsigned,int,unsigned short,unsigned,unsigned short,unsigned );
    unsigned lineMove( unsigned p, int count );
    void TurnOffHighLight(void) {  formatLinePtr=&TCEditor::formatLine; SyntaxHL=shlNoSyntax; };
    void TurnOnCHighLight(void);
    void TurnOnPascalHighLight(void);
    void TurnOnClipperHighLight(void);
    void TurnOnGenericHighLight(void);
    void SetHighlightTo(shlState sHL, int subSHL=0);
    void CacheSyntaxHLData(int id);
    void *SearchPMTrigger(char *trg);
    void RecalculateLineAttributes(void);
    void ProfileEditor(void);
    void CacheColors(void);

    void InsertCharInLine(char cVal, Boolean allowUndo=True);
    void MakeEfectiveLineInEdition();
    char *ColToPointer();
    char *ColToPointer(int &Dif);
    char *ColToPointerPost();
    int  nextWord();
    int  prevWord(Boolean moveCursor=True);
    void MoveCursor(char *ori,char *dest);
    void EditLine();
    void deleteRange(char *from,char *to,Boolean allowUndo=True);
    void deleteRangeLineInEdition(char *from,char *to,int x);
    int  LineWidth();
    int  LineWidth(char *s, char *d);
    void insertSpaces( unsigned length, int X, Boolean canUseTabs=True );
    void MoveLinesUp(int i);
    void MoveLinesDown(int i);
    void SetStartOfSelecting(unsigned startOffSet);
    void UpdateSelecting(void);
    void MoveToMouse( TPoint m, uchar selMode );
    void MoveCursorTo(unsigned x, unsigned y);
    void GoAndSelectLine(int line);
    int  IsFirstCharInLine(void);
    void GotoOffSet(unsigned o);
    void IndentBlock(unsigned Amount, char Fill, Boolean allowUndo=True);
    void UnIndentBlock(unsigned Amount, Boolean allowUndo=True);
    void BackSpace(Boolean allowUndo=True);
    void ExpandMacro(void);
    int TestPropagation(uint32 OldAttr,uint16 NewAttr,char *proxLine, uint32 proxLineNum);
    int SearchCloseSymbol(char open, char close);
    int SearchCloseSymbolXY(char open, char close, int &X, int &Y);
    int SearchOpenSymbol(char open, char close);
    int SearchOpenSymbolXY(char open, char close, int &X, int &Y);
    Boolean clipReplace(void);
    int GoFirstCharInLine(void);
    void SelWordUnderCursor(void);
    int nextCWord();
    void addToUndo(UndoState st, void *p=NULL);
    void freeUndoCell(int Index);
    void redo(void);
    void UndoSaveFinalState(UndoCell &un);
    void UndoSaveStartState(UndoCell &un);
    void BlockToUpper(Boolean allowUndo);
    void BlockToLower(Boolean allowUndo);
    int  AdjustBufEditFor(int lar);
    void Beep(void);
    void AdjustLineSel(uint32 pos,int dif,Boolean IncludeStart=False,Boolean toLeft=True);
    void AdjustDrawPtr(void);
    void updateCrossCur(void);
    void setStatusLine(char *s);
    void RecalculateXofLineInEdit(void);
    Boolean hasRectSel(void) { return Boolean(!selRectHided && Xr1<Xr2 && Yr1<=Yr2); };
    unsigned GetOffSetOffLine(int y);
    int EnsureXDontTab(char *s,int x,int w,char **stop);
    void lockUndo(void) { undoLockCount++; };
    void unlockUndo(void);
    void SetSpecialLines(int *a) { SpecialLines=a; };
    // File handle members
    Boolean loadFile();
    Boolean save();
    Boolean saveAs();
    Boolean saveAsUNIX();
    Boolean saveFile(Boolean Unix=False);
    virtual Boolean valid( ushort );
    char fileName[PATH_MAX];

    LineLengthArray lenLines; // pseudo-Array with all the line-lengths
    uint32 totalLines;        // Total number of lines
    uint32 drawLine;          // first displayed line
    uint32 lineInEdition;     // Line number in edition process
    char  *curLinePtr;        // Pointer to the start of the line where the
                              // cursor is.
    char  *bufEdit;           // Buffer to edit a line
    uint16 bufEditLen;        // Allocated memory for bufEdit
    char  *inEditPtr;         // Pointer to the cursor inside the line edition
                              // buffer
    Boolean IslineInEdition;  // There is a line under edition?
    TPoint curPos;            // Position of cursor inside the file
    int    restCharsInLine;   // Number of chars between inEditPtr and the end
                              // of the buffer.
    unsigned selLineStart;    // selStart in a line
    unsigned selLineEnd;      // selEnd in a line
    unsigned selNewStart;     // The value of selXXX when the line in edition
    unsigned selNewEnd;       // will be put in the buffer
    Boolean  selHided;       // True if the selection is invisible
    uint32 selStartOffSet;   // The start of a selecting operation
    unsigned Markers[10];    // 0=does't exist != It's a marker
    int MarkersInLine[10];   // -1 Isn't in this line other offset in the line
    unsigned attrInEdit;     // Attributes for the line in edition
    Boolean NotExpandingMacro; // False if we are expanding a pseudo macro to
                               // avoid an alteration of the selected area
    uchar   ForceSelection;    // Force to set this selecting mode instead
                               // of use the shifts in handleEvent

    UndoCell UndoArray[MAX_UNDO];    // Array with the undo info
    UndoState UndoSt;                // Actual State
    int UndoBase,UndoActual,UndoTop; // Index in the array

    // a pointer to the function to format the line to be displayed.
    void (TCEditor::*formatLinePtr)(void *, unsigned, int, unsigned short, unsigned, unsigned short, unsigned );
    // a pointer to the function to format calculate the s. hl. attributes
    uint16 (*LineMeassure)(char *, char *, uint16 &);
    shlState SyntaxHL;        // Says the type of syntax highlight used
    int      GenericSHL;      // What sub-type if the type is generic
    int SHLValueSelected;     // That's the position in the array of the detected SHL
    static unsigned char SHLTableUse[4];  // A conversion table to know what generic shl uses an internal SHL
    static strSHL  *SHLArray;   // Array of configurable SHLs
    static SOStack *SHLSOStack; // SOStack of the strigs of the configurable SHLs
    static strSHL   strC;       // Cached Syntax HL values
    static int      strCid;     // What element is cached
    static int      SHLCant;    // Number of SHLs defined
    static TNoCaseSOSStringCollection *SHLGenList; // Names of the SHLs tp choose one

    // Macro, I don't know if this will used really
    Boolean Recording;
    uint16  MacroArray[32];
    int     MacroCount;

    static unsigned LoadingVersion;   // That's the version of the desktop file opened
                             // Is here to comunicate the value between the
                             // ::read functions
    // CrossCursor
    Boolean CrossCursorInCol,CrossCursorInRow;
    static Boolean staticCrossCursorInCol;
    static Boolean staticCrossCursorInRow;
    int CrossCursorCol,CrossCursorRow;
    char CrossCursorBuf[setMaxScreenY];
    char CrossCursorBufR[setMaxScreenX];
    int CrossCursorY2,CrossCursorX2;
    Boolean CrossCurInCacheC,CrossCurInCacheR;

    // Status Line
    Boolean IsStatusLineOn;
    int     StatusLinePos;    // 1 means is at the end 0 at top
    static char StatusLine[setMaxScreenX*2];

    // New search options
    static ushort SearchInSel;
    static ushort FromWhere;
    unsigned StartOfSearch;
    unsigned selStartF,selEndF;
    Boolean IsFoundOn;

    // Highligth of one char
    int XHLC,YHLC,XHLCo,YHLCo,XHLCc,YHLCc;
    Boolean IsHLCOn;
    char OldHLAttr,OldHLAttro;

    // Rectangular selection
    int Xr1,Yr1,Xr2,Yr2;     // Start and end point of the rect. sel
    Boolean selRectHided;    // To hide the sel
    struct selRecSt *selRectClip;

    // Groups of undo
    int undoLockCount;
    int undoGroupCount;

    // To keep track of the position of some line
    int *SpecialLines;

    // If 1 the colors are allready cached
    static int colorsCached;

    // For the pseudo macros by now only one
    static TPMCollection *PMColl;

    static const char *backupExt;

    SetDefStreamMembersCommon(TCEditor,TViewPlus)
};

SetDefStreamOperators(TCEditor)

#endif  // Uses_TCEditor




#if defined( Uses_TCEditWindow ) && !defined( __TCEditWindow__ )
#define __TCEditWindow__

// That's a structure to hold the most important information of an
// esitor window.
// The coordinates are short because a 32768 screen is big enough ;-)
typedef struct
{
 uchar version,dummy;
 uchar shl,subshl;
 short origin_x,origin_y;
 short size_x,size_y;
 short cursor_x,cursor_y;
 short zorigin_x,zorigin_y;
 short zsize_x,zsize_y;
 ushort ed_flags,prj_flags;
} EditorResume;

class TCEditWindow : public TWindow
{

public:

    TCEditWindow( const TRect&, const char *, int );
    virtual void close();
    virtual const char *getTitle( short );
    virtual void handleEvent( TEvent& );
    virtual void sizeLimits( TPoint& min, TPoint& max );
    virtual TPalette& getPalette() const;

    void FillResume(EditorResume &r);
    void ApplyResume(EditorResume &r);

    TCEditor *editor;

private:

    static const char * near clipboardTitle;
    static const char * near untitled;

    SetDefStreamMembersNoConst(TCEditWindow)
};

SetDefStreamOperators(TCEditWindow)

void ReadResume(EditorResume &r, ipstream& is);
void SaveResume(EditorResume &r, opstream& os);
void FillResumeWith(EditorResume &r,TPoint &origin,TPoint &size,TPoint &cursor);

#endif  // Uses_TCEditWindow

#endif
