#ifndef __CEDITINT_H_SET_
#define __CEDITINT_H_SET_

// Configuration for the Editor:

//#define SET
#define ROBERT
//#define ML

#ifdef SET
#define BIOS_KEYBOARD
#define STANDALONE
#define SAVE_ALL_VARS
#define CACHED_COLORS
#ifdef __GNUC__
#define RHIDE
#endif
#endif

#ifdef ROBERT
#define BIOS_KEYBOARD
#define RHIDE
#define SAVE_ALL_VARS
#define CACHED_COLORS
#endif

#ifdef ML
#define BIOS_KEYBOARD
#define STANDALONE
#define SAVE_ALL_VARS
#define CACHED_COLORS
#endif

#if defined(__GNUC__) && !defined(NO_INTL_SUP)
// International support via gettext only in the GNU version
#include "intl.h"
#else
#include "nointl.h"
#endif

#define TCEDITOR_VERSION 0x000218UL

// Tabs setings

#ifdef Tabs8
#define AdvanceWithTab(a,b)     if (a==9) b|=7; b++
#define NextTabPos(x)           (((x/8)+1)*8)
#define MoveWithTab(b)          b|=7; b++
#define IsATabPos(a)            (a%8)==0
#else
#define AdvanceWithTab(a,b)     if (a==9) b+=tabSize-(b%tabSize); else b++
#define NextTabPos(x)           (((x/tabSize)+1)*tabSize)
#define MoveWithTab(b)          b+=tabSize-(b%tabSize)
#define IsATabPos(a)            (a%tabSize)==0
#endif

// Now some macros dealing with the different eon of line handlings
// on MS-DOS and unix-like

#if 1

#define IsntEOL(a) (a!='\r' && a!='\n')
#define IsEOL(a)   (a=='\r' || a=='\n')
#ifdef __DJGPP__
#define LenEOL     2
const char crlf[] = "\r\n";
#else
#define LenEOL     1
const char crlf[] = "\n";
#endif

#else //  I'm using that by now BUT in the future I'll try to use:

#ifdef __DJGPP__
#define LenEOL     2
const char crlf[] = "\r\n";
#define IsntEOL(a) (a!='\r')
#define IsEOL(a)   (a=='\r')
#else
#define LenEOL     1
const char crlf[] = "\n";
#define IsntEOL(a) (a!='\n')
#define IsEOL(a)   (a=='\n')
#endif

#endif

#endif // __CEDITINT_H_SET_
