/* Copyright (C) 1996,1997,1998,1999 by Salvador E. Tropea (SET),
   see copyrigh file for details */
#define Uses_TRect
#define Uses_TDialog
#define Uses_TScrollBar
#define Uses_TButton
#define Uses_TDeskTop
#define Uses_TApplication
#define Uses_TProgram
#define Uses_TCollection
#define Uses_TListBox
#define Uses_MsgBox
#define Uses_TCEditWindow
#include <ceditor.h>
#include <dskwin.h>
#include <edcollec.h>
#include <editcoma.h>
#define Uses_TSetEditorApp
#define Uses_SETAppConst
#include <setapp.h>
#include <advice.h>

TView *setFocusTo;
Boolean focusChanged;
TEditorCollection *edHelper=NULL;

class TListWindowsDiag : public TDialog
{
public:
 TListWindowsDiag(TRect sizeDkt);
 void handleEvent(TEvent &event);
 TListEditors *tl;
};

TListWindowsDiag::TListWindowsDiag(TRect sizeDkt) :
 TDialog(sizeDkt,_("Windows List")),
 TWindowInit(TListWindowsDiag::initFrame)
{
 helpCtx = hcListWin;

 int h=sizeDkt.b.y-sizeDkt.a.y;
 int w=sizeDkt.b.x-sizeDkt.a.x;

 TScrollBar *sb = new TScrollBar( TRect(w-3,2,w-2,h-4) );
 insert(sb);
 tl = new TListEditors(TRect(2,2,w-3,h-4),1,sb);
 tl->newList(edHelper);
 insert(tl);

 TRect r(3,h-3,15,h-1);
 insert( new TButton(r,_("~G~o"),cmGo,bfDefault) );
 r.move(14,0);
 insert( new TButton(r,_("~D~elete"),cmDelete,bfNormal) );
 r.move(14,0);
 insert( new TButton(r,_("~O~pen"),cmInsert,bfNormal) );
 r.move(14,0);
 insert( new TButton(r,_("Cancel"),cmCancel,bfNormal) );

 selectNext( False );
 options |= ofCentered;
}

void TListWindowsDiag::handleEvent(TEvent &event)
{
 TDialog::handleEvent(event);
 switch (event.what)
   {
    case evCommand:
        {
         ccIndex pos = tl->focused;
         TDskWin *obj = (TDskWin *)(edHelper->at(pos));

         switch( event.message.command )
           {
            case cmGo:
                 if (obj->GoAction(pos))
                    delete obj;
                 tl->setRange(edHelper->getCount());
                 break;

            case cmDelete:
                 if (obj->DeleteAction(pos,False))
                    delete obj;
                 tl->setRange(edHelper->getCount());
                 break;

            case cmInsert:
                 message(editorApp,evCommand,cmeOpen,0);
                 break;

            case cmDelFile:
                 if (obj->CanBeDeletedFromDisk)
                   {
                    if (GiveAdvice(gadvDeleteFile0)==cmYes)
                      {
                       if (obj->DeleteAction(pos,True))
                          delete obj;
                       tl->setRange(edHelper->getCount());
                      }
                    else
                      {
                       clearEvent(event);
                       return;
                      }
                   }
                 else
                   {
                    messageBox(_("You can't delete it from disk"),mfOKButton);
                    clearEvent(event);
                    return;
                   }
                 break;

            default:
                 return;
           }
         if (state & sfModal)
           {
            endModal(event.message.command);
            clearEvent(event);
           }
        }
         break;
   }
}

void BringListOfWindows(void)
{
 TRect r=TApplication::deskTop->getExtent();
 r.b.x-=10;
 r.b.y-=6;

 TListWindowsDiag *d=new TListWindowsDiag(r);
 //d->helpCtx=cmeListWin;

 focusChanged=False;
 int i;

 do
  {
   TProgram::deskTop->insert(d);
   d->setState(sfModal,True);
   i = d->execute();
   TProgram::deskTop->remove(d);
  }
 while (i==cmDelete || i==cmDelFile);
 delete d;

 if (focusChanged)
   {
    setFocusTo->select();
    setFocusTo->show();
    TProgram::deskTop->unlock();
   }
}
