/* Copyright (C) 1996,1997,1998,1999 by Salvador E. Tropea (SET),
   see copyrigh file for details */
typedef struct
{
 int Line;
 int Column;
} FileInfo;

#ifdef STANDALONE
// This file is used by the standalone editor to declare more things
class TSOSListBox;
class TSOSListBoxMsg;

#ifdef Uses_TSOSListBoxMsg
class TSOSListBoxMsg : public TSOSListBox
{
public:
 TSOSListBoxMsg(const TRect& bounds, ushort aNumCols, TScrollBar *aScrollBar)
 : TSOSListBox(bounds,aNumCols,aScrollBar) {}

 virtual void focusItem(ccIndex item);
 virtual void selectItem(ccIndex item);
 virtual void handleEvent(TEvent& event);
 virtual void setState(uint16 aState, Boolean enable);
 void selectNext(void);
 void selectPrev(void);
 int  getLineOf(int pos);
 void updateCommands(int enable);
 void saveAs();
 void save(char *name);
 void copyClipboard();

 int selectOK;
};
#endif

class TEdMsgDialog : public TDialog
{
public:
  TEdMsgDialog(const TRect &r,const char *t);
  virtual void changeBounds(const TRect &);
  virtual void close(void);
  virtual void handleEvent(TEvent& event);
  TSOSListBoxMsg *MsgList;
  ~TEdMsgDialog();
};

extern TEdMsgDialog *EdMessageWindowInit(int Insert=1);
extern int  EdMessageCantMessages(void);
extern void EdMessageSelectNext(void);
extern void EdMessageSelectPrev(void);
extern void EdJumpToMessage(ccIndex item);

#endif

int  DumpFileToMessage(char *file,char *from,
                       char *(*ParseFun)(char *buf,FileInfo &fI,char *&fileName)=0,
                       int kill=1);

// This is provided by edmsg.cc in the editor or by rhideint.cc in libset
extern void EdShowMessage(char *msg,Boolean remove_old=False);
extern void EdShowMessage(char *msg, FileInfo &fInfo, char *fileName,
                          Boolean remove_old=False);

