// CompileDialog.cpp : implementation file
//

#include "stdafx.h"
#include "DFE95.h"
#include "CDialectPage.h"
#include "OptimizePage.h"
#include "OtherPage.h"
#include "OverallPage.h"
#include "WarningPage.h"
#include "AdvancedSheet.h"
#include "CompileDialog.h"
#include "extern.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCompileDialog dialog


CCompileDialog::CCompileDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CCompileDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCompileDialog)
	m_Exename = _T("");
	m_Aout = -1;
	m_Object = -1;
	m_GenDebug = FALSE;
	//}}AFX_DATA_INIT
}


void CCompileDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCompileDialog)
	DDX_Text(pDX, IDC_EDIT_EXENAME, m_Exename);
	DDX_Radio(pDX, IDC_RADIO_AOUT, m_Aout);
	DDX_Radio(pDX, IDC_RADIO_OBJECT, m_Object);
	DDX_Check(pDX, IDC_GENDEBUG_CHECK, m_GenDebug);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCompileDialog, CDialog)
	//{{AFX_MSG_MAP(CCompileDialog)
	ON_BN_CLICKED(IDC_COMPILE_BUTTON, OnCompileButton)
	ON_BN_CLICKED(IDC_RADIO_OBJECT, OnRadioObject)
	ON_BN_CLICKED(IDC_RADIO_EXE, OnRadioExe)
	ON_BN_CLICKED(IDC_ADD_BUTTON, OnAddButton)
	ON_BN_CLICKED(IDC_REMOVE_BUTTON, OnRemoveButton)
	ON_BN_CLICKED(IDC_ADVANCED_BUTTON, OnAdvancedButton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCompileDialog message handlers

void CCompileDialog::OnCompileButton() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	CString str;
	CString liststr;
	int i;
	CListBox *list = (CListBox *)GetDlgItem(IDC_LIST);
	str += filename;
	str += " ";
	if (m_Object == 0)
		str += "-c ";
	else if (m_Aout == 1)
	{
		str += "-o ";
		str += m_Exename;
		str += " ";
	}
	if (m_GenDebug == TRUE)
		str += "-g ";
	if (ansi == TRUE)
		str += "-ansi ";
	if (no_asm == TRUE)
		str += "-fno-asm ";
	if (traditional == TRUE)
		str += "-traditional ";
	switch (optimize)
	{
	case 1:
		str += "-O1 ";
		break;
	case 2:
		str += "-O2 ";
		break;
	case 3:
		str += "-O3 ";
		break;
	default:
		break;
	}
	if (!flags.IsEmpty())
	{
		str += flags;
		str += " ";
	}
	if (S == TRUE)
		str += "-S ";
	if (E == TRUE)
		str += "-E ";
	switch (force)
	{
	case 1:
		str += "-x c ";
		break;
	case 2:
		str += "-x objective-c ";
		break;
	case 3:
		str += "-x c++ ";
		break;
	case 4:
		str += "-x c-header ";
		break;
	case 5:
		str += "-x cpp-output ";
		break;
	case 6:
		str += "-x c++-cpp-output ";
		break;
	case 7:
		str += "-x assembler ";
		break;
	case 8:
		str += "-x assembler-with-cpp ";
		break;
	default:
		break;
	}
	switch (warning)
	{
	case 1:
		str += "-w ";
		break;
	case 2:
		str += "-Wall ";
		break;
	case 3:
		str += "-W ";
		break;
	case 4:
		str += "-Werror ";
		break;
	default:
		break;
	}
	if (list->GetCount() != 0)
	{
		for (i = 0; i < list->GetCount(); i++)
		{
			list->GetText(i, liststr);
			if (liststr.GetLength() <= 2)
			{
				str += "-l";
				str += liststr;
				str += " ";
			}
			else if (liststr.GetAt(liststr.GetLength() - 2) != '.')
			{
				str += "-l";
				str += liststr;
				str += " ";
			}
		}
		for (i = 0; i < list->GetCount(); i++)
		{
			list->GetText(i, liststr);
			if (liststr.GetLength() > 2)
			{
				if (liststr.GetAt(liststr.GetLength() - 2) == '.')
				{
					list->GetText(i, liststr);
					str += liststr;
					str += " ";
				}
			}
		}
	}
	ShellExecute(NULL,"open","gcc",str.GetBuffer(256),".",SW_NORMAL);
	numlibs = list->GetCount();
	for (i = 0; i < numlibs; i++)
		list->GetText(i, libs[i]);
	gen_debug = m_GenDebug;
	OnOK();
}

void CCompileDialog::OnRadioObject() 
{
	// TODO: Add your control notification handler code here
	GetDlgItem(IDC_RADIO_AOUT)->EnableWindow(FALSE);
	GetDlgItem(IDC_RADIO_EXENAME)->EnableWindow(FALSE);
	GetDlgItem(IDC_EDIT_EXENAME)->EnableWindow(FALSE);
	GetDlgItem(IDC_LIST)->EnableWindow(FALSE);
	GetDlgItem(IDC_ADD_BUTTON)->EnableWindow(FALSE);
	GetDlgItem(IDC_REMOVE_BUTTON)->EnableWindow(FALSE);
}

void CCompileDialog::OnRadioExe() 
{
	// TODO: Add your control notification handler code here
	GetDlgItem(IDC_RADIO_AOUT)->EnableWindow(TRUE);
	GetDlgItem(IDC_RADIO_EXENAME)->EnableWindow(TRUE);
	GetDlgItem(IDC_EDIT_EXENAME)->EnableWindow(TRUE);
	GetDlgItem(IDC_LIST)->EnableWindow(TRUE);
	GetDlgItem(IDC_ADD_BUTTON)->EnableWindow(TRUE);
	GetDlgItem(IDC_REMOVE_BUTTON)->EnableWindow(TRUE);
}

BOOL CCompileDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	// TODO: Add extra initialization here
	CString str('x', (3 - extension.GetLength()));
	CListBox *list = (CListBox *)GetDlgItem(IDC_LIST);
	m_Aout = 1;
	m_Object = 1;
	m_Exename = filename + str;
	m_Exename.SetAt(m_Exename.GetLength() - 3, 'e');
	m_Exename.SetAt(m_Exename.GetLength() - 2, 'x');
	m_Exename.SetAt(m_Exename.GetLength() - 1, 'e');
	for (int i = 0; i < numlibs; i++)
		list->AddString(libs[i]);
	m_GenDebug = gen_debug;
	UpdateData(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CCompileDialog::OnAddButton() 
{
	// TODO: Add your control notification handler code here
	CString ext;
	CString str;
	CFileDialog filedialog(TRUE, NULL, NULL, OFN_HIDEREADONLY | 
		OFN_OVERWRITEPROMPT, 
		"Object and Library Files (*.a), (*.so), (*.o)| *.a;*.so;*.o||");
	CListBox *list = (CListBox*)GetDlgItem(IDC_LIST);
	if (filedialog.DoModal() == IDOK)
	{
		ext = filedialog.GetFileExt();
		str = filedialog.GetFileName();
		if (!ext.CompareNoCase("o"))
			list->AddString(filedialog.GetPathName());
		else if (!ext.CompareNoCase("a"))
		{
			str = str.Left(str.GetLength()-2);
			str = str.Right(str.GetLength()-3);
			list->AddString(str);
		}
		else
		{
			str = str.Left(str.GetLength()-3);
			str = str.Right(str.GetLength()-3);
			list->AddString(str);
		}
	}
}

void CCompileDialog::OnRemoveButton() 
{
	// TODO: Add your control notification handler code here
	CListBox *list = (CListBox*)GetDlgItem(IDC_LIST);
	if (list->GetCurSel() != LB_ERR)
		list->DeleteString(list->GetCurSel());
}

void CCompileDialog::OnAdvancedButton() 
{
	// TODO: Add your control notification handler code here
	CAdvancedSheet sheet("Advanced Options");
	sheet.DoModal();
}
