#!/bin/bash
#
# $Id: tryinst.sh,v 1.4 2002/06/23 20:28:31 richdawe Exp $
# Copyright (C) 2001 by Richard Dawe
#
# Try a DJGPP installation using pakke. This assumes that you have a mirror
# of the DJGPP archive available and specified in the 'share/pakke/pakkerc'
# file in you DJGPP directory. The base directory of the the DJGPP archive
# should be given as a command-line argument.
#
# Example:
#
#     <this-script> z:/djgpp-mirror
#
# When prompted whether to overwrite DSMs on installation of djgpp-dsms,
# choose to skip overwriting the already installed files. The DSMs from
# pakke's sources are likely to have bugfixes over the ones in the packages
# on Simtel.NET.
#

#
# TODO: Test out web downloads too!
#

# What are we doing?
set -x

TOP=$(pwd)/../..

# Mirror path
MIRRORDIR=$1
shift

if [ "a$MIRRORDIR" = "a" ]; then
    echo "Syntax: $0 <mirror-directory>"
    exit 1
fi

# Assume that we have a 5 digit PID.
TESTDIR=${TMPDIR}/zip$$

# Guess the executable extension, if any.
if [ -f ${TOP}/bin/pakke.exe ]; then
    EXEEXT=.exe
else
    EXEEXT=
fi

# How should we invoke pakke?
SRCPAKKE=${TOP}/bin/pakke${EXEEXT}
PAKKE=${TESTDIR}/bin/pakke${EXEEXT}
PAKKEOPTS="--verbose --root ${TESTDIR}"
Z="${PAKKE} ${PAKKEOPTS}"

# Create the configuration file. Copy the one from the DJGPP directory,
# because we've probably customised that to point at a mirror
# of the DJGPP archive or part thereof.
mkdir -p ${TESTDIR}/share/pakke
cp -v ${DJDIR}/share/pakke/pakkerc ${TESTDIR}/share/pakke

# Copy wget too, since --with-pakke doesn't do that yet.
cp -rv ${DJDIR}/share/pakke/win32 ${TESTDIR}/share/pakke

# Create the pakke database.
${SRCPAKKE} ${PAKKEOPTS} --initdb --with-pakke || exit 1

# Check that we're using the right version.
${SRCPAKKE} ${PAKKEOPTS} --version > ${TESTDIR}/srcpakke.ver
${Z} ${PAKKEOPTS} --version        > ${TESTDIR}/pakke.ver

diff ${TESTDIR}/srcpakke.ver ${TESTDIR}/pakke.ver \
    || ( echo "pakke installation into ${TESTDIR} failed!"; exit 1 )

# Find the latest available DSM package and install it.
DSMPACKAGE=$(find ${MIRRORDIR}/v2 -name 'ds[0-9]*.zip' | sort | tail -n 1)
${Z} --install $DSMPACKAGE || exit 1

# Update the available DSMs from the pakke distribution.
# We may have fixed some bugs in the ones distributed in DJGPP packages.
mkdir -p ${TESTDIR}/share/pakke/db-avail
cp -uv ${TOP}/share/pakke/db-avail/*.dsm ${TESTDIR}/share/pakke/db-avail

# Install DJGPP packages.
${Z} --install ${MIRRORDIR}/v2/djdev203.zip || exit 1

# HACK: Add a provide to the installed djdev, to allow Perl to install.
grep djgpp-dev-env ${TESTDIR}/share/pakke/db/djdev203.dsm \
    || echo "provides: djgpp-dev-env" \
    >> ${TESTDIR}/share/pakke/db/djdev203.dsm

# djdev 2.03's DSM may be stale compared with pakke's djdev 2.03 DSM.
# Synchronise to use the pakke copy.
#${Z} --syncdb || exit 1

${Z} --install ${MIRRORDIR}/v2gnu/bsh204b.zip || exit 1
# TODO: Remove texinfo DSM for share/pakke/db-avail and then try
# to install with pakke guessing the DSM.
#${Z} --install ${MIRRORDIR}/v2gnu/txi40b.zip || exit 1

# HACK for binutils 2.11.2, due to bad DSM
#${Z} --install ${MIRRORDIR}/v2gnu/bnu2112b.zip || exit 1

( cd ${TESTDIR}; \
    ${MIRRORDIR}/unzip32 ${MIRRORDIR}/v2gnu/bnu2112b.zip;
    cd - ) || exit 1

mv ${TESTDIR}/manifest/bnu2112b.dsm ${TESTDIR}/manifest/bnu2112b.dsm.old
grep -v ^binaries-dsm ${TESTDIR}/manifest/bnu2112b.dsm.old \
    > ${TESTDIR}/manifest/bnu2112b.dsm
mv -fv ${TESTDIR}/manifest/bnu2112b.dsm ${TESTDIR}/share/pakke/db-avail

${Z} --syncdb -v --non-interactive || exit 1

# Normal service is resumed.
${Z} --install ${MIRRORDIR}/v2gnu/gcc304b.zip || exit 1
${Z} --install ${MIRRORDIR}/v2gnu/gpp304b.zip || exit 1
${Z} --install ${MIRRORDIR}/v2gnu/fil40b.zip || exit 1
#${Z} --install -A "sed 3.02 (binaries)" || exit 1
${Z} --install ${MIRRORDIR}/v2gnu/sed3028b.zip || exit 1
${Z} --install ${MIRRORDIR}/v2gnu/perl561b.zip || exit 1
${Z} --install -A "m4 1.4 (binaries)" || exit 1
${Z} --install -A "autoconf 2.13 (binaries)" || exit 1
${Z} --install -A "automake 1.4 (binaries)" || exit 1
