/* Copyright (C) 1998 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 1996 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <libc/stubs.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <go32.h>
#include <ctype.h>
#include <dpmi.h>
#include <libc/dosio.h>
#include <libc/farptrgs.h>

int
__chdir (const char *mydirname)
{
  __dpmi_regs r;
  int drv_no = -1;

  if (mydirname == 0)
  {
    errno = EINVAL;
    return -1;
  }

  if (mydirname[0] == 0)
  {
    errno = ENOENT;
    return -1;
  }

  _put_path(mydirname);

  /* _put_path performs some magic conversions of file names, so
     the path in the transfer buffer can include a drive even though
     MYDIRNAME doesn't seem to.  */
  if (_farpeekb(_dos_ds, __tb + 1) == ':')
    drv_no = (_farpeekb(_dos_ds, __tb) & 0x1f) - 1;

  if (drv_no == -1 || _farpeekb(_dos_ds, __tb + 2) != 0)
  {
    if(_USE_LFN)
      r.x.ax = 0x713b;
    else
      r.h.ah = 0x3b;
    r.x.dx = __tb_offset;
    r.x.ds = __tb_segment;
    __dpmi_int(0x21, &r);
    if(r.x.flags & 1)
    {
      errno = __doserr_to_errno(r.x.ax);
      return -1;
    }
  }

  if (drv_no != -1)
  {
    /* Change current drive also.  This *will* work if
       the directory change above worked. */
    r.h.ah = 0x0e;
    r.h.dl = drv_no;
    __dpmi_int(0x21, &r);
  }

  return 0;
}
