/* Project SWORD
   V2.0

   SubSystem : Screen graphics management
   File      : Src/Graphics/Zone.CC
   Author    : Eric NICOLAS
   Overview  : TZone Object = a part of the screen
   UpDate    : Oct 22, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"

short  RegTZone;
char  *IdentTZone = "TZone";
TRect  NoClip;
TZone *MouseActiveZone;

// Constructors

TZone::TZone() : TObject()
{ Where=TRect();
  Init();
}

TZone::TZone(int X, int Y, int L, int H) : TObject()
{ Where=TRect(X,Y,X+L-1,Y+H-1);
  Init();
}

TZone::TZone(TRect& R) : TObject()
{ Where=R;
  Init();
}

TZone::~TZone(void)
{ if (!Destroyed)
  { Done();
    Destroyed=TRUE;
  }
}

void TZone::Init(void)
{ Register=RegTZone;
  Ident=IdentTZone;
  DrawStatus=0;
  SysColor=SysColorAddition=0;
  SetStatus(sfVisible);
  Inside=Where-Where.P1();
  MouseAspect=MouseCursorArrow;
}

void TZone::Done(void)
{ if (MouseActiveZone==this) MouseActiveZone=NULL;
  TObject::Done();
}

void TZone::InitAfterInsert(void)
{ }

// Graphical methods

void TZone::MakeGlobal(TPoint Src, TPoint& Dest)
{ TAtom* A=_Father;
  Dest=Src;
  while((A!=NULL)&&(A->Register>=RegTZone))
  { Dest+=((TZone*)A)->Where.P1();
    A=A->Father();
  }
}

void TZone::MakeLocal(TPoint Src, TPoint& Dest)
{ TAtom* A=_Father;
  Dest=Src;
  while((A!=NULL)&&(A->Register>=RegTZone))
  { Dest-=((TZone*)A)->Where.P1();
    A=A->Father();
  }
}

void TZone::DrawBegin(void)
{ if (!DrawStatus)
  { MakeGlobal(Where.P1(),Corner);
    // MouseClipON();
  }
  DrawStatus++;
}

void TZone::DrawEnd(void)
{ DrawStatus--;
  if (!DrawStatus)
  { // MouseClipOFF();
  }
}

void TZone::Invalidate(TRect& What)
{ if (Father()!=NULL)
    Father()->Invalidate(What+Where.P1());
}

void TZone::ShowDrawingNow(void)
{ if (Father()!=NULL)
    Father()->ShowDrawingNow();
}

void TZone::DoDraw(TRect& Clip)
{ if (GetStatus(sfVisible))
  { DrawBegin();
    TRect  R=Clip-(Where-Where.P1());
    if (!R.Empty())
    { // L'intersection entre la zone a tracer et cet objet
      // est non-vide. On le retrace donc.
      // 1. Ses fils
      TZone *Z=Son();
      TRect  RSon;
      while(Z!=NULL)
      { RSon=R-(Z->Where.P1());
        Z->DoDraw(RSon);
        Z=Z->Next();
      }
      // 2. Lui-meme
      GrSetClipBox(R.X1()+Corner.X(),R.Y1()+Corner.Y(),
                   R.X2()+Corner.X(),R.Y2()+Corner.Y());
      Draw(R);
    }
    DrawEnd();
  }
}

void TZone::Draw(TRect & )
{ }

void TZone::BecomeActiveZone(void)
{ if (MouseAspect!=CurrentMouseAspect)
     ChangeMouseAspect(MouseActiveZone->MouseAspect);
}

void TZone::LeaveActiveZone(void)
{ }

void TZone::PutPixel(int X, int Y)
{ GrPlot(X+Corner.X(),Y+Corner.Y(),NoSysColor[SysColor+SysColorAddition]);
}

void TZone::Bar(int X1, int Y1, int X2, int Y2)
{ GrFilledBox(X1+Corner.X(),Y1+Corner.Y(),X2+Corner.X(),Y2+Corner.Y(),NoSysColor[SysColor+SysColorAddition]);
}

void TZone::Rectangle(int X1, int Y1, int X2, int Y2)
{ GrBox(X1+Corner.X(),Y1+Corner.Y(),X2+Corner.X(),Y2+Corner.Y(),NoSysColor[SysColor+SysColorAddition]);
}

void TZone::LineX(int X1, int Y1, int X2)
{ GrHLine(X1+Corner.X(),X2+Corner.X(),Y1+Corner.Y(),NoSysColor[SysColor+SysColorAddition]);
}

void TZone::LineY(int X1, int Y1, int Y2)
{ GrVLine(X1+Corner.X(),Y1+Corner.Y(),Y2+Corner.Y(),NoSysColor[SysColor+SysColorAddition]);
}

void TZone::Line(int X1, int Y1, int X2, int Y2)
{ GrLine(X1+Corner.X(),Y1+Corner.Y(),X2+Corner.X(),Y2+Corner.Y(),NoSysColor[SysColor+SysColorAddition]);
}

int TZone::Frame3D(int Down)
{ return Frame3D(Down,0,0,Where.L()-1,Where.H()-1);
}

int TZone::Frame3D(int Down, int X1, int Y1, int X2, int Y2)
{ char c1,c2,c3,c4;
  int  D;
  if ( Down )
  { c1=GetColor(1);    c2=GetColor(0);
    c3=GetColor(2);    c4=GetColor(3);
    D=1;
  }
  else
  { c1=GetColor(3);    c2=GetColor(2);
    c3=GetColor(1);    c4=GetColor(0);
    D=0;
  }
  SetSysColor(c1);          LineX(X1,Y1,X2-1);     LineY(X1,Y1+1,Y2-1);
  SetSysColor(c2);          LineX(X1+1,Y1+1,X2-2); LineY(X1+1,Y1+2,Y2-2);
  SetSysColor(c3);          LineX(X1+1,Y2-1,X2-1); LineY(X2-1,Y1+1,Y2-2);
  SetSysColor(c4);          LineX(X1,Y2,X2);       LineY(X2,Y1,Y2-1);
  return D;
}

void TZone::PutStr(int X, int Y, char *Text, TFont *Font)
{ Font->PutStr(X+Corner.X(),Y+Corner.Y(),Text,NoSysColor[SysColor+SysColorAddition]);
}

void TZone::PutSysStr(int X, int Y, char *Text, TFont *Font)
{ Font->PutSysStr(X+Corner.X(),Y+Corner.Y(),Text,NoSysColor[SysColor+SysColorAddition]);
}

void TZone::SetSysColor(int C)
{ SysColor=C;
}

int TZone::GetColor(int C)
{ if (Father()!=NULL) return Father()->GetColor(C);
                 else return 0;
}

void TZone::SetColorGroup(char ColorGroup)
{ TZone *Z=Son();
  while(Z!=NULL)
  { Z->SetColorGroup(ColorGroup);
    Z=Z->Next();
  }
}

void TZone::SetWriteMode(int WM)
{ SysColorAddition=WM;
}

// Manipulations diverses

void TZone::ShrinkInside(TRect& )
{ }

void TZone::Insert(TAtom *A)
{ TObject::Insert(A);
  ((TZone*)A)->ShrinkInside(Inside);
//  ((TZone*)A)->InitAfterInsert(); /* Dej appel dans TObject::Insert */
}

// Flux d'objets

void TZone::Read(TDisk *file)
{ TObject::Read(file);
  Where.Read(file);
  Inside.Read(file);
}

void TZone::Write(TDisk *file)
{ TObject::Write(file);
  Where.Write(file);
  Inside.Write(file);
}

// Gestion des vnements

boolean TZone::MouseMove(TPoint& W, int )
{ TPoint P;
  MakeLocal(W,P);
  if (GetStatus(sfMouseIn))
  { // Si la souris est dj dedans
    if ((P.X()<Where.X1()) || (P.X()>Where.X2()) ||
        (P.Y()<Where.Y1()) || (P.Y()>Where.Y2())) ClearStatus(sfMouseIn);
  }
  else
  { // Si la souris tait en dehors
    if ((P.X()>=Where.X1()) && (P.X()<=Where.X2()) &&
        (P.Y()>=Where.Y1()) && (P.Y()<=Where.Y2())) SetStatus(sfMouseIn);
  }
  MakeGlobal(Where.P1(),P);
  if (GetStatus(sfMouseIn))
    if (MouseActiveZone==NULL) MouseActiveZone=this;
  return FALSE;
}

void TZone::DoChangeSize(int dX, int dY)
{ TZone *Z;
  if (GetOptions(opCSLoX)) Where.X1()+=dX;
  if (GetOptions(opCSLoY)) Where.Y1()+=dY;
  if (GetOptions(opCSHiX)) Where.X2()+=dX;
  if (GetOptions(opCSHiY)) Where.Y2()+=dY;
  Z=Son();
  while(Z!=NULL)
  { Z->DoChangeSize(dX,dY);
    Z=Z->Next();
  }
}
