/* Project SWORD
   V2.0

   SubSystem : Screen graphics management
   File      : Src/Graphics/Graphics.CC
   ErrNos    : 2000..2099
   Author    : Eric NICOLAS
   Overview  : Init / Done of the module Graphics
   UpDate    : Oct 14, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"

// ----- Global variables

char     *EndingMessage;

// ----- Local variables

static char *Messages[1] =
      { "Mouse driver not found" };

#include "Graphics/M_Arrow.INC"
#include "Graphics/M_Hand.INC"
#include "Graphics/M_Size1.INC"
#include "Graphics/M_Size2.INC"
#include "Graphics/M_Button.INC"
#include "Graphics/M_Inact.INC"

GrCursor *CurMouse[6];
char     *DefaultEndingMessage = "\n\nThanks you for using SWORD, see you soon...\n\n";
char      CurrentMouseAspect;
char      OldMouseAspect;

// ===== Gestion locale des erreurs =========================================

static boolean ErrorMessages(char *Message)
{ int MessageNo;
  switch(Error)
  { case erNoMouseDetected: MessageNo=0;   break;
    default:
      return FALSE;
  }
  strcpy(Message,Messages[MessageNo]);
  return TRUE;
}

// ----- Functions

void ChangeMouseAspect(int MouseAspect)
{ if ((MouseAspect>=0)&&(MouseAspect<6))
  { MouseEraseCursor();
    MouseSetCursor(CurMouse[MouseAspect]);
    MouseDisplayCursor();
    OldMouseAspect=CurrentMouseAspect;
    CurrentMouseAspect=MouseAspect;
  }
}

void RestoreMouseAspect(void)
{ ChangeMouseAspect(OldMouseAspect);
}

void InitGraphics(void)
{ int i;
  // Gestionnaire local d'erreur
  AddErrorHandler(ErrorMessages);
  // Enregistrement des objets du module Graphics
  RegisterObject(new TZone()         ,&RegTZone);
  RegisterObject(new TDesktop()      ,&RegTDesktop);
  RegisterObject(new TWindow()       ,&RegTWindow);
  RegisterObject(new TMappingObject(),&RegTMappingObject);
  // Bascule en mode graphique
  GrSetMode(GR_width_height_color_graphics,
            SetUp.ScreenX,SetUp.ScreenY,SetUp.ScreenColors);
  NoClip=TRect(0,0,GrMaxX(),GrMaxY());
  Debug("  GRMODE...    Resolution X   = %d\n"
        "               Resolution Y   = %d\n",GrMaxX()+1,GrMaxY()+1);
  InitColors();
  // Cration des divers curseurs de souris
  int ColorTable[17];
  ColorTable[0]=16;
  for(i=0;i<16;i++)
    ColorTable[i+1]=NoSysColor[i];
  CurMouse[0]=GrBuildCursor(MouseArrow     ,12,16,1, 1, ColorTable);
  CurMouse[1]=GrBuildCursor(MouseHand      ,16,17, 8, 8,ColorTable);
  CurMouse[2]=GrBuildCursor(MouseSize1     ,12,20, 6,10,ColorTable);
  CurMouse[3]=GrBuildCursor(MouseSize2     ,12,20, 6,10,ColorTable);
  CurMouse[4]=GrBuildCursor(MouseButton    ,15,15, 7, 7,ColorTable);
  CurMouse[5]=GrBuildCursor(MouseInactivity,26,26,13,13,ColorTable);
  // Initialise la bibliothque de gestion souris
  if (!MouseDetect())
  { Error=erNoMouseDetected;
    ErrorViewer();
  }
  MouseEventMode(1);
  MouseEventEnable(TRUE,TRUE);
  MouseInit();
  MouseSetCursor(CurMouse[0]);
  MouseDisplayCursor();
  EndingMessage=DefaultEndingMessage;
  // Init of Font and Mapping managing
  InitMapping();
  InitFont();
  // Sortie de vrification Debug
  Debug("  GRAPHICS...  OK.\n");
}

void DoneGraphics(void)
{ DoneFont();
  DoneMapping();
  DoneColors();
  MouseUnInit();
  // Destruction des divers curseurs de souris
  GrDestroyCursor(CurMouse[0]);
  GrDestroyCursor(CurMouse[1]);
  GrDestroyCursor(CurMouse[2]);
  GrDestroyCursor(CurMouse[3]);
  GrDestroyCursor(CurMouse[4]);
  // Retour au mode texte
  GrSetMode(GR_80_25_text);
  // Message de sortie
  textattr(0x1B);
  cprintf(
  "   ͻ   "
  "      Graphical User Interface SWORD           The Sword Group 1993,1995      "
  "   ͹   "
  "    For all informations :             Version : V%s Nov 1995             "
  "      Eric NICOLAS                                                           "
  "      11 Allee du parc G. Pompidou                                           "
  "      38100 GRENOBLE                                                         "
  "      FRANCE                           E-mail: nicolas@dsys.ceng.cea.fr      "
  "   ͼ   ",
  SwordVer);
  textattr(0x07);
  printf("\n\n%s",EndingMessage);
  printf("\n\n");
}
