/* Project SWORD
   V2.0

   SubSystem : Screen graphics management
   File      : Src/Graphics/FontSys.CC
   Author    : Olivier PAYEN, Eric NICOLAS
   Overview  : Font managing
   UpDate    : Dec 19, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"

extern "C" {
#include <grxfile.h>
}

TFont *FontSystem;
TFont *FontListing;

TFont::TFont(char *Name)
{ // Load the fonts in Normal, Italic, Bold, BoldItalic
  char   Tmp[10];
  char   FileName[120];
  TDisk *File;
  // :: Normal
  Fonts[FFace_NORMAL]=GrLoadFont(Name);
  // :: Italic
  sprintf(Tmp,"%sI",Name);
  _GrGetFname(Tmp,_GrFontPath,FNTENV,FNTEXT,FileName);
  File=new TDisk(FileName,stOpen);
  if (Error) Fonts[FFace_ITALIC]=Fonts[FFace_NORMAL];
	    else Fonts[FFace_ITALIC]=GrLoadFont(Tmp);
  delete File;
  Error=0;
  // :: Bold
  sprintf(Tmp,"%sB",Name);
  _GrGetFname(Tmp,_GrFontPath,FNTENV,FNTEXT,FileName);
  File=new TDisk(FileName,stOpen);
  if (Error) Fonts[FFace_BOLD]=Fonts[FFace_NORMAL];
	    else Fonts[FFace_BOLD]=GrLoadFont(Tmp);
  delete File;
  Error=0;
  // :: Bold-Italic
  sprintf(Tmp,"%sBI",Name);
  _GrGetFname(Tmp,_GrFontPath,FNTENV,FNTEXT,FileName);
  File=new TDisk(FileName,stOpen);
  if (Error) Fonts[FFace_BOLD | FFace_ITALIC]=Fonts[FFace_NORMAL];
	    else Fonts[FFace_BOLD | FFace_ITALIC]=GrLoadFont(Tmp);
  delete File;
  Error=0;
  // Initialize the default parameters for future drawings
  Options.txo_xmag=Options.txo_ymag=1;
  Options.txo_bgcolor.v=0;
  Options.txo_direct=GR_TEXT_RIGHT;
  Options.txo_xalign=Options.txo_yalign=GR_ALIGN_DEFAULT;
  Options.txo_chrtype=GR_BYTE_TEXT;
  ChooseFace(FFace_NORMAL);
  UnderLine(FALSE);
  BackColor(FBack_NOCOLOR);
}

TFont::~TFont()
{ if (Fonts[3]!=Fonts[0]) GrUnloadFont(Fonts[3]);
  if (Fonts[2]!=Fonts[0]) GrUnloadFont(Fonts[2]);
  if (Fonts[1]!=Fonts[0]) GrUnloadFont(Fonts[1]);
  GrUnloadFont(Fonts[0]);
}

// Choosing the font's attributes

void TFont::ChooseFace(int Face)
{ Options.txo_font=Fonts[Face & 3];
}

void TFont::UnderLine(boolean UL)
{ if (UL) UnderLineOption=GR_UNDERLINE_TEXT;
     else UnderLineOption=0;
}

void TFont::BackColor(int Color)
{ Options.txo_bgcolor.v=Color;
}

// Using the font

int TFont::WidthStr(char *Text)
{ if (Text==NULL) return 0;
             else return GrStringWidth(Text,strlen(Text),&Options);
}

int TFont::HeightStr(char *Text)
{ if (Text==NULL) return GrFontHeight(&Options);
             else return GrStringHeight(Text,strlen(Text),&Options);
}

void TFont::TruncStr(int Width, char *Text, char *Result)
{ strcpy(Result,Text);
  while (WidthStr(Result)>Width)
    Result[strlen(Result)-1]=0;
}

void TFont::PutStr(int X, int Y, char *Text, int Color)
{ if (Text==NULL) return;
  Options.txo_fgcolor.v=Color+UnderLineOption;
  GrDrawString(Text,strlen(Text),X,Y,&Options);
}

// Using the font with system text

int TFont::WidthSysStr(char *Text)
{ int L;
  if (Text==NULL) L=0;
  else
  { char *P=strchr(Text,'&');
    if (P!=NULL)
    { *P=0;
      L=GrStringWidth(Text,strlen(Text),&Options);
      *P='&';
      L+=GrStringWidth(P+1,strlen(P+1),&Options);
    }
    else L=GrStringWidth(Text,strlen(Text),&Options);
  }
  return L;
}

void TFont::TruncSysStr(int Width, char *Text,char *Result)
{ strcpy(Result,Text);
  while (WidthSysStr(Result)>Width)
  { Result[strlen(Result)-1]=0;
    if (Result[strlen(Result)-1]=='&') Result[strlen(Result)-1]=0;
  }
}

void TFont::PutSysStr(int X, int Y, char *Text, int Color)
{ if (Text==NULL) return;
  // Search for a '&' character
  char *P=strchr(Text,'&');
  char  Temp[2];
  int   dX;
  if (P!=NULL)
  { // Show the first part of the string
    *P=0;
    PutStr(X,Y,Text,Color);
    // Compute the next position for the other part of the string
    dX=WidthStr(Text);
    *P='&';
    // Show the underlined character
    UnderLine(TRUE);
    Temp[0]=*(P+1);
    Temp[1]=0;
    PutStr(X+dX,Y,Temp,Color);
    dX+=WidthStr(Temp);
    // Show the end of the string
    UnderLine(FALSE);
    PutStr(X+dX,Y,P+2,Color);
  }
  else PutStr(X,Y,Text,Color);
}

// Init/Done of the Font system

void InitFont()
{ FontSystem=new TFont("HELV15");
  FontListing=new TFont("COUR14");
}

void DoneFont()
{ delete FontListing;
  delete FontSystem;
}
