/* Project SWORD
   V2.0

   SubSystem : Little usefull graphical objects
   File      : Src/Gadgets/TitleBar.CC
   Author    : Eric NICOLAS
   Overview  : TTitleBar object
   UpDate    : May 22, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"
#include "Drawings/Drawings.H"
#include "Gadgets/Gadgets.H"

short RegTTitleBar;
char *IdentTTitleBar = "TTitleBar";

// Constructors

TTitleBar::TTitleBar() : TZone()
{ Init();
}

TTitleBar::TTitleBar(int X, int Y, int L, int , char *_Title) : TZone(X,Y,L,21)
{ Init(_Title);
}

TTitleBar::TTitleBar(TRect& R, char *_Title) : TZone(R.X1(),R.Y1(),R.L(),21)
{ Init(_Title);
}

void TTitleBar::Init(char *_Title)
{ Register=RegTTitleBar;
  Ident=IdentTTitleBar;
  SetOptions(opCSHiX);
  if (_Title!=NULL) Title=strdup(_Title);
  else Title=NULL;
}

TTitleBar::~TTitleBar(void)
{ if (!Destroyed)
  { Done();
    Destroyed=TRUE;
  }
}

void TTitleBar::Done(void)
{ if (Title!=NULL) free(Title);
  TZone::Done();
}

// Events

boolean TTitleBar::HandleCommand(long Command, char , short , long , void *)
{ if ((Command==cmSelect)||(Command==cmUnSelect)) Invalidate();
  return FALSE;
}

boolean TTitleBar::MouseLDown(TPoint& mWhere, int )
{ if (GetStatus(sfMouseIn))
  { TEvent   Event;
    TWindow *W=Father();
    int      dX1,dY1,dX2,dY2,dX,dY;
    TRect    Rect;
    dX1=W->Corner.X()-mWhere.X();
    dY1=W->Corner.Y()-mWhere.Y();
    dX2=dX1+W->Where.L()-1;
	 dY2=dY1+W->Where.H()-1;
    ChangeMouseAspect(MouseCursorHand);
    MouseSetCursorMode(M_CUR_BOX,dX1,dY1,dX2,dY2,NoSysColor[15]);
    do
    { GetEvent(&Event);
    } while(Event.What!=evMouseLUp);
    MouseSetCursorMode(M_CUR_NORMAL);
    RestoreMouseAspect();
    // Garde l'ancienne coordonne
    Rect=TRect(0,0,W->Where.L()-1,W->Where.H()-1)+W->Corner;
    // Dplace la fentre
    dX=Event.Where.X()-mWhere.X();
    dY=Event.Where.Y()-mWhere.Y();
    if ((dX)||(dY))
    { // Demande le retrac de l'ancienne position
      W->Invalidate();
      // Change la position
      W->Where+=TPoint(dX,dY);
      // Met  jour le systme de recouvrement
      Desktop->UpdateClipZone();
		// Demande de retracer la nouvelle position
      W->Invalidate();
    }
    return TRUE;
  }
  return FALSE;
}

// Graphics

void TTitleBar::Draw(TRect& )
{ int   Active=Father()->GetStatus(sfSelected);
  int   L,H,sL,sH;
  char *NewTitle=strdup(Title);
  L=Where.L();
  H=Where.H();
  // Trace le fond
  if (Active) SetSysColor(GetColor(DarkGray));
			else SetSysColor(GetColor(Black));
  Bar(0,0,L-1,H-2);
  SetSysColor(GetColor(LightGray));
  LineX(0,H-1,L-1);
  // Trace le titre
  if (Active) SetSysColor(GetColor(White));
			else SetSysColor(GetColor(LightGray));
  FontSystem->ChooseFace(FFace_BOLD);
  FontSystem->TruncStr(L-20,Title,NewTitle);
  sH=FontSystem->HeightStr(NewTitle);
  sL=FontSystem->WidthStr(NewTitle);
  PutSysStr((L-sL)/2,(H-1-sH)/2,NewTitle,FontSystem);
  FontSystem->ChooseFace(FFace_NORMAL);
  free(NewTitle);
}

void TTitleBar::ShrinkInside(TRect& InsideFather)
{ InsideFather.P1()+=TPoint(0,Where.H());
}
