/* Project SWORD
   V2.0

   SubSystem  : Basic objects, General use mecanisms
   CommandNos : 1100..1199
   File       : Include/Mecanism/Object.H
   Author     : Eric NICOLAS
   Overview   : Basic object : Events, Selection, Data exchange
   UpDate     : Oct 23, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _MECANISM_OBJECT_H_
#define _MECANISM_OBJECT_H_

extern short RegTObject;
extern char *IdentTObject;

// What's in Options

// :: Global
#define opDrawable       0x0001
#define opSelectable     0x0002
#define opChangeAreaWait 0x0004
#define opGetAllEvents   0x0008
#define opCSLoX          0x0040
#define opCSLoY          0x0080
#define opCSHiX          0x0100
#define opCSHiY          0x0200
#define opCSAll          0x03C0
#define opSizeable       0x0400
// :: Menus
#define opSeparator      0x0800
#define opMainMenu       0x1000

// What's in Status

// :: Global
#define sfMouseIn        0x0001
#define sfSelected       0x0002
#define sfDown           0x0004
#define sfVisible        0x0008
#define sfDisabled       0x0010
#define sfColorsOK       0x0020
#define sfModified       0x0040
// :: Menus
#define sfMenuChoiceDown 0x0080

// Global commands

#define cmSelect         1100
#define cmUnSelect       1101
// Standard FILE MENU commands
#define cmFileNew        1120
#define cmFileOpen       1121
#define cmFileSave       1122
#define cmFileSaveAs     1123
#define cmFileQuit       1124
#define cmQuit           1125

// ----- TObject

class TObject : public TAtom
{ public:
    long   ExitCode;
  protected:
    int    Status;
    int    Options;
  public:
  // Constructors / Destructors
           TObject(void);
  virtual ~TObject(void);
  virtual  void InitAfterInsert(void);
  // Access to datas
          int      GetStatus(int StatusMask);
          void     SetStatus(int StatusMask);
          void     ClearStatus(int StatusMask);
          int      GetOptions(int OptionsMask);
          void     SetOptions(int OptionsMask);
          void     ClearOptions(int OptionsMask);
  // Events
  // :: Distributing events
	      void     DispatchEvent(TEvent* Event);
          void     DealEvent(TEvent* Event);
  virtual void     HandleEvent(TEvent* Event);
  virtual void     GetEvent(TEvent* Event);
	      void     ClearEvent(TEvent *Event);
	      long     Exec(void);
  // :: Generating events
  virtual void     SetEvent(TEvent* Event);
	      void     SetCommand(long Command);
	      void     SetCommand(long Command, char  Info08b);
	      void     SetCommand(long Command, short Info16b);
	      void     SetCommand(long Command, long  Info32b);
	      void     SetCommand(long Command, void *InfoPtr);
  // :: Acting on events
  // :: :: Mouse
  virtual boolean  MouseLDown(TPoint& Where, int Buttons);
  virtual boolean  MouseRDown(TPoint& Where, int Buttons);
  virtual boolean  MouseLUp(TPoint& Where, int Buttons);
  virtual boolean  MouseRUp(TPoint& Where, int Buttons);
  virtual boolean  MouseDblClc(TPoint& Where, int Buttons);
  virtual boolean  MouseMove(TPoint& Where, int Buttons);
  // :: :: Keyboard
  virtual boolean  KeyDown(int ScanCode);
  virtual boolean  ToggleKey();
  // :: :: Time
  virtual boolean  Time();
  virtual boolean  Date();
  // :: :: Commands
  virtual boolean  HandleCommand(long Command, char Info08b=0, short Info16b=0, long Info32b=0, void *InfoPtr=NULL);
  // :: :: Auto event
  virtual boolean  AutoEvt(void);
  // Selections
  virtual void     Select(void);
  virtual void     UnSelect(void);
          void     SelectNext(void);
          void     SelectPrevious(void);
  virtual boolean  Focus(void);
  // Linked lists
          TObject* First(void);
          TObject* Last(void);
          TObject* Next(void);
          TObject* Previous(void);
          TObject* Son(void);
          TObject* Father(void);
  virtual void     Insert(TAtom* A);
  // Objects streams
  virtual TAtom*   Duplicate(void);
  virtual void     Read(TDisk *file);
  virtual void     Write(TDisk *file);
  // Data exchange
  virtual void     SetData(void *Ptr);
  virtual void     GetData(void *Ptr);
  virtual long     DataSize(void);
};

// Inline functions

inline TObject* TObject::First(void)
{ return (TObject*)(TAtom::First());
}

inline TObject* TObject::Last(void)
{ return (TObject*)(TAtom::Last());
}

inline TObject* TObject::Next(void)
{ return (TObject*)(TAtom::Next());
}

inline TObject* TObject::Previous(void)
{ return (TObject*)(TAtom::Previous());
}

inline TObject* TObject::Son(void)
{ return (TObject*)(TAtom::Son());
}

inline TObject* TObject::Father(void)
{ return (TObject*)(TAtom::Father());
}


inline int TObject::GetStatus(int StatusMask)
{ return (Status & StatusMask);
}

inline void TObject::SetStatus(int StatusMask)
{ Status|=StatusMask;
}

inline void TObject::ClearStatus(int StatusMask)
{ Status&=~StatusMask;
}

inline int TObject::GetOptions(int OptionsMask)
{ return (Options & OptionsMask);
}

inline void TObject::SetOptions(int OptionsMask)
{ Options|=OptionsMask;
}

inline void TObject::ClearOptions(int OptionsMask)
{ Options&=~OptionsMask;
}

#endif // _MECANISM_OBJECT_H_
