/* Project SWORD
   V2.0

   SubSystem : Screen graphics management
   File      : Include/Graphics/Window.H
   Author    : Eric NICOLAS
   Overview  : TWindow Object = Overlapped windows management
   UpDate    : Oct 22, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _GRAPHICS_WINDOW_H_
#define _GRAPHICS_WINDOW_H_

extern short RegTWindow;
extern char *IdentTWindow;

struct TWindow : TZone
{ char         ColorGroup;
  TScreenZone *Clipping;
  TPoint       MinimalSize;
  // Constructeurs
          TWindow();
          TWindow(int X, int Y, int L, int H);
          TWindow(TRect& R);
          void     Init(void);
  virtual ~TWindow();
          void     Done(void);
  // Mthodes graphiques
  virtual int      GetColor(int C);
  virtual void     DoDraw(TRect& Clip);
  virtual void     SetColorGroup(char ColorGroup);
  // Gestion des vnements
  virtual boolean  MouseLDown(TPoint& Where, int Buttons);
  virtual void     HandleEvent(TEvent *Event);
  // Gestion du Clip
          void     ResetClip();
          void     CalculateClip();
          void     ComeToForeground(void);
  // Liste chane
          TWindow *Next();
	      TWindow *Previous();
	      TWindow *First();
	      TWindow *Last();
  virtual void     UnLink(void);
  // Flux d'objets
  virtual TAtom*   Duplicate();
  virtual void     Read(TDisk *file);
  virtual void     Write(TDisk *file);
};

// Inline functions

inline TWindow *TWindow::Next()
{ return (TWindow*)(TZone::Next());
}

inline TWindow *TWindow::Previous()
{ return (TWindow*)(TZone::Previous());
}

inline TWindow *TWindow::First()
{ return (TWindow*)(TZone::First());
}

inline TWindow *TWindow::Last()
{ return (TWindow*)(TZone::Last());
}

inline TAtom* TWindow::Duplicate(void)
{ return new TWindow();
}

#endif // _GRAPHICS_WINDOW_H_
