/* Project SWORD
   V2.0

   SubSystem  : Little usefull graphical objects
   CommandNos : 3200..3299
   File       : Include/Gadgets/Lift.H
   Author     : Eric NICOLAS
   Overview   : TLift object
   UpDate     : Nov 12, 1995

** Copyright (C) 1993,1995 Eric NICOLAS
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _GADGETS_LIFT_H_
#define _GADGETS_LIFT_H_

#define cmLiftInc        3200
#define cmLiftDec        3201
#define cmLiftHorizMoved 3202
#define cmLiftVertMoved  3203

// --- TLiftButton object

extern short RegTLiftButton;
extern char *IdentTLiftButton;

struct TLiftButton : TStdButton
{         TLiftButton();
          TLiftButton(int X, int Y, int Command, int ScanCode, char *IconeDescr);
          void     Init(void);
  //
  virtual void     Action();
  // Objects streams
  virtual TAtom*   Duplicate(void);
};

// --- TLift object

extern short RegTLift;
extern char *IdentTLift;

struct TLift : TZone
{ protected:
	 boolean Horizontal;
	 TButton *Inc, *Dec;
	 int     Xctr,Lctr;
	 int     RealP1, RealP2;
	 int     ViewP1, ViewP2;
	 int     Step;
    int     ScanPageInc, ScanPageDec;
    TObject *Connected;
  public:
  // Constructors
			 TLift();
			 TLift(int X, int Y, int L, int H, boolean _Horizontal);
			 TLift(TRect& R, boolean _Horizontal);
			 void     Init(boolean _Horizontal);
  // Lift elements size and position
  virtual void     ShrinkInside(TRect& InsideFather);
  virtual void     DoChangeSize(int dX, int dY);
			 void     ChangePos(void);
  // Access to data
			 void     SetViewPos(int P1, int P2);
			 void     SetRealPos(int P1, int P2);
			 void     SetIncStep(int _Step);
			 void     GetViewPos(int &P1, int &P2);
          void     SetConnectedObject(TObject *_Connected);
  //
          void     PageInc(void);
          void     PageDec(void);
          void     PageMove(TPoint &dW);
  //
  virtual void     Draw(TRect& Clip);
  virtual boolean  HandleCommand(long Command, char Info08b=0, short Info16b=0, long Info32b=0, void *InfoPtr=NULL);
  virtual boolean  MouseLDown(TPoint& Where, int Buttons);
  virtual boolean  KeyDown(int ScanCode);
  // Objects streams
  virtual TAtom*   Duplicate(void);
};

// Inline functions

inline TAtom* TLiftButton::Duplicate(void)
{ return new TLiftButton();
}

inline TAtom* TLift::Duplicate(void)
{ return new TLift();
}

inline void TLift::SetViewPos(int P1, int P2)
{ ViewP1=P1;
  ViewP2=P2;
  ChangePos();
}

inline void TLift::SetRealPos(int P1, int P2)
{ RealP1=P1;
  RealP2=P2;
  ChangePos();
}

inline void TLift::SetIncStep(int _Step)
{ Step=_Step;
}

inline void TLift::GetViewPos(int &P1, int &P2)
{ P1=ViewP1;
  P2=ViewP2;
}

inline void TLift::SetConnectedObject(TObject *_Connected)
{ Connected=_Connected;
}

#endif // _GADGETS_LIFT_H_