/*****************************************************************************
*  
*                                  DESQview/X 
*                           BASIC UDP (DATAGRAM) DAEMON
*
*  The following code demonstrates the implementation of a basic stream 
*  daemon under DESQview/X.  Similar code may be used for daemons that are
*  managed by the DESQview/X Network Manager and are activated by  
*  incoming datagrams from a remote host.
*
*  The basic methodology is as follows.  
*
*   - The DESQview/X Network Manager opens a datagram socket for the daemon
*     based upon the contents of the NETWORK\INETD.CFG file, and the DVPs in 
*     the NETWORK subdirectory.
*
*   - A datagram is sent to the socket.
*
*   - The Network Manager instructs DESQview/X to load the appropriate 
*     DVP for the daemon (from INETD.CFG).
*
*   - The daemon is started and immediately requests information about the 
*     socket.
*
*   - The daemon then processes the datagram.
*
*	 - The daemon then instructs the Network Manager that it is finished
*		with the socket and relinquishes control of it to the Network Manager.
*
*
******************************************************************************/


#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <netdb.h>		
#include <netinet\in.h>	
#include <sys\time.h>
#include <sys\socket.h>
#include <sys\errno.h>
#include <sys\ioctl.h>


void	chat(int s);

void main(int argc, char *argv[])
{
	int						s,bytes;
	char						rbuff[81];
	struct sockaddr_in	source;
	int						len	= sizeof(struct sockaddr_in);

	/* Daemon has been started by the Network Manager.  Request the connection */
	/* information.  The second parameter to so_daemon indicates that we wish	*/
	/* to wait for the connection information.  If we wished to poll for the	*/
	/* next connection, we could simply specify FALSE in the second parameter.	*/

	printf("\n\nDESQview/X Sample DATAGRAM Daemon.\n");

	while(1){

		printf("\n\nWaiting for next datagram.  Please wait.\n");

		s	=	so_daemon(argv,1);

		if(s < 0){
			printf("\nError:  Unable to retrieve connection information.\n\n");
			break;
		}

		/* Get the datagram														*/

		len	= sizeof(struct sockaddr_in);

		bytes	= recvfrom(s, rbuff, 80 , 0, (struct sockaddr *)&source, &len);

		if(bytes > 0)
			
			printf("\n%s -> %s",inet_ntoa(source.sin_addr), rbuff);

		/* Relinquish control of the socket to the Network Manager.	*/

		so_unlink(s);

	}
}

